/*	$Modname: vjcinit.c$  $version: 1.2$      $date: 01/06/95$   */
/*
* 	$lgb$
1.0 08/24/94 titus
1.1 08/26/94 titus Add Copyright
1.2 01/06/95 titus Cosmetic Changes
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#define GLOBAL_FILE
#include <string.h>
#include "vjc.h"
/************************************************************************************/
static enum TEST initialize_line_compression_state (LINE_COMPRESSION_STATE *sptr_line_compression_state);
/************************************************************************************/
enum TEST initialize_vjc (ULONG clock_ticks_per_second)
{
	USHORT index;
	VJC_PORT_CLASS *sptr_port_class;

	PARAMETER_NOT_USED(clock_ticks_per_second);

	if (vjc.enabled == TRUE) 
	{
		sptr_port_class = &vjc.port[0];

		for (index = 0x0000; index < NUMBER_OF_VJC_PORTS; ++index)
		{
		if (sptr_port_class->vjc_compression_enabled == TRUE)
			{
			if (initialize_line_compression_state (&sptr_port_class->line_compression_state) == FAIL)
				{
				return (FAIL);
				}

			ppp_register_vj_compression (index,
				(BYTE (*) (USHORT real_port_number, void **ptr_to_sptr_ip_packet, USHORT *usptr_number_of_bytes))
				vj_compress_tcp_header,	vj_get_maximum_connection_states, vj_get_compress_connection_id,
				(void (*)
				(USHORT receive_port_number, void **ptr_to_sptr_ip_packet, USHORT *usptr_number_of_bytes, BYTE type_of_packet))
				vj_uncompress_tcp_header);
			}

		vjc_printf (VJC_INIT_PRINTF, "VJC: Initializing line compression state for port %u\n", index);

		++sptr_port_class;
		}

		vjc_printf (VJC_INIT_PRINTF, "VJC: Data Structures Initialized\n");

		return (PASS);
	}
	else
	{
		vjc_printf (VJC_INIT_PRINTF, "VJC: Class is not enabled\n");

		return (PASS);
	}

}
/************************************************************************************/
static enum TEST initialize_line_compression_state (LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	USHORT index;
	CONNECTION_STATE *sptr_connection_state;

	sptr_connection_state = &sptr_line_compression_state->transmitted_connection_states[0];

	/*
 	 * Clean out any junk left from the last time line was used.
 	 */

	memset ((void *) sptr_line_compression_state, 0x00, sizeof (LINE_COMPRESSION_STATE));

	/*
 	 * Link the transmit states into a circular list.
 	 */

	for (index = 0x0000; index < (MAXIMUM_NUMBER_OF_CONNECTION_STATES - 1); ++index)
		{
		sptr_connection_state->connection_identifier = (BYTE) index;

		sptr_connection_state->sptr_connection_state_next = sptr_connection_state + 1;

		++sptr_connection_state;
		}

	sptr_connection_state->sptr_connection_state_next = &sptr_line_compression_state->transmitted_connection_states[0];

	sptr_connection_state->connection_identifier = MAXIMUM_NUMBER_OF_CONNECTION_STATES - 1;

	sptr_line_compression_state->sptr_last_connection_state = sptr_connection_state;

	/*
 	 * Make sure we don't accidentally do CID compression (assumes MAXIMUM_NUMBER_OF_CONNECTION_STATES < 255).
 	 */

	sptr_line_compression_state->last_received_connection_identifier = INVALID_CONNECTION_IDENTIFIER;

	sptr_line_compression_state->last_transmitted_connection_identifier = INVALID_CONNECTION_IDENTIFIER;

	return (PASS);
}

/*************************************************************************/
/* Reset all the slots */
/*************************************************************************/
void vjc_reset_connection_states (USHORT port_number)
{
	CONNECTION_STATE 			*sptr_tx_connection_state;
	CONNECTION_STATE 			*sptr_rx_connection_state;
	LINE_COMPRESSION_STATE	*sptr_line_compression_state;
	USHORT index;

	if (vjc.enabled == TRUE && vjc.port[port_number].vjc_compression_enabled == TRUE) 
	{
		sptr_line_compression_state = &vjc.port[port_number].line_compression_state;

		sptr_tx_connection_state = &sptr_line_compression_state->transmitted_connection_states[0];
		sptr_rx_connection_state = &sptr_line_compression_state->received_connection_states[0];

		for (index = 0x0000; index < (MAXIMUM_NUMBER_OF_CONNECTION_STATES - 1); ++index)
		{
			memset ((void *) &sptr_tx_connection_state->uncompressed_header[0], 0x00, MAXIMUM_HEADER_LENGTH);

			memset ((void *) &sptr_rx_connection_state->uncompressed_header[0], 0x00, MAXIMUM_HEADER_LENGTH);

			++sptr_rx_connection_state;
			++sptr_tx_connection_state;
		}
	}
}

