/*	$Modname: vjctxck.c$  $version: 1.3$      $date: 01/06/95$   */
/*
* 	$lgb$
1.0 08/24/94 titus
1.1 08/25/94 titus
1.2 08/26/94 titus Add Copyright
1.3 01/06/95 titus Cosmetic Changes
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <string.h>
#include "vjc.h"
/************************************************************************************/
static enum BOOLEAN check_if_packet_is_compressible (IP_PACKET **ptr_to_sptr_ip_packet, IP_HEADER **ptr_to_sptr_ip_header,
	TCP_HEADER **ptr_to_sptr_tcp_header, USHORT *usptr_number_of_bytes);
static enum BOOLEAN check_if_packet_is_an_ip_fragment (IP_HEADER *sptr_ip_header);
static USHORT get_fragment_offset_and_more_fragments_flag (IP_HEADER *sptr_ip_header);
static enum BOOLEAN check_if_ip_protocol_is_not_tcp (IP_HEADER *sptr_ip_header, USHORT number_of_bytes);
static enum BOOLEAN check_if_syn_fin_rst_control_bits_in_tcp_header_are_set_and_if_ack_is_not_set (TCP_HEADER *sptr_tcp_header);
static void set_local_variables_for_compression_processing (LINE_COMPRESSION_STATE *sptr_line_compression_state,
	CONNECTION_STATE **ptr_to_sptr_connection_state, BYTE *bptr_change_mask, BYTE **ptr_to_bptr_compressed_header,
	BYTE *compressed_header, IP_HEADER *sptr_ip_header, TCP_HEADER *sptr_tcp_header, USHORT *usptr_header_length,
	enum BOOLEAN *eptr_send_uncompressed);
static void locate_or_create_connection_state (enum BOOLEAN *eptr_send_uncompressed,
	CONNECTION_STATE **ptr_to_sptr_connection_state, LINE_COMPRESSION_STATE *sptr_line_compression_state,
	IP_HEADER *sptr_ip_header, TCP_HEADER *sptr_tcp_header);
static enum BOOLEAN check_if_most_recently_used_connection_state_matches_current_packet (IP_HEADER *sptr_ip_header,
	IP_HEADER *sptr_old_ip_header, TCP_HEADER *sptr_tcp_header, TCP_HEADER *sptr_old_tcp_header);
static CONNECTION_STATE *search_and_get_matching_connection_state (enum BOOLEAN *eptr_found_header,
	LINE_COMPRESSION_STATE *sptr_line_compression_state, CONNECTION_STATE *sptr_connection_state,	IP_HEADER *sptr_ip_header,
	TCP_HEADER *sptr_tcp_header);
static void move_connection_state_to_front_of_list (LINE_COMPRESSION_STATE *sptr_line_compression_state,
	CONNECTION_STATE *sptr_connection_state, CONNECTION_STATE *sptr_previous_connection_state);
static void set_pointers_to_last_header_that_was_saved_in_connection_state (CONNECTION_STATE *sptr_connection_state,
	IP_HEADER **ptr_to_sptr_old_ip_header, TCP_HEADER **ptr_to_sptr_old_tcp_header);
static enum BOOLEAN check_if_any_changes_to_fields_that_we_did_not_expect_to_change (IP_HEADER *sptr_ip_header,
	IP_HEADER *sptr_old_ip_header, TCP_HEADER *sptr_tcp_header, TCP_HEADER *sptr_old_tcp_header);
/************************************************************************************/
enum TYPE_OF_PACKET vjc_compress_tcp_header (IP_PACKET **ptr_to_sptr_ip_packet, USHORT *usptr_number_of_bytes,
	LINE_COMPRESSION_STATE *sptr_line_compression_state)
{
	CONNECTION_STATE *sptr_connection_state;
	IP_HEADER *sptr_ip_header;													/* current IP header */
	IP_HEADER *sptr_old_ip_header;											/* last IP header */
	USHORT header_length;
	TCP_HEADER *sptr_old_tcp_header;											/* last TCP header */
	TCP_HEADER *sptr_tcp_header;												/* current TCP header */
	BYTE change_mask;																/* change mask */
	BYTE compressed_header[MAXIMUM_COMPRESSED_HEADER_LENGTH];		/* changes from last to current */
	BYTE *bptr;
	enum BOOLEAN send_uncompressed;
	USHORT checksum;
	ULONG delta_acknowledgment_number;
	ULONG delta_sequence_number;

	if (check_if_packet_is_compressible (ptr_to_sptr_ip_packet, &sptr_ip_header, &sptr_tcp_header, usptr_number_of_bytes)
		== FALSE)
		{
		++vjc.statistics.type_ip_packets_transmitted;

		return (TYPE_IP_PACKET);
		}
	else
		{
#ifdef DEBUG
		print_uncompressed_header_in_packet (*ptr_to_sptr_ip_packet, TRANSMIT, FROM_UPPER_LEVEL);
#endif

		set_local_variables_for_compression_processing (sptr_line_compression_state, &sptr_connection_state, &change_mask,
			&bptr, compressed_header, sptr_ip_header, sptr_tcp_header, &header_length, &send_uncompressed);

		locate_or_create_connection_state (&send_uncompressed, &sptr_connection_state, sptr_line_compression_state,
			sptr_ip_header, sptr_tcp_header);

#ifdef DEBUG
		print_connection_state (sptr_connection_state->uncompressed_header, TRANSMIT, OLD, sptr_connection_state);
#endif

		if (send_uncompressed == TRUE)
			{
			send_uncompressed_packet (sptr_line_compression_state, sptr_connection_state, sptr_ip_header, header_length,
				*ptr_to_sptr_ip_packet);

			return (TYPE_UNCOMPRESSED_TCP_PACKET);
			}

		set_pointers_to_last_header_that_was_saved_in_connection_state (sptr_connection_state,	&sptr_old_ip_header,
			&sptr_old_tcp_header);

		if (check_if_any_changes_to_fields_that_we_did_not_expect_to_change (sptr_ip_header, sptr_old_ip_header, sptr_tcp_header,
			sptr_old_tcp_header) == TRUE)
			{
			send_uncompressed_packet (sptr_line_compression_state, sptr_connection_state, sptr_ip_header, header_length,
				*ptr_to_sptr_ip_packet);

			return (TYPE_UNCOMPRESSED_TCP_PACKET);
			}
		else
			{
			figure_out_which_of_the_fields_changed (&change_mask, &send_uncompressed, sptr_tcp_header, sptr_old_tcp_header,
				&delta_sequence_number, &delta_acknowledgment_number, &bptr);

			if (send_uncompressed == TRUE)
				{
				send_uncompressed_packet (sptr_line_compression_state, sptr_connection_state, sptr_ip_header, header_length,
					*ptr_to_sptr_ip_packet);

	 			return (TYPE_UNCOMPRESSED_TCP_PACKET);
				}

			look_for_special_case_encodings (&change_mask, &send_uncompressed, header_length, sptr_ip_header, sptr_old_ip_header,
				delta_sequence_number, delta_acknowledgment_number, &bptr, compressed_header);

			if (send_uncompressed == TRUE)
				{
				send_uncompressed_packet (sptr_line_compression_state, sptr_connection_state, sptr_ip_header, header_length,
					*ptr_to_sptr_ip_packet);

				return (TYPE_UNCOMPRESSED_TCP_PACKET);
				}

			check_for_change_in_packet_identifier_or_whether_tcp_push_flag_is_set (&change_mask, sptr_ip_header, sptr_old_ip_header,
				sptr_tcp_header, &bptr);

			update_connection_state_with_new_header (&checksum, sptr_connection_state,	sptr_tcp_header, sptr_ip_header,
				header_length);

			insert_compressed_header_into_original_packet_in_place_of_old_header (ptr_to_sptr_ip_packet,
				sptr_line_compression_state, sptr_connection_state, change_mask,
				header_length, checksum, &bptr, compressed_header, sptr_ip_header, usptr_number_of_bytes);

#ifdef DEBUG
			print_connection_state (sptr_connection_state->uncompressed_header, TRANSMIT, NEW, sptr_connection_state);

			print_compressed_header_in_packet (*ptr_to_sptr_ip_packet, TRANSMIT, TO_LOWER_LEVEL,
				(USHORT) (*usptr_number_of_bytes - sizeof (UNION_MAC_HEADER)), sptr_line_compression_state);
#endif

			++vjc.statistics.type_tcp_compressed_packets_transmitted;

			return (TYPE_COMPRESSED_TCP_PACKET);
			}
		}
}
/************************************************************************************/
static enum BOOLEAN check_if_packet_is_compressible (IP_PACKET **ptr_to_sptr_ip_packet, IP_HEADER **ptr_to_sptr_ip_header,
	TCP_HEADER **ptr_to_sptr_tcp_header, USHORT *usptr_number_of_bytes)
{
	USHORT number_of_bytes_without_mac_header;

	/*
 	 * Bail if this is an IP fragment.
	 */

	*ptr_to_sptr_ip_header = (IP_HEADER *) &(*ptr_to_sptr_ip_packet)->header;

	number_of_bytes_without_mac_header = (USHORT) (*usptr_number_of_bytes - sizeof (UNION_MAC_HEADER));

	if ((check_if_packet_is_an_ip_fragment (*ptr_to_sptr_ip_header) == TRUE) ||
		(check_if_ip_protocol_is_not_tcp (*ptr_to_sptr_ip_header, number_of_bytes_without_mac_header) == TRUE))
		{
		return (FALSE);
		}

	*ptr_to_sptr_tcp_header = get_pointer_to_tcp_header (*ptr_to_sptr_ip_header);

	/*
	 * Bail if the TCP packet isn't `compressible' (i.e., ACK isn't set or some other control bit is set).
	 */

	if (check_if_syn_fin_rst_control_bits_in_tcp_header_are_set_and_if_ack_is_not_set (*ptr_to_sptr_tcp_header) == TRUE)
		{
		return (FALSE);
		}
	else
		{
		return (TRUE);
		}
}
/************************************************************************************/
static enum BOOLEAN check_if_packet_is_an_ip_fragment (IP_HEADER *sptr_ip_header)
{
	if ((get_fragment_offset_and_more_fragments_flag (sptr_ip_header) & host_to_net_short (IP_FRAGMENT_MASK)) !=
		0x0000)
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}
/************************************************************************************/
static USHORT get_fragment_offset_and_more_fragments_flag (IP_HEADER *sptr_ip_header)
{
	USHORT most_significant_part;
	USHORT least_significant_part;
	USHORT fragment_offset_with_more_fragments_flag;

	least_significant_part = sptr_ip_header->fragment_offset_least_significant_part;

	most_significant_part = (USHORT) sptr_ip_header->flags_fragment_offset.fragment_offset_most_significant_part;

	most_significant_part = (USHORT) (most_significant_part | (sptr_ip_header->flags_fragment_offset.more_fragment_flag <<
		SIZEOF_FRAGMENT_OFFSET_MOST_SIGNIFICANT_PART));

	fragment_offset_with_more_fragments_flag = (USHORT) ((most_significant_part << NUMBER_OF_BITS_IN_BYTE) +
		least_significant_part);

	return (fragment_offset_with_more_fragments_flag);
}
/************************************************************************************/
static enum BOOLEAN check_if_ip_protocol_is_not_tcp (IP_HEADER *sptr_ip_header, USHORT number_of_bytes)
{
	if ((sptr_ip_header->protocol != TCP_PROTOCOL) || (number_of_bytes <
		(MINIMUM_IP_HEADER_LENGTH_IN_BYTES + MINIMUM_TCP_HEADER_LENGTH_IN_BYTES)))
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}
/************************************************************************************/
TCP_HEADER *get_pointer_to_tcp_header (IP_HEADER *sptr_ip_header)
{
	USHORT header_length;
	TCP_HEADER *sptr_tcp_header;

	header_length = (USHORT) (sptr_ip_header->version_header_length.header_length << WORD_LENGTH_TO_BYTE_LENGTH_CONVERSION);

	sptr_tcp_header = (TCP_HEADER *) ((BYTE *) sptr_ip_header + header_length);

	return (sptr_tcp_header);
}
/************************************************************************************/
static enum BOOLEAN check_if_syn_fin_rst_control_bits_in_tcp_header_are_set_and_if_ack_is_not_set (TCP_HEADER *sptr_tcp_header)
{
	if (((sptr_tcp_header->flags.synchronize_flag == TRUE) || (sptr_tcp_header->flags.finished_flag == TRUE) ||
		(sptr_tcp_header->flags.reset_flag == TRUE)) || (sptr_tcp_header->flags.acknowledgment_flag == FALSE))
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}
/************************************************************************************/
static void set_local_variables_for_compression_processing (LINE_COMPRESSION_STATE *sptr_line_compression_state,
	CONNECTION_STATE **ptr_to_sptr_connection_state, BYTE *bptr_change_mask, BYTE **ptr_to_bptr_compressed_header,
	BYTE *compressed_header, IP_HEADER *sptr_ip_header, TCP_HEADER *sptr_tcp_header, USHORT *usptr_header_length,
	enum BOOLEAN *eptr_send_uncompressed)
{
	*ptr_to_sptr_connection_state = sptr_line_compression_state->sptr_last_connection_state->sptr_connection_state_next;

	*bptr_change_mask = 0x00;

	*ptr_to_bptr_compressed_header = &compressed_header[0];

	*usptr_header_length = (USHORT) sptr_ip_header->version_header_length.header_length;

	*usptr_header_length += (USHORT) sptr_tcp_header->header_length_byte.header_length;

	*usptr_header_length <<= WORD_LENGTH_TO_BYTE_LENGTH_CONVERSION;	/* It is shifted to get length in bytes */

	*eptr_send_uncompressed = FALSE;
}
/************************************************************************************/
static void locate_or_create_connection_state (enum BOOLEAN *eptr_send_uncompressed,
	CONNECTION_STATE **ptr_to_sptr_connection_state, LINE_COMPRESSION_STATE *sptr_line_compression_state,
	IP_HEADER *sptr_ip_header, TCP_HEADER *sptr_tcp_header)
{
	enum BOOLEAN found_header;
	IP_HEADER *sptr_old_ip_header;
	TCP_HEADER *sptr_old_tcp_header;
	enum BOOLEAN most_recently_used_connection_state_is_matched;

	/*
 	 * Packet is compressible -- we're going to send either a COMPRESSED_TCP_PACKET or UNCOMPRESSED_TCP_PACKET packet.
	 * Either way we need to locate (or create) the connection state. Special case the most recently used connection since
	 * it's most likely to be used again & we don't have to do any reordering if it's used.
 	 */

	found_header = FALSE;

	sptr_old_ip_header = (IP_HEADER *) &(*ptr_to_sptr_connection_state)->uncompressed_header[0];

	sptr_old_tcp_header = get_pointer_to_tcp_header (sptr_old_ip_header);

	most_recently_used_connection_state_is_matched =
		check_if_most_recently_used_connection_state_matches_current_packet (sptr_ip_header, sptr_old_ip_header,
		sptr_tcp_header, sptr_old_tcp_header);

	if (most_recently_used_connection_state_is_matched == FALSE)
		{
		/*
		 * Wasn't the first -- search for it.
		 *
		 * States are kept in a circularly linked list with last_connection_state pointing to the end of the list. The list is
		 * kept in lru order by moving a state to the head of the list whenever it is referenced. Since the list is short and,
		 * empirically, the connection we want is almost always near the front, we locate states via linear search. If we
		 * don't find a state for the datagram, the oldest state is (re-)used.
		 */

		*ptr_to_sptr_connection_state = search_and_get_matching_connection_state (&found_header, sptr_line_compression_state,
			*ptr_to_sptr_connection_state, sptr_ip_header, sptr_tcp_header);

		if (found_header == FALSE)
			{
			*eptr_send_uncompressed = TRUE;
			}
		}
}
/************************************************************************************/
static enum BOOLEAN check_if_most_recently_used_connection_state_matches_current_packet (IP_HEADER *sptr_ip_header,
	IP_HEADER *sptr_old_ip_header, TCP_HEADER *sptr_tcp_header, TCP_HEADER *sptr_old_tcp_header)
{
	if ((sptr_ip_header->source_ip_address != sptr_old_ip_header->source_ip_address) ||
		(sptr_ip_header->destination_ip_address != sptr_old_ip_header->destination_ip_address) ||
		(sptr_tcp_header->source_port != sptr_old_tcp_header->source_port) ||
		(sptr_tcp_header->destination_port != sptr_old_tcp_header->destination_port))
		{
		return (FALSE);
		}
	else
		{
		++vjc.statistics.matching_connection_state_was_the_most_recently_used_one;

		return (TRUE);
		}
}
/************************************************************************************/
static CONNECTION_STATE *search_and_get_matching_connection_state (enum BOOLEAN *eptr_found_header,
	LINE_COMPRESSION_STATE *sptr_line_compression_state, CONNECTION_STATE *sptr_connection_state, IP_HEADER *sptr_ip_header,
	TCP_HEADER *sptr_tcp_header)
{
	IP_HEADER *sptr_old_ip_header;
	TCP_HEADER *sptr_old_tcp_header;
	CONNECTION_STATE *sptr_previous_connection_state;
	CONNECTION_STATE *sptr_last_connection_state;

	sptr_last_connection_state = sptr_line_compression_state->sptr_last_connection_state;

	*eptr_found_header = FALSE;

	do
		{
		sptr_previous_connection_state = sptr_connection_state;

		sptr_connection_state = sptr_connection_state->sptr_connection_state_next;

		sptr_old_ip_header = (IP_HEADER *) &sptr_connection_state->uncompressed_header[0];

		sptr_old_tcp_header = get_pointer_to_tcp_header ((IP_HEADER *) sptr_old_ip_header);

		if ((sptr_ip_header->source_ip_address == sptr_old_ip_header->source_ip_address) &&
			(sptr_ip_header->destination_ip_address == sptr_old_ip_header->destination_ip_address) &&
			(sptr_tcp_header->source_port == sptr_old_tcp_header->source_port) &&
			(sptr_tcp_header->destination_port == sptr_old_tcp_header->destination_port))
			{
			*eptr_found_header = TRUE;

			break;
			}
		}
	while (sptr_connection_state != sptr_last_connection_state);

	if (*eptr_found_header == FALSE)
		{
		/*
		 * Didn't find it -- re-use oldest connection_state. Send an uncompressed packet that tells the other side what
		 * connection number we're using for this conversation. Note that since the state list is circular, the oldest state
		 * points to the newest and we only need to set last_connection_state to update the lru linkage.
		 */

		++vjc.statistics.least_recently_used_connection_state_was_replaced;

		sptr_line_compression_state->sptr_last_connection_state = sptr_previous_connection_state;
		}
	else
		{
		/* Found it -- move to the front of the connection state list. */

		++vjc.statistics.matching_connection_state_was_found;

		move_connection_state_to_front_of_list (sptr_line_compression_state,	sptr_connection_state,
			sptr_previous_connection_state);
		}

	return (sptr_connection_state);
}
/************************************************************************************/
static void move_connection_state_to_front_of_list (LINE_COMPRESSION_STATE *sptr_line_compression_state,
	CONNECTION_STATE *sptr_connection_state, CONNECTION_STATE *sptr_previous_connection_state)
{
	CONNECTION_STATE *sptr_last_connection_state;

	sptr_last_connection_state = sptr_line_compression_state->sptr_last_connection_state;

	if (sptr_last_connection_state == sptr_connection_state)
		{
 		sptr_line_compression_state->sptr_last_connection_state = sptr_previous_connection_state;
		}
	else
		{
		sptr_previous_connection_state->sptr_connection_state_next = sptr_connection_state->sptr_connection_state_next;

 		sptr_connection_state->sptr_connection_state_next = sptr_last_connection_state->sptr_connection_state_next;

		sptr_last_connection_state->sptr_connection_state_next = sptr_connection_state;
		}
}
/************************************************************************************/
static void set_pointers_to_last_header_that_was_saved_in_connection_state (CONNECTION_STATE *sptr_connection_state,
	IP_HEADER **ptr_to_sptr_old_ip_header, TCP_HEADER **ptr_to_sptr_old_tcp_header)
{
	*ptr_to_sptr_old_ip_header = (IP_HEADER *) &sptr_connection_state->uncompressed_header[0];

	*ptr_to_sptr_old_tcp_header = get_pointer_to_tcp_header (*ptr_to_sptr_old_ip_header);
}
/************************************************************************************/
static enum BOOLEAN check_if_any_changes_to_fields_that_we_did_not_expect_to_change (IP_HEADER *sptr_ip_header,
	IP_HEADER *sptr_old_ip_header, TCP_HEADER *sptr_tcp_header, TCP_HEADER *sptr_old_tcp_header)
{
	/*
	 * Make sure that only what we expect to change changed. The first, second and third lines of the `if' check the IP protocol
	 * version, header length & type of service. The 5th and 6th lines check the "Don't fragment flag" bit field. The 7th
	 * line checks the time-to-live field. The 8th line checks the TCP header length. The 9th-to-13th lines
	 * check the IP options, if any. The 14th-to-18th lines check the TCP options, if any. If any of these fields are different
	 * between the previous & current datagram, we send the current datagram `uncompressed'.
	 */

	if ((sptr_ip_header->version_header_length.version != sptr_old_ip_header->version_header_length.version) ||
		(sptr_ip_header->version_header_length.header_length != sptr_old_ip_header->version_header_length.header_length) ||
		(memcmp ((const void *) &sptr_ip_header->service_type, (const void *) &sptr_old_ip_header->service_type, 1) !=
		MEMCOMPARE_MATCH) ||
		(sptr_ip_header->flags_fragment_offset.do_not_fragment_flag !=
		sptr_old_ip_header->flags_fragment_offset.do_not_fragment_flag) ||
		(sptr_ip_header->time_to_live != sptr_old_ip_header->time_to_live) ||
		(sptr_tcp_header->header_length_byte.header_length != sptr_old_tcp_header->header_length_byte.header_length) ||
		(((BYTE) sptr_ip_header->version_header_length.header_length > MINIMUM_IP_HEADER_LENGTH_IN_WORDS) &&
		(memcmp ((const void *) ((ULONG *) sptr_ip_header + (sptr_ip_header->version_header_length.header_length)),
		(const void *) ((ULONG *) sptr_old_ip_header + (sptr_old_ip_header->version_header_length.header_length)),
		((sptr_ip_header->version_header_length.header_length << WORD_LENGTH_TO_BYTE_LENGTH_CONVERSION) -
		MINIMUM_IP_HEADER_LENGTH_IN_BYTES)) !=	MEMCOMPARE_MATCH)) ||
		((sptr_tcp_header->header_length_byte.header_length > MINIMUM_TCP_HEADER_LENGTH_IN_WORDS) &&
		(memcmp ((const void *) ((ULONG *) sptr_tcp_header + (sptr_tcp_header->header_length_byte.header_length)),
		(const void *) ((ULONG *) sptr_old_tcp_header + (sptr_old_tcp_header->header_length_byte.header_length)),
		(((BYTE) sptr_tcp_header->header_length_byte.header_length << WORD_LENGTH_TO_BYTE_LENGTH_CONVERSION) -
		MINIMUM_TCP_HEADER_LENGTH_IN_BYTES)) != MEMCOMPARE_MATCH)))
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}

