/*	$Modname: vvjcmisc.h$  $version: 1.1$      $date: 08/26/94$   */
/*
* 	$lgb$
1.0 08/25/94 titus
1.1 08/26/94 titus Add Copyright
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#ifndef _VVJCMISC_H_
#define _VVJCMISC_H_


typedef struct SERVICE_TYPE_BIT_STRUCTURE
{
#ifndef BIG_ENDIAN
	unsigned int	unused:2;
	unsigned int	high_reliability:1;
	unsigned int	high_throughput:1;
	unsigned int	low_delay:1;
	unsigned int	precedence:3;
#else
	unsigned int	precedence:3;
	unsigned int	low_delay:1;
	unsigned int	high_throughput:1;
	unsigned int	high_reliability:1;
	unsigned int	unused:2;
#endif
} SERVICE_TYPE_BIT_STRUCTURE;


typedef union UNION_SERVICE_TYPE_BIT_STRUCTURE
{
	SERVICE_TYPE_BIT_STRUCTURE	_bit;
	BYTE								_byte;
} UNION_SERVICE_TYPE_BIT_STRUCTURE;


typedef struct SOCKET
{
	ULONG 	ip_address;
	USHORT 	port;
	USHORT	virtual_port_number;
} SOCKET;


typedef struct VERSION_LENGTH_BIT_STRUCTURE
{
#ifndef BIG_ENDIAN
	unsigned int	header_length:4;
	unsigned int	version:4;
#else
	unsigned int	version:4;
	unsigned int	header_length:4;
#endif
} VERSION_LENGTH_BIT_STRUCTURE;


typedef struct FLAG_FRAGMENT_OFFSET_BIT_STRUCTURE
{
#ifndef BIG_ENDIAN
	unsigned int	fragment_offset_most_significant_part:5;
	unsigned int	more_fragment_flag:1;
	unsigned int	do_not_fragment_flag:1;
	unsigned int	unused_bit:1;
#else
	unsigned int	unused_bit:1;
	unsigned int	do_not_fragment_flag:1;
	unsigned int	more_fragment_flag:1;
	unsigned int	fragment_offset_most_significant_part:5;
#endif
} FLAG_FRAGMENT_OFFSET_BIT_STRUCTURE;


typedef struct IP_HEADER
{
	VERSION_LENGTH_BIT_STRUCTURE 			version_header_length;
	SERVICE_TYPE_BIT_STRUCTURE				service_type;
	USHORT										total_length;
	USHORT										identifier;
	FLAG_FRAGMENT_OFFSET_BIT_STRUCTURE 	flags_fragment_offset;
	BYTE											fragment_offset_least_significant_part;
	BYTE											time_to_live;
	BYTE											protocol;
	USHORT										header_checksum;
	ULONG											source_ip_address;
	ULONG											destination_ip_address;
} IP_HEADER;


typedef union UNION_OPTIONS_OR_DATA
{
	BYTE	data;
	BYTE	ip_options;

} UNION_OPTIONS_OR_DATA;


typedef struct	IP_PACKET
{
	UNION_MAC_HEADER			mac_header;
	IP_HEADER					header;
	UNION_OPTIONS_OR_DATA	options_or_data;
} IP_PACKET;


typedef struct TCP_HEADER_LENGTH_BYTE
{
#ifndef BIG_ENDIAN
	unsigned int reserved:4;
	unsigned int header_length:4;
#else
	unsigned int header_length:4;
	unsigned int reserved:4;
#endif
} TCP_HEADER_LENGTH_BYTE;


typedef struct TCP_HEADER_FLAGS
{
#ifndef BIG_ENDIAN
	unsigned int finished_flag:1;
	unsigned int synchronize_flag:1;
	unsigned int reset_flag:1;
	unsigned int push_flag:1;
	unsigned int acknowledgment_flag:1;
	unsigned int urgent_flag:1;
	unsigned int congest_flag:1;	/* not in rfc793 */
	unsigned int reserved:1;
#else
	unsigned int reserved:1;
	unsigned int congest_flag:1;	/* not in rfc793 */
	unsigned int urgent_flag:1;
	unsigned int acknowledgment_flag:1;
	unsigned int push_flag:1;
	unsigned int reset_flag:1;
	unsigned int synchronize_flag:1;
	unsigned int finished_flag:1;
#endif
} TCP_HEADER_FLAGS;


/* TCP header as defined by RFC793 */
typedef struct TCP_HEADER
{
	USHORT 						source_port;
	USHORT 						destination_port;
	ULONG	 						sequence_number;
	ULONG	 						acknowledgment_number;
	TCP_HEADER_LENGTH_BYTE 	header_length_byte;
	TCP_HEADER_FLAGS			flags;
	USHORT						window_size;
	USHORT						checksum;
	USHORT						urgent_pointer;
} TCP_HEADER;

#endif
