#include	"defs.h"
#include "ethernet.h"

extern enum	BOOLEAN	TxPktOnEth(void *, USHORT,USHORT);

extern ETHERNET_CLASS		ethernet;


/****************************************************************************/
/*
	This is called from lsl to transmit a packet. This is called with interrupts
	enabled.
	look in wan device driver header files for details on the different 
	pointers to tx & rx descriptors. Look at the corresponding function in
	c-files in wan device driver.
*/
/****************************************************************************/
enum TEST send_ethernet_packet (ULONG protocol_stack_id,
		USHORT port_number, 
		USHORT virtual_port_number, 
		void *sptr_tx_buffer,
		USHORT number_of_bytes,	
		enum BOOLEAN bridged_packet, 			/* do not cal new_crc */
		enum BOOLEAN protocol_packet,			/* device driver buffer */
		void (*fptr_tx_completion) (USHORT port_number, 
			void *sptr_ethernet_buffer) )
{
	int	TmpSr;
	ETHERNET_PORT_CLASS *sptr_ethernet_port_class = &ethernet.port;
	ETHERNET_TX_DESCRIPTOR *sptr_current_tx_descriptor;

	PARAMETER_NOT_USED (protocol_stack_id);
	PARAMETER_NOT_USED (virtual_port_number);

	sptr_current_tx_descriptor = get_entry_from_list (&sptr_ethernet_port_class->free_tx_list);

	if ( (sptr_current_tx_descriptor == NULL) )
		{

		++sptr_ethernet_port_class->statistics.number_of_rejected_tx_packets;
/* By Sanjay */
		++(((DEVICE_DRIVER_REGISTRATION_ENTRY *)(sptr_ethernet_port_class->device_driver_id))->rfc1213_ifEntry.ifOutDiscards);
/* By Sanjay */

		if (protocol_packet == TRUE)
			{
			packet_forward_device_driver_free (port_number, ethernet.port.device_driver_id,
				(void *) ((ULONG) sptr_tx_buffer));
			}

		if (fptr_tx_completion != NULL)
			{
			(*fptr_tx_completion) (virtual_port_number, sptr_tx_buffer);
			}

		return (FAIL);
		}

	++sptr_ethernet_port_class->statistics.number_of_packets_to_tx;
/* By Sanjay */
	++(((DEVICE_DRIVER_REGISTRATION_ENTRY *)(sptr_ethernet_port_class->device_driver_id))->rfc1213_ifEntry.ifOutQLen);
 	(((DEVICE_DRIVER_REGISTRATION_ENTRY *)(sptr_ethernet_port_class->device_driver_id))->rfc1213_ifEntry.ifOutOctets) += number_of_bytes;
/* By Sanjay */

	sptr_current_tx_descriptor->length = number_of_bytes;
	sptr_current_tx_descriptor->protocol_stack_virtual_port_number = virtual_port_number;
	sptr_current_tx_descriptor->sptr_tx_packet = sptr_tx_buffer;
	sptr_current_tx_descriptor->fptr_tx_complete = fptr_tx_completion;
	sptr_current_tx_descriptor->device_driver_buffer = protocol_packet;
	sptr_current_tx_descriptor->bridged_packet = bridged_packet;
	sptr_current_tx_descriptor->in_use = TRUE;

/*
	we are modifying the current_tx_list and scheduled_tx_list lists both of 
	these are being accessed even in the ethernet interrupts service routine
	so disable the interrupts.
*/
	TmpSr = _GPL();
	_SPL(7);
	if( TxPktOnEth(sptr_tx_buffer,number_of_bytes,bridged_packet) )	

/* 
   if a free TX BD can be obtained in the 68360 for ethernet this returns TRUE
   then we must put this on scheduled_tx_list list otherwise we need to put
   this on current_tx_list so that when ever a tx gets completed current_tx_list
   can be checked for any pending frames to be txed.
*/
	    add_entry_to_list (&sptr_ethernet_port_class->scheduled_tx_list, (LINK *) sptr_current_tx_descriptor);
	else
	    add_entry_to_list (&sptr_ethernet_port_class->current_tx_list, (LINK *) sptr_current_tx_descriptor);

	/* Srikar, Mar 24, 1997. Following added to inform LSL of packet transmit submission. */

	lsl_control(LSL_PACKET_TRANSMIT_SUBMITTED_OR_COMPLETED, port_number, LSL_PACKET_SUBMITTED_FOR_TRANSMIT);

	_SPL(TmpSr);
	return (PASS);
}
/****************************************************************************/
/*
	this is called from interrupt service routine for every completed tx.
	take out the first tx bd from scheduled for tx list and put them on 
	transmit completed list.
	This is called with ints disabled.
	look in wan device driver header files for details on the different 
	pointers to tx & rx descriptors. Look at the corresponding function in
	c-files in wan device driver.
*/
/****************************************************************************/

void ethernet_tx_isr_complete()
{

	ETHERNET_PORT_CLASS *sptr_ether_port_class = &ethernet.port;
	ETHERNET_TX_DESCRIPTOR *sptr_tx_descriptor;

	sptr_tx_descriptor = get_entry_from_list ((LINK *) &ethernet.port.scheduled_tx_list);
	if(sptr_tx_descriptor == NULL){
/*		ether_printf("interrupt for packet not sent \n\r");*/
		return;
	}
	--sptr_ether_port_class->statistics.number_of_packets_to_tx;
	sptr_ether_port_class->statistics.number_of_packets_txed++;
	sptr_ether_port_class->statistics.number_of_bytes_txed +=
						sptr_tx_descriptor->length;
/* By Sanjay */
	--(((DEVICE_DRIVER_REGISTRATION_ENTRY *)(sptr_ether_port_class->device_driver_id))->rfc1213_ifEntry.ifOutQLen);
/* By Sanjay */
	add_entry_to_list (&sptr_ether_port_class->transmit_completed_list, (LINK *) sptr_tx_descriptor);

	sptr_tx_descriptor = get_entry_from_list ((LINK *) &ethernet.port.current_tx_list);
	if(sptr_tx_descriptor == NULL){
		return;
	}
	if(TxPktOnEth(sptr_tx_descriptor->sptr_tx_packet,sptr_tx_descriptor->length,sptr_tx_descriptor->bridged_packet)) {
		add_entry_to_list (&sptr_ether_port_class->scheduled_tx_list, (LINK *) sptr_tx_descriptor);
	} else {
		/* This entry couldn't be scheduled!!! at least do the last rites */
		/* Vidy 05/06/96 */
		add_entry_to_list (&sptr_ether_port_class->transmit_completed_list, (LINK *) sptr_tx_descriptor);
		ether_printf("\n\r FATAL atleast one of the tx bd's must be free \r\n");
	}
}
/****************************************************************************/
/*
	This is called with interrupts enabled from main to call transmit completed
	routines of all the tx descriptors queued up in current_tx_list.
	look in wan device driver header files for details on the different 
	pointers to tx & rx descriptors. Look at the corresponding function in
	c-files in wan device driver.
*/
/****************************************************************************/
void ethernet_packet_transmitted (int portnum)
{
	int	TmpSr;
	ETHERNET_PORT_CLASS *sptr_ether_port_class = &ethernet.port;
	ETHERNET_TX_DESCRIPTOR *sptr_tx_descriptor;
	ETHERNET_RX_DESCRIPTOR *sptr_rx_descriptor;


	sptr_rx_descriptor = (ETHERNET_RX_DESCRIPTOR *)
		get_entry_from_list ((LINK *) &ethernet.port.rx_descriptor_need_buffer_list);

	if (sptr_rx_descriptor != NULL)
		{
		get_a_new_ethernet_buffer (ETHERNET_PORT_NUMBER, sptr_rx_descriptor);
		}
/*
	transmit_completed_list queue is modified even in the interrupt service routine
	so disable interrupts
*/
	TmpSr = _GPL();
	_SPL(7);
	sptr_tx_descriptor = get_entry_from_list ((LINK *) &ethernet.port.transmit_completed_list);
	_SPL(TmpSr);
	while(sptr_tx_descriptor != NULL)
	{
		sptr_tx_descriptor->in_use = FALSE;

#ifdef NOT_NOW
		++sptr_ether_port_class->statistics.number_of_packets_txed;
#endif

		if (sptr_tx_descriptor->fptr_tx_complete != NULL)
			{
			(*sptr_tx_descriptor->fptr_tx_complete) (
				sptr_tx_descriptor->protocol_stack_virtual_port_number,sptr_tx_descriptor->sptr_tx_packet);

			/* Srikar, Mar 24, 1997. Following added to inform LSL of packet transmit completion. */

			lsl_control(LSL_PACKET_TRANSMIT_SUBMITTED_OR_COMPLETED, portnum, LSL_PACKET_TRANSMIT_OVER);

			}

		if (sptr_tx_descriptor->device_driver_buffer == TRUE)
			{
			packet_forward_device_driver_free (ETHERNET_PORT_NUMBER,ethernet.port.device_driver_id,
				sptr_tx_descriptor->sptr_tx_packet);
			}
	   add_entry_to_list (&sptr_ether_port_class->free_tx_list,(LINK *) &sptr_tx_descriptor->links);

		TmpSr = _GPL();
		_SPL(7);
		sptr_tx_descriptor = get_entry_from_list ((LINK *) &ethernet.port.transmit_completed_list);
		_SPL(TmpSr);
	}
}

void ether_tx_error()
{
/* By Sanjay */
	++(((DEVICE_DRIVER_REGISTRATION_ENTRY *)(ethernet.port.device_driver_id))->rfc1213_ifEntry.ifOutErrors);
	ethernet.port.statistics.number_of_tx_errors++;
/* By Sanjay */
}
