#ifndef LINK_TYPEDEF_DEFINED

#define LINK_TYPEDEF_DEFINED

typedef	struct	LINK
{
	struct	LINK	*sptr_forward_link;
	struct	LINK	*sptr_backward_link;
} LINK;

#endif

typedef	union	BUFFER
{
	ETHERNET_BUFFER			ethernet_packet;
	BYTE					data[2048];
} BUFFER;

typedef	struct	ETHERNET_TX_DESCRIPTOR
{
	LINK					links;
	USHORT					length;

	BUFFER					*sptr_tx_packet;

	void					(*fptr_tx_complete) (USHORT port_number,BUFFER *sptr_ethernet_buffer);

	enum BOOLEAN					in_use;
	enum BOOLEAN					device_driver_buffer;
	USHORT							protocol_stack_virtual_port_number;
	USHORT							bridged_packet;
} ETHERNET_TX_DESCRIPTOR;

typedef	struct	ETHERNET_RX_DESCRIPTOR
{
	LINK				links;
	ETHERNET_BUFFER	*sptr_rx_buffer;
	USHORT			buffer_size;
	USHORT			number_of_bytes_rxed;
} ETHERNET_RX_DESCRIPTOR;

typedef	union	UNION_ETHERNET_DESCRIPTOR
{
	ETHERNET_TX_DESCRIPTOR	tx;
	ETHERNET_RX_DESCRIPTOR 	rx;
} UNION_ETHERNET_DESCRIPTOR;

typedef	struct	ETHERNET_STATISTICS
{
	ULONG				number_of_packets_txed;
	ULONG				number_of_bytes_txed;
	ULONG				number_of_packets_to_tx;
	ULONG				number_of_rejected_tx_packets;
	ULONG				number_of_tx_errors;

	ULONG				number_of_packets_rxed;
	ULONG				number_of_bytes_rxed;
	ULONG				number_of_rx_errors;
	ULONG				number_of_rx_queue_overflows;

#if 0
	ULONG				number_of_wrong_byte_counts_rxed;
	ULONG				number_of_rx_overruns;

	ULONG				number_of_out_of_receive_descriptors;
	ULONG 			number_of_too_small_packets_received;
	ULONG 			number_of_too_large_packets_received;

	ULONG				number_of_wrong_sized_rx_frames;

	ULONG				number_of_start_tx_commands;
	ULONG				number_of_tx_stalls;
	ULONG				number_of_tx_unknowns;
	ULONG				number_of_queued_tx_commands;

	ULONG				number_of_tx_underruns;

	ULONG				number_of_crc_errors;
	ULONG				number_of_overrun_errors;
	ULONG				number_of_residual_bit_frame_or_normal_end_of_frames;
	ULONG				number_of_frame_with_abort_errors;
	ULONG				number_of_short_frame_errors;
#endif

} ETHERNET_STATISTICS;

typedef	struct	ETHERNET_PORT_CLASS
{
	enum BOOLEAN							enabled;

	ETHERNET_TX_DESCRIPTOR					
								tx_descriptor[NUMBER_OF_ETHERNET_TX_BUFFERS];
	ETHERNET_RX_DESCRIPTOR		
								rx_descriptor[NUMBER_OF_ETHERNET_RX_BUFFERS];

	LINK									free_tx_list;
	LINK									current_tx_list;

/* Jo	ETHERNET_TX_DESCRIPTOR					*sptr_current_tx_descriptor;
	ETHERNET_RX_DESCRIPTOR					*sptr_current_rx_descriptor;
	ETHERNET_RX_DESCRIPTOR					*sptr_partial_rx_descriptor;*/
	LINK									free_rx_list;
	LINK									current_rx_list;
	LINK									scheduled_rx_list;
	LINK									scheduled_tx_list;
	LINK									transmit_completed_list;

	USHORT								number_of_rx_buffers;

	LINK									rx_descriptor_need_buffer_list;

	BYTE									port_number;
	ULONG									device_driver_id;

	ETHERNET_STATISTICS				statistics;


	USHORT 								minimum_packet_length;
	enum BOOLEAN						port_is_AUI;
	BYTE									ethernet_local_io_value;
} ETHERNET_PORT_CLASS;

typedef	struct	ETHERNET_CLASS
{
	enum BOOLEAN		enabled;
#if 0 /* Jo 17/05/99 */
	enum BOOLEAN		printing_enabled;
	enum BOOLEAN		initialization_printing_enabled;
	enum BOOLEAN		rx_printing_enabled;
	enum BOOLEAN		tx_printing_enabled;
#endif /* Jo 17/05/99 */

	ETHERNET_PORT_CLASS	port;
} ETHERNET_CLASS;

/* asyncini.c */

enum TEST initialize_ethernet_controller (ULONG clock_ticks_per_second);

/*void ethernet_printf (enum ASYNC_PRINTF_GROUPS printf_group,const char *cptr_format, ...);*/

/* asynctx.c */

enum TEST send_ethernet_packet (ULONG protocol_stack_id,USHORT port_number,
		USHORT virtual_port_number,void *sptr_tx_buffer,
		USHORT number_of_bytes, enum BOOLEAN bridged_packet,
		enum BOOLEAN protocol_packet,
		void (*fptr_tx_completion) (USHORT port_number,
			void *sptr_async_buffer));

void ethernet_packet_transmitted (int);

/* asyncrx.c */

enum BOOLEAN ethernet_packet_received (USHORT port_number,ETHERNET_BUFFER **sptr_async_buffer_rxed,
	USHORT *usptr_number_of_bytes_rxed);

void ethernet_return_buffer_to_device_driver (USHORT real_port_number,void *vptr_buffer);

enum TEST get_a_new_ethernet_buffer (USHORT real_port_number,ETHERNET_RX_DESCRIPTOR *sptr_current_rx_descriptor);


