#include	"defs.h"
/*	$Modname: annexdin.c$  $version: 1.12$      $date: 08/17/94$   */
/*
* 	$lgb$
1.0 01/02/93 ross
1.1 01/02/93 ross
1.2 01/10/93 ross changing to symmetric dlci's - IBM way
1.3 01/17/93 ross added function to store ipx dlci
1.4 01/23/93 ross changed .link_up = FALSE to TRUE, for boot up messages.
1.5 01/23/93 ross moved lsl code into frtx and frrx
1.6 10/11/93 ross update for changes in LSL, changed some CRC handling.
1.7 03/01/94 ross testing with cisco frame relay and pacific bell.
1.8 03/19/94 ross fixes for cisco conformance testing
1.9 03/27/94 ross added inverse arp, frutil.c, rfc1315 naming, and serial device driver function pointers.
1.10 04/12/94 ross removed unnecessary include file.
1.11 06/08/94 ross fixed problem with N391 timer.  Courtesy of Rick.
1.12 08/17/94 ross fixes for dlci up/down effects on virtual ports
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include "fr.h"
/****************************************************************************/
static void delete_all_dlcis_on_port (USHORT port_number);
/****************************************************************************/
void initialize_annex_d (void)
{
	USHORT port_number;       /* port number for loop */

	for (port_number = 0x0000; port_number < frame_relay.total_number_of_frame_relay_ports; ++port_number)
		{
		if (frame_relay.port[port_number].annex_d.enabled == TRUE)
			{
			if (frame_relay.port[port_number].management_type == 0)
				frame_relay.port[port_number].management_type = ANNEX_D_MGMT_TYPE;
			}

		frame_relay.port[port_number].annex_d.user.liv_response_received = TRUE;

		if (frame_relay.port[port_number].annex_d.frDlcmiErrorThreshold == 0x00000000L)
			{
			frame_relay.port[port_number].annex_d.frDlcmiErrorThreshold = N392_DEFAULT;
			}

		if (frame_relay.port[port_number].annex_d.frDlcmiMonitoredEvents == 0x00000000L)
			{
			frame_relay.port[port_number].annex_d.frDlcmiMonitoredEvents = N393_DEFAULT;
			}

		if (frame_relay.port[port_number].annex_d.frDlcmiPollingInterval == 0x00000000L)
			{
			frame_relay.port[port_number].annex_d.frDlcmiPollingInterval = T391_DEFAULT;
			}

		if (frame_relay.port[port_number].annex_d.polling_verification_timer_T392 == 0x00000000L)
			{
			frame_relay.port[port_number].annex_d.polling_verification_timer_T392 = T392_DEFAULT;
			}

		if (frame_relay.port[port_number].annex_d.frDlcmiFullEnquiryInterval == 0x00000000L)
			{
			frame_relay.port[port_number].annex_d.frDlcmiFullEnquiryInterval = N391_DEFAULT;
			}

		frame_relay.port[port_number].annex_d.frDlcmiFullEnquiryInterval *=
			frame_relay.port[port_number].annex_d.frDlcmiPollingInterval;

		frame_relay.port[port_number].annex_d.link_state = FRAME_RELAY_LINK_DOWN; 
		frame_relay.port[port_number].annex_d.network.time_since_last_status_enquiry_message_received = frame_relay.timer;

		frame_relay.port[port_number].mib.frDlcmiState = ANSI_T1_617_D;
		frame_relay.port[port_number].mib.frDlcmiAddress = Q922;
		frame_relay.port[port_number].mib.frDlcmiAddressLen = TWO_BYTES_ADDRESS_LEN;
		frame_relay.port[port_number].mib.frDlcmiMaxSupportedVCs = MAXIMUM_NUMBER_OF_DLCI_CONNECTIONS;
		frame_relay.port[port_number].mib.frDlcmiMulticast = FR_DLCMI_MULTICAST_NOT_BROADCAST;
#if 0	/* KVSP */
		frame_relay.port[port_number].mib.frCircuitCommittedBurst = 0x00000000L;
		frame_relay.port[port_number].mib.frCircuitExcessBurst = 0x00000000L;
		frame_relay.port[port_number].mib.frCircuitThroughput = 0x00000000L;
#endif
		}
}
/****************************************************************************/
void reset_frame_relay_port (USHORT port_number)
{
	delete_all_dlcis_on_port (port_number);

	frame_relay.port[port_number].annex_d.link_state = FRAME_RELAY_LINK_DOWN; 
	frame_relay.port[port_number].annex_d.network.time_since_last_status_enquiry_message_received = frame_relay.timer;
}
/****************************************************************************/
static void delete_all_dlcis_on_port (USHORT port_number)
{
	DLCI_LIST_ENTRY *sptr_dlci_connection_entry;

	while (TRUE)
		{
		sptr_dlci_connection_entry = get_entry_from_list ((LINK *) &frame_relay.port[port_number].dlci_list);

		if (sptr_dlci_connection_entry == NULL)
			{
			break;
			}

		sptr_dlci_connection_entry->mib.frCircuitState = INACTIVE_FRAME_RELAY_CIRCUIT_STATE;

		if (frame_relay.fptr_snmp_trap_function != NULL)
			{
			(*frame_relay.fptr_snmp_trap_function) (sptr_dlci_connection_entry->mib.frCircuitIfIndex,sptr_dlci_connection_entry->dlci,
				sptr_dlci_connection_entry->mib.frCircuitState);
			}
		}
}
