#include	"defs.h"
/*	$Modname: frdlci.c$  $version: 1.10$      $date: 04/21/95$   */
/*
* 	$lgb$
1.0 01/02/93 ross
1.1 01/02/93 ross
1.2 01/10/93 ross changing to symmetric dlci's - IBM way
1.3 01/17/93 ross added function to store ipx dlci
1.4 10/11/93 ross update for changes in LSL, changed some CRC handling.
1.5 03/01/94 ross testing with cisco frame relay and pacific bell.
1.6 03/27/94 ross added inverse arp, frutil.c, rfc1315 naming, and serial device driver function pointers.
1.7 04/12/94 ross added code to clear out source address in normalized headers.
1.8 06/13/94 ross added snmp access routines, fixed bug with ip header tx's.  Courtesy of Rick.
1.9 08/17/94 ross fixes for dlci up/down effects on virtual ports
1.10 04/21/95 ross Increased size of stack_id.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <stdlib.h>
#include "fr.h"
/****************************************************************************/
enum TEST create_dlci_connection_entry (USHORT port_number,USHORT dlci,enum BOOLEAN active,enum BOOLEAN new)
{
	DLCI_LIST_ENTRY *sptr_dlci_connection_entry;
	USHORT index;

	sptr_dlci_connection_entry = (DLCI_LIST_ENTRY *) calloc (1,sizeof (DLCI_LIST_ENTRY));

	if (sptr_dlci_connection_entry != NULL)
		{
		sptr_dlci_connection_entry->dlci = dlci;
		sptr_dlci_connection_entry->new = new;

#if 1
		sptr_dlci_connection_entry->mode = PVC_ADHERE_TO_CIR;
		sptr_dlci_connection_entry->CIR = 32000;
		sptr_dlci_connection_entry->Be = 0;

		if (frame_relay.CIR_interval == 0)
			frame_relay.CIR_interval = 1000;	/* make default to 1 sec */

		sptr_dlci_connection_entry->committed_burst_size =
			(((sptr_dlci_connection_entry->CIR * (ULONG)frame_relay.CIR_interval) / (ULONG)1000) >> 3);
		sptr_dlci_connection_entry->excess_burst_size =
			(((sptr_dlci_connection_entry->Be * (ULONG)frame_relay.CIR_interval) / (ULONG)1000) >> 3);

		sptr_dlci_connection_entry->access_rate = sptr_dlci_connection_entry->committed_burst_size;
		sptr_dlci_connection_entry->current_rate = sptr_dlci_connection_entry->committed_burst_size;
		sptr_dlci_connection_entry->minimum_rate = (sptr_dlci_connection_entry->committed_burst_size >> 2);
		sptr_dlci_connection_entry->step_up_rate = (sptr_dlci_connection_entry->access_rate >> 4);
		sptr_dlci_connection_entry->step_down_rate = (sptr_dlci_connection_entry->access_rate >> 3);

		sptr_dlci_connection_entry->start_time_of_measurement_interval = (ULONG)-1L;
		sptr_dlci_connection_entry->bytes_sent_in_this_interval = 0;
		sptr_dlci_connection_entry->stop_sending = FALSE;
#endif

		/* compression related variables - KVSP */
#if 1
		sptr_dlci_connection_entry->compression = FALSE;
		sptr_dlci_connection_entry->mode_1_state = DISABLED_STATE;
		sptr_dlci_connection_entry->tx_sequence_number = 0;
		sptr_dlci_connection_entry->rx_sequence_number = 0xFF;
		sptr_dlci_connection_entry->waiting_for_reset_ack = FALSE;
		sptr_dlci_connection_entry->sent_reset_ack = FALSE;
		sptr_dlci_connection_entry->wait_timer = 0xFFFF;
#endif

		/* statistics related variables */
#if 1
		sptr_dlci_connection_entry->dlci_down_count = 0;
		sptr_dlci_connection_entry->dlci_uptime = 0;
		sptr_dlci_connection_entry->thruput = 0;
		sptr_dlci_connection_entry->bytes_sent_till_last_sec = 0;

		memset (&sptr_dlci_connection_entry->bytes_sent, (int)NULL, sizeof(DLCI_TRAFFIC));
		memset (&sptr_dlci_connection_entry->frames_sent, (int)NULL, sizeof(DLCI_TRAFFIC));
		memset (&sptr_dlci_connection_entry->bytes_received, (int)NULL, sizeof(DLCI_TRAFFIC));
		memset (&sptr_dlci_connection_entry->frames_received, (int)NULL, sizeof(DLCI_TRAFFIC));
#endif

		sptr_dlci_connection_entry->BECN_set = FALSE;
		sptr_dlci_connection_entry->FECN_set = FALSE;

		sptr_dlci_connection_entry->BECN_count = 0;

		sptr_dlci_connection_entry->wan_tx_buffers =
			(WAN_TX_DESCRIPTOR *) calloc (MAX_TX_QUEUE_PER_DLCI,sizeof (WAN_TX_DESCRIPTOR));
		if (sptr_dlci_connection_entry->wan_tx_buffers != NULL)
			{
			for (index=0; index < MAX_TX_QUEUE_PER_DLCI; index++)
				{
				add_entry_to_list ((LINK *)&sptr_dlci_connection_entry->tx_free_list,
					(LINK *)&sptr_dlci_connection_entry->wan_tx_buffers[index]);
				}
			}
		else
			{
			printf ("FR: No memory to queue buffers for congestion control\r\n");
			}

		if (active == TRUE)
			{
			sptr_dlci_connection_entry->mib.frCircuitState = ACTIVE_FRAME_RELAY_CIRCUIT_STATE;
			}
		else
			{
			sptr_dlci_connection_entry->mib.frCircuitState = INACTIVE_FRAME_RELAY_CIRCUIT_STATE;
			}

		sptr_dlci_connection_entry->mib.frCircuitIfIndex = port_number;

		++frame_relay.port[port_number].number_of_current_dlcis;

		if (frame_relay.fptr_snmp_trap_function != NULL)
			{
			(*frame_relay.fptr_snmp_trap_function) (sptr_dlci_connection_entry->mib.frCircuitIfIndex,sptr_dlci_connection_entry->dlci,
				sptr_dlci_connection_entry->mib.frCircuitState);
			}

#if 0
		sptr_dlci_connection_entry->mib.frCircuitDlci = (ULONG) dlci;
#else
		sptr_dlci_connection_entry->mib.frCircuitDlci = (BYTE) dlci;
#endif
		sptr_dlci_connection_entry->mib.frCircuitReceivedFECNs = 0;
		sptr_dlci_connection_entry->mib.frCircuitReceivedBECNs = 0;
		sptr_dlci_connection_entry->mib.frCircuitSentFrames = 0;
		sptr_dlci_connection_entry->mib.frCircuitSentOctets = 0;
		sptr_dlci_connection_entry->mib.frCircuitReceivedFrames = 0;
		sptr_dlci_connection_entry->mib.frCircuitReceivedOctets = 0;
		sptr_dlci_connection_entry->mib.frCircuitCreationTime = frame_relay.timer;
		sptr_dlci_connection_entry->mib.frCircuitLastTimeChange = frame_relay.timer;
#if 0	/* KVSP */
		sptr_dlci_connection_entry->mib.frCircuitCommittedBurst = frame_relay.port[port_number].mib.frCircuitCommittedBurst;
		sptr_dlci_connection_entry->mib.frCircuitExcessBurst = frame_relay.port[port_number].mib.frCircuitExcessBurst;
		sptr_dlci_connection_entry->mib.frCircuitThroughput = frame_relay.port[port_number].mib.frCircuitThroughput;
#else
		sptr_dlci_connection_entry->mib.frCircuitCommittedBurst = sptr_dlci_connection_entry->committed_burst_size;
		sptr_dlci_connection_entry->mib.frCircuitExcessBurst = sptr_dlci_connection_entry->excess_burst_size;
		sptr_dlci_connection_entry->mib.frCircuitThroughput = 0;	/* non-committed */
#endif

		sptr_dlci_connection_entry->ipx_virtual_port_number = 0xFFFF;
		sptr_dlci_connection_entry->ip_virtual_port_number = 0xFFFF;
		sptr_dlci_connection_entry->stp_virtual_port_number = 0xFFFF;

		add_entry_to_list ((LINK *) &frame_relay.port[port_number].dlci_list,(LINK *) &sptr_dlci_connection_entry->links);

		printf ("\r\nCreated DLCI Entry = %d", dlci);

		return (PASS);
		}
	else
		return (FAIL);
}
/****************************************************************************/
void delete_dlci_connection_entry (USHORT port_number,USHORT dlci)
{
	DLCI_LIST_ENTRY *sptr_matching_entry;

	sptr_matching_entry = get_dlci_connection_entry (port_number,dlci);

	if (sptr_matching_entry != NULL)
		{
		--frame_relay.port[port_number].number_of_current_dlcis;

		delete_entry_from_list ((LINK *) &frame_relay.port[port_number].dlci_list,(LINK *) sptr_matching_entry);

		if (sptr_matching_entry->wan_tx_buffers != NULL)
			free (sptr_matching_entry->wan_tx_buffers);

		free (sptr_matching_entry);
		}
}
/****************************************************************************/
DLCI_LIST_ENTRY *get_dlci_connection_entry (USHORT port_number,USHORT dlci)
{
	DLCI_LIST_ENTRY *sptr_matching_entry;

	for (sptr_matching_entry = (DLCI_LIST_ENTRY *) frame_relay.port[port_number].dlci_list.sptr_forward_link;
		sptr_matching_entry != NULL; sptr_matching_entry = sptr_matching_entry->links.sptr_forward_link)
		{
		if (sptr_matching_entry->dlci == dlci)
			{
			return (sptr_matching_entry);
			}
		}

	return (NULL);
}
/****************************************************************************/
void set_all_dlcis_active_flag (USHORT port_number,enum BOOLEAN active_flag)
{
	USHORT pvc_index;
	DLCI_LIST_ENTRY *sptr_current_connection_entry;

	pvc_index = 0x0000;

	sptr_current_connection_entry = (DLCI_LIST_ENTRY *) frame_relay.port[port_number].dlci_list.sptr_forward_link;

	while (pvc_index < NUMBER_OF_FRAME_RELAY_PVCS && sptr_current_connection_entry != NULL)
		{
		if (active_flag == TRUE)
			{
			sptr_current_connection_entry->mib.frCircuitState = ACTIVE_FRAME_RELAY_CIRCUIT_STATE;
			}
		else
			{
			sptr_current_connection_entry->mib.frCircuitState = INACTIVE_FRAME_RELAY_CIRCUIT_STATE;
			}

		++pvc_index;

		sptr_current_connection_entry	= sptr_current_connection_entry->links.sptr_forward_link;
		}
}
/****************************************************************************/
void set_all_dlcis_new_flag (USHORT port_number,enum BOOLEAN new_flag)
{
	USHORT pvc_index;
	DLCI_LIST_ENTRY *sptr_current_connection_entry;

	pvc_index = 0x0000;

	sptr_current_connection_entry = (DLCI_LIST_ENTRY *) frame_relay.port[port_number].dlci_list.sptr_forward_link;

	while (pvc_index < NUMBER_OF_FRAME_RELAY_PVCS && sptr_current_connection_entry != NULL)
		{
		sptr_current_connection_entry->new = new_flag;

		++pvc_index;

		sptr_current_connection_entry	= sptr_current_connection_entry->links.sptr_forward_link;
		}
}
/****************************************************************************/
void stop_sending_on_all_dlcis (USHORT port_number)
{
	USHORT pvc_index;
	DLCI_LIST_ENTRY *sptr_current_connection_entry;

	pvc_index = 0x0000;

	sptr_current_connection_entry = (DLCI_LIST_ENTRY *) frame_relay.port[port_number].dlci_list.sptr_forward_link;

	while (pvc_index < NUMBER_OF_FRAME_RELAY_PVCS && sptr_current_connection_entry != NULL)
		{
		sptr_current_connection_entry->stop_sending = TRUE;

		++pvc_index;

		sptr_current_connection_entry	= sptr_current_connection_entry->links.sptr_forward_link;
		}
}
/****************************************************************************/
void start_sending_on_all_dlcis (USHORT port_number)
{
	USHORT pvc_index;
	DLCI_LIST_ENTRY *sptr_current_connection_entry;

	pvc_index = 0x0000;

	sptr_current_connection_entry = (DLCI_LIST_ENTRY *) frame_relay.port[port_number].dlci_list.sptr_forward_link;

	while (pvc_index < NUMBER_OF_FRAME_RELAY_PVCS && sptr_current_connection_entry != NULL)
		{
		sptr_current_connection_entry->stop_sending = FALSE;

		++pvc_index;

		sptr_current_connection_entry	= sptr_current_connection_entry->links.sptr_forward_link;
		}
}

