#include	"defs.h"
/*	$Modname: frutil.c$  $version: 1.3$      $date: 04/21/95$   */
/*
* 	$lgb$
1.0 03/27/94 ross new file.
1.1 03/27/94 ross added copyright.
1.2 04/12/94 ross added list functions for people who don't have our lsl or ipx.
1.3 04/21/95 ross Increased size of stack_id.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <stdio.h>
#include	<stdarg.h>
#include "fr.h"
/****************************************************************************/
USHORT get_dlci_from_protocol_stack_virtual_port_number (ULONG protocol_stack_id,USHORT protocol_stack_virtual_port_number)
{
	PROTOCOL_STACK_DLCI_TABLE *sptr_protocol_stack_dlci_table;
	USHORT dlci;

	if (protocol_stack_id == frame_relay.ip_stack_id)
		{
		sptr_protocol_stack_dlci_table = &frame_relay.ip_dlci_table;
		}
	else if (protocol_stack_id == frame_relay.ipx_stack_id)
		{
		sptr_protocol_stack_dlci_table = &frame_relay.ipx_dlci_table;
		}
	else if (protocol_stack_id == frame_relay.stp_stack_id)
		{
		sptr_protocol_stack_dlci_table = &frame_relay.stp_dlci_table;
		}
	else if (protocol_stack_id == frame_relay.source_routing_stack_id)
		{
		sptr_protocol_stack_dlci_table = &frame_relay.source_routing_dlci_table;
		}
	else
		{
		return (ILLEGAL_DLCI_FOR_PROTOCOL);
		}

	dlci = sptr_protocol_stack_dlci_table->entry[protocol_stack_virtual_port_number].dlci;

	return (dlci);
}
/***************************************************************************/
USHORT get_virtual_port_number_from_dlci (USHORT dlci,PROTOCOL_STACK_DLCI_TABLE *sptr_dlci_table)
{
	USHORT virtual_port_number;

	for (virtual_port_number = 0x0000; virtual_port_number < MAXIMUM_NUMBER_OF_PROTOCOL_STACK_VIRTUAL_PORT_NUMBERS_WITH_DLCI;
		++virtual_port_number)
		{
		if (sptr_dlci_table->entry[virtual_port_number].dlci == dlci)
			{
			return (virtual_port_number);
			}
		}

	return (ILLEGAL_VIRTUAL_PORT_NUMBER);
}
/****************************************************************************/
void convert_dlci (UNION_USEABLE_DLCI *uptr_dlci)
{
	UNION_USEABLE_DLCI useable_dlci;
	UNION_DLCI *uptr_dlci_in_packet;

	useable_dlci = *uptr_dlci;

	uptr_dlci->_ushort = 0x0000;

	uptr_dlci_in_packet = (UNION_DLCI *) uptr_dlci;

	uptr_dlci_in_packet->_bit.dlci_lsb = useable_dlci._bit.dlci_lsb;
	uptr_dlci_in_packet->_bit.dlci_msb = useable_dlci._bit.dlci_msb;

	uptr_dlci_in_packet->_bit.extended_address_1 = TRUE;
}
/****************************************************************************/
USHORT convert_dlci_to_bit_format (USHORT dlci)
{
	UNION_USEABLE_DLCI useable_dlci;
	UNION_DLCI return_dlci;

	useable_dlci._ushort = dlci;

	return_dlci._ushort = 0x0000;

	return_dlci._bit.dlci_lsb = useable_dlci._bit.dlci_lsb;
	return_dlci._bit.dlci_msb = useable_dlci._bit.dlci_msb;

	return_dlci._bit.extended_address_1 = TRUE;

	return (return_dlci._ushort);
}
/****************************************************************************/
void convert_dlci_to_ushort (UNION_DLCI *uptr_dlci)
{
	UNION_DLCI dlci;
	UNION_USEABLE_DLCI *uptr_dlci_in_packet;

	dlci = *uptr_dlci;

	uptr_dlci_in_packet = (UNION_USEABLE_DLCI *) uptr_dlci;

	uptr_dlci_in_packet->_ushort = 0x0000;

	uptr_dlci_in_packet->_bit.dlci_lsb = dlci._bit.dlci_lsb;
	uptr_dlci_in_packet->_bit.dlci_msb = dlci._bit.dlci_msb;
}
/****************************************************************************/
USHORT get_ushort_dlci (UNION_DLCI dlci)
{
	UNION_USEABLE_DLCI useable_dlci;

	useable_dlci._ushort = 0x0000;

	useable_dlci._bit.dlci_lsb = dlci._bit.dlci_lsb;
	useable_dlci._bit.dlci_msb = dlci._bit.dlci_msb;

	return (useable_dlci._ushort);
}
/****************************************************************************/
USHORT get_port_number_from_dlci (USHORT dlci)
{
	USHORT port_number;
	DLCI_LIST_ENTRY *sptr_dlci_connection_entry;

	for (port_number = 0; port_number < frame_relay.total_number_of_frame_relay_ports; ++port_number)
		{
		sptr_dlci_connection_entry = (DLCI_LIST_ENTRY *)get_pointer_to_first_entry_in_list ((LINK *) &frame_relay.port[port_number].dlci_list);

		while (sptr_dlci_connection_entry != NULL)
			{
			if (sptr_dlci_connection_entry->dlci == dlci)
				return (port_number);

			sptr_dlci_connection_entry = (DLCI_LIST_ENTRY *)get_pointer_to_next_entry_in_list ((LINK *) sptr_dlci_connection_entry);
			}
		}

#ifdef DEBUG
	printf ("No port assigned for DLCI - 0x%x\r\n", dlci);
#endif
	return (0xFFFF);
}
/*************************************************************************/
void enable_or_disable_frame_relay_printing (enum BOOLEAN enable_or_disable)
{
	frame_relay.printing_enabled = enable_or_disable;
}
/*************************************************************************/
void enable_or_disable_frame_relay_group_printing (enum BOOLEAN enable_or_disable,enum FRAME_RELAY_PRINTF_GROUPS printf_group)
{
	switch (printf_group)
		{
		case FRAME_RELAY_MEMORY_PRINTF:
			frame_relay.memory_printing_enabled = enable_or_disable;
			break;
		case FRAME_RELAY_ALARM_PRINTF:
			frame_relay.alarm_printing_enabled = enable_or_disable;
			break;
		case FRAME_RELAY_SNMP_PRINTF:
			frame_relay.snmp_printing_enabled = enable_or_disable;
			break;
		case FRAME_RELAY_DATA_PRINTF:
			frame_relay.data_printing_enabled = enable_or_disable;
			break;
		case FRAME_RELAY_TUNNEL_PRINTF:
			frame_relay.tunnel_printing_enabled = enable_or_disable;
			break;
		case FRAME_RELAY_INVERSE_ARP_PRINTF:
			frame_relay.inverse_arp_printing_enabled = enable_or_disable;
			break;
		}
}
/*************************************************************************/
void frame_relay_printf (enum FRAME_RELAY_PRINTF_GROUPS printf_group,const char *cptr_format, ...)
{
	enum BOOLEAN print_string;

	va_list argptr;

	va_start (argptr,cptr_format);

	if (frame_relay.printing_enabled == FALSE)
		{
		va_end (argptr);

		return;
		}

	print_string = FALSE;

	switch (printf_group)
		{
		case FRAME_RELAY_MEMORY_PRINTF:
			print_string = frame_relay.memory_printing_enabled;
			break;
		case FRAME_RELAY_ALARM_PRINTF:
			print_string = frame_relay.alarm_printing_enabled;
			break;
		case FRAME_RELAY_SNMP_PRINTF:
			print_string = frame_relay.snmp_printing_enabled;
			break;
		case FRAME_RELAY_DATA_PRINTF:
			print_string = frame_relay.data_printing_enabled;
			break;
		case FRAME_RELAY_TUNNEL_PRINTF:
			print_string = frame_relay.tunnel_printing_enabled;
			break;
		case FRAME_RELAY_INVERSE_ARP_PRINTF:
			print_string = frame_relay.inverse_arp_printing_enabled;
			break;
		}

	if (print_string == TRUE)
		{
		vprintf (cptr_format,argptr);
		}

	va_end (argptr);
}
