/*	$Modname: kfr.h$  $version: 1.13$      $date: 04/21/95$   */
/*
* 	$lgb$
1.0 05/14/92 ross
1.1 07/28/92 ross
1.2 10/27/92 ross
1.3 12/09/92 ross adding support for SNMP
1.4 12/27/92 ross
1.5 01/02/93 ross
1.6 01/10/93 ross changing to symmetric dlci's - IBM way
1.7 01/23/93 ross moved lsl code into frtx and frrx
1.8 10/11/93 ross update for changes in LSL, changed some CRC handling.
1.9 03/01/94 ross testing with cisco frame relay and pacific bell.
1.10 03/19/94 ross fixes for cisco conformance testing
1.11 03/27/94 ross added inverse arp, frutil.c, rfc1315 naming, and serial device driver function pointers.
1.12 08/17/94 ross fixes for dlci up/down effects on virtual ports
1.13 04/21/95 ross Increased size of stack_id.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#ifndef PROTOCOL_MASKS

	#define PROTOCOL_MASK 0x00ff
	#define PROTOCOL_MASKS
	#define GET_PROTOCOL_TYPE_MASK 0xff00
	#define OFFSET_OF_STACK_ID 0x08

#endif

#define NUMBER_OF_FRAME_RELAY_PORTS 			3
#define NUMBER_OF_DLCI_CONNECTIONS_PER_PORT 100
#define MAXIMUM_NUMBER_OF_DLCI_CONNECTIONS 16
#define ILLEGAL_PORT_NUMBER 0xffff
#define BROADCAST_FRAME_RELAY_DLCI 0xffff
#define SIZE_OF_WAN_CRC 2
#define NUMBER_OF_ERROR_BYTES 50
#define MAXIMUM_FRAME_SIZE 2100
#define MAXIMUM_NUMBER_OF_PROTOCOL_STACK_VIRTUAL_PORT_NUMBERS_WITH_DLCI 32
#define ILLEGAL_STACK_ID 0xffff
#define ILLEGAL_VIRTUAL_PORT_NUMBER	0xffff
#define ILLEGAL_DLCI_FOR_PROTOCOL	0xffff

enum FRAME_RELAY_LINK_STATE
{
	FRAME_RELAY_LINK_DOWN,
	FRAME_RELAY_LINK_UP
};

enum ANNEX_D_MODE
{
	NO_SIGNALING       = 1,
	USER_MODE          = 2,
	NETWORK_MODE     	 = 3,
	BIDIRECTIONAL_MODE = 4
};

enum MAXIMUMS_FOR_ANNEX_D_IN_CHANNEL_SIGNALLING_PARAMETERS
{
	MAXIMUM_N391 = 255,
	MAXIMUM_N392 = 10,
	MAXIMUM_N393 = 10
};

enum ENCAPSULATION_TYPE
{
	RFC1490,
	CISCO
};

enum FRAME_RELAY_PRINTF_GROUPS
{
	FRAME_RELAY_MEMORY_PRINTF,
	FRAME_RELAY_ALARM_PRINTF,
	FRAME_RELAY_SNMP_PRINTF,
	FRAME_RELAY_INVERSE_ARP_PRINTF,
	FRAME_RELAY_DATA_PRINTF,
	FRAME_SNMP_PRINTF,
	FRAME_RELAY_TUNNEL_PRINTF
};

/* ---------------------------------------- RFC1315 ------------------------------------------------------ */

enum FR_DLCMI_STATE
{
	NO_LMI_CONFIGURED = 0x01,
	LMI_REV1 = 0x02,
	ANSI_T1_617_D = 0x03,
	ANSI_T1_617_B = 0x04
};

enum FR_DLCMI_ADDRESS
{
	Q921 = 0x01,
	Q922_MARCH_90 = 0x02,
	Q922_NOVEMBER_90 = 0x03,
	Q922 = 0x04
};

enum FR_DLCMI_ADDRESS_LEN
{
	TWO_BYTES_ADDRESS_LEN = 0x02,
	THREE_BYTES_ADDRESS_LEN = 0x03,
	FOUR_BYTES_ADDRESS_LEN = 0x04
};

enum FR_DLCMI_MULTICAST
{
	FR_DLCMI_MULTICAST_NOT_BROADCAST = 0x01,
	FR_DLCMI_MULTICAST_BROADCAST = 0x02
};

enum FR_CIRCUIT_STATE
{
	INVALID_FRAME_RELAY_CIRCUIT_STATE = 0x00000001L,
	ACTIVE_FRAME_RELAY_CIRCUIT_STATE = 0x00000002L,
	INACTIVE_FRAME_RELAY_CIRCUIT_STATE = 0x00000003L,

	__ULONG_FILLER = 0x10000000L
};

enum FRAME_RELAY_ALARM_TYPE
{
	UNKNOWN_ERROR = 1,
	RX_PACKET_TOO_SHORT,
	RX_PACKET_TOO_LONG,       			
	ILLEGAL_DLCI,       					
	UNKNOWN_DLCI,       					
	ANNEX_D_PROTOCOL_ERROR,    				
	ANNEX_D_UNKNOWN_INFORMATION_ELEMENT,  
	ANNEX_D_SEQUENCE_ERROR, 					
	ANNEX_D_UNKNOWN_REPORT,  					
	NO_ERROR_SINCE_RESET	
};

/* KVSP */

#define	FECN_WINDOW_SIZE			16
#define	BECN_WINDOW_SIZE			8
#define	MAX_TX_QUEUE_PER_DLCI	128

/* PVC can be configured to function in any of these modes */

#define	PVC_ADHERE_TO_CIR				0
#define	PVC_ADHERE_TO_CIR_BE			1
#define	PVC_AS_FAST_AS_POSSIBLE		2

/* management types */

#define	LMI_MGMT_TYPE					0
#define	ANNEX_D_MGMT_TYPE				1
#define	ANNEX_A_MGMT_TYPE				2
#define	UNKNOWN_MGMT_TYPE				255
