#include	"defs.h"
#include "fr.h"

/****************************************************************************/
static void check_lmi_errors (USHORT port_number);
static void clear_lmi_error_counters (USHORT port_number);

/****************************************************************************/
void initialize_lmi (void)
{
	USHORT port_number;       /* port number for loop */

	for (port_number = 0x0000; port_number < frame_relay.total_number_of_frame_relay_ports; ++port_number)
	{
		if (frame_relay.port[port_number].annex_d.enabled == FALSE)
		{
			frame_relay.port[port_number].lmi.enabled = TRUE;

			frame_relay.port[port_number].lmi.user.liv_response_received = TRUE;
			frame_relay.port[port_number].lmi.user.enabled =
				frame_relay.port[port_number].annex_d.user.enabled;

			frame_relay.port[port_number].lmi.frEnquiryInterval =
				frame_relay.port[port_number].annex_d.frDlcmiFullEnquiryInterval;	/* N391 */
			frame_relay.port[port_number].lmi.frErrorThreshold =
				frame_relay.port[port_number].annex_d.frDlcmiErrorThreshold;		/* N392 */
			frame_relay.port[port_number].lmi.frMonitoredEvents =
				frame_relay.port[port_number].annex_d.frDlcmiMonitoredEvents;		/* N393 */
			frame_relay.port[port_number].lmi.frUserPollingTimer =
				frame_relay.port[port_number].annex_d.frDlcmiPollingInterval;		/* T391 */
			frame_relay.port[port_number].lmi.frNetworkFrequencyInterval =
				frame_relay.port[port_number].annex_d.polling_verification_timer_T392; /* T392 */

			frame_relay.port[port_number].lmi.tx_sequence_number = 0;
			frame_relay.port[port_number].lmi.rx_sequence_number = 1;

			frame_relay.port[port_number].lmi.link_state = FRAME_RELAY_LINK_DOWN; 

			frame_relay.port[port_number].mib.frDlcmiState = LMI_REV1;
		}
	}
}
/****************************************************************************/
void check_for_lmi_timeouts (void)
{
	USHORT port_number;       /* port number for loop */

	for (port_number = 0x0000; port_number < frame_relay.total_number_of_frame_relay_ports; ++port_number)
	{
		if (frame_relay.port[port_number].enabled == TRUE)
		{
			if (frame_relay.port[port_number].lmi.enabled == TRUE)
			{
				check_lmi_errors (port_number);

				if (frame_relay.port[port_number].lmi.user.enabled == TRUE)
				{
					send_lmi_status_enquiry_message (port_number);

					send_lmi_full_status_enquiry_message (port_number);
				}
			}
		}
	}
}
/****************************************************************************/
static void check_lmi_errors (USHORT port_number)
{
	if (frame_relay.port[port_number].lmi.total_number_of_monitored_events >=
		frame_relay.port[port_number].lmi.frMonitoredEvents)
	{
		if (frame_relay.port[port_number].lmi.total_number_of_error_events >
			frame_relay.port[port_number].lmi.frErrorThreshold)
		{
			clear_lmi_error_counters (port_number);

			set_frame_relay_link_state (port_number,FRAME_RELAY_LINK_DOWN);
		}
		else
		{
			set_frame_relay_link_state (port_number,FRAME_RELAY_LINK_UP);

			clear_lmi_error_counters (port_number);
		}
	}
}
/****************************************************************************/
static void clear_lmi_error_counters (USHORT port_number)
{
	frame_relay.port[port_number].lmi.user.number_of_missed_status_response_messages = 0x00;
	frame_relay.port[port_number].lmi.total_number_of_monitored_events = 0x00;
	frame_relay.port[port_number].lmi.total_number_of_error_events = 0x00;
}
