/*	$Modname: vfradstr.h$  $version: 1.12$      $date: 04/17/95$   */
/*
* 	$lgb$
1.0 01/02/93 ross
1.1 01/02/93 ross
1.2 01/10/93 ross changing to symmetric dlci's - IBM way
1.3 02/11/93 ross changes for annex d.
1.4 10/11/93 ross update for changes in LSL, changed some CRC handling.
1.5 12/03/93 ross fixes for lsl version 3.0
1.6 02/01/94 ross added timer prototype.
1.7 03/19/94 ross fixes for cisco conformance testing
1.8 03/27/94 ross added inverse arp, frutil.c, rfc1315 naming, and serial device driver function pointers.
1.9 06/13/94 ross added snmp access routines, fixed bug with ip header tx's.  Courtesy of Rick.
1.10 08/17/94 ross fixes for dlci up/down effects on virtual ports
1.11 01/12/95 ross added BYTE_ENUM and USHORT_ENUM.
1.12 04/17/95 ross removed pragma from header file.  Courtesy of Hung.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
typedef struct REPORT_TYPE_INFORMATION_ELEMENT
{
	BYTE										id;
	BYTE										length;

	BYTE_ENUM (ANNEX_D_REPORT_TYPE) 	type;

} REPORT_TYPE_INFORMATION_ELEMENT;

typedef struct LIV_INFORMATION_ELEMENT
{
	BYTE			id;
	BYTE			length;
	BYTE			tx_sequence_number;
	BYTE			rx_sequence_number;
} LIV_INFORMATION_ELEMENT;

typedef	struct	PVC_NEW_AND_ACTIVE_FLAGS
{
#ifndef BIG_ENDIAN
	unsigned	int	reserved:1;
	unsigned	int	active:1;
	unsigned	int	reserved_1:1;
	unsigned	int	new:1;
	unsigned	int	reserved_2:3;
	unsigned	int	extension:1;
#else
	unsigned	int	extension:1;
	unsigned	int	reserved_2:3;
	unsigned	int	new:1;
	unsigned	int	reserved_1:1;
	unsigned	int	active:1;
	unsigned	int	reserved:1;
#endif
} PVC_NEW_AND_ACTIVE_FLAGS;

typedef	union	UNION_PVC_NEW_AND_ACTIVE_FLAGS
{
	PVC_NEW_AND_ACTIVE_FLAGS	_bit;
	BYTE								_byte;
} UNION_PVC_NEW_AND_ACTIVE_FLAGS;

typedef	struct	ANNEX_D_DLCI_BIT_STRUCTURE
{
#ifndef BIG_ENDIAN
	unsigned int	dlci_msb:6;
	unsigned int	reserved:1;
	unsigned int	extended_address:1;

	unsigned int	reserved_1:3;
	unsigned int	dlci_lsb:4;
	unsigned int	extended_address_1:1;
#else
	unsigned int	extended_address:1;
	unsigned int	reserved:1;
	unsigned int	dlci_msb:6;

	unsigned int	extended_address_1:1;
	unsigned int	dlci_lsb:4;
	unsigned int	reserved_1:3;
#endif
} ANNEX_D_DLCI_BIT_STRUCTURE;

typedef	union	UNION_ANNEX_D_DLCI
{
	ANNEX_D_DLCI_BIT_STRUCTURE	_bit;
	USHORT							_ushort;
} UNION_ANNEX_D_DLCI;

typedef struct PVC_STATUS_INFORMATION_ELEMENT
{
	BYTE										id;
	BYTE										length;
	UNION_ANNEX_D_DLCI					dlci;
	UNION_PVC_NEW_AND_ACTIVE_FLAGS	type;
} PVC_STATUS_INFORMATION_ELEMENT;

typedef	struct	ANNEX_D_HEADER
{
	UNION_DLCI											dlci;
	BYTE													unnumbered_frame_info;
	BYTE_ENUM (PROTOCOL_DISCRIMINATOR_TYPE)	protocol_discriminator;
	BYTE													call_reference;
	BYTE_ENUM (ANNEX_D_STATUS_MESSAGE_TYPE)	status_message;
	BYTE_ENUM (ANNEX_D_PROTOCOL_SHIFT)			locking_shift;
	REPORT_TYPE_INFORMATION_ELEMENT				report;
} ANNEX_D_HEADER;

typedef struct FULL_STATUS_ENQUIRY_MESSAGE
{
	ANNEX_D_HEADER				header;
	LIV_INFORMATION_ELEMENT liv_information_element;
} FULL_STATUS_ENQUIRY_MESSAGE;				

typedef struct FULL_STATUS_RESPONSE_MESSAGE
{
	ANNEX_D_HEADER							header;
	LIV_INFORMATION_ELEMENT 			liv_information_element;
	PVC_STATUS_INFORMATION_ELEMENT   pvc_status[NUMBER_OF_FRAME_RELAY_PVCS];
} FULL_STATUS_RESPONSE_MESSAGE;

typedef struct LIV_STATUS_ENQUIRY_MESSAGE
{
	ANNEX_D_HEADER				header;
	LIV_INFORMATION_ELEMENT liv_information_element;
} LIV_STATUS_ENQUIRY_MESSAGE;				

typedef struct LIV_STATUS_RESPONSE_MESSAGE
{
	ANNEX_D_HEADER				header;
	LIV_INFORMATION_ELEMENT liv_information_element;
} LIV_STATUS_RESPONSE_MESSAGE;				

typedef struct ASYNC_STATUS_ENQUIRY_MESSAGE
{
	ANNEX_D_HEADER							header;
	PVC_STATUS_INFORMATION_ELEMENT   pvc_status;
} ASYNC_STATUS_ENQUIRY_MESSAGE;				

typedef struct ASYNC_STATUS_RESPONSE_MESSAGE
{
	ANNEX_D_HEADER							header;
	PVC_STATUS_INFORMATION_ELEMENT   pvc_status;
} ASYNC_STATUS_RESPONSE_MESSAGE;				

/* to support ANNEX-A management procedures */

typedef	struct	ANNEX_A_HEADER
{
	UNION_DLCI											dlci;
	BYTE													unnumbered_frame_info;
	BYTE_ENUM (PROTOCOL_DISCRIMINATOR_TYPE)	protocol_discriminator;
	BYTE													call_reference;
	BYTE_ENUM (ANNEX_D_STATUS_MESSAGE_TYPE)	status_message;
	REPORT_TYPE_INFORMATION_ELEMENT				report;
} ANNEX_A_HEADER;

typedef struct ANXA_FULL_STATUS_ENQUIRY_MESSAGE
{
	ANNEX_A_HEADER				header;
	LIV_INFORMATION_ELEMENT liv_information_element;
} ANXA_FULL_STATUS_ENQUIRY_MESSAGE;				

typedef struct ANXA_FULL_STATUS_RESPONSE_MESSAGE
{
	ANNEX_A_HEADER							header;
	LIV_INFORMATION_ELEMENT 			liv_information_element;
	PVC_STATUS_INFORMATION_ELEMENT   pvc_status[NUMBER_OF_FRAME_RELAY_PVCS];
} ANXA_FULL_STATUS_RESPONSE_MESSAGE;

typedef struct ANXA_LIV_STATUS_ENQUIRY_MESSAGE
{
	ANNEX_A_HEADER				header;
	LIV_INFORMATION_ELEMENT liv_information_element;
} ANXA_LIV_STATUS_ENQUIRY_MESSAGE;				

typedef struct ANXA_LIV_STATUS_RESPONSE_MESSAGE
{
	ANNEX_A_HEADER				header;
	LIV_INFORMATION_ELEMENT liv_information_element;
} ANXA_LIV_STATUS_RESPONSE_MESSAGE;				

typedef struct ANXA_ASYNC_STATUS_ENQUIRY_MESSAGE
{
	ANNEX_A_HEADER							header;
	PVC_STATUS_INFORMATION_ELEMENT   pvc_status;
} ANXA_ASYNC_STATUS_ENQUIRY_MESSAGE;				

typedef struct ANXA_ASYNC_STATUS_RESPONSE_MESSAGE
{
	ANNEX_A_HEADER							header;
	PVC_STATUS_INFORMATION_ELEMENT   pvc_status;
} ANXA_ASYNC_STATUS_RESPONSE_MESSAGE;				

/* to support ANNEX-A management procedures */

typedef	union	UNION_ANNEX_D_MESSAGE
{
	FULL_STATUS_ENQUIRY_MESSAGE	full_status_enquiry;
	FULL_STATUS_RESPONSE_MESSAGE	full_status_response;
	LIV_STATUS_ENQUIRY_MESSAGE		liv_status_enquiry;
	LIV_STATUS_RESPONSE_MESSAGE	liv_status_response;
	ASYNC_STATUS_ENQUIRY_MESSAGE	async_status_enquiry;
	ASYNC_STATUS_RESPONSE_MESSAGE	async_status_response;
	ANNEX_D_HEADER						header;
	ANNEX_A_HEADER						anxa_header;
} UNION_ANNEX_D_MESSAGE;

/* annexdin.c */

void initialize_annex_d (void);
void reset_frame_relay_port (USHORT port_number);

/* annexdrx.c */

enum RX_PACKET_STATE annex_d_frame_received (USHORT port_number,UNION_ANNEX_D_MESSAGE *sptr_rxed_frame,
	USHORT number_of_bytes_rxed);
USHORT get_annexd_ushort_dlci (UNION_ANNEX_D_DLCI annex_d_format_dlci);

/* annexdtx.c */

void *get_a_frame_relay_send_packet (USHORT port_number,USHORT size_of_packet);
void frame_relay_tx_completion_routine (USHORT port_number,FRAME_RELAY_PACKET *sptr_serial_buffer);
void send_liv_status_enquiry_message (USHORT port_number);
void send_liv_status_response_message (USHORT port_number,LIV_STATUS_ENQUIRY_MESSAGE *sptr_liv_status_enquiry);
void send_full_status_enquiry_message (USHORT port_number);
void send_full_status_response_message (USHORT port_number,FULL_STATUS_ENQUIRY_MESSAGE *sptr_full_status_enquiry);
void send_async_status_enquiry_message (USHORT port_number);
void send_async_status_enquiry_message_dlci (USHORT port_number, USHORT dlci);
void send_async_status_response_message (USHORT port_number,ASYNC_STATUS_ENQUIRY_MESSAGE *sptr_async_status_enquiry);

/* annexdtm.c */

void frame_relay_timer (void);
void set_frame_relay_link_state (USHORT port_number,enum FRAME_RELAY_LINK_STATE link_state);
enum BOOLEAN is_frame_relay_link_up (USHORT port_number);
