/* definitions to support data compression over frame relay using        */
/* FRF.9 IA (implementation agreement) from frame relay forum (01/22/96) */

/* state transition phases for mode-1 operation */

#define	DISABLED_STATE				1
#define	INITIALIZATION_STATE		2
#define	OPERATION_STATE			3

/* parameters for mode-1 initialization process */

#define	P_RETRY_TIMER				3		/* 3 seconds */
#define	P_RETRY_COUNT				10

#define	MODE1_NO_CODE				0
#define	MODE1_REQUEST_CODE		1
#define	MODE1_RESPONSE_CODE		2

#define	WAIT_TIMEOUT				2		/* time to wait for reset ack */

#define	FRF9_NLPID					0xB0

/* one for NLPID, one for DCP header, one for seq number and two for length */

#define	FRF9_BUFFER_ADJUSTMENT	5

typedef	struct	FRF9_DCP_HEADER
{
	unsigned int	extension:1;
	unsigned int	compressed_mode:1;
	unsigned int	reset_ack:1;
	unsigned int	reset_request:1;
	unsigned int	reserved:3;
	unsigned int	control_or_data:1;
} FRF9_DCP_HEADER;

typedef	struct	FRF9_DCP_DATA_PDU_HEADER
{
	UNION_DLCI			dlci;				/* 2 octet address */
	BYTE					control;			/* UI frame - 0x03 */
	BYTE					nlpid;			/* NLPID - 0xB0 */
	FRF9_DCP_HEADER	dcp_header;		/* DCP header */
} FRF9_DCP_DATA_PDU_HEADER;

typedef	struct	FRF9_DCPCP_MODE1_RR_FORMAT
{
	BYTE					code;
	BYTE					identifier;
	USHORT				length;
} FRF9_DCPCP_MODE1_RR_FORMAT;

typedef	struct	FRF9_DCPCP_MODE1_CONF_FORMAT
{
	BYTE					type;
	BYTE					length;
	BYTE					revision;
} FRF9_DCPCP_MODE1_CONF_FORMAT;

typedef	struct	FRF9_DCPCP_MODE1_PDU_FORMAT
{
	FRF9_DCPCP_MODE1_RR_FORMAT			request_response;
	FRF9_DCPCP_MODE1_CONF_FORMAT		config_options;
} FRF9_DCPCP_MODE1_PDU_FORMAT;

typedef	struct	FRF9_DCP_DATA_PAYLOAD
{
	BYTE		sequence_number;
	USHORT	original_length;
	BYTE		payload[1];
} FRF9_DCP_DATA_PAYLOAD;

/* frf9tx.c */

BYTE *build_frf9_frame (USHORT port_number, USHORT dlci,
			BYTE *sptr_frame, USHORT *ptr_number_of_bytes);
void send_frf9_reset_request (USHORT port_number, USHORT dlci);
void send_frf9_reset_ack (USHORT port_number, USHORT dlci);
void send_mode_1_request (USHORT port_number, USHORT dlci);
void send_mode_1_response (USHORT port_number, USHORT dlci);
void frf9_tx_completion_routine (USHORT port_number,BYTE *sptr_serial_buffer);
void reset_frf9_tx_sequence_number (DLCI_LIST_ENTRY *sptr_dlci_entry);

/* frf9rx.c */

void check_dlci_mode_1_state (USHORT port_number);
enum BOOLEAN is_frf9_frame (BYTE *sptr_frame, USHORT *usptr_number_of_bytes_received);
enum BOOLEAN handle_frf9_frame (USHORT port_number, BYTE **sptr_frame,
		USHORT *usptr_number_of_bytes_received);
enum BOOLEAN handle_frf9_data_frame (USHORT port_number, BYTE **sptr_frame,
		USHORT *usptr_number_of_bytes_received);
void reset_compression_on_dlci (USHORT dlci);
void check_reset_requests_and_acks (USHORT dlci);
void initialize_compression_contexts(void);
