/* 
	File 	: dlbkup.h
	Purpose : A header file for including in both LLDD & PPP sections to
				support Dial Backup
	Author  : Chidananda Murthy R
	Date	: 1st October 1996
*/

#ifndef __INCLUDEDLBKUP__
#define __INCLUDEDLBKUP__

#ifndef PHONE_NUM_LEN
#define		PHONE_NUM_LEN			60
#endif

enum WAN_PORT_STATUS
{
	DLBK_DISABLED,
	DLBK_FREE,
	UP_N_WAITING,	/* Port has come up; but waiting for utilization by PPP */
	BUSY,
	DOWN,
	DOWN_BY_DEMAND,
	CLOSING_FOR_DLBK,
	OPENING_FOR_DLBK,
	DOD_DIAL
};

/* WAN Port's Connection Method */
typedef struct WAN_CONNECTION_METHOD
{
	enum BOOLEAN			answering_enabled;		/* True if port has to answer an incoming call */
	BYTE 					phone_number[PHONE_NUM_LEN] ; /* Otherwise the phone no.to be dialled */
} WAN_CONNECTION_METHOD;


#endif


