#include	".\defs.h"
/* $modname: ccpoptnp.c$ $version: 1.0$ $date: 10/19/95$ */
/*
$lgb$
1.0 10/19/95 biao Compression Control Protocol (CCP) Initial Release.
$lge$
*/
/************************************************************************/
/*	Copyright (C) 1995 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <string.h>
#include "ccp.h"
/****************************************************************************/
static void ccp_negotiation_error (void *vptr_context, USHORT port_number, OPTION_LIST_ENTRY *sptr_received_option,
	OPTION_LISTS *sptr_option_lists);
/****************************************************************************/
enum TEST ccp_configure_request_option_processor (OPTION_LIST_ENTRY *sptr_remote_option,CCP_PORT_CLASS *sptr_port)
{
	OPTION_LIST_ENTRY *sptr_local_option;

	sptr_local_option = find_matching_option (&sptr_port->option_lists.remote_configured,sptr_remote_option->type.generic);

	if (sptr_local_option == NULL)  /* this should never happen but just in case */
		{
		return (FAIL); 
		}

	if (sptr_local_option->negotiable == TRUE)
		{
		return (PASS);
		}

	if (option_value_match (sptr_local_option,sptr_remote_option) != NULL)
		{
		return (PASS);
		}

	if (alternate_option_value_match (sptr_local_option,sptr_remote_option) != NULL)
		{
		return (PASS);
		}

	if (range_option_value_match (sptr_local_option,sptr_remote_option) == TRUE)
		{
		return (PASS);
		}

	if (set_option_values_for_nak (sptr_local_option,sptr_remote_option) == FAIL)
		{
		ccp_negotiation_error (sptr_port,sptr_port->port_number,sptr_remote_option,&sptr_port->option_lists);
		}

	return (FAIL);
}
/****************************************************************************/
enum TEST ccp_configure_nak_option_processor (OPTION_LIST_ENTRY *sptr_remote_option,CCP_PORT_CLASS *sptr_port)
{
	OPTION_LIST_ENTRY *sptr_local_option;
	ALTERNATE_OPTION *sptr_alternate_option;

	sptr_local_option = find_matching_option (&sptr_port->option_lists.tx_accepted,sptr_remote_option->type.generic);

	if (sptr_local_option == NULL)  /* this should never happen but just in case */
		{
		return (FAIL); 
		}

	if (sptr_local_option->negotiable == TRUE)
		{
		if (option_value_match (sptr_local_option,sptr_remote_option) != NULL)
			{
			return (PASS);
			}

		sptr_alternate_option = alternate_option_value_match (sptr_local_option,sptr_remote_option);

		if (sptr_alternate_option != NULL)
			{
			replace_data_field_in_option (sptr_local_option,sptr_alternate_option->uptr_data,sptr_alternate_option->length);

			return (PASS);
			}

		if (range_option_value_match (sptr_local_option,sptr_remote_option) == TRUE)
			{
			replace_data_field_in_option (sptr_local_option,sptr_remote_option->uptr_data,sptr_remote_option->length);

			return (PASS);
			}

		replace_data_field_in_option (sptr_local_option,sptr_remote_option->uptr_data,sptr_remote_option->length);

		return (PASS);
		}
	else
		{
		ccp_negotiation_error (sptr_port,sptr_port->port_number,sptr_remote_option,&sptr_port->option_lists);

		return (FAIL);
		}
}
/****************************************************************************/
static void ccp_negotiation_error (void *vptr_context, USHORT port_number, OPTION_LIST_ENTRY *sptr_received_option,
	OPTION_LISTS *sptr_option_lists)
{
	enum BOOLEAN close_connection;

	close_connection = TRUE;

	if (ccp.fptr_event_upcall != NULL)
		{
		close_connection = (enum BOOLEAN) (*ccp.fptr_event_upcall) (CCP_EVENT_OPTIONS_EXHAUSTED, port_number, TRUE, vptr_context,
			sptr_received_option, sptr_option_lists);
		}

	if (close_connection == TRUE)
		{
		execute_ccp_state_machine (PPP_CLOSE_EVENT, port_number, NULL, 0x0000);
		}
}
