#include	".\defs.h"
#ifdef STAC_LZS
/* $modname: ccpstac.c$ $version: 1.0$ $date: 10/19/95$ */
/*
$lgb$
1.0 10/19/95 biao Compression Control Protocol (CCP) Initial Release.
$lge$
*/
/************************************************************************/
/*	Copyright (C) 1995 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdlib.h>
#include <string.h>
#include "ccp.h"
/*************************************************************************/
static BYTE* adjust_compression_pointer_and_length (PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_packet, USHORT *usptr_ppp_packet_length,
	USHORT *usptr_length_of_data_to_be_compressed);
static UNION_PPP_PACKET *stacker_decompress_compressed_ppp (USHORT real_port_number, UNION_PPP_PACKET *uptr_ppp_packet, 
	USHORT *usptr_ppp_packet_length);
static PPP_PACKET_WITH_MAC_HEADER *prepare_a_ppp_send_packet (USHORT real_port_number, PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_packet,	
	BYTE *bptr_data_to_be_compressed, USHORT length_of_data_to_be_compressed, USHORT *ustpr_longest_possible_compressed_data_length, 
	USHORT *usptr_optional_check_value_length);
static enum TEST install_optional_check_value (USHORT real_port_number, 
	PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_encapsulated_stacker_compression_packet, BYTE *bptr_data_to_be_compressed,
	USHORT length_of_data_to_be_compressed, USHORT *usptr_optional_check_value_length);
static void install_LCB (PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_encapsulated_stacker_compression_packet, 
	BYTE *bptr_data_to_be_compressed, USHORT length_of_data_to_be_compressed, USHORT *usptr_optional_check_value_length);
static void install_CRC (PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_encapsulated_stacker_compression_packet, 
	BYTE *bptr_data_to_be_compressed, USHORT length_of_data_to_be_compressed, USHORT *usptr_optional_check_value_length);
static void install_sequence_number (USHORT real_port_number, 
	PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_encapsulated_stacker_compression_packet, USHORT *usptr_optional_check_value_length);
static BYTE *adjust_decompression_pointer_and_length (USHORT real_port_number, 
	UNION_STACKER_COMPRESSION_PACKET *uptr_stacker_compression_packet, USHORT *usptr_stacker_compression_packet_length);
static PPP_PACKET_WITH_MAC_HEADER *prepare_a_ppp_receive_packet (USHORT real_port_number, USHORT stacker_compressed_data_length, 
	USHORT *usptr_longest_possible_decompressed_data_length);
static enum TEST verify_decompressed_data (USHORT real_port_number, 
	UNION_STACKER_COMPRESSION_PACKET *uptr_stacker_compression_packet, BYTE *bptr_first_byte_following_the_decompressed_data, 
	BYTE *bptr_decompressed_data, USHORT decompressed_data_length,	PPP_PACKET_WITH_MAC_HEADER *sptr_decompressed_ppp_packet);
static enum TEST LCB_verify_decompressed_data (USHORT real_port_number, 
	STACKER_COMPRESSION_PACKET_WITH_LCB *sptr_stacker_compression_packet_with_lcb, BYTE *bptr_decompressed_data, 
	USHORT decompressed_data_length, PPP_PACKET_WITH_MAC_HEADER *sptr_decompressed_ppp_packet) ;
static enum TEST CRC_verify_decompressed_data (USHORT real_port_number, 
	STACKER_COMPRESSION_PACKET_WITH_CRC *sptr_stacker_compression_packet_with_crc, BYTE *bptr_decompressed_data, 
	USHORT decompressed_data_length, BYTE *bptr_first_byte_following_the_decompressed_data, 
	PPP_PACKET_WITH_MAC_HEADER *sptr_decompressed_ppp_packet);
static void adjust_decompressed_packet_with_uncompressed_protocol_field (BYTE *bptr_second_byte_of_ppp_protocol_type_field,
	USHORT *usptr_ppp_packet_length, USHORT decompressed_data_length);
static void handle_incorrect_sequence_number (USHORT real_port_number, BYTE sequence_number_received) ;
static void free_compressed_ppp_packet (USHORT port_number, void *vptr_buffer);
/*************************************************************************/
PPP_PACKET_WITH_MAC_HEADER *stacker_compress_ppp (USHORT real_port_number, USHORT protocol_virtual_port_number, 
	enum BOOLEAN *eptr_device_driver_buffer, PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_packet, USHORT *usptr_ppp_packet_length,
	void (**ptr_fptr_tx_completion) (USHORT port_number, void *vptr_buffer))
{
	BYTE *bptr_data_to_be_compressed;
	USHORT length_of_data_to_be_compressed;
	ULONG length_of_data_to_be_compressed_for_LZW_Compress;
	USHORT longest_possible_compressed_data_length;
	ULONG longest_possible_compressed_data_length_for_LZW_Compress;
	PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_encapsulated_stacker_compression_packet;
	BYTE *bptr_buffer_to_compress_to;
	USHORT compressed_data_length;
	USHORT optional_check_value_length;

	bptr_data_to_be_compressed = adjust_compression_pointer_and_length (sptr_ppp_packet, usptr_ppp_packet_length, 
		&length_of_data_to_be_compressed);

	sptr_ppp_encapsulated_stacker_compression_packet = prepare_a_ppp_send_packet (real_port_number, sptr_ppp_packet, 
		bptr_data_to_be_compressed, length_of_data_to_be_compressed, &longest_possible_compressed_data_length,  
		&optional_check_value_length);
	
	if (sptr_ppp_encapsulated_stacker_compression_packet == NULL)
		{
		return (NULL);
		}
	
	longest_possible_compressed_data_length_for_LZW_Compress = longest_possible_compressed_data_length;
	length_of_data_to_be_compressed_for_LZW_Compress = length_of_data_to_be_compressed;
	
	bptr_buffer_to_compress_to = sptr_ppp_encapsulated_stacker_compression_packet->protocol_data + optional_check_value_length;

	if (ccp.ports[real_port_number].stacker.sender_history_count_and_check_mode.structure.history_count == 0x0000)
		{
		/*	if no compression history is kept, the sender is expected to reset the compression history
			at the beginning of every packet */   
		LZS_InitHistory (ccp.ports[real_port_number].stacker.bptr_scratch_RAM);

		ccp_printf (CCP_DATA_PRINTF, "CCP:Stacker LZS: Compression History Is Reset on Port %04x", real_port_number);
		}

	LZS_Compress (&bptr_data_to_be_compressed, &bptr_buffer_to_compress_to, 
		&length_of_data_to_be_compressed_for_LZW_Compress, &longest_possible_compressed_data_length_for_LZW_Compress, 
		(void *) ccp.ports[real_port_number].stacker.bptr_scratch_RAM, 
		(USHORT) (LZS_SOURCE_FLUSH | LZS_DEST_FLUSH | 
			ccp.ports[real_port_number].stacker.performance_mode << STACKER_PERFORMANCE_MODE_SHIFT_VAL), 
		ccp.ports[real_port_number].stacker.performance_value);
	
	compressed_data_length = (USHORT) (longest_possible_compressed_data_length - 
		longest_possible_compressed_data_length_for_LZW_Compress); 
	
	if (compressed_data_length > length_of_data_to_be_compressed)	/* data expansion detected */
		{
		ccp_printf (CCP_DATA_PRINTF, "CCP:Stacker LZS: Data Expansion Detected on Port %04x, Ratio(Source/Compressed) = %d/%d\n", 
			real_port_number, length_of_data_to_be_compressed,	compressed_data_length);
		
		buffer_free ((void *) sptr_ppp_encapsulated_stacker_compression_packet);
		
		return (sptr_ppp_packet);
		}
	else
		{
		ccp_printf (CCP_DATA_PRINTF, "CCP:Stacker LZS: PPP Packet Compressed on Port %04x, Ratio(Source/Compressed) = %d/%d\n", 
			real_port_number, length_of_data_to_be_compressed,	compressed_data_length);
				
		/* we've done with the original PPP packet, so we return the buffer */
		return_buffer (real_port_number, protocol_virtual_port_number, device_driver_buffer, 
			sptr_ppp_packet, *ptr_fptr_tx_completion);

		*eptr_device_driver_buffer = FALSE;
		
		/* the newly constructed packet will be freed by our own tx_completion function */
		*ptr_fptr_tx_completion = free_compressed_ppp_packet;	
		
		*usptr_ppp_packet_length = (USHORT) (sizeof (PPP_HEADER) + compressed_data_length + optional_check_value_length);
		
		return (sptr_ppp_encapsulated_stacker_compression_packet);
		}
}
/*************************************************************************/
static BYTE* adjust_compression_pointer_and_length (PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_packet, USHORT *usptr_ppp_packet_length,
	USHORT *usptr_length_of_data_to_be_compressed)
{
	BYTE *bptr_data_to_be_compressed;
	
	if	((sptr_ppp_packet->header.protocol_type & BIG_ENDIAN_CONSTANT (0xff00)) != 0x0000)
		{	
		/* PPP protocol field is not compressible	*/
		bptr_data_to_be_compressed = (BYTE *) &(sptr_ppp_packet->header) + SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS;	
		*usptr_length_of_data_to_be_compressed = (USHORT) (*usptr_ppp_packet_length - SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS);
		}
	else
		{
		bptr_data_to_be_compressed = (BYTE *) &(sptr_ppp_packet->header) + SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS + 
			HALF_SIZE_OF_PPP_PROTOCOL_FIELD;
		*usptr_length_of_data_to_be_compressed = (USHORT) (*usptr_ppp_packet_length - SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS - 
			HALF_SIZE_OF_PPP_PROTOCOL_FIELD);
		}
	
	return (bptr_data_to_be_compressed);
}	
/*************************************************************************/
static PPP_PACKET_WITH_MAC_HEADER *prepare_a_ppp_send_packet (USHORT real_port_number, 
	PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_packet,	BYTE *bptr_data_to_be_compressed, USHORT length_of_data_to_be_compressed, 
	USHORT *usptr_longest_possible_compressed_data_length, USHORT *usptr_optional_check_value_length)
{
	PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_encapsulated_stacker_compression_packet;
	USHORT longest_possible_ppp_encapsulated_stacker_compression_packet;
	
	*usptr_longest_possible_compressed_data_length = (USHORT) (length_of_data_to_be_compressed + 
		length_of_data_to_be_compressed * STACKER_LZS_MAXIMUM_EXPANSION_RATIO + 0.5);
	
	longest_possible_ppp_encapsulated_stacker_compression_packet = (USHORT) (sizeof (PPP_PACKET_WITH_MAC_HEADER) - 
		VARIABLE_NUMBER_OF_BYTES +	sizeof (UNION_STACKER_COMPRESSION_PACKET) - VARIABLE_NUMBER_OF_BYTES + 
		*usptr_longest_possible_compressed_data_length);
	
	sptr_ppp_encapsulated_stacker_compression_packet = 
		(PPP_PACKET_WITH_MAC_HEADER *) buffer_malloc (longest_possible_ppp_encapsulated_stacker_compression_packet);
	
	if (sptr_ppp_encapsulated_stacker_compression_packet == NULL)
		{
		ccp_printf (CCP_ALARM_PRINTF, "CCP:Stacker LZS: prepare_a_ppp_send_packet () buffer_malloc () failed\n");

		return (NULL);
		}
	
	memcpy ((void *) sptr_ppp_encapsulated_stacker_compression_packet, (void *) sptr_ppp_packet, 
		SIZE_OF_MAC_HEADER + SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS);
	
	sptr_ppp_encapsulated_stacker_compression_packet->header.protocol_type = FIRST_CHOICE_COMPRESSION_PROTOCOL;	/* 0x00FD */
	
	if (install_optional_check_value (real_port_number, sptr_ppp_encapsulated_stacker_compression_packet, 
		bptr_data_to_be_compressed, length_of_data_to_be_compressed, usptr_optional_check_value_length) == FAIL)
		{
		return (NULL);
		}
	
	return (sptr_ppp_encapsulated_stacker_compression_packet);
}
/*************************************************************************/
static enum TEST install_optional_check_value (USHORT real_port_number, 
	PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_encapsulated_stacker_compression_packet, BYTE *bptr_data_to_be_compressed,
	USHORT length_of_data_to_be_compressed, USHORT *usptr_optional_check_value_length)
{ 
	switch (ccp.ports[real_port_number].stacker.sender_history_count_and_check_mode.structure.check_mode)
		{
		case NONE:
			
			*usptr_optional_check_value_length = 0x0000;
			
			break;
		
		case LCB :
		
			install_LCB (sptr_ppp_encapsulated_stacker_compression_packet, bptr_data_to_be_compressed, 
				length_of_data_to_be_compressed,	usptr_optional_check_value_length);

			break;

		case CCP_CRC :
		
			install_CRC (sptr_ppp_encapsulated_stacker_compression_packet, bptr_data_to_be_compressed, 
				length_of_data_to_be_compressed,	usptr_optional_check_value_length);
			
			break;

		case SEQUENCE_NUMBER :
		
			install_sequence_number (real_port_number, sptr_ppp_encapsulated_stacker_compression_packet, 
				usptr_optional_check_value_length);
			
			break;
			
		default :
			
			ccp_printf (CCP_ALARM_PRINTF,"CCP:Stacker LZS: Unknown Check Mode: %04x\n", real_port_number);
			
			return (FAIL);
		}
	
	return (PASS);
}	
/*************************************************************************/
static void install_LCB (PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_encapsulated_stacker_compression_packet, 
	BYTE *bptr_data_to_be_compressed, USHORT length_of_data_to_be_compressed, USHORT *usptr_optional_check_value_length)
{
	STACKER_COMPRESSION_PACKET_WITH_LCB *sptr_stacker_compression_packet_with_lcb;
	BYTE LCB_byte;
	USHORT index;

	LCB_byte = 0xff;
	
	for (index = 0x0000; index < length_of_data_to_be_compressed; ++index)
		{
		LCB_byte ^= bptr_data_to_be_compressed[index];
		}
	
	sptr_stacker_compression_packet_with_lcb = 
		(STACKER_COMPRESSION_PACKET_WITH_LCB *) sptr_ppp_encapsulated_stacker_compression_packet->protocol_data;
	
	sptr_stacker_compression_packet_with_lcb->LCB = LCB_byte;
	
	*usptr_optional_check_value_length = 1;
}
/*************************************************************************/
static void install_CRC (PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_encapsulated_stacker_compression_packet, 
	BYTE *bptr_data_to_be_compressed, USHORT length_of_data_to_be_compressed, USHORT *usptr_optional_check_value_length)
{
	USHORT original_data_checksum;
	STACKER_COMPRESSION_PACKET_WITH_CRC *sptr_stacker_compression_packet_with_crc;
	
	original_data_checksum = calculate_frame_check_sequence (INIT_FRAME_CHECK_SEQUENCE, 
		(BYTE *) bptr_data_to_be_compressed, length_of_data_to_be_compressed);
	
	original_data_checksum = (USHORT) ~original_data_checksum;
	
	sptr_stacker_compression_packet_with_crc = 
		(STACKER_COMPRESSION_PACKET_WITH_CRC *) sptr_ppp_encapsulated_stacker_compression_packet->protocol_data;
	
	sptr_stacker_compression_packet_with_crc->CRC = host_to_net_short (original_data_checksum);

	*usptr_optional_check_value_length = 2;
}
/*************************************************************************/
static void install_sequence_number (USHORT real_port_number, 
	PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_encapsulated_stacker_compression_packet, USHORT *usptr_optional_check_value_length)
{
	STACKER_COMPRESSION_PACKET_WITH_SEQUENCE_NUMBER	*sptr_stacker_compression_packet_with_sequence_number;

	sptr_stacker_compression_packet_with_sequence_number = 
		(STACKER_COMPRESSION_PACKET_WITH_SEQUENCE_NUMBER *) sptr_ppp_encapsulated_stacker_compression_packet->protocol_data;
		
	sptr_stacker_compression_packet_with_sequence_number->sequence_number = 	
		ccp.ports[real_port_number].stacker.sender_sequence_number;
	
	++ccp.ports[real_port_number].stacker.sender_sequence_number;
	
	*usptr_optional_check_value_length = 1;
}
/*************************************************************************/
UNION_PPP_PACKET *stacker_decompress_ppp (USHORT real_port_number, UNION_PPP_PACKET *uptr_ppp_packet, 
	USHORT *usptr_ppp_packet_length)
{
	UNION_PPP_PACKET *sptr_decompressed_ppp_packet;
	STACKER_COMPRESSION_PACKET_WITH_SEQUENCE_NUMBER *sptr_stacker_compression_packet_with_sequence_number;

	if (uptr_ppp_packet->generic.header.protocol_type == FIRST_CHOICE_COMPRESSION_PROTOCOL)
		{
		if (ccp.ports[real_port_number].receiver_is_waiting_for_reset_ack == TRUE)
			{
			if (ccp.ports[real_port_number].stacker.receiver_history_count_and_check_mode.structure.check_mode == SEQUENCE_NUMBER)
				{
				sptr_stacker_compression_packet_with_sequence_number = 
					(STACKER_COMPRESSION_PACKET_WITH_SEQUENCE_NUMBER *) ((BYTE *) uptr_ppp_packet + sizeof (PPP_HEADER));
				
				ccp.ports[real_port_number].stacker.sequence_number_of_latest_received_packet = 
					sptr_stacker_compression_packet_with_sequence_number->sequence_number;
				}
			send_ccp_reset_request_with_history_number (real_port_number, 
				ccp.ports[real_port_number].stacker.receiver_history_count_and_check_mode.structure.history_count);
			
			return (NULL);
			}

		sptr_decompressed_ppp_packet = 
			stacker_decompress_compressed_ppp (real_port_number, uptr_ppp_packet, usptr_ppp_packet_length);

		return (sptr_decompressed_ppp_packet);
		}
	else
		{
		return (uptr_ppp_packet);
		}
}
/*************************************************************************/
static UNION_PPP_PACKET *stacker_decompress_compressed_ppp (USHORT real_port_number, UNION_PPP_PACKET *uptr_ppp_packet, 
	USHORT *usptr_ppp_packet_length)
{
	UNION_STACKER_COMPRESSION_PACKET *uptr_stacker_compression_packet;
	PPP_PACKET_WITH_MAC_HEADER *sptr_decompressed_ppp_packet;
	BYTE *bptr_stacker_compressed_data;
	BYTE *bptr_buffer_to_decompress_to;
	BYTE *bptr_second_byte_of_ppp_protocol_type_field;
	USHORT stacker_compression_packet_length;
	USHORT stacker_compressed_data_length;
	USHORT longest_possible_decompressed_data_length;
	USHORT decompressed_data_length;
	ULONG stacker_compressed_data_length_for_LZS_Decompress;
	ULONG longest_possible_decompressed_data_length_for_LZS_Decompress;
	ULONG device_driver_id;
	
	device_driver_id = (*ccp.ppp.fptr_get_device_driver_id_function) (real_port_number);
	
	uptr_stacker_compression_packet = (UNION_STACKER_COMPRESSION_PACKET *) ((BYTE *) uptr_ppp_packet + sizeof (PPP_HEADER));
	stacker_compression_packet_length = (USHORT) (*usptr_ppp_packet_length - sizeof (PPP_HEADER));
	stacker_compressed_data_length = stacker_compression_packet_length;

	bptr_stacker_compressed_data = adjust_decompression_pointer_and_length (real_port_number, uptr_stacker_compression_packet,
		&stacker_compressed_data_length);

	if (bptr_stacker_compressed_data == NULL)
		{
		return (NULL);
		}

	sptr_decompressed_ppp_packet = prepare_a_ppp_receive_packet (real_port_number, stacker_compressed_data_length, 
		&longest_possible_decompressed_data_length);

	if (sptr_decompressed_ppp_packet == NULL)
		{
		return (NULL);
		}

	bptr_second_byte_of_ppp_protocol_type_field = (BYTE *) (&(sptr_decompressed_ppp_packet->header)) + 
		SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS + HALF_SIZE_OF_PPP_PROTOCOL_FIELD;

	stacker_compressed_data_length_for_LZS_Decompress = stacker_compressed_data_length;
	longest_possible_decompressed_data_length_for_LZS_Decompress = longest_possible_decompressed_data_length;
	bptr_buffer_to_decompress_to = bptr_second_byte_of_ppp_protocol_type_field;

	LZS_Decompress (&bptr_stacker_compressed_data, &bptr_buffer_to_decompress_to, 
		&stacker_compressed_data_length_for_LZS_Decompress,	&longest_possible_decompressed_data_length_for_LZS_Decompress, 
		ccp.ports[real_port_number].stacker.bptr_scratch_RAM, LZS_RESET);

	decompressed_data_length = (USHORT) (longest_possible_decompressed_data_length  - 
		longest_possible_decompressed_data_length_for_LZS_Decompress);
	
	if (verify_decompressed_data (real_port_number, uptr_stacker_compression_packet, bptr_buffer_to_decompress_to, 
		bptr_second_byte_of_ppp_protocol_type_field, decompressed_data_length, sptr_decompressed_ppp_packet) == FAIL)
		{
		return (NULL);
		}
	
	ccp_printf (CCP_DATA_PRINTF, "CCP:Stacker LZS: PPP Packet Decompressed on Port %04x, Ratio (Compressed/Source) = %d/%d\n",
		real_port_number, stacker_compressed_data_length, decompressed_data_length);
	
	adjust_decompressed_packet_with_uncompressed_protocol_field (bptr_second_byte_of_ppp_protocol_type_field, 
		usptr_ppp_packet_length, decompressed_data_length);
	
	/* now that we are done with the original PPP packet, we free it. */
	device_driver_free (real_port_number, device_driver_id, (void *) uptr_ppp_packet);
	
	return ((UNION_PPP_PACKET *) &(sptr_decompressed_ppp_packet->header));
}
/*************************************************************************/
static BYTE *adjust_decompression_pointer_and_length (USHORT real_port_number, 
	UNION_STACKER_COMPRESSION_PACKET *uptr_stacker_compression_packet, USHORT *usptr_stacker_compression_packet_length)
{
	BYTE *bptr_stacker_compressed_data;
	BYTE sequence_number_received;

	switch (ccp.ports[real_port_number].stacker.receiver_history_count_and_check_mode.structure.check_mode)
		{
		case NONE:
			
			bptr_stacker_compressed_data = (BYTE *) uptr_stacker_compression_packet;

			break;
		
		case LCB :
		
			bptr_stacker_compressed_data = (BYTE *) uptr_stacker_compression_packet + 1;
			--(*usptr_stacker_compression_packet_length);
			
			break;

		case CCP_CRC :
			
			bptr_stacker_compressed_data = (BYTE *) uptr_stacker_compression_packet + 2;
			(*usptr_stacker_compression_packet_length) -= 2;
			
			break;
		
		case SEQUENCE_NUMBER :
		
			sequence_number_received = *((BYTE *) uptr_stacker_compression_packet);

			if (sequence_number_received != ccp.ports[real_port_number].stacker.receiver_sequence_number)
				{
				ccp_printf (CCP_ALARM_PRINTF,"CCP:Stacker LZS: Incorrect Sequence Number Received on Port: %04x\n", 
					real_port_number);

				handle_incorrect_sequence_number (real_port_number, sequence_number_received);
				
				return (NULL);
				}
			
			++ccp.ports[real_port_number].stacker.receiver_sequence_number;
			
			bptr_stacker_compressed_data = (BYTE *) uptr_stacker_compression_packet + 1;
			--(*usptr_stacker_compression_packet_length);
			
			break;
		
		default :
			
			ccp_printf (CCP_ALARM_PRINTF,"CCP:Stacker LZS: Unknown Check Mode: %04x\n", real_port_number);
			
			return (NULL);
		}

	return (bptr_stacker_compressed_data);
}
/*************************************************************************/
static PPP_PACKET_WITH_MAC_HEADER *prepare_a_ppp_receive_packet (USHORT real_port_number, USHORT stacker_compressed_data_length, 
	USHORT *usptr_longest_possible_decompressed_data_length)
{
	PPP_PACKET_WITH_MAC_HEADER *sptr_decompressed_ppp_packet;
	USHORT longest_possible_decompressed_ppp_packet_length;
	ULONG device_driver_id;
	
	device_driver_id = (*ccp.ppp.fptr_get_device_driver_id_function) (real_port_number);
	
	*usptr_longest_possible_decompressed_data_length = 
		(USHORT) (stacker_compressed_data_length * STACKER_LZS_MAXIMUM_COMPRESSION_RATIO);

	longest_possible_decompressed_ppp_packet_length = (USHORT) (SIZE_OF_MAC_HEADER + SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS + 
		HALF_SIZE_OF_PPP_PROTOCOL_FIELD + *usptr_longest_possible_decompressed_data_length + 
		((ccp.ports[real_port_number].stacker.receiver_history_count_and_check_mode.structure.check_mode == CCP_CRC)
		? SIZE_OF_WAN_CRC : 0));	
	
	sptr_decompressed_ppp_packet = (PPP_PACKET_WITH_MAC_HEADER *) device_driver_malloc (real_port_number, 
			device_driver_id, longest_possible_decompressed_ppp_packet_length);

	if (sptr_decompressed_ppp_packet == NULL)
		{
		ccp_printf (CCP_ALARM_PRINTF, "CCP:Stacker LZS: prepare_a_ppp_receive_packet () device_driver_malloc () failed\n");
	
		return (NULL);
		}

	sptr_decompressed_ppp_packet->header.hdlc_address = HDLC_ADDRESS;
	sptr_decompressed_ppp_packet->header.hdlc_control = UNNUMBERED_INFORMATION;
	
	return (sptr_decompressed_ppp_packet);
}
/*************************************************************************/
static enum TEST verify_decompressed_data (USHORT real_port_number, 
	UNION_STACKER_COMPRESSION_PACKET *uptr_stacker_compression_packet, BYTE *bptr_first_byte_following_the_decompressed_data, 
	BYTE *bptr_decompressed_data, USHORT decompressed_data_length,	PPP_PACKET_WITH_MAC_HEADER *sptr_decompressed_ppp_packet)
{
	switch (ccp.ports[real_port_number].stacker.receiver_history_count_and_check_mode.structure.check_mode)
		{
		case NONE :
		
			break;

		case LCB:
		
			if (LCB_verify_decompressed_data (real_port_number, 
				&(uptr_stacker_compression_packet->stacker_compression_packet_with_lcb), bptr_decompressed_data, 
				decompressed_data_length, sptr_decompressed_ppp_packet) == FAIL)
				{
				return (FAIL);
				}
			
			break ;

		case CCP_CRC :
		
			if (CRC_verify_decompressed_data (real_port_number, 
				&(uptr_stacker_compression_packet->stacker_compression_packet_with_crc), bptr_decompressed_data, 
				decompressed_data_length, bptr_first_byte_following_the_decompressed_data,	sptr_decompressed_ppp_packet) == FAIL)
				{
				return (FAIL);
				}
			
			break;

		case SEQUENCE_NUMBER:
		
			break;

		default :
			
			ccp_printf (CCP_ALARM_PRINTF,"CCP:Stacker LZS: Unknown Check Mode: %04x\n", real_port_number);
			
			return (FAIL);
		}
	
	return (PASS);
}
/*************************************************************************/
static enum TEST LCB_verify_decompressed_data (USHORT real_port_number, 
	STACKER_COMPRESSION_PACKET_WITH_LCB *sptr_stacker_compression_packet_with_lcb, BYTE *bptr_decompressed_data, 
	USHORT decompressed_data_length, PPP_PACKET_WITH_MAC_HEADER *sptr_decompressed_ppp_packet) 
{
	BYTE LCB_byte;
	USHORT index;
	ULONG device_driver_id;
	
	device_driver_id = (*ccp.ppp.fptr_get_device_driver_id_function) (real_port_number);
	
	LCB_byte = 0xff;
	
	for (index = 0x0000; index < decompressed_data_length; ++index)
		{
		LCB_byte ^= bptr_decompressed_data[index];
		}
		
	if (sptr_stacker_compression_packet_with_lcb->LCB != LCB_byte)
		{
		ccp_printf (CCP_ALARM_PRINTF,"CCP:Stacker LZS: LCB Check Failed on Port %04x\n",real_port_number);

		device_driver_free (real_port_number, device_driver_id, sptr_decompressed_ppp_packet);
		
		if (ccp.ports[real_port_number].stacker.receiver_history_count_and_check_mode.structure.history_count != 0x0000)
			{
			send_ccp_reset_request_with_history_number (real_port_number, 
				ccp.ports[real_port_number].stacker.receiver_history_count_and_check_mode.structure.history_count);
			 
			ccp.ports[real_port_number].receiver_is_waiting_for_reset_ack = TRUE;
			}
		
		return (FAIL);
		}
	
	return (PASS); 
}
/*************************************************************************/
static enum TEST CRC_verify_decompressed_data (USHORT real_port_number, 
	STACKER_COMPRESSION_PACKET_WITH_CRC *sptr_stacker_compression_packet_with_crc, BYTE *bptr_decompressed_data, 
	USHORT decompressed_data_length, BYTE *bptr_first_byte_following_the_decompressed_data, 
	PPP_PACKET_WITH_MAC_HEADER *sptr_decompressed_ppp_packet) 
{
	USHORT new_checksum;
	ULONG device_driver_id;
	
	device_driver_id = (*ccp.ppp.fptr_get_device_driver_id_function) (real_port_number);
	
	*((USHORT *) bptr_first_byte_following_the_decompressed_data) = 
		net_to_host_short (sptr_stacker_compression_packet_with_crc->CRC); 

	new_checksum = calculate_frame_check_sequence (INIT_FRAME_CHECK_SEQUENCE, bptr_decompressed_data,
		(USHORT) (decompressed_data_length + 2));

	if (new_checksum != FINAL_GOOD_FRAME_CHECK_SEQUENCE)
		{
		ccp_printf (CCP_ALARM_PRINTF,"CCP:Stacker LZS: CRC Check Failed on Port %04x\n",real_port_number);

		device_driver_free (real_port_number, device_driver_id, sptr_decompressed_ppp_packet);
		
		if (ccp.ports[real_port_number].stacker.receiver_history_count_and_check_mode.structure.history_count != 0x0000)
			{
			send_ccp_reset_request_with_history_number (real_port_number, 
				ccp.ports[real_port_number].stacker.receiver_history_count_and_check_mode.structure.history_count);
			 
			ccp.ports[real_port_number].receiver_is_waiting_for_reset_ack = TRUE;
			}
	
		return (FAIL);
		}

	return (PASS);
}
/*************************************************************************/
static void adjust_decompressed_packet_with_uncompressed_protocol_field (BYTE *bptr_second_byte_of_ppp_protocol_type_field,
	USHORT *usptr_ppp_packet_length, USHORT decompressed_data_length)
{
	BYTE *bptr_first_byte_of_ppp_protocol_type_field;

	bptr_first_byte_of_ppp_protocol_type_field = bptr_second_byte_of_ppp_protocol_type_field - 1;
	
	if (*bptr_second_byte_of_ppp_protocol_type_field & '\x01'== 0x00)
		{
		memmove ((void *) bptr_first_byte_of_ppp_protocol_type_field, (void *) bptr_second_byte_of_ppp_protocol_type_field, 
			decompressed_data_length);
		
		*usptr_ppp_packet_length = (USHORT) (decompressed_data_length + SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS);
		}
	else
		{
		*bptr_first_byte_of_ppp_protocol_type_field = '\0';
		
		*usptr_ppp_packet_length = (USHORT) (decompressed_data_length + SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS + 
			HALF_SIZE_OF_PPP_PROTOCOL_FIELD);
		}
}
/*************************************************************************/
static void handle_incorrect_sequence_number (USHORT real_port_number, BYTE sequence_number_received) 
{
	ccp.ports[real_port_number].stacker.sequence_number_of_latest_received_packet =	sequence_number_received;

	if (ccp.ports[real_port_number].stacker.receiver_history_count_and_check_mode.structure.history_count != 0x0000)
		{
		send_ccp_reset_request_with_history_number (real_port_number, 
			ccp.ports[real_port_number].stacker.receiver_history_count_and_check_mode.structure.history_count);
		 
		ccp.ports[real_port_number].receiver_is_waiting_for_reset_ack = TRUE;
		}
	else
		{
		ccp.ports[real_port_number].stacker.receiver_sequence_number = (BYTE) (sequence_number_received + 1);
		}
}
/*************************************************************************/
static void free_compressed_ppp_packet (USHORT port_number, void *vptr_buffer)
{
	PARAMETER_NOT_USED (port_number);
	
	buffer_free ((void *) vptr_buffer); 
}
#endif /* STAC_LZS */

