#include	".\defs.h"
/* $modname: ccptx.c$ $version: 1.0$ $date: 10/19/95$ */
/*
$lgb$
1.0 10/19/95 biao Compression Control Protocol (CCP) Initial Release.
$lge$
*/
/************************************************************************/
/*	Copyright (C) 1995 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <string.h>
#include "ccp.h"
/****************************************************************************/
static void send_ccp_packet (USHORT real_port_number, PPP_PACKET *sptr_tx_packet, 
	USHORT number_of_bytes_to_send, enum PPP_CONTROL_CODE code, BYTE id);
/****************************************************************************/
void send_ccp_configuration_request (USHORT real_port_number)
{
	USHORT number_of_bytes_to_send;
	CCP_CONFIGURE_REQUEST_PACKET *sptr_configuration_request_packet;

	number_of_bytes_to_send = sizeof (PPP_HEADER) + sizeof (CCP_HEADER);
	
	number_of_bytes_to_send = 
		(USHORT) (number_of_bytes_to_send + get_size_of_ppp_options (&ccp.ports[real_port_number].option_lists.tx_accepted));

	sptr_configuration_request_packet = (CCP_CONFIGURE_REQUEST_PACKET *) ppp_get_a_send_packet (real_port_number, 
		number_of_bytes_to_send);

	if (sptr_configuration_request_packet == NULL)
		{
		return;
		}

	store_ppp_options_in_packet (&ccp.ports[real_port_number].option_lists.tx_accepted, 
		(PPP_OPTION *) &sptr_configuration_request_packet->options);

	ccp.ports[real_port_number].id_sequence_number = (BYTE) (ccp.ports[real_port_number].id_sequence_number + 1);

	ccp.ports[real_port_number].last_id_of_ccp_packet_sent = ccp.ports[real_port_number].id_sequence_number;
	ccp.ports[real_port_number].length_of_last_txed_ccp_packet = number_of_bytes_to_send;

	ccp_printf (CCP_DATA_PRINTF, "CCP: Configure Request Tx on port: %04x, ID %02x\n", real_port_number, 
		ccp.ports[real_port_number].id_sequence_number);

	send_ccp_packet (real_port_number, (PPP_PACKET *) sptr_configuration_request_packet, number_of_bytes_to_send, 
		CONFIGURE_REQUEST, ccp.ports[real_port_number].id_sequence_number);
}
/****************************************************************************/
static void send_ccp_packet (USHORT real_port_number, PPP_PACKET *sptr_tx_packet, USHORT number_of_bytes_to_send, 
	enum PPP_CONTROL_CODE code, BYTE id)
{
	sptr_tx_packet->code = (BYTE_ENUM (PPP_CONTROL_CODE)) code;
	sptr_tx_packet->id = id;
	sptr_tx_packet->length = swap ((USHORT) (number_of_bytes_to_send - sizeof (PPP_HEADER)));

	sptr_tx_packet->header.protocol_type = CCP_PROTOCOL;

	ccp.ports[real_port_number].ccp_statistics.number_of_tx_bytes += number_of_bytes_to_send;

	++ccp.ports[real_port_number].ccp_statistics.number_of_tx_packets;
	++ccp.ports[real_port_number].ccp_statistics.number_of_control_tx_packets[sptr_tx_packet->code];

	if (code == CONFIGURE_REQUEST)
		{
		sptr_tx_packet->header.hdlc_address = HDLC_ADDRESS;
		sptr_tx_packet->header.hdlc_control = UNNUMBERED_INFORMATION;

		if (memcmp (&ccp.ports[real_port_number].last_txed_ccp_configuration_request_packet, sptr_tx_packet, 
			number_of_bytes_to_send) == (int) NULL)
			{
			ccp.ports[real_port_number].id_sequence_number = (BYTE) (ccp.ports[real_port_number].id_sequence_number - 1);

			ccp.ports[real_port_number].last_id_of_ccp_packet_sent = ccp.ports[real_port_number].id_sequence_number;
			}

		memcpy (&ccp.ports[real_port_number].last_txed_ccp_configuration_request_packet, sptr_tx_packet, number_of_bytes_to_send);
		}

	send_native_ppp_packet (real_port_number, sptr_tx_packet, number_of_bytes_to_send, ppp_send_completion);
}
/****************************************************************************/
void send_ccp_configuration_ack (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet, USHORT number_of_bytes_rxed)
{
	CCP_CONFIGURE_ACK_PACKET *sptr_configuration_ack_packet;

	ccp.ports[real_port_number].length_of_last_rxed_ccp_configuration_packet = number_of_bytes_rxed;

	sptr_configuration_ack_packet = (CCP_CONFIGURE_ACK_PACKET *) ppp_get_a_send_packet (real_port_number, number_of_bytes_rxed);

	if (sptr_configuration_ack_packet == NULL)
		{
		return;
		}

	memcpy (sptr_configuration_ack_packet, sptr_ccp_rx_packet, number_of_bytes_rxed);

	sptr_configuration_ack_packet->code = CONFIGURE_ACK;

	ccp_printf (CCP_DATA_PRINTF, "CCP: Configure Ack Tx on port: %04x\n", real_port_number);

	send_native_ppp_packet (real_port_number, (PPP_PACKET *) sptr_configuration_ack_packet, 
		number_of_bytes_rxed, ppp_send_completion);
}
/****************************************************************************/
void send_ccp_configuration_nak (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet)
{
	USHORT number_of_bytes_to_send;
	CCP_CONFIGURE_NAK_PACKET *sptr_configuration_nak_packet;

	number_of_bytes_to_send = sizeof (PPP_HEADER) + sizeof (CCP_HEADER);

	number_of_bytes_to_send = 
		(USHORT) (number_of_bytes_to_send + get_size_of_ppp_options (&ccp.ports[real_port_number].option_lists.tx_nak));

	sptr_configuration_nak_packet = (CCP_CONFIGURE_NAK_PACKET *) ppp_get_a_send_packet (real_port_number, number_of_bytes_to_send);

	if (sptr_configuration_nak_packet == NULL)
		{
		return;
		}

	store_ppp_options_in_packet (&ccp.ports[real_port_number].option_lists.tx_nak, 
		(PPP_OPTION *) &sptr_configuration_nak_packet->options);

	ccp_printf (CCP_DATA_PRINTF, "CCP: Configure NAK Tx on port: %04x\n", real_port_number);

	send_ccp_packet (real_port_number, (PPP_PACKET *) sptr_configuration_nak_packet, number_of_bytes_to_send, 
		CONFIGURE_NAK, sptr_ccp_rx_packet->ccp_header.id);
}
/****************************************************************************/
void send_ccp_configuration_reject (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet)
{
	USHORT number_of_bytes_to_send;
	CCP_CONFIGURE_REJECT_PACKET *sptr_configuration_reject_packet;

	number_of_bytes_to_send = sizeof (PPP_HEADER) + sizeof (CCP_HEADER);

	number_of_bytes_to_send = 
		(USHORT) (number_of_bytes_to_send + get_size_of_ppp_options (&ccp.ports[real_port_number].option_lists.tx_reject));

	sptr_configuration_reject_packet = (CCP_CONFIGURE_REJECT_PACKET *) ppp_get_a_send_packet (real_port_number, 
		number_of_bytes_to_send);

	if (sptr_configuration_reject_packet == NULL)
		{
		return;
		}

	ccp_printf (CCP_DATA_PRINTF, "CCP: Configure REJECT Tx on port: %04x\n", real_port_number);

	store_ppp_options_in_packet (&ccp.ports[real_port_number].option_lists.tx_reject, 
		(PPP_OPTION *) &sptr_configuration_reject_packet->options);

	send_ccp_packet (real_port_number, (PPP_PACKET *) sptr_configuration_reject_packet, number_of_bytes_to_send, 
		CONFIGURE_REJECT, sptr_ccp_rx_packet->ccp_header.id);
}
/****************************************************************************/
void send_ccp_termination_request (USHORT real_port_number)
{
	CCP_TERMINATE_REQUEST *sptr_termination_request_packet;

	ccp_printf (CCP_DATA_PRINTF, "CCP: Termination Request Tx on port: %04x\n", real_port_number);

	sptr_termination_request_packet = (CCP_TERMINATE_REQUEST *) ppp_get_a_send_packet (real_port_number, sizeof (CCP_TERMINATE_REQUEST));

	if (sptr_termination_request_packet == NULL)
		{
		return;
		}

	ccp.ports[real_port_number].id_sequence_number = (BYTE) (ccp.ports[real_port_number].id_sequence_number + 1);

	++ccp.ports[real_port_number].number_of_termination_requests;

	ccp.ports[real_port_number].last_id_of_ccp_packet_sent = ccp.ports[real_port_number].id_sequence_number;

	if (ccp.fptr_event_upcall != NULL)
		{
		(*ccp.fptr_event_upcall) (CCP_EVENT_TERMINATION_REQUEST, real_port_number);
		}

	send_ccp_packet (real_port_number, (PPP_PACKET *) sptr_termination_request_packet, sizeof (CCP_TERMINATE_REQUEST), 
		TERMINATION_REQUEST, ccp.ports[real_port_number].id_sequence_number);
}
/******************************************************************************/
void send_ccp_termination_ack (USHORT real_port_number,  CCP_PACKET *sptr_ccp_rx_packet)
{
	CCP_TERMINATE_ACK *sptr_termination_ack_packet;

	ccp_printf (CCP_DATA_PRINTF, "CCP: Termination ACK Tx on port: %04x\n", real_port_number);

	sptr_termination_ack_packet = (CCP_TERMINATE_ACK *) ppp_get_a_send_packet (real_port_number, sizeof (CCP_TERMINATE_ACK));

	if (sptr_termination_ack_packet == NULL)
		{
		return;
		}

	send_ccp_packet (real_port_number, (PPP_PACKET *) sptr_termination_ack_packet, sizeof (CCP_TERMINATE_ACK), 
		TERMINATION_ACK, sptr_ccp_rx_packet->ccp_header.id);
}
/*************************************************************************************************/
void send_ccp_code_reject (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet, USHORT number_of_bytes_rxed)
{
	CCP_CODE_REJECT_PACKET *sptr_code_reject_packet;
	USHORT number_of_bytes_in_tx_packet;
	ULONG ppp_remote_MRU;

	ppp_remote_MRU = (*ccp.ppp.fptr_get_ppp_remote_MRU_function) (real_port_number);

	ccp_printf (CCP_DATA_PRINTF, "CCP: Code Reject Tx on port: %04x\n", real_port_number);

	number_of_bytes_in_tx_packet = (USHORT) (sizeof (PPP_HEADER) + sizeof (CCP_HEADER) + number_of_bytes_rxed);

	sptr_code_reject_packet = (CCP_CODE_REJECT_PACKET *) ppp_get_a_send_packet (real_port_number, number_of_bytes_in_tx_packet);

	if (sptr_code_reject_packet == NULL)
		{
		return;
		}

	memcpy (&sptr_code_reject_packet->rejected_packet, sptr_ccp_rx_packet, number_of_bytes_rxed);

	if (number_of_bytes_in_tx_packet > ppp_remote_MRU)
		{
		number_of_bytes_in_tx_packet = (USHORT) ppp_remote_MRU;
		}

	send_ccp_packet (real_port_number, (PPP_PACKET *) sptr_code_reject_packet, number_of_bytes_in_tx_packet, 
		CODE_REJECT, sptr_ccp_rx_packet->ccp_header.id);
}
/****************************************************************************/
void send_ccp_reset_request (USHORT real_port_number)
{
	CCP_RESET_REQUEST *sptr_reset_request_packet;

	ccp_printf (CCP_DATA_PRINTF, "CCP: Reset Request Tx on port: %04x\n", real_port_number);

	sptr_reset_request_packet = (CCP_RESET_REQUEST *) ppp_get_a_send_packet (real_port_number, sizeof (CCP_RESET_REQUEST));

	if (sptr_reset_request_packet == NULL)
		{
		return;
		}

	ccp.ports[real_port_number].id_sequence_number = (BYTE) (ccp.ports[real_port_number].id_sequence_number + 1);

	++ccp.ports[real_port_number].number_of_reset_requests;

	ccp.ports[real_port_number].last_id_of_ccp_packet_sent = ccp.ports[real_port_number].id_sequence_number;

	send_ccp_packet (real_port_number, (PPP_PACKET *) sptr_reset_request_packet, sizeof (CCP_RESET_REQUEST), 
		RESET_REQUEST, ccp.ports[real_port_number].id_sequence_number);
}
/****************************************************************************/
void send_ccp_reset_request_with_history_number (USHORT real_port_number, USHORT history_number)
{
	CCP_RESET_REQUEST_WITH_HISTORY_NUMBER *sptr_reset_request_packet;

	ccp_printf (CCP_DATA_PRINTF, "CCP: Reset Request Tx on port: %04x\n", real_port_number);

	sptr_reset_request_packet = (CCP_RESET_REQUEST_WITH_HISTORY_NUMBER *) ppp_get_a_send_packet (real_port_number, 
		sizeof (CCP_RESET_REQUEST_WITH_HISTORY_NUMBER));

	if (sptr_reset_request_packet == NULL)
		{
		return;
		}

	ccp.ports[real_port_number].id_sequence_number = (BYTE) (ccp.ports[real_port_number].id_sequence_number + 1);

	++ccp.ports[real_port_number].number_of_reset_requests;

	ccp.ports[real_port_number].last_id_of_ccp_packet_sent = ccp.ports[real_port_number].id_sequence_number;

	sptr_reset_request_packet->history_number = host_to_net_short (history_number);

	send_ccp_packet (real_port_number, (PPP_PACKET *) sptr_reset_request_packet, sizeof (CCP_RESET_REQUEST_WITH_HISTORY_NUMBER), 
		RESET_REQUEST, ccp.ports[real_port_number].id_sequence_number);
}
/******************************************************************************/
void send_ccp_reset_ack (USHORT real_port_number,  CCP_PACKET *sptr_ccp_rx_packet)
{
	CCP_RESET_ACK *sptr_request_ack_packet;

	ccp_printf (CCP_DATA_PRINTF, "CCP: Reset ACK Tx on port: %04x\n", real_port_number);

	sptr_request_ack_packet = (CCP_RESET_ACK *) ppp_get_a_send_packet (real_port_number, sizeof (CCP_RESET_ACK));

	if (sptr_request_ack_packet == NULL)
		{
		return;
		}

	send_ccp_packet (real_port_number, (PPP_PACKET *) sptr_request_ack_packet, sizeof (CCP_RESET_ACK), 
		RESET_ACK, sptr_ccp_rx_packet->ccp_header.id);
}
/******************************************************************************/
void send_ccp_reset_ack_with_history_number (USHORT real_port_number,  CCP_PACKET *sptr_ccp_rx_packet)
{
	CCP_RESET_ACK_WITH_HISTORY_NUMBER *sptr_request_ack_packet;

	ccp_printf (CCP_DATA_PRINTF, "CCP: Reset ACK Tx on port: %04x\n", real_port_number);

	sptr_request_ack_packet = (CCP_RESET_ACK_WITH_HISTORY_NUMBER *) ppp_get_a_send_packet (real_port_number, 
		sizeof (CCP_RESET_ACK_WITH_HISTORY_NUMBER));

	if (sptr_request_ack_packet == NULL)
		{
		return;
		}

	sptr_request_ack_packet->history_number = 
		((CCP_RESET_REQUEST_WITH_HISTORY_NUMBER *) sptr_ccp_rx_packet)->history_number; 
	
	send_ccp_packet (real_port_number, (PPP_PACKET *) sptr_request_ack_packet, sizeof (CCP_RESET_ACK_WITH_HISTORY_NUMBER), 
		RESET_ACK, sptr_ccp_rx_packet->ccp_header.id);
}
