#include	".\defs.h"
/* $modname: ccpupcal.c$ $version: 1.0$ $date: 10/19/95$ */
/*
$lgb$
1.0 10/19/95 biao Compression Control Protocol (CCP) Initial Release.
$lge$
*/
/************************************************************************/
/*	Copyright (C) 1995 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdarg.h>
#include "ccp.h"
/****************************************************************************/
static ULONG ccp_event_this_layer_up (USHORT real_port_number, USHORT event, void *vptr_argument_list);
static ULONG ccp_event_this_layer_down (USHORT real_port_number, USHORT event, void *vptr_argument_list);
static ULONG ccp_event_this_layer_finished (USHORT real_port_number, USHORT event, void *vptr_argument_list);
static ULONG ccp_event_termination_request (USHORT real_port_number, USHORT event, void *vptr_argument_list);
static ULONG ccp_event_options_exhausted (USHORT real_port_number, USHORT event, void *vptr_argument_list);
/****************************************************************************/
static ULONG (*fptr_upcall[]) (USHORT event, USHORT real_port_number, void *vptr_argument_list) =
{
	ccp_event_this_layer_up,
	ccp_event_this_layer_down,
	ccp_event_this_layer_finished,
	ccp_event_termination_request,

	ccp_event_options_exhausted
};
/****************************************************************************/
ULONG ccp_event_upcall_example (USHORT event, USHORT real_port_number, ...)
{
	ULONG return_value;
	va_list argptr;

	va_start (argptr, real_port_number);

	if (event > CCP_EVENT_OPTIONS_EXHAUSTED)
		{
		ccp_printf (CCP_ALARM_PRINTF, "CCP: Illegal Up Call %04x\n", event);
		}

	ccp_printf (CCP_ALARM_PRINTF, "CCP: OEM Upcall Event on Port %04x event %04x occurred\n", real_port_number, event);

	return_value = (*fptr_upcall[event]) (real_port_number, event, argptr);

	va_end (argptr);

	return (return_value);
}
/****************************************************************************/
static ULONG ccp_event_this_layer_up (USHORT real_port_number, USHORT event, void *vptr_argument_list)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (event);
	PARAMETER_NOT_USED (vptr_argument_list);

	return ((ULONG) NULL);
}
/****************************************************************************/
static ULONG ccp_event_this_layer_down (USHORT real_port_number, USHORT event, void *vptr_argument_list)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (event);
	PARAMETER_NOT_USED (vptr_argument_list);

	return ((ULONG) NULL);
}
/****************************************************************************/
static ULONG ccp_event_this_layer_finished (USHORT real_port_number, USHORT event, void *vptr_argument_list)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (event);
	PARAMETER_NOT_USED (vptr_argument_list);

	return ((ULONG) NULL);
}
/****************************************************************************/
static ULONG ccp_event_termination_request (USHORT real_port_number, USHORT event, void *vptr_argument_list)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (event);
	PARAMETER_NOT_USED (vptr_argument_list);

	return ((ULONG) NULL);
}
/****************************************************************************/
static ULONG ccp_event_options_exhausted (USHORT real_port_number, USHORT event, void *vptr_argument_list)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (event);
	PARAMETER_NOT_USED (vptr_argument_list);

	return (0x00000001L);						 
}
