#include	".\defs.h"
/* $modname: ccputil.c$ $version: 1.0$ $date: 10/19/95$ */
/*
$lgb$
1.0 10/19/95 biao Compression Control Protocol (CCP) Initial Release.
$lge$
*/
/************************************************************************/
/*	Copyright (C) 1995 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include "ccp.h"
/*************************************************************************/
void ccp_printf (enum CCP_PRINTF_GROUPS printf_group, const char *cptr_format, ...)
{
	enum BOOLEAN print_string;

	va_list argptr;

	va_start (argptr, cptr_format);

	if (ccp.printing_enabled == FALSE)
		{
		va_end (argptr);

		return;
		}

	print_string = FALSE;

	switch (printf_group)
		{
		case CCP_MEMORY_PRINTF:
			print_string = ccp.memory_printing_enabled;
			break;
		case CCP_ALARM_PRINTF:
			print_string = ccp.alarm_printing_enabled;
			break;
		case CCP_DATA_PRINTF:
			print_string = ccp.data_printing_enabled;
			break;
		}

	if (print_string == TRUE)
		{
		vprintf (cptr_format, argptr);
		}

	va_end (argptr);
}
/****************************************************************************/
void set_ccp_class_to_zero (void)
{
	memset (&ccp, (int) NULL, sizeof (CCP_CLASS));
}
/****************************************************************************/
void swap_in_place (USHORT *usptr_ushort_to_swap_bytes_with)
{
	USHORT low_byte;
	USHORT high_byte;

	low_byte = (USHORT) low_byte_of_ushort (*usptr_ushort_to_swap_bytes_with);

	high_byte = (USHORT) high_byte_of_ushort (*usptr_ushort_to_swap_bytes_with);

	*usptr_ushort_to_swap_bytes_with = (USHORT) two_bytes_to_ushort (low_byte, high_byte);
}



/* Sachin 17/06/1997 */
/*
   The following functions are added after CCP stopped functioning when
   we introduced the new buffer division scheme. The problem was that
   the WAN port ends up getting lesser number of buffers and all the
   buffers are allocated initially by wan driver. Even when wan does
   a device_driver_free(), it keeps circularting the buffers among
   the need_buffer_list, etc., leaving nothing for device_driver_malloc().
   So, what we do is, preallocate one buffer for CCP for each port.

   VERY VERY IMPORTANT :
      Before calling this set of functions, PPP's device driver ID MUST
      be set. That is why, ccp_preallocate_buffer() is called after
      calling lsl_control() in ppp_initialize() and not during
      ccp_initialize(). ccp_initialize() is called before PPP registers
      to LSL.
*/

/*
   This functions allocates a buffer and keeps it.
   It is to be called during INIT and then whenever this preallocated
   buffer is used up when CCP successfully expand a packet.
*/
void ccp_preallocate_buffer (unsigned short real_port_number)
{
	unsigned long device_driver_id;
	
	device_driver_id = (*ccp.ppp.fptr_get_device_driver_id_function) (real_port_number);
   if (device_driver_id == NULL)
   {
      printf ("Illegal device driver id\n") ;
      return ;
   }

   ccp.ports[real_port_number].sptr_preallocated_buffer =
      device_driver_malloc (real_port_number, device_driver_id, NULL) ;
}


/*
   When CCP needs a buffer to expand a packet to, it calls this
   function. Earlier, it used to call device_driver_malloc()
*/
void *ccp_device_driver_malloc (unsigned short real_port_number, unsigned long device_driver_id, unsigned short buffer_length)
{
   void *buffer_to_return ;

   PARAMETER_NOT_USED (device_driver_id) ;
   
   buffer_to_return = ccp.ports[real_port_number].sptr_preallocated_buffer ;
   ccp.ports[real_port_number].sptr_preallocated_buffer = NULL ;

   if (buffer_to_return == NULL)
   {
      while (1)
         printf ("FATAL : CCP port %d buffer lost, but how !!!!!!!\n", real_port_number) ;
   }

   return (buffer_to_return) ;
}


/*
   If the expansion fails or for some reason, if the ccp_device_driver_malloc()ed
   buffer is not going to be used, it is freed using this function. It was
   earlier freed using device_driver_free()
*/
void ccp_device_driver_free (unsigned short real_port_number, unsigned long device_driver_id, void *sptr_buffer)
{
   PARAMETER_NOT_USED (device_driver_id) ;

   if (ccp.ports[real_port_number].sptr_preallocated_buffer != NULL)
   {
      while (1)
         printf ("FATAL : Another buffer being freed to CCP port %d\n", real_port_number) ;
   }

   ccp.ports[real_port_number].sptr_preallocated_buffer = sptr_buffer ;
}

/* Sachin 17/06/1997 */

