/* $modname: kccp.h$ $version: 1.0$ $date: 10/19/95$ */
/*
$lgb$
1.0 10/19/95 biao Compression Control Protocol (CCP) Initial Release.
$lge$
*/
/************************************************************************/
/*	Copyright (C) 1995 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#define SIZE_OF_MAC_HEADER 										10
#define SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS				2
#define HALF_SIZE_OF_PPP_PROTOCOL_FIELD						1
#define SIZE_OF_BSD_LZW_SEQUENCE_NUMBER						2
#define SIZE_OF_PREDICTOR_COMPRESSION_FLAG_AND_LENGTH		2
#define SIZE_OF_PREDICTOR_GUESS_TABLE 							65536

#if 0
#define STACKER_LZS_MAXIMUM_EXPANSION_RATIO					0.125
#define BSD_LZW_MAXIMUM_EXPANSION_RATIO						1.00
#define STACKER_LZS_MAXIMUM_COMPRESSION_RATIO				10.00
#define BSD_LZW_MAXIMUM_COMPRESSION_RATIO						10.00
#endif 

#define STACKER_LZS_MAXIMUM_EXPANSION_RATIO					(1/8)
#define BSD_LZW_MAXIMUM_EXPANSION_RATIO						1
#define STACKER_LZS_MAXIMUM_COMPRESSION_RATIO				10
#define BSD_LZW_MAXIMUM_COMPRESSION_RATIO						10

#define STACKER_PERFORMANCE_MODE_SHIFT_VAL					3

#define VARIABLE_NUMBER_OF_FRAMES								1

enum CCP_OPTION_TYPE
{
	CCP_PREDICTOR_TYPE_I	= 			0x01,
	CCP_PREDICTOR_TYPE_II =			0x02,
	CCP_STACKER_LZS_COMPRESSION = 0x11,
	CCP_BSD_LZW_COMPRESSION = 		0x15,
	CCP_NO_COMPRESSION_NEGOTIATED,
	
	NUMBER_OF_CCP_OPTIONS
};

enum CCP_STACKER_CHECK_MODE
{
	NONE,
	LCB,
	CCP_CRC,
	SEQUENCE_NUMBER
};

enum CCP_PRINTF_GROUPS
{
	CCP_MEMORY_PRINTF,
	CCP_ALARM_PRINTF,
	CCP_DATA_PRINTF
};

enum CCP_EVENT_UPCALL
{
	CCP_EVENT_THIS_LAYER_UP,
	CCP_EVENT_THIS_LAYER_DOWN,
	CCP_EVENT_THIS_LAYER_FINISHED,
	CCP_EVENT_TERMINATION_REQUEST,

	CCP_EVENT_OPTIONS_EXHAUSTED
};

enum PREDICTOR_COMPRESSION_FLAG
{ 
	UNCOMPRESSED,
	COMPRESSED
};

