/*	$Modname: kppp.h$  $version: 1.29$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 12/10/93 ross Initial Release.
1.1 12/10/93 ross Added copyright notice.
1.2 01/05/94 ross Added support for version control.
1.3 01/05/94 keyur Added some #define.
1.4 01/20/94 keyur Added some more #define.
1.5 02/22/94 keyur There is no major change to this release.
1.6 03/15/94 keyur Deleted conditional compile for BIG ENDIAN.
1.7 03/23/94 keyur Added some more #define constants.
1.8 04/04/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John. Co
1.9 04/12/94 keyur Added State Machine support for LCP according to RFC1548
1.10 04/13/94 keyur Added support for NCP state machine
1.11 04/19/94 keyur Added ordering of options for LCP and NCP, courtesy of John
1.12 05/02/94 keyur cosmetic changes.
1.13 06/23/94 ross cosmetic.
1.14 06/23/94 ross put nak responses into groups.  Courtesy of John.
1.15 07/18/94 ross general cleanup with options, added header compression, accm features.
1.16 08/08/94 ross working on adding version 2
1.17 08/11/94 ross adding rfc1570 lcp support
1.18 08/24/94 ross adding new ncps.
1.19 09/29/94 ross fixes for Chap, courtesy of Danny.  Added STP and Netbios.
1.20 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.21 12/02/94 ross testing NT3.5 RAS
1.22 12/05/94 ross dynamic option support.  Portions courtesy of Dan.
1.23 12/11/94 ross adding multiple value option support
1.24 12/13/94 ross connected to NT RAS with Netbios
1.25 02/27/95 ross dynamic load changes including lsl_control.
1.26 03/03/95 ross added up calls.
1.27 03/10/95 ross general fixes.  see change.doc
1.28 03/11/95 ross general fixes.  see change.doc
1.29 10/19/95 biao added Compression Control Protocol (CCP) support. Please refer to change.doc for details.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#ifndef PROTOCOL_MASKS

	#define PROTOCOL_MASK 0x00ff
	#define PROTOCOL_MASKS
	#define GET_PROTOCOL_TYPE_MASK 0xff00
	#define OFFSET_OF_STACK_ID 0x08

#endif

#define MIB_ENABLED													 1
#define MIB_DISABLED													 2
#define MAXIMUM_NUMBER_OF_PPP_PORTS								 3
#define ILLEGAL_PORT_NUMBER 										0xffff
#define ILLEGAL_STACK_ID 											0xffffffffL
#define SIZE_OF_WAN_CRC 											 2
#define NUMBER_OF_ERROR_BYTES									   50
#define HDLC_FLAG_SEQUENCE											0x7e
#define HDLC_ADDRESS 												0xff
#define LSL_LCP_PROTOCOL_ID 										0xff
#define DEFAULT_MAXIMUM_MRU										1500
#define MAXIMUM_CONFIGURATION_REQUESTS 						20
#define MAXIMUM_TERMINATION_REQUESTS							10
#define MAXIMUM_CONFIGURATION_REQUEST_SEND_INTERVAL	 	 3
#define MAXIMUM_CONFIGURATION_REQUEST_BACKOFF_INTERVAL	10
#define MAXIMUM_TERMINATION_REQUEST_SEND_INTERVAL		 	 3
#define MAXIMUM_ECHO_REQUEST_SEND_INTERVAL					 3
#define MAXIMUM_ECHO_REQUESTS_NOT_ACKNOWLEDGED				20
#define MAXIMUM_STRING_LENGTH										80
#define MAXIMUM_PACKET_LENGTH										2048
#define DEFAULT_ASYNC_CONTROL_CHARACTER_MAP				  	0xffffffffL
#define ASYNC_CONTROL_ESCAPE_SEQUENCE							0x7d
#define ASYNC_FLAG_SEQUENCE										0x7e
#define ASYNC_SIXTH_BIT_COMPLEMENT								0x20
#define INIT_FRAME_CHECK_SEQUENCE								0xffff
#define VARIABLE_NUMBER_OF_BYTES									0x01
#define VARIABLE_NUMBER												0x01
#define ASYNC_MAXIMUM_TX_ENCODED_PACKET_MULTIPLIER			 2
#define MAXIMUM_APPLETALK_PACKET_LENGTH						599
#define APPLETALK_STACK_ID											 3
#define MAXIMUM_NUMBER_OF_PROTOCOL_REJECTS_RECEIVED		10
#define DEFAULT_FCS_TABLE_SIZE									256
#define DEFAULT_MAGIC_NUMBER										0x00000000L
#define MAXIMUM_NUMBER_OF_NCP_OPTIONS							8
#define MAXIMUM_SIZE_OF_OPTION									16
#define PPP_IPX_NAME_SIZE											48
#define CHALLENGE_VALUE_SIZE										8
/* Sachin 06/10/1997, to handle larger chap challenges */
#define MAX_CHALLENGE_VALUE_SIZE									64

#define RESPONSE_VALUE_SIZE										16
#define NAME_SIZE														128
#define SMALL_NAME_SIZE												80
#define FINAL_GOOD_FRAME_CHECK_SEQUENCE						0xf0b8
#define MAXIMUM_NUMBER_OF_USERS									50
#define NCP_MASK BIG_ENDIAN_CONSTANT (0x8000)

/* Kamalnath SLIP 06\03\1997 */
#define END	 		0xC0  /* indicates end of packet */
#define ESC  		0xDB 	/* indicates byte stuffing */
#define ESC_END  	0xDC	/* ESC ESC_END means END data byte */
#define ESC_ESC	0xDD  /* ESC ESC_ESC means ESC data byte */

#define IP_HEADER_START_BYTE  		0x45
#define SIZE_OF_SLIP_FRM_HEADER 		2
#define SLIP_MAXIMUM_TX_ENCODED_PACKET_MULTIPLIER			 2
/* Kamalnath SLIP 06\03\1997 */

enum NCP_STACK_INDEX
{
	PPP_IP_NCP_STACK_INDEX,
#if 0
	PPP_IPX_NCP_STACK_INDEX,
	PPP_APPLETALK_NCP_STACK_INDEX,
	PPP_NETBIOS_NCP_STACK_INDEX,
	PPP_BRIDGING_NCP_STACK_INDEX,
#endif
	NUMBER_OF_NCP_STACKS
};

enum PPP_STATE
{
	PPP_INITIAL_STATE = 0x00,
	PPP_STARTING_STATE = 0x01,
	PPP_CLOSED_STATE = 0x02,
	PPP_STOPPED_STATE = 0x03,
	PPP_CLOSING_STATE = 0x04,
	PPP_STOPPING_STATE = 0x05,
	PPP_REQUEST_SENT_STATE = 0x06,
	PPP_ACK_RECEIVED_STATE = 0x07,
	PPP_ACK_SENT_STATE = 0x08,
	PPP_OPENED_STATE = 0x09,

	NUMBER_OF_PPP_STATES,
	NO_CHANGE_TO_PPP_STATE,
	ILLEGAL_PPP_STATE
};

enum PPP_PHASE
{
	PPP_LINK_DEAD, 
	PPP_LINK_UP,	
	PPP_LINK_ESTABLISHING,
	PPP_LINK_ESTABLISHED_FAILURE,
	PPP_LINK_OPENED,
	PPP_LINK_AUTHENTICATING,
	PPP_LINK_AUTHENTICATED,
	PPP_LINK_AUTHENTICATION_FAILED,
	PPP_NETWORK_LAYER_PROTOCOL_PHASE,
	PPP_NETWORK_LAYER_CLOSING,
	PPP_TERMINATE_LINK_PHASE,
	PPP_TERMINATED_LINK_GOING_DOWN
};

enum PPP_EVENT
{
	PPP_UP_EVENT = 0x0000,
	PPP_DOWN_EVENT = 0x0001,
	PPP_OPEN_EVENT = 0x0002,
	PPP_CLOSE_EVENT = 0x0003,
	PPP_TIMEOUT_WITH_COUNTER_GREATER_THAN_ZERO_EVENT = 0x0004,
	PPP_TIMEOUT_WITH_COUNTER_EXPIRED_EVENT = 0x0005,
	PPP_RECEIVE_CONFIGURE_REQUEST_GOOD_EVENT = 0x0006,
	PPP_RECEIVE_CONFIGURE_REQUEST_BAD_EVENT = 0x0007,
	PPP_RECEIVE_CONFIG_REQUEST_BAD_OPTION_EVENT = 0x0008,
	PPP_RECEIVE_CONFIGURE_ACK_EVENT = 0x0009,
	PPP_RECEIVE_CONFIGURE_NAK_EVENT = 0x000a,
	PPP_RECEIVE_CONFIGURE_REJECT_EVENT = 0x000b,
	PPP_RECEIVE_TERMINATE_REQUEST_EVENT = 0x000c,
	PPP_RECEIVE_TERMINATE_ACK_EVENT = 0x000d,
	PPP_RECEIVE_UNKNOWN_CODE_EVENT = 0x000e,
	PPP_RECEIVE_CODE_REJECT_PERMITTED_EVENT = 0x000f,
	PPP_RECEIVE_PROTOCOL_REJECT_EVENT = 0x0010,
	PPP_RECEIVE_CODE_REJECT_CATASTROPHIC_EVENT = 0x0011,
	PPP_RECEIVE_ECHO_REQUEST_EVENT = 0x0012,
	PPP_RECEIVE_ECHO_REPLY_EVENT = 0x0013,
	PPP_RECEIVE_DISCARD_REQUEST_EVENT = 0x0014,

	PPP_ECHO_RESPONSE_TIMEOUT = 0x0015,
	PPP_ECHO_RESPONSE_TIMEOUT_FAILURE = 0x0016,

	NUMBER_OF_PPP_EVENTS
};

enum OPTION_PARSE_RESULT
{
	OPTIONS_RECEIVED_ARE_OK,
	SOME_OPTIONS_ARE_NACKED,
	SOME_OPTIONS_ARE_REJECTED,
	OPTION_PARSING_ERROR,
	OPTION_PARSING_FATAL
};

enum OPTION_STATE
{
	OPTION_DEFAULT_STATE,
	OPTION_PARSED_STATE,
	OPTION_ACKED_STATE,
	OPTION_NACKED_STATE,
	OPTION_REJECTED_STATE
};

enum LCP_OPTION_TYPE
{
	LCP_MAXIMUM_RECEIVE_UNIT						= 0x01,
	LCP_ASYNC_CONTROL_CHARACTER_MAP				= 0x02,
	LCP_AUTHENTICATION_PROTOCOL					= 0x03,
	LCP_QUALITY_PROTOCOL								= 0x04,
	LCP_MAGIC_NUMBER									= 0x05,
	LCP_PROTOCOL_FIELD_COMPRESSION				= 0x07,
	LCP_ADDRESS_AND_CONTROL_FIELD_COMPRESSION	= 0x08,
	LCP_FCS_ALTERNATIVES = 0x09,
	LCP_SELF_DESCRIBING_PADDING = 0x0a,
	LCP_CALLBACK = 0x0d,
	LCP_COMPOUND_FRAMES = 0x0f,

	LCP_MAXIMUM_RECONSTRUCTED_UNIT				= 0x11,
	LCP_SHORT_SEQUENCE_NUMBER_HEADER				= 0x12,
	LCP_ENDPOINT_DISCRIMINATOR						= 0x13,
	LCP_LINK_DISCRIMINATOR							= 0x17,

/* sudhir */
/* 	NUMBER_OF_LCP_OPTIONS */
	NUMBER_OF_LCP_OPTIONS = 0xff 
/* sudhir */

};

enum PPP_CONTROL_CODE
{
	CONFIGURE_REQUEST = 		0x01,
	CONFIGURE_ACK = 			0x02,
	CONFIGURE_NAK = 			0x03,
	CONFIGURE_REJECT = 		0x04,
	TERMINATION_REQUEST = 	0x05,
	TERMINATION_ACK = 		0x06,
	CODE_REJECT = 				0x07,
	PROTOCOL_REJECT = 		0x08,
	PPP_ECHO_REQUEST = 		0x09,
	PPP_ECHO_REPLY = 			0x0a,
	DISCARD_REQUEST =			0x0b,
	IDENTIFICATION = 			0x0c,
	TIME_REMAINING = 			0x0d,
#if defined (CCP)
	RESET_REQUEST =			0x0e,
	RESET_ACK		=			0x0f,
#endif
	NUMBER_OF_PPP_CONTROL_CODES,

	AUTHENTICATION_REQUEST= 0x01,
	AUTHENTICATION_ACK =		0x02,
	AUTHENTICATION_NAK = 	0x03,
	CHAP_AUTHENTICATION_ACK = 0x03,
	CHAP_AUTHENTICATION_NAK = 0x04,

	CHAP_CHALLENGE = 0x01,
	CHAP_RESPONSE = 0x02,

	CBCP_REQUEST = 0x01,
	CBCP_RESPONSE = 0x02,
	CBCP_ACK = 0x03
};

enum PPP_PROTOCOL_TYPE
{
	IP_PROTOCOL	 =	BIG_ENDIAN_CONSTANT (0x0021),
	IPX_PROTOCOL	 =	BIG_ENDIAN_CONSTANT (0x002b),
	APPLETALK_PROTOCOL = BIG_ENDIAN_CONSTANT (0x0029),
	VAN_JACOBSON_COMPRESSED_PROTOCOL = BIG_ENDIAN_CONSTANT (0x002d),
	VAN_JACOBSON_UNCOMPRESSED_PROTOCOL = BIG_ENDIAN_CONSTANT (0x002f),
	BRIDGING_PROTOCOL = BIG_ENDIAN_CONSTANT (0x0031),
	MULTILINK_PROTOCOL = BIG_ENDIAN_CONSTANT (0x003d),
	NETBIOS_PROTOCOL = BIG_ENDIAN_CONSTANT (0x003f),

	_8021D_SPANNING_TREE_BPDU = BIG_ENDIAN_CONSTANT (0x0201),
	SOURCE_ROUTING_BPDU = BIG_ENDIAN_CONSTANT (0x0203),
	DEC_LAN_BRIDGE_100 = BIG_ENDIAN_CONSTANT (0x0205),

	IPCP_PROTOCOL = BIG_ENDIAN_CONSTANT (0x8021),
	IPXCP_PROTOCOL = BIG_ENDIAN_CONSTANT (0x802b),
	ATCP_PROTOCOL = BIG_ENDIAN_CONSTANT (0x8029),
	BCP_PROTOCOL = BIG_ENDIAN_CONSTANT (0x8031),
	NBFCP_PROTOCOL = BIG_ENDIAN_CONSTANT (0x803f),
	
	LCP_PROTOCOL = BIG_ENDIAN_CONSTANT (0xc021),	
	PAP_PROTOCOL = BIG_ENDIAN_CONSTANT (0xc023),
	CHAP_PROTOCOL = BIG_ENDIAN_CONSTANT (0xc223),
	LINK_QUALITY_PROTOCOL =  BIG_ENDIAN_CONSTANT (0xc025),

	CBCP_PROTOCOL = BIG_ENDIAN_CONSTANT (0xC029)

#if defined (CCP)
	,	/* terminate the previous entry */
	LINK_CCP_PROTOCOL = BIG_ENDIAN_CONSTANT (0x80fb),
	CCP_PROTOCOL = BIG_ENDIAN_CONSTANT (0x80fd),
	FIRST_CHOICE_COMPRESSION_PROTOCOL = BIG_ENDIAN_CONSTANT (0x00fd)
#endif
};

enum IPCP_OPTION_TYPE
{
	IP_ADDRESSES_OPTION_TYPE  	= 	0x01,
	IP_COMPRESSION_OPTION_TYPE	=	0x02,
	IP_ADDRESS_OPTION_TYPE 		=	0x03,

/* SUDHIR */
	IP_PRIMARY_DNS_OPTION_TYPE  = 129,
	IP_SECONDARY_DNS_OPTION_TYPE = 131,
/* SUDHIR */

	NUMBER_OF_IPCP_OPTIONS = 0x05
};

enum VAN_JACOBSON_COMPRESSION_TYPE
{
	VJ_IP_TYPE  	= 	0x40,
	VJ_UNCOMPRESSED_TCP_TYPE	=	0x70,
	VJ_COMPRESSED_TCP_TYPE 	=	0x80,
	VJ_TYPE_ERROR = 0x00
};

enum ATCP_OPTION_TYPE
{
 	APPLETALK_ADDRESS_OPTION_TYPE	= 0x01,
	APPLETALK_ROUTING_PROTOCOL_OPTION = 0x02,
	APPLETALK_SUPPRESS_BROADCAST_OPTION_TYPE	= 0x03,
	APPLETALK_COMPRESSION_OPTION = 0x04,
	APPLETALK_SERVER_INFORMATION_OPTION	= 0x05,
	APPLETALK_ZONE_INFORMATION_OPTION = 0x06,
	APPLETALK_DEFAULT_ROUTER_ADDRESS_OPTION = 0x07,

	NUMBER_OF_APPLETALK_OPTIONS
};

enum AUTHENTICATION_STATUS
{
	SUCCESSFUL 		=	0x01,
	UNSUCCESSFUL 	=	0x02
};

enum PPP_ALARM_TYPE
{
	PPP_RX_PACKET_TOO_SHORT, 
	PPP_RX_PACKET_TOO_LONG 
};

enum PPP_PRINTF_GROUPS
{
	PPP_MEMORY_PRINTF,
	PPP_ALARM_PRINTF,
	PPP_DATA_PRINTF,
	PPP_LCP_PRINTF,
	PPP_NCP_PRINTF
#ifdef __MLPPP__
	,PPP_MLPPP_PRINTF
#endif
};

#if 0 /* Jo 18/05/99 */
/* Kamalnath 24\04\1997 */
enum SLIP_PRINTF_GROUPS
{
	SLIP_MEMORY_PRINTF,
	SLIP_ALARM_PRINTF,
	SLIP_DATA_PRINTF,
	SLIP_EVENT_PRINTF
};
/* Kamalnath 24\04\1997 */

#define NETBIOS_MAXIMUMUM_NAME_LENGTH 16

enum NETBIOS_NCP_OPTION
{
	NAME_PROJECTION = 0x01,
	PEER_INFORMATION = 0x02,
	MULTICAST_FILTERING = 0x03,
	IEEE_MAC_ADDRESS_REQUIRED = 0x04,

	NUMBER_OF_NETBIOS_OPTIONS
};

enum NETBIOS_ADDED_TYPE
{
	NETBIOS_UNIQUE_NAME = 0x01,
	NETBIOS_GROUP_NAME = 0x02
};

enum NETBIOS_CONFIGURE_REJECT_TYPE
{
	NAME_ADDED_SUCCESSFULLY,
	DUPLICATE_NAME_IN_LOCAL_TABLE = 0x0d,
	NAME_TABLE_FULL = 0x0e,
	NAME_NOT_FOUND_OR_CANNOT_SPECIFIY_SPECIAL_CHARATERS = 0x15,
	NAME_IN_USE_ON_REMOTE_NETBIOS = 0x16,
	NAME_CONFLICT_DETECTED = 0x19,
	NAME_DEFINED_BY_ANOTHER_ENVIRONMENT = 0x30,
	REQUIRED_SYSTEM_RESOURCES_EXHAUSTED = 0x35
};

enum NETBIOS_PEER_CLASS
{
	MICROSOFT_PPP_NETBIOS_GATEWAY_SERVER = 0x0001,
	GENERIC_PPP_NETBIOS_GATEWAY_SERVER = 0x0002,
	MICROSOFT_PPP_LOCAL_ACCESS_ONLY_SERVER = 0x0003,
	GENERIC_PPP_LOCAL_ACCESS_ONLY_SERVER = 0x0004,
	GENERIC_PPP_NETBIOS_BRIDGE = 0x0006,
	MICROSOFT_PPP_ENDSYSTEM = 0x0007,
	GENERIC_PPP_ENDSYSTEM = 0x0008,

  _NETBIOS_PEER_CLASS_USHORT_FILLER = 0x1000
};

enum MULTICAST_FORWARD_PERIOD_TYPE
{
	FORWARD_ALL_MULTICAST_PACKETS,
	UNKNOWN_FORWARD_PERIOD = 0xffff
};

enum NETBIOS_PRIORITY_TYPE
{
	DIRECTED_PACKETS_HAVE_PRIORITY,
	MULTICAST_PACKETS_HAVE_PRIORITY
};

enum IPXCP_COMPRESSION_OPTION_TYPE
{
	TELEBIT_IPX_COMPRESSION = BIG_ENDIAN_CONSTANT (0x0002),
	SHIVA_COMPRESSED_NCP_IPX = BIG_ENDIAN_CONSTANT (0x0235)
};

enum IPXCP_ROUTING_PROTOCOL_TYPE
{
	NO_IPXCP_ROUTING_PROTOCOL_REQUIRED = BIG_ENDIAN_CONSTANT (0x0000),
	NOVELL_RIP_SAP_REQUIRED = BIG_ENDIAN_CONSTANT (0x0002),
	NOVELL_NLSP_REQUIRED = BIG_ENDIAN_CONSTANT (0x0004),
	_IPXCP_ROUTING_PROTOCOL_TYPE_USHORT_FILLER = 0x1000
};

enum BRIDGING_NCP_OPTION
{
	BRIDGE_IDENTIFICATION_TYPE = 0x01,
	LINE_IDENTIFICATION_TYPE = 0x02,
	MAC_SUPPORT_TYPE = 0x03,
	TINYGRAM_COMPRESSION_TYPE = 0x04,
	LAN_IDENTIFICATION_TYPE = 0x05,
	MAC_ADDRESS_TYPE = 0x06,
	SPANNING_TREE_PROTOCOL_TYPE = 0x07,

	NUMBER_OF_SPANNING_TREE_OPTIONS
};

enum BRIDGE_MAC_TYPE
{
	IEEE_802_3_ETHERNET_CANONICAL = 0x01,
	IEEE_802_4_CANONICAL = 0x02,
	IEEE_802_5_NON_CANONICAL = 0x03,
	FDDI_NON_CANONICAL = 0x04,
	IEEE_802_5_CANONICAL = 0x0b,
	FDDI_CANONICAL = 0x0c,

	NUMBER_OF_BRIDGE_MAC_TYPES
};

enum BRIDGE_PROTOCOL_TYPE
{
	NO_SPANNING_TREE = 0x00,
	SPANNING_TREE_8021D = 0x01,
	SPANNING_TREE_8021G = 0x02,
	IBM_SOURCE_ROUTING_SPANNING_TREE = 0x03,
	DEC_LAN_BRIDGE_100_SPANNING_TREE = 0x04,

	NUMBER_OF_BRIDGE_PROTOCOL_TYPES
};

enum AT_COMPRESSION_PROTOCOL
{
	YET_TO_DEFINE
};

enum AT_ROUTING_PROTOCOL
{
	NO_ROUTING 	= BIG_ENDIAN_CONSTANT (0x0000),
	AT_RTMP 		= BIG_ENDIAN_CONSTANT (0x0001),
	AT_AURP 		= BIG_ENDIAN_CONSTANT (0x0002),
	AT_ABGP 		= BIG_ENDIAN_CONSTANT (0x0003),

	_AT_ROUTING_USHORT_FILLER = 0x1000
};

enum AT_SERVER_CLASS
{
  PPP_DIAL_IN_SERVER	  		= BIG_ENDIAN_CONSTANT (0x0001),
  GENERIC						= BIG_ENDIAN_CONSTANT (0x0002),
  DIAL_IN_AND_ROUTER_BOTH	= BIG_ENDIAN_CONSTANT (0x0003),

	_AT_SERVER_CLASS_USHORT = 0x1000
};

#endif /* Jo 18/05/99 */

enum PPP_LQR_QUALITY {
	LQR_GOOD = 1,
	LQR_BAD = 2,
	LQR_NOT_DETERMINED = 3
};

enum IPXCP_OPTION_TYPE
{
	IPX_NETWORK_NUMBER = 0x01,
	IPX_NODE_NUMBER,
	IPX_COMPRESSION_PROTOCOL,
	IPX_ROUTING_PROTOCOL,
	IPX_ROUTER_NAME,
	IPX_CONFIGURATION_COMPLETE,

	NUMBER_OF_IPXCP_OPTIONS
};

enum AUTHENTICATION_ALGORITHM
{
	MD5_ALGORITHM = 0x05
};

enum CALLBACK_OPERATION
{
	LOCATION_DETERMINED_BY_AUTHENTICATION = 0,
	DIALING_STRING = 1,
	LOCATION_ID = 2,
	_E164_NUMBER = 3,
	DISTINGUISHED_NAME = 4,
	LOC_DETERMINED_BY_CBCP_PROTOCOL = 6
};

enum PPP_EVENT_UPCALL
{
	PPP_EVENT_LCP_THIS_LAYER_UP,
	PPP_EVENT_LCP_THIS_LAYER_DOWN,
	PPP_EVENT_LCP_THIS_LAYER_FINISHED,
	PPP_EVENT_LCP_TERMINATION_REQUEST,
	PPP_EVENT_LCP_ID_REQUEST,
	PPP_EVENT_LCP_ID_REQUEST_RECEIVED,
	PPP_EVENT_LCP_TIME_REMAINING_REQUEST,
	PPP_EVENT_LCP_TIME_REMAINING_RECEIVED,

	PPP_EVENT_NCP_THIS_LAYER_UP,
	PPP_EVENT_NCP_THIS_LAYER_DOWN,
	PPP_EVENT_NCP_THIS_LAYER_FINISHED,

	PPP_EVENT_AUTHENTICATE_REQUEST,
	PPP_EVENT_AUTHENTICATE_LOOKUP,
	PPP_EVENT_AUTHENTICATE_VERIFY,
	PPP_EVENT_AUTHENTICATE_ACK_TRANSMITTED,
	PPP_EVENT_AUTHENTICATE_ACK_RECEIVED,
	PPP_EVENT_AUTHENTICATION_FAILED,
	PPP_EVENT_AUTHENTICATION_REFUSED,

	PPP_EVENT_OPTIONS_EXHAUSTED
};

#ifdef __DOD__

enum PPP_CONNECT_STATE
{
	LINK_DOWN = 0x00,
	LINK_UP = 0x01,
	LINK_GOING_DOWN = 0x02,
	LINK_DOWN_BY_DEMAND = 0x03,
	LINK_GOING_UP = 0x04
};


/* Vidy & Sudha 25 Nov 1998 */
enum TRIGGER_PORT_OPEN
{
	NOT_REQUIRED = 0x00,
	REQUIRED,
	REOPEN_REQUIRED,
	INITIALLY_NOT_REQUIRED,
	REQUIRED_NOW

};
/* Vidy & Sudha 25 Nov 1998 */

#endif /* __DOD__ */

/* Srikar, Mar 22, 1997. Added the following constants for validation of InitialMRU and FcsSize setting. */

/* Following constants define the configured minimum and maximum MRU. */

#define	SNMP_PPP_LINK_MRU_MINIMUM	1500
#define	SNMP_PPP_LINK_MRU_MAXIMUM	1534

/* Following is the allowed value(s) for size of FCS. */

#define SNMP_PPP_LINK_16_BIT_CRC		16
#define SNMP_PPP_LINK_32_BIT_CRC		32

/* Following constants define whether link quality report option will be negotiated or not. */

#define	SNMP_PPP_LINK_LQR_DISABLED	1
#define	SNMP_PPP_LINK_LQR_ENABLED	2

/* Following constants define the operational status of IP over the PPP link. */

#define	SNMP_PPP_IP_LINK_OPENED		1
#define	SNMP_PPP_IP_LINK_NOT_OPENED	2

/* Following constants define the compression control protocol used by IP. */

#define	SNMP_PPP_IP_COMPRESSION_NONE	1
#define	SNMP_PPP_IP_COMPRESSION_VJ_TCP	2

/* Following constants define the administrative enabling/disabling of certain PPP options like IP */
/* protocol, VJ compression. */

#define	SNMP_PPP_OPTION_ADMIN_DISABLED	0
#define	SNMP_PPP_OPTION_ADMIN_ENABLED	1
#define	SNMP_PPP_OPTION_ADMIN_ORIGINATE_NEGOTIATION_OFF	2		/* Do not initiate the negotiation. */

/* End of addition by Srikar. */

#define	SCRIPT_ACTIVATED_DOD		3	/* must not be = to TRUE or FALSE */
