#include	"defs.h"


void dummy_fn();

#ifdef __MLPPP__

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "ppp.h"
/* Sachin, 07th November */
#include <wanmgr.h>
/* Sachin, 07th November */

#define	MAX_FRAGMENTS	5
#define	MIN_FRAGMENT_SIZE	512

#if MP_MD
#define LOG_TABLE_SIZE 1024
void *mppp_alloced_address[LOG_TABLE_SIZE] ;
#endif


static enum TEST fragment_and_send_packet(USHORT real_port_number, USHORT protocol_virtual_port_number,
	PPP_PACKET_WITH_MAC_HEADER *sptr_tx_packet,USHORT number_of_bytes,enum BOOLEAN do_not_calculate_crc,
	enum BOOLEAN device_driver_buffer,void (*fptr_tx_completion) (USHORT port_number,void *vptr_buffer),
	void *vptr_original_buffer);
int calculate_number_of_fragments_and_sizes(MLPPP_PORT_CLASS *sptr_mlppp, USHORT number_of_bytes, FRAGMENTATION_INFO	*fragment_info);
static void *mlppp_get_a_send_fragment (USHORT port_number,ULONG size_of_fragment_data);
void mlppp_free_a_send_fragment (USHORT real_port_number,void *vptr_tx_packet);
static enum TEST send_fragment(USHORT real_port_number, USHORT protocol_virtual_port_number,
	PPP_PACKET_WITH_MAC_HEADER *sptr_tx_packet,USHORT number_of_bytes,enum BOOLEAN do_not_calculate_crc,
	enum BOOLEAN device_driver_buffer,void (*fptr_tx_completion) (USHORT port_number,void *vptr_buffer),
	void *vptr_async_buffer);


/*#define	_MY_DEBUG_*/

#ifdef	_MY_DEBUG_
extern	BYTE	UpdateMessage[];
#endif


extern ULONG get_port_queue_depth(int port_number);


/*************************************************************************/

enum TEST send_mlppp_packet (ULONG protocol_stack_id,USHORT real_port_number,USHORT protocol_virtual_port_number,
	PPP_PACKET_WITH_MAC_HEADER *sptr_tx_packet,USHORT number_of_bytes,enum BOOLEAN do_not_calculate_crc,
	enum BOOLEAN device_driver_buffer,void (*fptr_tx_completion) (USHORT port_number,void *vptr_buffer))
{
	enum TEST header_ok;
	USHORT number_of_ppp_bytes;
	USHORT number_of_ppp_bytes_without_headers;
	void *vptr_async_buffer;

	real_port_number = (USHORT) (real_port_number - ppp.number_of_lan_ports);

/* 17/05/99 Jo Slip not handled in LCPR */
#ifdef _BIG_PROXY_
/* Sachin, 07th November */
	if (ppp.port[real_port_number].slip_on == TRUE)
	{
		void *vptr_slip_buffer;
		
		if (get_wan_port_owner(real_port_number) != OWNED_BY_SLIP)
			return (FAIL);

		number_of_bytes = send_slip_packet (real_port_number, (void**)&sptr_tx_packet,number_of_bytes,
				protocol_virtual_port_number,device_driver_buffer,fptr_tx_completion,&vptr_slip_buffer);
		
		if (number_of_bytes == 0x0000)
		{
			return (FAIL);
		}
		
		protocol_virtual_port_number = real_port_number;
		fptr_tx_completion = slip_packet_transmitted;
		device_driver_buffer = FALSE;
#if 1	/* KVSP */
      vptr_slip_buffer = sptr_tx_packet ;
#endif

		if ((*ppp.port[real_port_number].serial_driver.fptr_tx_routine) (real_port_number,protocol_virtual_port_number,
			sptr_tx_packet,number_of_bytes,do_not_calculate_crc,device_driver_buffer,fptr_tx_completion,
			vptr_slip_buffer) == PASS)
		{
#if 0	/* KVSP */
			printf("Slip packet sent\n");
#endif
			return (PASS);
		}
		else
		{
/*			printf("SLIP: Packet transmit on port %04X failed\n", real_port_number);*/
			return (FAIL);
		}
	}
/* Sachin, 07th November */
#endif
/* 17/05/99 Jo Slip not handled in LCPR */

/* Added By Naveen... */
#if 1
   if (ppp.port[real_port_number].enabled == FALSE)
   {
		return_buffer (real_port_number,protocol_virtual_port_number,device_driver_buffer,sptr_tx_packet,fptr_tx_completion);
		return (FAIL);
   }

	if (mlppp.dod_enabled_bundle[real_port_number].link_down_by_demand)
	{
/* sudhir 3/3/98 */
		if ((ppp.port[real_port_number].connect_state == LINK_DOWN_BY_DEMAND)
			&& (ppp.port[real_port_number].callback_on == FALSE))
/* sudhir 3/3/98 */
		{
   		printf("PPP:Reactivating port %04x\r\n", real_port_number);
			ppp_link_active(real_port_number);
		}
		return_buffer (real_port_number,protocol_virtual_port_number,device_driver_buffer,sptr_tx_packet,fptr_tx_completion);
		return (FAIL);
	}
#endif
/* ...Added By Naveen */


#ifdef _BIG_PROXY_
	if (protocol_stack_id == mlppp.port[real_port_number].ncp[PPP_BRIDGING_NCP_STACK_INDEX].protocol_stack_id)
	{
		sptr_tx_packet = add_bcp_lan_id (real_port_number,protocol_virtual_port_number,sptr_tx_packet,&number_of_bytes,
			do_not_calculate_crc,fptr_tx_completion);

		if (sptr_tx_packet == NULL)
		{
			return (FAIL);
		}

		if (fptr_tx_completion != NULL)
			fptr_tx_completion = ppp_free_a_bridge_send_packet;
	}
#endif
	number_of_ppp_bytes = (USHORT) (number_of_bytes - sizeof (UNION_MAC_HEADER) + sizeof (PPP_HEADER));

	number_of_ppp_bytes_without_headers = (USHORT) (number_of_bytes - sizeof (UNION_MAC_HEADER));

/* The Following line is modified by Naveen , At the end one extra parameter was there 
   and it is removed */

	header_ok = build_ppp_header (real_port_number,protocol_stack_id,sptr_tx_packet);

/*needs to be changed use mrru
	if ((header_ok == FAIL) || (number_of_ppp_bytes_without_headers > ppp.port[real_port_number].lcp_mibs.pppLinkStatusRemoteMRU))*/

	if ((header_ok == FAIL) || (number_of_ppp_bytes_without_headers > mlppp.port[real_port_number].RemoteMRRU))
	{
		return_buffer (real_port_number,protocol_virtual_port_number,device_driver_buffer,sptr_tx_packet,fptr_tx_completion);
		return (FAIL);
	}

/*needs to be changed use mrru*/
	number_of_bytes = compress_protocol_packet (real_port_number,&sptr_tx_packet,number_of_bytes,
		&protocol_virtual_port_number,&device_driver_buffer,&fptr_tx_completion);

	number_of_bytes = (USHORT) (number_of_bytes - sizeof (UNION_MAC_HEADER) + sizeof (PPP_HEADER));

#if defined (CCP)
	if ((ppp.ccp.enabled == TRUE) && ((*ppp.ccp.fptr_get_ccp_port_status_function) (real_port_number) == TRUE))
	{
		sptr_tx_packet = ccp_compress_ppp (real_port_number, protocol_virtual_port_number, &device_driver_buffer, sptr_tx_packet, 
			&number_of_bytes,	&fptr_tx_completion);

		if (sptr_tx_packet == NULL)
			return (FAIL);
	}
#endif

	vptr_async_buffer = sptr_tx_packet;

#ifdef	_MY_DEBUG_
/*	sprintf(UpdateMessage, "tx: packet protocol %04x", 
							sptr_tx_packet->header.protocol_type);*/
#endif


	if (mlppp.port[real_port_number].multilink_enabled)
	{
		return(fragment_and_send_packet(real_port_number, protocol_virtual_port_number,
				sptr_tx_packet, number_of_bytes, do_not_calculate_crc,
				device_driver_buffer,fptr_tx_completion,vptr_async_buffer));
	}
	else
	{
		return(send_fragment(mlppp.port[real_port_number].LinkInfo[0].port->port_number,
		protocol_virtual_port_number, sptr_tx_packet, number_of_bytes,
		do_not_calculate_crc, device_driver_buffer,fptr_tx_completion,vptr_async_buffer));
	}
}

/*************************************************************************/
static enum TEST fragment_and_send_packet(USHORT real_port_number, USHORT protocol_virtual_port_number,
	PPP_PACKET_WITH_MAC_HEADER *sptr_tx_packet,USHORT number_of_bytes,enum BOOLEAN do_not_calculate_crc,
	enum BOOLEAN device_driver_buffer,void (*fptr_tx_completion) (USHORT port_number,void *vptr_buffer),
	void *vptr_original_buffer)
{
	FRAGMENTATION_INFO	fragmentation_information[MAX_FRAGMENTS];
	MLPPP_PORT_CLASS	*sptr_mlppp;
	MULTILINK_FRAGMENT	*sptr_multilink_fragment;
	LINKS_CLASS	*sptr_link;
	BYTE	*sptr_data;
	void *vptr_async_buffer;
	int	number_of_fragments, i;
	USHORT	current_fragment_size;
	enum TEST return_value = PASS;

	sptr_mlppp = &mlppp.port[real_port_number];

	sptr_tx_packet = compress_ppp_header (sptr_tx_packet, &number_of_bytes, TRUE, TRUE);

	sptr_data = (BYTE *)&sptr_tx_packet->header;

	number_of_fragments = calculate_number_of_fragments_and_sizes(sptr_mlppp,
								number_of_bytes, fragmentation_information);

	if (number_of_fragments == 0)
	{
		printf ("MLPPP: No Fragments to send\n");
		return_value = FAIL;
	}

 	for (i = 0; i < number_of_fragments; i++)
	{
		sptr_link = &sptr_mlppp->LinkInfo[fragmentation_information[i].link_number];

		current_fragment_size = fragmentation_information[i].fragment_size;

		sptr_multilink_fragment = (MULTILINK_FRAGMENT *)
					mlppp_get_a_send_fragment(sptr_link->port_number, current_fragment_size);

		if (sptr_multilink_fragment != NULL)
		{
			vptr_async_buffer = sptr_multilink_fragment;

			if (i == 0)
				sptr_multilink_fragment->mlppp_header.begin = TRUE;
			if (i == number_of_fragments-1)
				sptr_multilink_fragment->mlppp_header.end = TRUE;

			sptr_multilink_fragment->mlppp_header.sequence_number =
					sptr_mlppp->NextSendSequenceNumber;

#ifdef	_MY_DEBUG_
			printf( "Tx Pkt Seq No %8lx", sptr_mlppp->NextSendSequenceNumber);
#endif

			sptr_mlppp->NextSendSequenceNumber++;
			sptr_mlppp->NextSendSequenceNumber &= MAX_SEQUENCE_NUMBER;

			(*(ULONG *)(&sptr_multilink_fragment->mlppp_header)) = 
				host_to_net_long((*(ULONG *)(&sptr_multilink_fragment->mlppp_header)));

			memcpy(&sptr_multilink_fragment->data[0], sptr_data, current_fragment_size);
			sptr_data += current_fragment_size;

			sptr_multilink_fragment = (MULTILINK_FRAGMENT *)
				((ULONG)sptr_multilink_fragment - sizeof(UNION_MAC_HEADER) + sizeof(PPP_HEADER));

/*may  need to ccp here or in send_packet*/
			return_value = send_fragment(sptr_link->port_number, sptr_link->port_number,
				(PPP_PACKET_WITH_MAC_HEADER *)sptr_multilink_fragment,
				current_fragment_size + sizeof(PPP_HEADER) + sizeof(MLPPP_HEADER),
				do_not_calculate_crc, FALSE, mlppp_free_a_send_fragment, vptr_async_buffer);
		}
		else
			return_value = FAIL;
		if (return_value == FAIL)
			break;
	}

	return_buffer (real_port_number,protocol_virtual_port_number,
			device_driver_buffer,vptr_original_buffer,fptr_tx_completion);

	return(return_value);
}

/*************************************************************************/


/* #define __FEEL_FREE_TO_FRAGMENT_PACKETS__  */

#ifndef __FEEL_FREE_TO_FRAGMENT_PACKETS__


int calculate_number_of_fragments_and_sizes(MLPPP_PORT_CLASS *sptr_mlppp, USHORT number_of_bytes, FRAGMENTATION_INFO	*sptr_fragmentation_information)
{
	int number_of_fragments, i;
	USHORT	block_size;
	FRAGMENTATION_INFO	*sptr_frag;


	if (number_of_bytes > sptr_mlppp->LinkInfo[sptr_mlppp->LastTxLink].mlppp_payload)
	{
		number_of_fragments = number_of_bytes / MIN_FRAGMENT_SIZE + 1;

		if (number_of_fragments > sptr_mlppp->NoOfLinks)
			number_of_fragments = sptr_mlppp->NoOfLinks;

		if (number_of_fragments >= MAX_FRAGMENTS)
		{
			printf ("MLPPP: Number of fragments %d exceeded max\n", number_of_fragments);
			number_of_fragments = MAX_FRAGMENTS;
		}

		block_size = number_of_bytes / number_of_fragments;
	}
	else
	{
		block_size = number_of_bytes;
		number_of_fragments = 1;
	}

	sptr_frag = sptr_fragmentation_information;
	while (1)
	{
		sptr_frag->fragment_size = block_size;
		sptr_frag->link_number = sptr_mlppp->LastTxLink++;

/* vidy repositioned this check to avoid packet loosing */		

		if (sptr_mlppp->LastTxLink >= sptr_mlppp->NoOfLinks)
			sptr_mlppp->LastTxLink = 0;

		number_of_bytes -= block_size;
		if (number_of_bytes < block_size)
			break;
		sptr_frag++;
	}
	sptr_frag->fragment_size += number_of_bytes;

	sptr_frag = sptr_fragmentation_information;

	for (i = 0; i < number_of_fragments; i++)
	{
		if (sptr_frag->fragment_size > sptr_mlppp->LinkInfo[sptr_frag->link_number].mlppp_payload)
		{
			if (number_of_fragments == MAX_FRAGMENTS)
			{
/*				printf ("MLPPP: This packet is gone\n");*/
				return(0);
			}

			sptr_fragmentation_information[number_of_fragments].fragment_size = 
				sptr_frag->fragment_size - sptr_mlppp->LinkInfo[sptr_frag->link_number].mlppp_payload;
			sptr_fragmentation_information[number_of_fragments].link_number = sptr_frag->link_number;
			sptr_frag->fragment_size = sptr_mlppp->LinkInfo[sptr_frag->link_number].mlppp_payload;
			number_of_fragments++;
		}
		sptr_frag++;
	}

	if (number_of_fragments == MAX_FRAGMENTS)	
/*		printf ("MLPPP: This packet is gone\n");*/

	if (number_of_fragments >= 2)	
		printf ("MLPPP: Packet is fragmented to %d\n", number_of_fragments);
	
	return(number_of_fragments);
}

#else


int calculate_number_of_fragments_and_sizes(MLPPP_PORT_CLASS *sptr_mlppp, USHORT number_of_bytes, FRAGMENTATION_INFO	*sptr_fragmentation_information)
{
	int number_of_fragments, i;
	USHORT	block_size;
	FRAGMENTATION_INFO	*sptr_frag;

	number_of_fragments = number_of_bytes / MIN_FRAGMENT_SIZE + 1;

	if (number_of_fragments > sptr_mlppp->NoOfLinks)
		number_of_fragments = sptr_mlppp->NoOfLinks;

	if (number_of_fragments >= MAX_FRAGMENTS)
	{
		printf ("MLPPP: Number of fragments %d exceeded max\n", number_of_fragments);
		number_of_fragments = MAX_FRAGMENTS;
	}

	block_size = number_of_bytes / number_of_fragments;

	sptr_frag = sptr_fragmentation_information;

	while (1)
	{
		if (sptr_mlppp->LastTxLink >= sptr_mlppp->NoOfLinks)
			sptr_mlppp->LastTxLink = 0;

		sptr_frag->fragment_size = block_size;
		sptr_frag->link_number = sptr_mlppp->LastTxLink++;

		number_of_bytes -= block_size;
		if (number_of_bytes < block_size)
			break;
		sptr_frag++;
	}
	sptr_frag->fragment_size += number_of_bytes;

	sptr_frag = sptr_fragmentation_information;

	for (i = 0; i < number_of_fragments; i++)
	{
		if (sptr_frag->fragment_size > sptr_mlppp->LinkInfo[sptr_frag->link_number].mlppp_payload)
		{
			if (number_of_fragments == MAX_FRAGMENTS)
			{
/*				printf ("MLPPP: This packet is gone\n");*/
				return(0);
			}

			sptr_fragmentation_information[number_of_fragments].fragment_size = 
				sptr_frag->fragment_size - sptr_mlppp->LinkInfo[sptr_frag->link_number].mlppp_payload;
			sptr_fragmentation_information[number_of_fragments].link_number = sptr_frag->link_number;
			sptr_frag->fragment_size = sptr_mlppp->LinkInfo[sptr_frag->link_number].mlppp_payload;
			number_of_fragments++;
		}
		sptr_frag++;
	}

	if (number_of_fragments >= 2)	
		printf ("MLPPP: Packet is fragmented\n");

	printf ("MLPPP: Number of Fragments : %d\n",number_of_fragments);
	return(number_of_fragments);
}


#endif
/*************************************************************************/
static void *mlppp_get_a_send_fragment (USHORT port_number,ULONG size_of_fragment_data)
{
	static	PPP_HEADER multilink_fragment_header = {0xff, 0x03, MULTILINK_PROTOCOL};
	MULTILINK_FRAGMENT	*sptr_multilink_fragment;
#if MP_MD
   int i ;
#endif

	PARAMETER_NOT_USED (port_number);

	sptr_multilink_fragment = table_malloc(1, size_of_fragment_data + sizeof(MLPPP_HEADER) + sizeof(PPP_HEADER));

   if (sptr_multilink_fragment == NULL)
   {
      return NULL;
   }

#if MP_MD
   for (i = 0 ; i < LOG_TABLE_SIZE ; i++)
   {
      if (mppp_alloced_address[i] == NULL)
      {
         mppp_alloced_address[i] = sptr_multilink_fragment;
         break;
      }
   }
   if (i == LOG_TABLE_SIZE)
   {
      while (1)
         ppp_printf(PPP_ALARM_PRINTF, "MLPPP: Log Table Size is not enough to record the mlppp allocations\n");
   }
#endif

	sptr_multilink_fragment->header = multilink_fragment_header;

	return (sptr_multilink_fragment);
}
/*************************************************************************/
void mlppp_free_a_send_fragment (USHORT real_port_number,void *vptr_tx_packet)
{
#if MP_MD
   int i;
#endif

	PARAMETER_NOT_USED (real_port_number);

/*	vptr_tx_packet = (void *) ((ULONG) vptr_tx_packet + sizeof (MAC_HEADER) - sizeof (PPP_HEADER));*/

#if MP_MD
   for(i=0 ; i<LOG_TABLE_SIZE ; ++i)
   {
      if (mppp_alloced_address[i] == vptr_tx_packet)
      {
         mppp_alloced_address[i] = NULL ;
         break;
      }
   }

   if (i == LOG_TABLE_SIZE)
   {
      while(1) 
         ppp_printf(PPP_ALARM_PRINTF, "MLPPP:Freeing a fragment which was never allocated : %08X\n", vptr_tx_packet);
   }
#endif
	
   buffer_free (vptr_tx_packet); 
}

/*************************************************************************/

/* Jo 13/11/98 */
#if 0
static enum TEST send_fragment(USHORT real_port_number, USHORT protocol_virtual_port_number,
	PPP_PACKET_WITH_MAC_HEADER *sptr_tx_packet,USHORT number_of_bytes,enum BOOLEAN do_not_calculate_crc,
	enum BOOLEAN device_driver_buffer,void (*fptr_tx_completion) (USHORT port_number,void *vptr_buffer),
	void *vptr_async_buffer)
{
	if (number_of_bytes == 0x0000)
	{
		return (FAIL);
	}


#ifdef __DOD__

	if (ppp.port[real_port_number].enabled == FALSE )
	{
ret_buf:
		return_buffer (real_port_number,protocol_virtual_port_number,device_driver_buffer,sptr_tx_packet,fptr_tx_completion);

		return (FAIL);
	}
	else if (ppp.port[real_port_number].state != PPP_OPENED_STATE)
	{
		if (ppp.port[real_port_number].connect_state == LINK_DOWN_BY_DEMAND)
		{
#ifdef DOD_DEBUG
		printf("PPP:Reactivating port %04x\r\n", real_port_number);
#endif
			ppp_link_active(real_port_number);
		}
			
		goto ret_buf;
	}
			
#else /* __DOD__ */
	if (ppp.port[real_port_number].enabled == FALSE || ppp.port[real_port_number].state != PPP_OPENED_STATE)
		{
		return_buffer (real_port_number,protocol_virtual_port_number,device_driver_buffer,sptr_tx_packet,fptr_tx_completion);

		return (FAIL);
		}
#endif /* __DOD__ */

	if ((*ppp.port[real_port_number].serial_driver.fptr_tx_routine) (real_port_number,protocol_virtual_port_number,
		&sptr_tx_packet->header,number_of_bytes,do_not_calculate_crc,device_driver_buffer,fptr_tx_completion,
		vptr_async_buffer) == PASS)
	{
#ifdef __DOD__
		reset_ppp_idle_timer (real_port_number);
#endif /* __DOD__ */

		return (PASS);
	}
	else
	{
		return (FAIL);
	}
}

#endif 
/* Jo 13/11/98 */

static enum TEST send_fragment(USHORT real_port_number, USHORT protocol_virtual_port_number,
	PPP_PACKET_WITH_MAC_HEADER *sptr_tx_packet,USHORT number_of_bytes,enum BOOLEAN do_not_calculate_crc,
	enum BOOLEAN device_driver_buffer,void (*fptr_tx_completion) (USHORT port_number,void *vptr_buffer),
	void *vptr_async_buffer)
{
#if 0   /* %%% By Naveen , I think we are not supporting tx address and control
          field compression (Sachin told me this) */
	if (ppp.port[real_port_number].tx_address_and_control_fields_compression_enabled || 
				ppp.port[real_port_number].tx_protocol_field_compression_enabled)
	{
		sptr_tx_packet = compress_ppp_header (sptr_tx_packet, &number_of_bytes,
			ppp.port[real_port_number].tx_address_and_control_fields_compression_enabled,
			ppp.port[real_port_number].tx_protocol_field_compression_enabled);
	}
#endif

	if (number_of_bytes == 0x0000)
		return (FAIL);


#ifdef __DOD__

	if (ppp.port[real_port_number].enabled == FALSE )
	{
ret_buf:
/* ...__NMD__... 10 Aug 1998 Sudha */
/*		return_buffer (real_port_number,protocol_virtual_port_number,device_driver_buffer,sptr_tx_packet,fptr_tx_completion); */
		return_buffer (real_port_number,protocol_virtual_port_number,device_driver_buffer,vptr_async_buffer,fptr_tx_completion);

		return (FAIL);
	}
	else if (ppp.port[real_port_number].state != PPP_OPENED_STATE)
	{
		if (ppp.port[real_port_number].connect_state == LINK_DOWN_BY_DEMAND)
		{
#ifdef DOD_DEBUG
		printf("PPP3:Reactivating port %04x\r\n", real_port_number);
#endif
			ppp_link_active(real_port_number);
		}
			
		goto ret_buf;
	}
			
#else /* __DOD__ */
	if (ppp.port[real_port_number].enabled == FALSE || ppp.port[real_port_number].state != PPP_OPENED_STATE)
	{
/* ...__NMD__... 10 Aug 1998 Sudha */
/*		return_buffer (real_port_number,protocol_virtual_port_number,device_driver_buffer,sptr_tx_packet,fptr_tx_completion); */
		return_buffer (real_port_number,protocol_virtual_port_number,device_driver_buffer,vptr_async_buffer,fptr_tx_completion);
		return (FAIL);
	}
#endif /* __DOD__ */

	if ((*ppp.port[real_port_number].serial_driver.fptr_tx_routine) (real_port_number,protocol_virtual_port_number,
		&sptr_tx_packet->header,number_of_bytes,do_not_calculate_crc,device_driver_buffer,fptr_tx_completion,
		vptr_async_buffer) == PASS)
	{
#ifdef __DOD__
		reset_ppp_idle_timer (real_port_number);
#endif /* __DOD__ */

/* __NMD__... 13/06/98 Vidy
realized that only the first link in the bundle applies the
negotiated ACCM!*/
   		if (ppp.port[real_port_number].accm_applied == FALSE)
   		{
      		apply_tx_accm (real_port_number) ;
      		ppp.port[real_port_number].accm_applied = TRUE ;      
   		}
/* ...__NMD__ */
		return (PASS);
	}
	else
		return (FAIL);
}

void mlppp_packet_transmitted (USHORT real_port_number)
{
	USHORT i;
	MLPPP_PORT_CLASS	*sptr_mlppp;
	USHORT port_number = real_port_number - ppp.number_of_lan_ports;

/* 17/05/99 Jo Slip not handled in LCPR */
#ifdef _BIG_PROXY_
/* Sachin, 07th November */
   if (ppp.port[port_number].slip_on == TRUE)
   {
      ppp_packet_transmitted (real_port_number) ;
      return ;
   }
/* Sachin, 07th November */
#endif
/* 17/05/99 Jo Slip not handled in LCPR */

	sptr_mlppp = &mlppp.port[port_number];

	for (i = 0; i < sptr_mlppp->NoOfLinks; i++)
	{
		ppp_packet_transmitted (sptr_mlppp->LinkInfo[i].port->port_number + ppp.number_of_lan_ports);
	}
}


#endif
