#include	"defs.h"
/*	$Modname: pppauth.c$  $version: 1.14$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 08/24/94 ross
1.1 08/24/94 ross cleanup for release
1.2 09/29/94 ross fixes for Chap, courtesy of Danny.  Added STP and Netbios.
1.3 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.4 12/02/94 ross testing NT3.5 RAS
1.5 12/03/94 ross testing Windows 95	RAS
1.6 01/26/95 ross changes for rwutils
1.7 01/30/95 ross removing duplicate configuration options
1.8 02/27/95 ross dynamic load changes including lsl_control.
1.9 03/01/95 ross removed AUTHENTICATE_REQUEST from send_lcp_chap_peer...
1.10 03/03/95 ross added up calls.
1.11 03/09/95 ross tested version 3 of upcalls.
1.12 03/10/95 ross chap working with nt 3.5.
1.13 05/15/95 ross subscripting error.  Courtesy of Dan.
1.14 10/19/95 biao added Compression Control Protocol (CCP) support. Please refer to change.doc for details.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <string.h>
#include <stdio.h>
#include "ppp.h"
#include <udb.h>
#include "vpppcb.h"
#include "\rtrware\rwutils\event.h"  /* Added by Subbi On 29 Sep 1999*/
#include "\rtrware\rwutils\evnt.h"  /* Added by Subbi On 29 Sep 1999*/
#include "\rtrware\rwutils\evntstr.h"  /* Added by Subbi On 29 Sep 1999*/

#ifdef EVENT_LOG
#include	<logif.h>
#endif
/*************************************************************************************************/
extern void event_broadcast_packets_on_all_ports (EVENT_HEADER *);  /* Added by Subbi On 30 Sep 1999*/
extern get_ip_address(USHORT port_number);	/* Added by Subbi on 30 Sep 1999 */

static void send_authentication_packet (USHORT real_port_number,PPP_PACKET *sptr_tx_packet,
	USHORT number_of_bytes_to_send,enum PPP_CONTROL_CODE code,BYTE id,enum PPP_PROTOCOL_TYPE protocol_type);
static void authentication_request_received (USHORT real_port_number,AUTHENTICATION_REQUEST_PACKET *sptr_pap_rx_packet);
static void authentication_ack_received (USHORT real_port_number);
static void authentication_nak_received (USHORT real_port_number);
static void send_chap_authentication_ack (USHORT real_port_number, BYTE id_from_request_packet);
static void send_chap_authentication_nak (USHORT real_port_number, BYTE id_from_request_packet);

void send_chap_ack_and_process (USHORT real_port_number) ;
void send_chap_nak_and_process (USHORT real_port_number) ;
enum BOOLEAN check_for_callback (USHORT real_port_number) ;

/*************************************************************************************************/
void send_lcp_chap_server_packet (USHORT real_port_number)
{
	USHORT number_of_bytes_to_send;
	CHAP_PACKET *sptr_chap_packet;
	ULONG random_number1;
	ULONG random_number2;
	char random_number_string[9];

/*	ppp_printf (PPP_LCP_PRINTF,"PPP:Send Chap server packet on port: %04x\r\n",real_port_number);*/

	number_of_bytes_to_send = sizeof (PPP_HEADER) + sizeof (LCP_HEADER) + sizeof (sptr_chap_packet->value_size) +
		CHALLENGE_VALUE_SIZE;
	
	sptr_chap_packet = (CHAP_PACKET *) ppp_get_a_send_packet (real_port_number,number_of_bytes_to_send);

	if (sptr_chap_packet == NULL)
		return;

	sptr_chap_packet->value_size = CHALLENGE_VALUE_SIZE;

	random_number1 = lsl_control (GET_RANDOM_NUMBER);
	random_number2 = lsl_control (GET_RANDOM_NUMBER);

	sprintf (&random_number_string[0],"%04lx",random_number1);
	sprintf (&random_number_string[4],"%04lx",random_number2);

	memcpy (&sptr_chap_packet->value,&random_number_string[0],CHALLENGE_VALUE_SIZE);
	memcpy (&ppp.port[real_port_number].authentication.challenge[0],&random_number_string[0],CHALLENGE_VALUE_SIZE);

	/* ppp.port[real_port_number].authentication.challenge[CHALLENGE_VALUE_SIZE - 1] = 0x00; may be deleted */ 

	ppp.port[real_port_number].id_sequence_number = (BYTE) (ppp.port[real_port_number].id_sequence_number + 1);

	ppp.port[real_port_number].last_id_of_chap_challenge_packet_sent = ppp.port[real_port_number].id_sequence_number;

	/* printf ("Txed CHAP challenge packet on port %d\n", real_port_number) ; */

	send_authentication_packet (real_port_number,(PPP_PACKET *) sptr_chap_packet,number_of_bytes_to_send,CHAP_CHALLENGE,
		ppp.port[real_port_number].id_sequence_number,CHAP_PROTOCOL);
}
/*************************************************************************************************/
void send_lcp_chap_peer_packet (USHORT real_port_number,char *cptr_response,BYTE id)
{
	USHORT number_of_bytes_to_send;
	CHAP_PACKET *sptr_chap_packet;

	ppp_printf (PPP_LCP_PRINTF,"PPP:Send Chap peer packet on port: %04x\r\n",real_port_number);

	ppp.port[real_port_number].authentication.rxed_authentication_ack = FALSE;

	number_of_bytes_to_send = (USHORT) (sizeof (PPP_HEADER) + sizeof (LCP_HEADER) + sizeof (sptr_chap_packet->value_size) +
		RESPONSE_VALUE_SIZE + strlen (ppp.port[real_port_number].authentication.user_name));
	
	sptr_chap_packet = (CHAP_PACKET *) ppp_get_a_send_packet (real_port_number,number_of_bytes_to_send);

	if (sptr_chap_packet == NULL)
		return;

	sptr_chap_packet->value_size = RESPONSE_VALUE_SIZE;

	memcpy (&sptr_chap_packet->value,cptr_response,RESPONSE_VALUE_SIZE);

	memcpy (&sptr_chap_packet->name[0],&ppp.port[real_port_number].authentication.user_name[0],
		strlen (ppp.port[real_port_number].authentication.user_name));

	ppp.port[real_port_number].last_id_of_chap_response_packet_sent = id;

	/* printf ("Txed CHAP response packet on port %d\n", real_port_number) ; */

	send_authentication_packet (real_port_number,(PPP_PACKET *) sptr_chap_packet,number_of_bytes_to_send,CHAP_RESPONSE,
		id,CHAP_PROTOCOL);
}
/******************************************************************************/
void chap_packet_received (USHORT real_port_number,CHAP_PACKET *sptr_chap_rx_packet,USHORT number_of_bytes_rxed)
{
	char name[NAME_SIZE];
	USHORT name_length;
	USHORT chap_packet_length;
	char secret[NAME_SIZE*2];
	char response[RESPONSE_VALUE_SIZE];
	EVENT_HEADER evnt_header;	/* Jo 11/10/99 Added for Monitoring Program */

	PARAMETER_NOT_USED (number_of_bytes_rxed);

	/* printf ("CHAP packet Rxed on port %d\n", real_port_number) ; */

	if ((sptr_chap_rx_packet->lcp_header.code == CHAP_RESPONSE) &&	(sptr_chap_rx_packet->value_size == RESPONSE_VALUE_SIZE))
	{
		/* printf ("Rxed CHAP response on port %d\n", real_port_number) ; */
		ppp.port[real_port_number].authentication.txed_authentication_ack = FALSE; 

		chap_packet_length = swap (sptr_chap_rx_packet->lcp_header.length);

		name_length = (USHORT) (chap_packet_length - sizeof (LCP_HEADER) - sizeof (sptr_chap_rx_packet->value_size) -
						  sptr_chap_rx_packet->value_size);

		memcpy (&name[0],&sptr_chap_rx_packet->name[0],name_length);

		name[name_length]= '\0';

		ppp.port[real_port_number].authentication.chap_secret[0] = '\0';  

		memcpy (&ppp.port[real_port_number].authentication.response[0],&sptr_chap_rx_packet->value.response[0],
			sptr_chap_rx_packet->value_size);

		ppp.port[real_port_number].authentication.id = sptr_chap_rx_packet->lcp_header.id;

		if (ppp.fptr_event_upcall != NULL)
		{
			(*ppp.fptr_event_upcall) (PPP_EVENT_AUTHENTICATE_LOOKUP,real_port_number,
			   &name[0]) ;
		}
	}
	else if ((sptr_chap_rx_packet->lcp_header.code == CHAP_CHALLENGE) &&
#if 0 /* Sachin 06/10/1997, to handle larger chap challenges */
		(sptr_chap_rx_packet->value_size == CHALLENGE_VALUE_SIZE))
#else
		(sptr_chap_rx_packet->value_size <= MAX_CHALLENGE_VALUE_SIZE))
#endif
	{
		/* printf ("Rxed CHAP challenge on port %d\n", real_port_number) ; */
		secret[0]= '\0';

		if (ppp.fptr_event_upcall != NULL)
		{
			(*ppp.fptr_event_upcall) (PPP_EVENT_AUTHENTICATE_REQUEST,real_port_number,
				&ppp.port[real_port_number].authentication.user_name[0],&ppp.port[real_port_number].authentication.password[0]);
		}

#ifdef __ADD_USER_NAME_TO_SECRET__
		strcpy (secret,ppp.port[real_port_number].authentication.user_name);
#endif
		strcpy (secret,ppp.port[real_port_number].authentication.password);

		MDString (sptr_chap_rx_packet->lcp_header.id,(BYTE *) &secret[0],(BYTE) strlen (&secret[0]),
			&sptr_chap_rx_packet->value.challenge[0],sptr_chap_rx_packet->value_size,(BYTE *) &response[0]);

		send_lcp_chap_peer_packet (real_port_number,&response[0],sptr_chap_rx_packet->lcp_header.id);
	}
	else if (sptr_chap_rx_packet->lcp_header.code == CHAP_AUTHENTICATION_ACK)
	{
			/* printf ("Rxed CHAP ack on port %d\n", real_port_number) ; */
#ifdef EVENT_LOG
{
#if 0
	char log_msg[LOG_NORMAL_MSG_LEN];
	sprintf(log_msg, "CHAP authentication OK on WAN %d", real_port_number + 1);
	write_log(log_msg);
#else
	write_log(LOG_EVENT_CHAP_AUTH_OK, (BYTE) (real_port_number + 1)); /* Imran 9/07/98 */
/* Jo 11/10/99 Added for Monitoring Program */
   	evnt_header.event_type = GENERAL_EVENTS;
		evnt_header.message_type = MONITOR_EVENT_CHAP_AUTH_OK;
 		evnt_header.server_ip_address	= get_ip_address(0);
		evnt_header.client_ip_address = 0;
      evnt_header.dest_ip_address= 0;
		evnt_header.port = real_port_number + 1;
	   strcpy(evnt_header.client_mac_address,"");
		event_broadcast_packets_on_all_ports (&evnt_header);
/* Jo 11/10/99 Added for Monitoring Program */
#endif
}
#endif
			if (ppp.fptr_event_upcall != NULL)
			{
				(*ppp.fptr_event_upcall) (PPP_EVENT_AUTHENTICATE_ACK_RECEIVED,real_port_number);
			}

			ppp.port[real_port_number].authentication.rxed_authentication_ack = TRUE;

			if (is_option_present (&ppp.port[real_port_number].option_lists.tx_accepted, (BYTE) LCP_AUTHENTICATION_PROTOCOL) != TRUE) 
			{
				ppp.port[real_port_number].authentication.status = SUCCESSFUL;

				bring_ncps_up (real_port_number,NULL,0x0000,PPP_INITIAL_STATE);
		
#if defined (CCP)
/* Sowmya 7/3/96
				if ((ppp.ccp.enabled == TRUE) && ((*ppp.ccp.fptr_get_ccp_port_status_function) (real_port_number) == TRUE))
				{
					(*ppp.ccp.fptr_execute_ccp_state_machine_function) (PPP_OPEN_EVENT, real_port_number, NULL, 0x0000);

					bring_ccp_up (real_port_number,NULL,0x0000,PPP_INITIAL_STATE);
				}
Sowmya 7/3/96 */
#endif
			}
			else if (ppp.port[real_port_number].authentication.txed_authentication_ack == TRUE)
			{		
				/* printf ("Authentication ack already txed on port %d\n", real_port_number) ; */
				ppp.port[real_port_number].authentication.status = SUCCESSFUL;
				
				bring_ncps_up (real_port_number,NULL,0x0000,PPP_INITIAL_STATE);
	
#if defined (CCP)
/* Sowmya 7/3/96
				if ((ppp.ccp.enabled == TRUE) && ((*ppp.ccp.fptr_get_ccp_port_status_function) (real_port_number) == TRUE))
				{
					(*ppp.ccp.fptr_execute_ccp_state_machine_function) (PPP_OPEN_EVENT, real_port_number, NULL, 0x0000);

					bring_ccp_up (real_port_number,NULL,0x0000,PPP_INITIAL_STATE);
				}
Sowmya 7/3/96 */
#endif
			}
			else
			{
				/* printf ("Authentication ack not yet txed on port %d\n", real_port_number) ; */
			}
	}
	else if (sptr_chap_rx_packet->lcp_header.code == CHAP_AUTHENTICATION_NAK)
	{
#ifdef EVENT_LOG
#if 0
	char log_msg[LOG_NORMAL_MSG_LEN];
	sprintf(log_msg, "CHAP authentication Fails on WAN %d", real_port_number + 1);
	write_log(log_msg);
#else
	write_log(LOG_EVENT_CHAP_AUTH_FAIL, (BYTE) (real_port_number + 1)); /* Imran 9/07/98 */

/* Jo 11/10/99 Added for Monitoring Program */
   evnt_header.event_type = GENERAL_EVENTS;
	evnt_header.message_type = MONITOR_EVENT_CHAP_AUTH_FAIL;
 	evnt_header.server_ip_address	= get_ip_address(0);
	evnt_header.client_ip_address = 0;
   evnt_header.dest_ip_address= 0;
	evnt_header.port = real_port_number + 1;
	strcpy(evnt_header.client_mac_address,"");
	event_broadcast_packets_on_all_ports (&evnt_header);
/* Jo 11/10/99 Added for Monitoring Program */
#endif
#endif
		/* printf ("Rxed CHAP nak on port %d\n", real_port_number) ; */
	}
}
/*************************************************************************************************/
void ppp_upper_layer_authentication_verification (USHORT real_port_number,ULONG vptr_chap_password_or_pap_pass_or_fail)
{
	USHORT_ENUM (PPP_PROTOCOL_TYPE) authentication_protocol;
	EVENT_HEADER evnt_header;	/* Added by Subbi on 30 Sep 1999 */

	BYTE authentication_option[3];
	char response[RESPONSE_VALUE_SIZE];

	if (copy_option (&ppp.port[real_port_number].option_lists.tx_accepted,LCP_AUTHENTICATION_PROTOCOL,
		&authentication_option[0],sizeof (authentication_option)) == FAIL)
			return;

	authentication_protocol = *((USHORT_ENUM (PPP_PROTOCOL_TYPE) *) &authentication_option[0]);

	if	(authentication_protocol == CHAP_PROTOCOL)
	{
#ifdef __ADD_USER_NAME_TO_SECRET__
		strcpy (&ppp.port[real_port_number].authentication.chap_secret[0],&ppp.port[real_port_number].authentication.user_name[0]);
#endif

		if (vptr_chap_password_or_pap_pass_or_fail == FAIL)
		{
			send_chap_nak_and_process (real_port_number) ;
			return ;
		}

		if (vptr_chap_password_or_pap_pass_or_fail == PASS)
		{
			/* printf ("Txed CHAP ack on port %d\n", real_port_number) ; */
			send_chap_ack_and_process (real_port_number) ;
			return ;
		}

		strcpy (&ppp.port[real_port_number].authentication.chap_secret[0],(char *) vptr_chap_password_or_pap_pass_or_fail);

		MDString (ppp.port[real_port_number].authentication.id,
			(BYTE *) &ppp.port[real_port_number].authentication.chap_secret[0],
			(BYTE) strlen ((char *) vptr_chap_password_or_pap_pass_or_fail),
			&ppp.port[real_port_number].authentication.challenge[0],CHALLENGE_VALUE_SIZE,(BYTE *) &response[0]);

		if ((vptr_chap_password_or_pap_pass_or_fail != FAIL) &&
			 (memcmp (&response[0],&ppp.port[real_port_number].authentication.response[0],RESPONSE_VALUE_SIZE) == (int) NULL))
		{
			/*	printf ("Txed CHAP ack on port %d\n", real_port_number) ; */
			send_chap_ack_and_process (real_port_number);
			return ;
		}
		else
		{
			/* printf ("Txed CHAP nak on port %d\n", real_port_number) ; */
			send_chap_nak_and_process (real_port_number);
			return;
		}
	}
	else	/* PAP */
	{
		if ((enum TEST) vptr_chap_password_or_pap_pass_or_fail == PASS)
		{
			/* printf ("Txed PAP ack on port %d\n", real_port_number) ; */
			send_lcp_authentication_ack (real_port_number,ppp.port[real_port_number].authentication.id);
			ppp.port[real_port_number].authentication.txed_authentication_ack = TRUE;
#ifdef EVENT_LOG
{
#if 0
	char log_msg[LOG_NORMAL_MSG_LEN];
	sprintf(log_msg, "Remote PAP authentication OK on WAN %d", real_port_number + 1);
	write_log(log_msg);
#else
	write_log(LOG_EVENT_REMOTE_PAP_AUTH_OK, (BYTE) (real_port_number + 1)); /* Imran 9/07/98 */

/* Jo 11/10/99 Added for Monitoring Program */
   evnt_header.event_type = GENERAL_EVENTS;
	evnt_header.message_type = MONITOR_EVENT_REMOTE_PAP_AUTH_OK;
 	evnt_header.server_ip_address	= get_ip_address(0);
	evnt_header.client_ip_address = 0;
   evnt_header.dest_ip_address= 0;
	evnt_header.port = real_port_number + 1;
	strcpy(evnt_header.client_mac_address,"");
	event_broadcast_packets_on_all_ports (&evnt_header);
/* Jo 11/10/99 Added for Monitoring Program */

#endif
}
#endif

			if (is_option_present (&ppp.port[real_port_number].option_lists.rx_accepted, (BYTE) LCP_AUTHENTICATION_PROTOCOL) != TRUE)
			{

/* Jo 04/06/99 Added for RAS */
				if (check_for_callback (real_port_number) == FALSE)
				{
					bring_ncps_up (real_port_number,NULL,0x0000,PPP_INITIAL_STATE);
			
#if defined (CCP)
/* Sowmya 7/3/96
					if ((ppp.ccp.enabled == TRUE) && ((*ppp.ccp.fptr_get_ccp_port_status_function) (real_port_number) == TRUE))
					{
						(*ppp.ccp.fptr_execute_ccp_state_machine_function) (PPP_OPEN_EVENT, real_port_number, NULL, 0x0000);

						bring_ccp_up (real_port_number,NULL,0x0000,PPP_INITIAL_STATE);
					}
Sowmya 7/3/96*/
#endif
					ppp.port[real_port_number].authentication.status = SUCCESSFUL;
				}
/* Jo 04/06/99 Added for RAS */
			}
			else if (ppp.port[real_port_number].authentication.rxed_authentication_ack == TRUE) 
			{
/* Jo 04/06/99 Added for RAS */
				if (check_for_callback (real_port_number) == FALSE)
				{
					bring_ncps_up (real_port_number,NULL,0x0000,PPP_INITIAL_STATE);
			
#if defined (CCP)
/* Sowmya 7/3/96
					if ((ppp.ccp.enabled == TRUE) && ((*ppp.ccp.fptr_get_ccp_port_status_function) (real_port_number) == TRUE))
					{
						(*ppp.ccp.fptr_execute_ccp_state_machine_function) (PPP_OPEN_EVENT, real_port_number, NULL, 0x0000);

						bring_ccp_up (real_port_number,NULL,0x0000,PPP_INITIAL_STATE);
					}
Sowmya 7/3/96 */
#endif
					ppp.port[real_port_number].authentication.status = SUCCESSFUL;
				}
/* Jo 04/06/99 Added for RAS */
			}
		}
		else
		{
#ifdef EVENT_LOG
{
#if 0
	char log_msg[LOG_NORMAL_MSG_LEN];
	sprintf(log_msg, "Remote PAP authentication failed on WAN %d", real_port_number + 1);
	write_log(log_msg);
#else
	write_log(LOG_EVENT_REMOTE_PAP_AUTH_FAIL, (BYTE) (real_port_number + 1)); /* Imran 9/07/98 */
  /* Added by Subbi on 29 Sep 1999	*/
   	evnt_header.event_type = GENERAL_EVENTS;
		evnt_header.message_type = MONITOR_EVENT_REMOTE_PAP_AUTH_FAIL;
 		evnt_header.server_ip_address	= get_ip_address(0);
		evnt_header.client_ip_address = 0;
      evnt_header.dest_ip_address= 0;
		evnt_header.port = real_port_number + 1;
	   strcpy(evnt_header.client_mac_address,"");
		event_broadcast_packets_on_all_ports (&evnt_header);
/* .... Subbi Add Ends...*/
#endif
}
#endif

			send_lcp_authentication_nak (real_port_number,ppp.port[real_port_number].authentication.id);

			if (++ppp.port[real_port_number].authentication.current_number_of_retries >
				ppp.port[real_port_number].authentication.maximum_number_of_retries)
			{
				execute_ppp_state_machine (PPP_CLOSE_EVENT,real_port_number,NULL,(USHORT) NULL);
				ppp.port[real_port_number].authentication.current_number_of_retries = 0;
				ppp.port[real_port_number].authentication.status = UNSUCCESSFUL;
				ppp.port[real_port_number].authentication.txed_authentication_ack = FALSE;
			}
			return ;
		}
	}
}
/*************************************************************************************************/
void send_lcp_authentication_request (USHORT real_port_number)
{
	AUTHENTICATION_REQUEST_PACKET *sptr_authentication_request_packet;
	USHORT number_of_bytes;
	BYTE *bptr_password_section;
	BYTE length_of_password;

/*	ppp_printf (PPP_LCP_PRINTF,"PPP:Authentication Request Tx on port: %04x\r\n",real_port_number);*/

	ppp.port[real_port_number].authentication.rxed_authentication_ack = FALSE;

	if (ppp.fptr_event_upcall != NULL)
		{
		(*ppp.fptr_event_upcall) (PPP_EVENT_AUTHENTICATE_REQUEST,real_port_number,
			&ppp.port[real_port_number].authentication.user_name,&ppp.port[real_port_number].authentication.password);
		}

	sptr_authentication_request_packet =
		(AUTHENTICATION_REQUEST_PACKET *) ppp_get_a_send_packet (real_port_number,sizeof (AUTHENTICATION_REQUEST_PACKET));

	if (sptr_authentication_request_packet == NULL)
		return;
	
	sptr_authentication_request_packet->code = AUTHENTICATION_REQUEST;

	ppp.port[real_port_number].id_sequence_number = (BYTE) (ppp.port[real_port_number].id_sequence_number + 1);

	sptr_authentication_request_packet->id = ppp.port[real_port_number].id_sequence_number;
	sptr_authentication_request_packet->header.protocol_type = PAP_PROTOCOL;
	sptr_authentication_request_packet->peer_id_length = (BYTE) strlen (ppp.port[real_port_number].authentication.user_name);

	strncpy (sptr_authentication_request_packet->peer_id,ppp.port[real_port_number].authentication.user_name,
		sptr_authentication_request_packet->peer_id_length);

	bptr_password_section = (BYTE *) ((ULONG) &sptr_authentication_request_packet->peer_id[0] +
		sptr_authentication_request_packet->peer_id_length); /* this field is variable length so we have to set it */

	length_of_password = (BYTE) strlen (ppp.port[real_port_number].authentication.password);

	*bptr_password_section = length_of_password;

	++bptr_password_section; /* move to password itself */

	strncpy ((char *) bptr_password_section,ppp.port[real_port_number].authentication.password,length_of_password);

	ppp.port[real_port_number].last_id_of_pap_packet_sent = sptr_authentication_request_packet->id;

	number_of_bytes = (USHORT) (sizeof (NCP_HEADER) +
		sptr_authentication_request_packet->peer_id_length +
		sizeof (sptr_authentication_request_packet->peer_id_length) + length_of_password +
		sizeof (sptr_authentication_request_packet->peer_password_length));

	sptr_authentication_request_packet->length = swap (number_of_bytes);

	send_native_ppp_packet (real_port_number,(PPP_PACKET *) sptr_authentication_request_packet,
		(USHORT) (number_of_bytes + sizeof (PPP_HEADER)),ppp_send_completion);
}
/*************************************************************************************************/
void send_lcp_authentication_ack (USHORT real_port_number,BYTE id_from_request_packet)
{
	AUTHENTICATION_ACK_PACKET *sptr_authentication_ack_packet;
	USHORT number_of_bytes;

	ppp_printf (PPP_LCP_PRINTF,"PPP:Authentication ACK Tx on port: %04x\r\n",real_port_number);

	sptr_authentication_ack_packet = (AUTHENTICATION_ACK_PACKET *) ppp_get_a_send_packet (real_port_number,
		sizeof (AUTHENTICATION_ACK_PACKET));

	if (sptr_authentication_ack_packet == NULL)
		return;
	
	sptr_authentication_ack_packet->message_length = (BYTE) strlen ("you are authenticated");

	sptr_authentication_ack_packet->code = AUTHENTICATION_ACK;
	sptr_authentication_ack_packet->id = id_from_request_packet;

	sptr_authentication_ack_packet->length =	swap ((USHORT) (sizeof (NCP_HEADER) + sizeof (sptr_authentication_ack_packet->message_length) +
		sptr_authentication_ack_packet->message_length));

	number_of_bytes = swap (sptr_authentication_ack_packet->length);

	sptr_authentication_ack_packet->header.protocol_type = PAP_PROTOCOL;

	strncpy (sptr_authentication_ack_packet->message,"you are authenticated",sptr_authentication_ack_packet->message_length);

	send_native_ppp_packet (real_port_number,(PPP_PACKET *) sptr_authentication_ack_packet,
		(USHORT) (number_of_bytes + sizeof (PPP_HEADER)),ppp_send_completion);

	if (ppp.fptr_event_upcall != NULL)
		{
		(*ppp.fptr_event_upcall) (PPP_EVENT_AUTHENTICATE_ACK_TRANSMITTED,real_port_number);
		}
}
/*************************************************************************************************/
void send_lcp_authentication_nak (USHORT real_port_number, BYTE id_from_request_packet )
{
	AUTHENTICATION_NAK_PACKET *sptr_authentication_nak_packet;
	USHORT number_of_bytes;

	ppp_printf (PPP_LCP_PRINTF,"PPP:Authentication NACK Tx on port: %04x\r\n",real_port_number);

	sptr_authentication_nak_packet = (AUTHENTICATION_NAK_PACKET *) ppp_get_a_send_packet (real_port_number,
		sizeof (AUTHENTICATION_NAK_PACKET));

	if (sptr_authentication_nak_packet == NULL)
		return;
	
	sptr_authentication_nak_packet->message_length = (BYTE) strlen ("you are not authenticated");

	sptr_authentication_nak_packet->code = AUTHENTICATION_NAK;
	sptr_authentication_nak_packet->id = id_from_request_packet;

	number_of_bytes =	swap ((USHORT)(sizeof (NCP_HEADER) + sizeof (sptr_authentication_nak_packet->message_length) +
		sptr_authentication_nak_packet->message_length));

	sptr_authentication_nak_packet->length = swap (sizeof (AUTHENTICATION_NAK_PACKET) -	sizeof (PPP_HEADER));
	
	sptr_authentication_nak_packet->header.protocol_type = PAP_PROTOCOL;

	strncpy (sptr_authentication_nak_packet->message,"you are not authenticated",
		sptr_authentication_nak_packet->message_length);

	send_native_ppp_packet (real_port_number,(PPP_PACKET *) sptr_authentication_nak_packet,
		(USHORT) (number_of_bytes + sizeof (PPP_HEADER)),ppp_send_completion);
}
/******************************************************************************/
void pap_packet_received (USHORT real_port_number,PAP_PACKET *sptr_pap_rx_packet,USHORT number_of_bytes_rxed)
{
	EVENT_HEADER evnt_header;	/* Added by Subbi on 30 Sep 1999 */
	PARAMETER_NOT_USED (number_of_bytes_rxed);

	switch (sptr_pap_rx_packet->lcp_header.code)
	{
		case AUTHENTICATION_REQUEST:
			authentication_request_received (real_port_number,(AUTHENTICATION_REQUEST_PACKET *) sptr_pap_rx_packet);
			break;
		case AUTHENTICATION_ACK:
#ifdef EVENT_LOG
{
#if 0
	char log_msg[LOG_NORMAL_MSG_LEN];
	sprintf(log_msg, "PAP authentication OK on WAN %d", real_port_number + 1);
	write_log(log_msg);
#else
	write_log(LOG_EVENT_PAP_AUTH_OK, (BYTE) (real_port_number + 1)); /* Imran 9/07/98 */
  /* Added by Subbi on 29 Sep 1999	*/
   	evnt_header.event_type = GENERAL_EVENTS;
		evnt_header.message_type = MONITOR_EVENT_PAP_AUTH_OK;
 		evnt_header.server_ip_address	= get_ip_address(0);
		evnt_header.client_ip_address = 0;
      evnt_header.dest_ip_address= 0;
		evnt_header.port = real_port_number + 1;
	   strcpy(evnt_header.client_mac_address,"");
		event_broadcast_packets_on_all_ports (&evnt_header);
/* .... Subbi Add Ends...*/
#endif
}
#endif
			authentication_ack_received (real_port_number);
			break;
		case AUTHENTICATION_NAK:
#ifdef EVENT_LOG
{
#if 0
	char log_msg[LOG_NORMAL_MSG_LEN];
	sprintf(log_msg, "PAP authentication failed on WAN %d", real_port_number + 1);
	write_log(log_msg);
#else
	write_log(LOG_EVENT_PAP_AUTH_FAIL, (BYTE) (real_port_number + 1)); /* Imran 9/07/98 */
  /* Added by Subbi on 29 Sep 1999	*/
   	evnt_header.event_type = GENERAL_EVENTS;
		evnt_header.message_type = MONITOR_EVENT_PAP_AUTH_FAIL;
 		evnt_header.server_ip_address	= get_ip_address(0);
		evnt_header.client_ip_address = 0;
      evnt_header.dest_ip_address= 0;
		evnt_header.port = real_port_number + 1;
	   strcpy(evnt_header.client_mac_address,"");
		event_broadcast_packets_on_all_ports (&evnt_header);
/* .... Subbi Add Ends...*/
#endif
}
#endif
			authentication_nak_received (real_port_number);
			break;
	}
}
/******************************************************************************/
static void authentication_request_received (USHORT real_port_number,AUTHENTICATION_REQUEST_PACKET *sptr_pap_rx_packet)
{
	char name[NAME_SIZE];
	char password[NAME_SIZE];
	USHORT name_length;
	USHORT password_length;
	char *cptr_peer_id;

	if (ppp.port[real_port_number].authentication.status == SUCCESSFUL)
		ppp.port[real_port_number].authentication.status = UNSUCCESSFUL;

	ppp.port[real_port_number].authentication.txed_authentication_ack = FALSE; 

	name_length = sptr_pap_rx_packet->peer_id_length;

	memcpy (&name[0], &sptr_pap_rx_packet->peer_id[0], name_length);

	name[name_length]= '\0';

	cptr_peer_id = &sptr_pap_rx_packet->peer_id[0] + name_length;

	password_length = (USHORT) *cptr_peer_id;

	++cptr_peer_id;

	memcpy (&password[0],cptr_peer_id,password_length );

	password[password_length]='\0';

	ppp.port[real_port_number].authentication.id = sptr_pap_rx_packet->id;

	if (ppp.fptr_event_upcall != NULL)
	{
		(*ppp.fptr_event_upcall) (PPP_EVENT_AUTHENTICATE_VERIFY,real_port_number,
			name,password);
	}
#ifdef BYME
	if (ppp.fptr_event_upcall != NULL)
	{
		(*ppp.fptr_event_upcall) (PPP_EVENT_AUTHENTICATE_VERIFY,real_port_number,
			&ppp.port[real_port_number].authentication.user_name,&ppp.port[real_port_number].authentication.password);
	}
#endif
}
/******************************************************************************/
static void authentication_ack_received (USHORT real_port_number)
{
	if (ppp.fptr_event_upcall != NULL)
	{
		(*ppp.fptr_event_upcall) (PPP_EVENT_AUTHENTICATE_ACK_RECEIVED,real_port_number);
	}

	ppp.port[real_port_number].authentication.rxed_authentication_ack = TRUE;

	if (is_option_present (&ppp.port[real_port_number].option_lists.tx_accepted, (BYTE) LCP_AUTHENTICATION_PROTOCOL) != TRUE) 
	{
		ppp.port[real_port_number].authentication.status = SUCCESSFUL;

		bring_ncps_up (real_port_number,NULL,0x0000,PPP_INITIAL_STATE);
	
#if defined (CCP)
/* Sowmya 7/3/96
		if ((ppp.ccp.enabled == TRUE) && ((*ppp.ccp.fptr_get_ccp_port_status_function) (real_port_number) == TRUE))
			{
			(*ppp.ccp.fptr_execute_ccp_state_machine_function) (PPP_OPEN_EVENT, real_port_number, NULL, 0x0000);		

			bring_ccp_up (real_port_number,NULL,0x0000,PPP_INITIAL_STATE);
			}
Sowmya 7/3/96 */
#endif
	} 
	else if (ppp.port[real_port_number].authentication.txed_authentication_ack == TRUE) 
	{		
		ppp.port[real_port_number].authentication.status = SUCCESSFUL;

		bring_ncps_up (real_port_number,NULL,0x0000,PPP_INITIAL_STATE);
	
#if defined (CCP)
/* Sowmya 7/3/96
		if ((ppp.ccp.enabled == TRUE) && ((*ppp.ccp.fptr_get_ccp_port_status_function) (real_port_number) == TRUE))
			{
			(*ppp.ccp.fptr_execute_ccp_state_machine_function) (PPP_OPEN_EVENT, real_port_number, NULL, 0x0000);		

			bring_ccp_up (real_port_number,NULL,0x0000,PPP_INITIAL_STATE);
			}
Sowmya 7/3/96 */
#endif
	}

}
/******************************************************************************/
static void authentication_nak_received (USHORT real_port_number)
{
	send_lcp_authentication_request (real_port_number);
}
/****************************************************************************/
static void send_authentication_packet (USHORT real_port_number,PPP_PACKET *sptr_tx_packet,
	USHORT number_of_bytes_to_send,enum PPP_CONTROL_CODE code,BYTE id,enum PPP_PROTOCOL_TYPE protocol_type)
{
	sptr_tx_packet->code = (BYTE_ENUM (PPP_CONTROL_CODE)) code;
	sptr_tx_packet->id = id;
	sptr_tx_packet->length = swap ((USHORT) (number_of_bytes_to_send - sizeof (PPP_HEADER)));

	sptr_tx_packet->header.protocol_type = (USHORT_ENUM (PPP_PROTOCOL_TYPE)) protocol_type;

	ppp.port[real_port_number].authentication.statistics.number_of_tx_bytes += number_of_bytes_to_send;

	++ppp.port[real_port_number].authentication.statistics.number_of_tx_packets;

	send_native_ppp_packet (real_port_number,sptr_tx_packet,number_of_bytes_to_send,ppp_send_completion);
}
/*************************************************************************************************/
static void send_chap_authentication_ack (USHORT real_port_number, BYTE id_from_request_packet )
{
	AUTHENTICATION_ACK_PACKET *sptr_authentication_ack_packet;

	ppp_printf (PPP_LCP_PRINTF,"PPP:CHAP Authentication ACK Tx on port: %04x\r\n",real_port_number);

	sptr_authentication_ack_packet = (AUTHENTICATION_ACK_PACKET *) ppp_get_a_send_packet (real_port_number,
		sizeof (AUTHENTICATION_ACK_PACKET));

	if (sptr_authentication_ack_packet == NULL)
	{
		/* printf ("ppp_get_a_send_packet() failed for port %d\n", real_port_number) ; */
		return;
	}
	
	sptr_authentication_ack_packet->code = CHAP_AUTHENTICATION_ACK;
	sptr_authentication_ack_packet->id = id_from_request_packet;
	sptr_authentication_ack_packet->length = swap (sizeof (AUTHENTICATION_ACK_PACKET) -	sizeof (PPP_HEADER));

	sptr_authentication_ack_packet->header.protocol_type = CHAP_PROTOCOL;
	
	sptr_authentication_ack_packet->message_length = (BYTE) strlen ("you are authenticated");

	strncpy (sptr_authentication_ack_packet->message,"you are authenticated",sptr_authentication_ack_packet->message_length);

	send_native_ppp_packet (real_port_number,(PPP_PACKET *) sptr_authentication_ack_packet,
		sizeof (AUTHENTICATION_ACK_PACKET),ppp_send_completion);

	/* printf ("Txed CHAP authentication ack on port %d\n") ; */

	if (ppp.fptr_event_upcall != NULL)
	{
		(*ppp.fptr_event_upcall) (PPP_EVENT_AUTHENTICATE_ACK_TRANSMITTED,real_port_number);
	}
}
/*************************************************************************************************/
static void send_chap_authentication_nak (USHORT real_port_number, BYTE id_from_request_packet )
{
	AUTHENTICATION_NAK_PACKET *sptr_authentication_nak_packet;

	ppp_printf (PPP_LCP_PRINTF,"PPP:CHAP Authentication NACK Tx on port: %04x\r\n",real_port_number);

	sptr_authentication_nak_packet = (AUTHENTICATION_NAK_PACKET *) ppp_get_a_send_packet (real_port_number,
		sizeof (AUTHENTICATION_NAK_PACKET));

	if (sptr_authentication_nak_packet == NULL)
		{
		return;
		}
	
	sptr_authentication_nak_packet->code = CHAP_AUTHENTICATION_NAK;
	sptr_authentication_nak_packet->id = id_from_request_packet;
	sptr_authentication_nak_packet->length = swap (sizeof (AUTHENTICATION_NAK_PACKET) -	sizeof (PPP_HEADER));
	
	sptr_authentication_nak_packet->header.protocol_type = CHAP_PROTOCOL;
	
	sptr_authentication_nak_packet->message_length = (BYTE) strlen ("you are not authenticated");

	strncpy (sptr_authentication_nak_packet->message,"you are not authenticated",
		sptr_authentication_nak_packet->message_length);

	send_native_ppp_packet (real_port_number,(PPP_PACKET *) sptr_authentication_nak_packet,
		sizeof (AUTHENTICATION_NAK_PACKET),ppp_send_completion);
}


/* Sachin 26/06/1996 */


/*
	The checking is made based on callback security being enabled or disabled.
	What should be done is, if callback security is enabled, always
	call him back at that number. Otherwise, the client can decide if he wants
	to be called at the number known to the administrator or the number that he
	gives.
*/


/* Jo 04/06/99 Added for RAS */
enum BOOLEAN check_for_callback (USHORT real_port_number)
{
	OPTION_LIST_ENTRY *sptr_option ;
	RAS_USER_DATABASE_RECORD *sptr_udb_record ;
	LCP_EXTENSION_CALLBACK *sptr_lcp_ext_callback ;

	sptr_option = find_matching_option (&ppp.port[real_port_number].option_lists.rx_accepted,
	                                    LCP_CALLBACK) ;

	if (sptr_option == NULL)
	{
		return (FALSE) ;
	}
	sptr_lcp_ext_callback = (LCP_EXTENSION_CALLBACK *) &sptr_option->uptr_data->byte_array[0] ;
	sptr_udb_record = &ppp.port[real_port_number].ras_user_database_record ;

/* Sachin 21/09/1996 */

/* 
	Noted by Sachin, Oct 4th 1996 :
	We negotiate callback for Win 95 (CBCP). But later, we go on to realise
	that the particular user does not have callback. In case of other callback
	mechanisms, it is fine. But in CBCP, we need to give WIN 95's dial up
	client the list of callback mechanisms supported. Here, it happens to be only
	no callback that is supported.
		So, what is noteworthy is the way we react in the two cases. In case of
	WIN 95, the handling is different. In any other case, we simply terminate the
	link. In case of WIN 95, we should not be terminating the link. Instead, we
	tell him that we dont have callback. It is upto him to decide what he wants
	to do next.
*/

	if ((is_ras_callback_enabled ((BYTE *)sptr_udb_record, real_port_number) == FALSE) &&
	    ((BYTE) sptr_lcp_ext_callback->operation != (BYTE) LOC_DETERMINED_BY_CBCP_PROTOCOL))
	{
		/*
			This user does not have callback. So, bring the port down.
			But do not do this if it is CBCP.
		*/
		ppp_printf (PPP_LCP_PRINTF, "Callback not permitted for user\n") ;
		ppp_device_driver_control (LOWER_DEVICE_DRIVER_DOWN,
			                       (real_port_number + ppp.number_of_lan_ports), NULL) ;
		return (TRUE) ;
	}

/* Sachin 21/09/1996 */

	if ((BYTE) sptr_lcp_ext_callback->operation == (BYTE) LOC_DETERMINED_BY_CBCP_PROTOCOL)
	{
		send_cbcp_request (real_port_number) ;
		return (TRUE) ;
	}

	send_lcp_termination_request (real_port_number) ;
	/* Otherwise, WanderLink does not get ready and wait for callback */
/*	 printf ("PPP : Sent LCP Termination request on port %d\n", real_port_number) ;  */

	if (sptr_udb_record->call_back_security == 1)
	{
		/* Callback number is provided by the administrator */

		if (sptr_lcp_ext_callback->operation != LOCATION_DETERMINED_BY_AUTHENTICATION)
		{
			/* printf ("CALLBACK : Callback security enabled, but client gives non-null number\n") ; */
			/* printf ("CALLBACK : Closing PPP device driver port %d\n", real_port_number) ; */
			ppp_device_driver_control (LOWER_DEVICE_DRIVER_DOWN,
			                           (real_port_number + ppp.number_of_lan_ports), NULL) ;
			return (TRUE) ;
		}
		/* printf ("CALLBACK : Callback security is enabled\n") ; */
	}
	else
	{
		/* Callback number is provided by the client */
		/* printf ("CALLBACK : Callback security is disabled\n") ; */
		memcpy (&sptr_udb_record->call_back_number[0],
		        &sptr_lcp_ext_callback->message[0],
				  sptr_option->length - 1) ;
		sptr_udb_record->call_back_number[sptr_option->length - 1] = '\0' ;
		sptr_udb_record->call_back_delay = 10 ;
	}

	printf ("CALLBACK : Callback number is %s\n", sptr_udb_record->call_back_number) ;
	printf ("CALLBACK : Callback duration is %d\n", sptr_udb_record->call_back_delay) ;

	if (ppp.port[real_port_number].serial_driver.fptr_control_routine != NULL)
	{
		ppp.port[real_port_number].callback_on = TRUE ;
		(*ppp.port[real_port_number].serial_driver.fptr_control_routine) (WAIT_AND_CALL_BACK,
	   	(ULONG) real_port_number,
			(ULONG) &ppp.port[real_port_number].ras_user_database_record) ;
	}

	return (TRUE) ;
}
/* Jo 04/06/99 Added for RAS */

void send_chap_ack_and_process (USHORT real_port_number)
{
	send_chap_authentication_ack (real_port_number, ppp.port[real_port_number].authentication.id) ;

	/* printf ("Sent CHAP ack on port %d\n", real_port_number) ; */

	ppp.port[real_port_number].authentication.txed_authentication_ack = TRUE ;

	if (is_option_present (&ppp.port[real_port_number].option_lists.rx_accepted, (BYTE) LCP_AUTHENTICATION_PROTOCOL) != TRUE) 
	{
		/* printf ("Peer does not want to authenticate, bringing ncps on port %d\n", real_port_number) ; */
/* Jo 04/06/99 Added for RAS */
		if (check_for_callback (real_port_number) == FALSE) 
		{
			bring_ncps_up (real_port_number, NULL, 0x0000, PPP_INITIAL_STATE) ;
			
#if defined (CCP)
/* Sowmya 7/3/96

			if ((ppp.ccp.enabled == TRUE) && ((*ppp.ccp.fptr_get_ccp_port_status_function) (real_port_number) == TRUE))
			{
				(*ppp.ccp.fptr_execute_ccp_state_machine_function) (PPP_OPEN_EVENT, real_port_number, NULL, 0x0000) ;		
				bring_ccp_up (real_port_number, NULL, 0x0000, PPP_INITIAL_STATE) ;
			}
Sowmya 7/3/96 */
#endif
			ppp.port[real_port_number].authentication.status = SUCCESSFUL ;
		}
/* Jo 04/06/99 Added for RAS */
	}
	else if (ppp.port[real_port_number].authentication.rxed_authentication_ack == TRUE)
	{
		/* printf ("Peer has authenticated, bringing ncps up on port %d\n", real_port_number) ; */
/* Jo 04/06/99 Added for RAS */
		if (check_for_callback (real_port_number) == FALSE) 
		{
			bring_ncps_up (real_port_number, NULL, 0x0000, PPP_INITIAL_STATE) ;
			
#if defined (CCP)
/* Sowmya 7/3/96
			if ((ppp.ccp.enabled == TRUE) && ((*ppp.ccp.fptr_get_ccp_port_status_function) (real_port_number) == TRUE))
			{
				(*ppp.ccp.fptr_execute_ccp_state_machine_function) (PPP_OPEN_EVENT, real_port_number, NULL, 0x0000) ;		
				bring_ccp_up (real_port_number, NULL, 0x0000, PPP_INITIAL_STATE) ;
			}
Sowmya 7/3/96 */
#endif
			ppp.port[real_port_number].authentication.status = SUCCESSFUL ;
		}
/* Jo 04/06/99 Added for RAS */
	}
	else
	{
		/* printf ("Authentication ack awaited from peer on port %d\n", real_port_number) ; */
	}
}


void send_chap_nak_and_process (USHORT real_port_number)
{
	send_chap_authentication_nak (real_port_number, ppp.port[real_port_number].authentication.id) ;

	if (++ppp.port[real_port_number].authentication.current_number_of_retries >
		ppp.port[real_port_number].authentication.maximum_number_of_retries)
	{
		execute_ppp_state_machine (PPP_CLOSE_EVENT, real_port_number, NULL, 0x0000) ;
		
		ppp.port[real_port_number].authentication.current_number_of_retries = 0 ;
		ppp.port[real_port_number].authentication.status = UNSUCCESSFUL ;
		ppp.port[real_port_number].authentication.txed_authentication_ack = FALSE ;
	}
	else
	{
		send_lcp_chap_server_packet (real_port_number) ;
	}
}
