/*
	Author   : Sachin (Courtesy, Bala)
	Date     : 5th July, 1996
	Synopsis : CBCP (Microsoft Standard for Callback, used in WIN 95)
*/

/* Observation :
	In cbcp_packet_received(), where see if the requested callback
	type is available for the user, also look at the callback
	enabled flag. Right now, it is only the callback security flag.

	Reorganize send_cbcp_request().

	Sachin, Christmas day, 1996
*/

#include "defs.h"
#include "ppp.h"
#include <udb.h>
#include "vpppcb.h"

/* Jo 04/06/99 Added for RAS */
void cbcp_packet_received (USHORT real_port_number, CBCP_PACKET *sptr_cbcp_rx_packet, USHORT number_of_bytes_rxed) ;
void send_cbcp_ack (USHORT real_port_number, CBCP_PACKET *sptr_cbcp_rx_packet) ;
void send_cbcp_request (USHORT real_port_number) ;

void cbcp_packet_received (USHORT real_port_number, CBCP_PACKET *sptr_cbcp_rx_packet,USHORT number_of_bytes_rxed)
{
	CBCP_RESPONSE_DATA *rxed_data ;
	RAS_USER_DATABASE_RECORD *sptr_udb_record ;

	sptr_udb_record = &ppp.port[real_port_number].ras_user_database_record ;

	PARAMETER_NOT_USED (number_of_bytes_rxed) ;

	if (sptr_cbcp_rx_packet->lcp_header.code == CBCP_RESPONSE)
	{
		rxed_data = &sptr_cbcp_rx_packet->data.response ;
		switch(rxed_data->callback_type)
		{
			case (1) : 
				/* No callback */
				ppp_printf (PPP_LCP_PRINTF, "CBCP : No Callback on port %d, ACKing and bringing ncps up\n", real_port_number) ;
				send_cbcp_ack (real_port_number, sptr_cbcp_rx_packet) ;
				bring_ncps_up (real_port_number, NULL, 0x0000, PPP_INITIAL_STATE) ;
			
#ifdef CCP
/* Sowmya 7/3/96
				if ((ppp.ccp.enabled == TRUE) && ((*ppp.ccp.fptr_get_ccp_port_status_function) (real_port_number) == TRUE))
				{
					(*ppp.ccp.fptr_execute_ccp_state_machine_function) (PPP_OPEN_EVENT, real_port_number, NULL, 0x0000) ;	
					bring_ccp_up (real_port_number, NULL, 0x0000, PPP_INITIAL_STATE) ;
				}
Sowmya 7/3/96 */
#endif
				break ;


			case (2) : 
				/* Callback to a user specifiable number */
				ppp_printf (PPP_LCP_PRINTF, "CBCP : Callback to a user specifiable number\n") ;
				if (sptr_udb_record->call_back_security == 1)
				{
					ppp_printf (PPP_LCP_PRINTF, "CBCP : Callback security enabled, invalid callback type requested by client\n") ;
					ppp_device_driver_control(CLOSE_DEVICE_DRIVER_PORT,
					                          real_port_number + ppp.number_of_lan_ports,
													  NULL) ;
					return ;
				}

				send_cbcp_ack(real_port_number, sptr_cbcp_rx_packet) ;
				send_lcp_termination_request (real_port_number) ;
				strcpy (&sptr_udb_record->call_back_number[0],
				        &rxed_data->callback_address.address[0]) ;
				sptr_udb_record->call_back_delay = rxed_data->delay ;

				ppp_printf (PPP_LCP_PRINTF, "CBCP : Callback number is %s\n", sptr_udb_record->call_back_number) ;
				ppp_printf (PPP_LCP_PRINTF, "CBCP : Callback duration is %d\n", sptr_udb_record->call_back_delay) ;

				if (ppp.port[real_port_number].serial_driver.fptr_control_routine != NULL)
				{
					ppp.port[real_port_number].callback_on = TRUE ;
					(*ppp.port[real_port_number].serial_driver.fptr_control_routine) (WAIT_AND_CALL_BACK,
						(ULONG) real_port_number,
						(ULONG) &ppp.port[real_port_number].ras_user_database_record) ;
				}

				break ;



			case 3 :
				/* callback to a pre-specified or administrator specified number */
				ppp_printf (PPP_LCP_PRINTF, "CBCP : callback to a pre-specified or administrator specified number\n") ;
				if (sptr_udb_record->call_back_security == 0)
				{
					ppp_printf (PPP_LCP_PRINTF, "CBCP : Callback security disabled, invalid callback type requested by client\n") ;
					ppp_device_driver_control(CLOSE_DEVICE_DRIVER_PORT,
					                          real_port_number + ppp.number_of_lan_ports,
													  NULL) ;
					return ;
				}

				send_cbcp_ack(real_port_number, sptr_cbcp_rx_packet) ;
				send_lcp_termination_request (real_port_number) ;

				ppp_printf (PPP_LCP_PRINTF, "CBCP : Callback number is %s\n", sptr_udb_record->call_back_number) ;
				ppp_printf (PPP_LCP_PRINTF, "CBCP : Callback duration is %d\n", sptr_udb_record->call_back_delay) ;

				if (ppp.port[real_port_number].serial_driver.fptr_control_routine != NULL)
				{
					ppp.port[real_port_number].callback_on = TRUE ;
					(*ppp.port[real_port_number].serial_driver.fptr_control_routine) (WAIT_AND_CALL_BACK,
						(ULONG) real_port_number,
						(ULONG) &ppp.port[real_port_number].ras_user_database_record) ;
				}

				break ;

			default :
				ppp_printf (PPP_LCP_PRINTF, "CBCP : Unknown callback type %d\n", rxed_data->callback_type) ;
				break ;
		}
	}
}



void send_cbcp_ack (USHORT real_port_number, CBCP_PACKET *sptr_cbcp_request)
{
	CBCP_ACK_PACKET *sptr_cbcp_ack_packet ;
	USHORT number_of_bytes ;

	ppp_printf (PPP_LCP_PRINTF, "CBCP : ACK Tx on port: %04x\r\n",real_port_number) ;

	sptr_cbcp_ack_packet = (CBCP_ACK_PACKET *) ppp_get_a_send_packet (real_port_number,
		sizeof (CBCP_ACK_PACKET)) ;

	if (sptr_cbcp_ack_packet == NULL)
		return ;
	
	sptr_cbcp_ack_packet->lcp_header.code = CBCP_ACK ;
	sptr_cbcp_ack_packet->lcp_header.id = sptr_cbcp_request->lcp_header.id ;
	memcpy (&sptr_cbcp_ack_packet->response, &sptr_cbcp_request->data.response,
	         sptr_cbcp_request->data.response.length) ;

	number_of_bytes = sptr_cbcp_request->data.response.length + sizeof (LCP_HEADER) ;
	sptr_cbcp_ack_packet->lcp_header.length =	swap (number_of_bytes) ;

	sptr_cbcp_ack_packet->ppp_header.protocol_type = CBCP_PROTOCOL ;

	send_native_ppp_packet (real_port_number, (PPP_PACKET *)sptr_cbcp_ack_packet,
		(USHORT) (number_of_bytes + sizeof (PPP_HEADER)),ppp_send_completion) ;
}


void send_cbcp_request (USHORT real_port_number)
{
	USHORT number_of_bytes_to_send ;
	CBCP_REQUEST_PACKET *sptr_cbcp_packet ;
	UNION_CALLBACK_OPTIONS *sptr_callback_options ;
	enum CBCP_CALLBACK_TYPE callback_type ;

	number_of_bytes_to_send = sizeof (PPP_HEADER) + sizeof (LCP_HEADER)
					+ sizeof(CALLBACK_OPTION_NO_CALLBACK) ;

	callback_type = CBCP_TYPE_NO_CALLBACK ;

	if (ppp.port[real_port_number].ras_user_database_record.call_back_enabled == TRUE)
	{
		if (ppp.port[real_port_number].ras_user_database_record.call_back_security == TRUE)
			callback_type = CBCP_TYPE_ADMINISTRATOR_SPECIFIED ;
		else
			callback_type = CBCP_TYPE_USER_SPECIFIED ;
	}

	switch (callback_type)
	{
		case (CBCP_TYPE_ADMINISTRATOR_SPECIFIED) :
			number_of_bytes_to_send += sizeof (CALLBACK_OPTION_CALL_BACK_PRE_SPECIFIED_NO) ;
			break ;

		case (CBCP_TYPE_USER_SPECIFIED) :
			number_of_bytes_to_send += sizeof (CALLBACK_OPTION_CALL_BACK_USER_SPECIFIED_NO) ;
			break ;

		case (CBCP_TYPE_NO_CALLBACK) :
			break ;
	}

	sptr_cbcp_packet = (CBCP_REQUEST_PACKET *) ppp_get_a_send_packet (real_port_number, number_of_bytes_to_send) ;
	if (sptr_cbcp_packet == NULL)
		return ;

	ppp.port[real_port_number].id_sequence_number = (BYTE) (ppp.port[real_port_number].id_sequence_number + 1) ;

	/* Fill up the PPP header */
	sptr_cbcp_packet->lcp_header.id = ppp.port[real_port_number].id_sequence_number ;
	sptr_cbcp_packet->lcp_header.code = CBCP_REQUEST ;
	sptr_cbcp_packet->lcp_header.length = swap ((USHORT) (number_of_bytes_to_send - sizeof (PPP_HEADER))) ;
	sptr_cbcp_packet->ppp_header.protocol_type = CBCP_PROTOCOL ;

	/* Include NO_CALLBACK option in the list */
	sptr_callback_options = (UNION_CALLBACK_OPTIONS *) sptr_cbcp_packet->request.data ;
	sptr_callback_options->no_callback.callback_type = CBCP_TYPE_NO_CALLBACK ;
	sptr_callback_options->no_callback.length = sizeof (CALLBACK_OPTION_NO_CALLBACK) ;
	sptr_callback_options->no_callback.delay = 0 ;

	sptr_callback_options = (UNION_CALLBACK_OPTIONS *) 
		((ULONG)sptr_callback_options + sizeof(CALLBACK_OPTION_NO_CALLBACK)) ;

	if (callback_type == CBCP_TYPE_ADMINISTRATOR_SPECIFIED)
	{
		/* Include ADMINISTRATOR_SPECIFIED option in the list */
		sptr_callback_options->pre_specified_no.callback_type = CBCP_TYPE_ADMINISTRATOR_SPECIFIED ;
		sptr_callback_options->pre_specified_no.length = sizeof (CALLBACK_OPTION_CALL_BACK_PRE_SPECIFIED_NO) ;
		sptr_callback_options->pre_specified_no.delay = 0 ;

		printf ("CBCP : Sent CBCP request with PRESPECIFIED CALLBACK option on port %04X\n", real_port_number) ;
	}
	else if (callback_type == CBCP_TYPE_USER_SPECIFIED)
	{
		/* Include USER_SPECIFIED option in the list */
		sptr_callback_options->user_specified_no.callback_type = CBCP_TYPE_USER_SPECIFIED ;
		sptr_callback_options->user_specified_no.length = sizeof (CALLBACK_OPTION_CALL_BACK_USER_SPECIFIED_NO) ;
		sptr_callback_options->user_specified_no.delay = 0 ;
		sptr_callback_options->user_specified_no.address_type = 1 ;
		sptr_callback_options->user_specified_no.address[0] = 0 ;

		printf ("CBCP : Sent CBCP request with USER SPECIFIED CALLBACK option on port %04X\n", real_port_number) ;
	}

	send_native_ppp_packet (real_port_number, (PPP_PACKET *) sptr_cbcp_packet,
	  number_of_bytes_to_send, ppp_send_completion) ;

	return ;
}
/* Jo 04/06/99 Added for RAS */
