#include	"defs.h"
/*	$Modname: pppcfgar.c$  $version: 1.2$      $date: 03/10/95$   */
/*
* 	$lgb$
1.0 12/13/94 ross initial version.
1.1 12/13/94 ross
1.2 03/10/95 ross general fixes.  see change.doc
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1993 - 1994 RouterWare, Inc.   								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA 92660	*/
/************************************************************************/
#include	<stdio.h>
#include	<string.h>
#include "ppp.h"
/****************************************************************************/
static BYTE parse_alternate_ppp_option_line (char *cptr_option_string,char *cptr_return_ncp_name,char *cptr_return_option_name,
	BYTE *bptr_return_option_number,char *cptr_value_type_string,char *cptr_value_string);
static BYTE parse_range_ppp_option_line (char *cptr_option_string,char *cptr_return_ncp_name,char *cptr_return_option_name,
	BYTE *bptr_return_option_number,char *cptr_value_type_string,char *cptr_value_string_low,char *cptr_value_string_high,
	char *cptr_value_string_step);
/****************************************************************************/
/*	PPP Port Option = 00,IPCP,IP Address,3,Alternate,IP,128.1.60.2 */
/****************************************************************************/
#ifdef _BIG_PROXY_
enum TEST get_alternate_option_values (char *cptr_option_string,char *cptr_return_ncp_name,char *cptr_return_option_name,
	BYTE *bptr_return_option_number,BYTE *bptr_return_data,BYTE *bptr_return_length,enum BOOLEAN *eptr_return_value_swapped)
{
	char value_type_string[12];
	char value_string[80];
	BYTE number_of_fields_scanned;

	number_of_fields_scanned = parse_alternate_ppp_option_line (cptr_option_string,cptr_return_ncp_name,cptr_return_option_name,
		bptr_return_option_number,value_type_string,value_string);

	if (number_of_fields_scanned != 6)
		{
		ppp_printf (PPP_ALARM_PRINTF,"Illegal Number of PPP Options %02x Entered %s!!!\r\n",
			number_of_fields_scanned,cptr_option_string);

		return (FAIL);
		}

	get_option_value (&value_type_string[0],&value_string[0],bptr_return_data,bptr_return_length,eptr_return_value_swapped);

	return (PASS);
}
/****************************************************************************/
static BYTE parse_alternate_ppp_option_line (char *cptr_option_string,char *cptr_return_ncp_name,char *cptr_return_option_name,
	BYTE *bptr_return_option_number,char *cptr_value_type_string,char *cptr_value_string)
{
	char *cptr_parameter;
	BYTE number_of_parameters_processed;
	char option_number_string[4];
	ULONG option_number;
	char alternate_string[14];

	number_of_parameters_processed = 0x00;

	cptr_parameter = strtok (cptr_option_string,",\n");

	cptr_parameter = copy_parameter (cptr_return_ncp_name,cptr_parameter,&number_of_parameters_processed);
	cptr_parameter = copy_parameter (cptr_return_option_name,cptr_parameter,&number_of_parameters_processed);
	cptr_parameter = copy_parameter (&option_number_string[0],cptr_parameter,&number_of_parameters_processed);
	cptr_parameter = copy_parameter (&alternate_string[0],cptr_parameter,&number_of_parameters_processed);
	cptr_parameter = copy_parameter (cptr_value_type_string,cptr_parameter,&number_of_parameters_processed);
	copy_parameter (cptr_value_string,cptr_parameter,&number_of_parameters_processed);

	sscanf (option_number_string,"%d",&option_number);
	*bptr_return_option_number = (BYTE) option_number;

	return (number_of_parameters_processed);
}
/****************************************************************************/
/* PPP Port Remote Option = 00,IPCP IP Address,3,Range,IP,128.1.60.2,128.1.60.3,0.0.0.1 */
/****************************************************************************/
enum TEST get_range_option_values (char *cptr_option_string,char *cptr_return_ncp_name,char *cptr_return_option_name,
	BYTE *bptr_return_option_number,BYTE *bptr_return_data,BYTE *bptr_return_length,enum BOOLEAN *eptr_return_value_swapped)
{
	char value_type_string[12];
	char value_string_low[80];
	char value_string_high[80];
	char value_string_step[80];
	BYTE number_of_fields_scanned;

	number_of_fields_scanned = parse_range_ppp_option_line (cptr_option_string,cptr_return_ncp_name,cptr_return_option_name,
		bptr_return_option_number,value_type_string,value_string_low,value_string_high,value_string_step);

	if (number_of_fields_scanned != 8)
		{
		ppp_printf (PPP_ALARM_PRINTF,"Illegal Number of PPP Options %02x Entered %s!!!\r\n",number_of_fields_scanned,
			cptr_option_string);

		return (FAIL);
		}

	get_option_value (&value_type_string[0],&value_string_low[0],bptr_return_data,bptr_return_length,eptr_return_value_swapped);

	bptr_return_data = (BYTE *) (bptr_return_data + *bptr_return_length);

	get_option_value (&value_type_string[0],&value_string_high[0],bptr_return_data,bptr_return_length,eptr_return_value_swapped);

	bptr_return_data = (BYTE *) (bptr_return_data + *bptr_return_length);

	get_option_value (&value_type_string[0],&value_string_step[0],bptr_return_data,bptr_return_length,eptr_return_value_swapped);

	*bptr_return_length = (BYTE) (*bptr_return_length * 3);

	return (PASS);
}
/****************************************************************************/
static BYTE parse_range_ppp_option_line (char *cptr_option_string,char *cptr_return_ncp_name,char *cptr_return_option_name,
	BYTE *bptr_return_option_number,char *cptr_value_type_string,char *cptr_value_string_low,char *cptr_value_string_high,
	char *cptr_value_string_step)
{
	char *cptr_parameter;
	BYTE number_of_parameters_processed;
	char option_number_string[4];
	ULONG option_number;
	char alternate_string[14];

	number_of_parameters_processed = 0x00;

	cptr_parameter = strtok (cptr_option_string,",\n");

	cptr_parameter = copy_parameter (cptr_return_ncp_name,cptr_parameter,&number_of_parameters_processed);
	cptr_parameter = copy_parameter (cptr_return_option_name,cptr_parameter,&number_of_parameters_processed);
	cptr_parameter = copy_parameter (&option_number_string[0],cptr_parameter,&number_of_parameters_processed);
	cptr_parameter = copy_parameter (&alternate_string[0],cptr_parameter,&number_of_parameters_processed);
	cptr_parameter = copy_parameter (cptr_value_type_string,cptr_parameter,&number_of_parameters_processed);
	cptr_parameter = copy_parameter (cptr_value_string_low,cptr_parameter,&number_of_parameters_processed);
	cptr_parameter = copy_parameter (cptr_value_string_high,cptr_parameter,&number_of_parameters_processed);
	copy_parameter (cptr_value_string_step,cptr_parameter,&number_of_parameters_processed);

	sscanf (option_number_string,"%d",&option_number);
	*bptr_return_option_number = (BYTE) option_number;

	return (number_of_parameters_processed);
}

#endif

