#include	"defs.h"
/*	$Modname: pppconfg.c$  $version: 1.25$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 03/09/94 keyur new nvram file.
1.1 03/09/94 keyur added support for version control.
1.2 03/23/94 keyur Cosmetic changes.
1.3 03/26/94 keyur Ran Lint compiler and code style program and got rid of unnecessary warnings
1.4 04/12/94 keyur Added cast for scanf.
1.5 04/12/94 keyur Added cast for scanf.
1.6 04/13/94 keyur Added support for NCP state machine
1.7 04/19/94 keyur Added ordering of options for LCP and NCP, courtesy of John
1.8 05/02/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John.
1.9 05/02/94 keyur took out memcheck header file.
1.10 08/11/94 ross adding rfc1570 lcp support
1.11 08/25/94 ross fixed scanf bug.  Courtesy of Danny.
1.12 08/25/94 ross deleted unnecessary files.
1.13 09/06/94 ross fixed sscanf big endian bug.  Courtesy of Danny.
1.14 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.15 12/02/94 ross testing NT3.5 RAS
1.16 12/05/94 ross dynamic option support.  Portions courtesy of Dan.
1.17 12/11/94 ross adding multiple value option support
1.18 12/13/94 ross connected to NT RAS with Netbios
1.19 12/13/94 ross added copyrights in some files
1.20 01/26/95 ross changes for rwutils
1.21 01/30/95 ross removing duplicate configuration options
1.22 01/30/95 ross moved magic number generation routine here from pppinit.
1.23 02/27/95 ross dynamic load changes including lsl_control.
1.24 03/10/95 ross general fixes.  see change.doc
1.25 10/19/95 biao added Compression Control Protocol (CCP) support. Please refer to change.doc for details.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1993 - 1994 RouterWare, Inc.   								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA 92660	*/
/************************************************************************/
#include	<stddef.h>
#include	<stdio.h>
#include	<string.h>
#include "ppp.h"
#include	<cnffile.h>
#include	<vnvrmstr.h>
#include	"vnvppp.h"
/****************************************************************************/
/* Jo 12/09/98 : Made modifications to access PPP options as bits instead of Strings */

void add_ppp_option (CNF_PPP_OPTION *cptr_option_string, char *cptr_ncp_name, char *cptr_option_name, USHORT port_number, enum BOOLEAN remote_configuration) ;
void add_ppp_port_ras_option (CNF_PPP_OPTION *cptr_option_string, char *cptr_ncp_name, char *cptr_option_name, USHORT port_number, enum BOOLEAN remote_configuration) ;
static void add_option_type (OPTION_LISTS *sptr_option_lists,char *cptr_port_number_and_option_string,
	char *cptr_option_string,enum BOOLEAN remote_configuration);
static enum TEST get_configuration_option_values (char *cptr_option_string,char *cptr_return_ncp_name,
	char *cptr_return_option_name,
	BYTE *bptr_return_option_number,BYTE *bptr_return_data,BYTE *bptr_return_length,enum BOOLEAN *eptr_return_value_swapped,
	enum BOOLEAN *eptr_negotiation_required,enum BOOLEAN *eptr_negotiable,enum BOOLEAN *eptr_automatic_nak_processing);
static char *parse_ppp_option_line (char *cptr_option_string,char *cptr_return_ncp_name,char *cptr_return_option_name,
	BYTE *bptr_return_option_number,char *cptr_automatic_nak_processing_string,char *cptr_negotiation_required_string,
	char *cptr_negotiable_string,BYTE *bptr_number_of_parameters_processed);
static void parse_option_value (char *cptr_value,BYTE *bptr_option_data,BYTE *bptr_length_of_all_options,
	enum BOOLEAN *eptr_return_value_swapped);
static ULONG get_ip_address_string (char *cptr_ip_address_string);
static enum NCP_STACK_INDEX get_stack_index (char *option_string);
static enum BOOLEAN get_option_value_type (char *value_type_string,char *value_string,BYTE *bptr_return_data,
	BYTE *bptr_return_length,enum BOOLEAN *eptr_return_value_swapped);
static BYTE get_size_of_numeric_string (enum CNF_DATA_VALUE_DATA_TYPE value_type) ;
static ULONG get_my_magic_number (void) ;

/* Kamlnath  29/08/1996 */
static void ip_bring_down_ncp (int real_port_number) ;
/* Kamalnath 29/08/1996 */
/* Srikar, Mar 17, 1997. Added the prototypes for the added functions */
/* Jo enum BOOLEAN set_port_ipx_operational_state(USHORT port_number, enum BOOLEAN new_state);
enum BOOLEAN get_port_ipx_operational_state(USHORT port_number); */

#if defined (CCP)
	static enum BOOLEAN is_ccp_option (char *option_string);
	static char *cptr_ccp_option = "CCP";
#endif

/* Jo 26/04/99 */
static const char *cptr_ncp_types[] = {"IPCP","IPXCP","ATCP","NBFCP","BCP"};
static const char *cptr_hex_values[] =	{"","%02jx","%02jx%02jx","%02jx%02jx%02jx","%02jx%02jx%02jx%02jx","%02jx%02jx%02jx%02jx%02jx",
	"%02jx%02jx%02jx%02jx%02jx%02jx", "%02jx%02jx%02jx%02jx%02jx%02jx%02jx"};
/****************************************************************************/
/* H is hex, D is decimal, # is size in bytes, S is little-endian swapped 
"IP","IPS","H6","H4","D4","H2","D2""H4S","D4S","H2S","D2S","H1","D1","String","Netbios String"
*/
/* PPP Port Option = 00,IPCP Address,3,Auto,Negotiation Not Required,Negotiable,IP,128.1.60.1 */
/* PPP Port Option = 00,IPCP Address,3,Auto,Alternate,IP,128.1.60.2 */
/* PPP Port Option = 00,IPCP Address,3,Auto,Range,IP,128.1.60.2,128.1.60.3,0.0.0.1 */
/****************************************************************************/

/* Jo */
int ppp_read_configuration (char *cptr_config) ;
void print_ppp_configured_parameters () ;
void print_ppp_options(OPTION_LIST *sptr_option_list) ;

/* Jo 28/08/98 : Made changes for Small Proxy */

#ifdef __MLPPP__
extern char ethernet_address[] ;
#endif

void add_ppp_option (CNF_PPP_OPTION *cptr_option_string, char *cptr_ncp_name, char *cptr_option_name, USHORT port_number, enum BOOLEAN remote_configuration)
{
	OPTION_LISTS *sptr_option_lists ; 
	OPTION_LIST *ptr_option_list ;
	char *value_format_string ;
	void *ptr_option_data ;
	enum NCP_STACK_INDEX stack_index ;
	BYTE option_data[128] ;
	BYTE length ;
	enum BOOLEAN value_swapped ;
	BYTE option_number ;
	enum BOOLEAN negotiation_required ;
	enum BOOLEAN negotiable ;
	enum BOOLEAN automatic_nak_processing ;
	ULONG magic_number, ip_address, ulong_swap_value ;
	USHORT ushort_swap_value ;

	option_data[0] = 0 ;
	if (cptr_option_string->valid == 0)
	{
/* Jo			ppp_printf (PPP_ALARM_PRINTF, "PPP:Invalid Option port %d %s %s \n", port_number, cptr_ncp_name, cptr_option_name) ;*/
			return ;
	}
	stack_index = get_stack_index (cptr_ncp_name) ;
	if (stack_index == NUMBER_OF_NCP_STACKS)
	{
#if defined (CCP)
		if (is_ccp_option (cptr_ncp_name) == TRUE)
			sptr_option_lists = &ppp.port[port_number].ccp.option_lists;
		else
			sptr_option_lists = &ppp.port[port_number].option_lists;
#else
		sptr_option_lists = &ppp.port[port_number].option_lists;
#endif
	}
	else
	{
#ifdef __MLPPP__
		sptr_option_lists = &mlppp.port[port_number].ncp[stack_index].option_lists;
#else
		sptr_option_lists = &ppp.port[port_number].ncp[stack_index].option_lists;
#endif
	}

	if (remote_configuration == TRUE)
		ptr_option_list = &sptr_option_lists->remote_configured ;
	else
		ptr_option_list = &sptr_option_lists->configured ;

	option_number = cptr_option_string->option_type ;
   if (cptr_option_string->NegNotReqd) 
		negotiation_required = FALSE ;
	else
		negotiation_required = TRUE ;
   if (cptr_option_string->Negotiable)
		negotiable = TRUE ;
	else
		negotiable = FALSE ;
	if (cptr_option_string->Auto)
		automatic_nak_processing = TRUE ;
	else
		automatic_nak_processing = FALSE ;

	if (cptr_option_string->value_type == H4S) 
		value_swapped = TRUE ;
	else
		value_swapped = FALSE ;

	if (cptr_option_string->value_type == IP)
	{
		 ip_address = get_ip_address_string (cptr_option_string->option_value) ;
		 memcpy (&option_data[0], &ip_address, sizeof (ULONG)) ; 
		 length = sizeof (ULONG) ;
	}
	else
	{
		 length = get_size_of_numeric_string (cptr_option_string->value_type) ;
		 if (cptr_option_string->value_type == D2)
				value_format_string = "%hu" ;
		else
				value_format_string = cptr_hex_values[length] ;

		if (length > 0x00)
		{
			sscanf (cptr_option_string->option_value, value_format_string, (int *) &option_data[0], (int *) &option_data[1],
				(int *) &option_data[2], (int *) &option_data[3], (int *) &option_data[4], (int *) &option_data[5],
				(int *) &option_data[6], (int *) &option_data[7]) ; 
		}
	}

	if (remote_configuration == FALSE)
	{
		if (strstr (cptr_option_name, "Magic Number") != NULL)
		{
			magic_number = get_my_magic_number () ;
			memcpy (&option_data[0], &magic_number, sizeof (magic_number)) ;
		}
#ifdef __MLPPP__
      else
      {
         if (strstr (cptr_option_name, "EPD") != NULL)
         {
            if (option_data[0] == 3) /* The EPD class is Ethernet Address */
               memcpy (&option_data[1], &ethernet_address[0], 6) ;
         }
      }
#endif
	}
	ptr_option_data = (void *) option_data ;

	if (value_swapped == TRUE)
	{
		if (length == sizeof (ULONG))
		{
			ulong_swap_value = swap_long (*((ULONG *)ptr_option_data)) ;
			ptr_option_data = &ulong_swap_value ;
		}
		else if (length == sizeof (USHORT))
		{
			ushort_swap_value = swap (*((USHORT *)ptr_option_data)) ;
			ptr_option_data = &ushort_swap_value ;
		}
	}

	if (add_new_ppp_option_to_list (ptr_option_list, OPTION_DEFAULT_STATE, option_number, length, ptr_option_data,
		negotiation_required, negotiable, automatic_nak_processing) == FAIL)
	{
		ppp_printf (PPP_ALARM_PRINTF, "PPP:Adding %s option to %s failed\n", cptr_option_name, cptr_ncp_name) ;
	}

}

void add_ppp_port_ras_option (CNF_PPP_OPTION *cptr_option_string, char *cptr_ncp_name, char *cptr_option_name, USHORT port_number, enum BOOLEAN remote_configuration)
{
	OPTION_LISTS *sptr_option_lists ; 
	OPTION_LIST *ptr_option_list ;
	char *value_format_string ;
	void *ptr_option_data ;
	enum NCP_STACK_INDEX stack_index ;
	BYTE option_data[128] ;
	BYTE length ;
	enum BOOLEAN value_swapped ;
	BYTE option_number ;
	enum BOOLEAN negotiation_required ;
	enum BOOLEAN negotiable ;
	enum BOOLEAN automatic_nak_processing ;
	ULONG magic_number, ip_address, ulong_swap_value ;
	USHORT ushort_swap_value ;

	option_data[0] = 0 ;
	if (cptr_option_string->valid == 0)
	{
			printf ("PPP:Invalid Option port %d %s %s \n", port_number, cptr_ncp_name, cptr_option_name) ;
			return ;
	}
	stack_index = get_stack_index (cptr_ncp_name) ;

	if (stack_index == NUMBER_OF_NCP_STACKS)
	{
		sptr_option_lists = &ppp.port[port_number].ras_option_lists;
	}
	else
	{
#ifdef __MLPPP__
		sptr_option_lists = &mlppp.port[port_number].ncp[stack_index].ras_option_lists;
#else
		sptr_option_lists = &ppp.port[port_number].ncp[stack_index].ras_option_lists;
#endif
	}

	if (remote_configuration == TRUE)
		ptr_option_list = &sptr_option_lists->remote_configured ;
	else
		ptr_option_list = &sptr_option_lists->configured ;

	option_number = cptr_option_string->option_type ;
   if (cptr_option_string->NegNotReqd) 
		negotiation_required = FALSE ;
	else
		negotiation_required = TRUE ;
   if (cptr_option_string->Negotiable)
		negotiable = TRUE ;
	else
		negotiable = FALSE ;
	if (cptr_option_string->Auto)
		automatic_nak_processing = TRUE ;
	else
		automatic_nak_processing = FALSE ;

	if (cptr_option_string->value_type == H4S) 
		value_swapped = TRUE ;
	else
		value_swapped = FALSE ;

	if (cptr_option_string->value_type == IP)
	{
		 ip_address = get_ip_address_string (cptr_option_string->option_value) ;
		 memcpy (&option_data[0], &ip_address, sizeof (ULONG)) ; 
		 length = sizeof (ULONG) ;
	}
	else
	{
		 length = get_size_of_numeric_string (cptr_option_string->value_type) ;
		 if (cptr_option_string->value_type == D2)
				value_format_string = "%hu" ;
		else
				value_format_string = cptr_hex_values[length] ;

		if (length > 0x00)
		{
			sscanf (cptr_option_string->option_value, value_format_string, (int *) &option_data[0], (int *) &option_data[1],
				(int *) &option_data[2], (int *) &option_data[3], (int *) &option_data[4], (int *) &option_data[5],
				(int *) &option_data[6], (int *) &option_data[7]) ; 
		}
	}

	if (remote_configuration == FALSE)
	{
		if (strstr (cptr_option_name, "Magic Number") != NULL)
		{
			magic_number = get_my_magic_number () ;
			memcpy (&option_data[0], &magic_number, sizeof (magic_number)) ;
		}
#ifdef __MLPPP__
      else
      {
         if (strstr (cptr_option_name, "EPD") != NULL)
         {
            if (option_data[0] == 3) /* The EPD class is Ethernet Address */
               memcpy (&option_data[1], &ethernet_address[0], 6) ;
         }
      }
#endif
	}
	ptr_option_data = (void *) option_data ;

	if (value_swapped == TRUE)
	{
		if (length == sizeof (ULONG))
		{
			ulong_swap_value = swap_long (*((ULONG *)ptr_option_data)) ;
			ptr_option_data = &ulong_swap_value ;
		}
		else if (length == sizeof (USHORT))
		{
			ushort_swap_value = swap (*((USHORT *)ptr_option_data)) ;
			ptr_option_data = &ushort_swap_value ;
		}
	}

	if (add_new_ppp_option_to_list (ptr_option_list, OPTION_DEFAULT_STATE, option_number, length, ptr_option_data,
		negotiation_required, negotiable, automatic_nak_processing) == FAIL)
	{
		ppp_printf (PPP_ALARM_PRINTF, "PPP:Adding %s option to %s failed\n", cptr_option_name, cptr_ncp_name) ;
	}
}

#if defined (CCP)
/****************************************************************************/
static enum BOOLEAN is_ccp_option (char *option_string)
{
	if (strstr (option_string, cptr_ccp_option) != NULL)
		{
		return (TRUE); 
		}
	else
		{
		return (FALSE);
		}

}
#endif
/****************************************************************************/
static enum NCP_STACK_INDEX get_stack_index (char *option_string)
{
	enum NCP_STACK_INDEX stack_index ;

	for (stack_index = 0x00; stack_index < NUMBER_OF_NCP_STACKS; stack_index = (enum NCP_STACK_INDEX) (stack_index + 1))
	{
		if (strstr (option_string,cptr_ncp_types[stack_index]) != NULL)
			break ;
	}

	return (stack_index) ;
}

/****************************************************************************/
/* Jo */
#if 0

void add_ppp_option (char *cptr_port_number_and_option_string)
{
	enum NCP_STACK_INDEX stack_index;
	USHORT port_number;
	char port_option_string[256];
	char *cptr_value_portion;
	OPTION_LISTS *sptr_option_lists;

	port_number = get_port_number_and_string (cptr_port_number_and_option_string,port_option_string);

	stack_index = get_stack_index (port_option_string);

	if (stack_index == NUMBER_OF_NCP_STACKS)
		{
#if defined (CCP)
		if (is_ccp_option (port_option_string) == TRUE)
			{
			sptr_option_lists = &ppp.port[port_number].ccp.option_lists;
			}
		else
			{
			sptr_option_lists = &ppp.port[port_number].option_lists;
			}
#else
		sptr_option_lists = &ppp.port[port_number].option_lists;
#endif
		}
	else
		{
/*  Jo included this */
#ifdef __MLPPP__
		sptr_option_lists = &mlppp.port[port_number].ncp[stack_index].option_lists;
#else
		sptr_option_lists = &ppp.port[port_number].ncp[stack_index].option_lists;
#endif
		}

	cptr_value_portion = strchr (cptr_port_number_and_option_string,',');

	strcpy (port_option_string,cptr_value_portion + 1);

	add_option_type (sptr_option_lists,cptr_port_number_and_option_string,port_option_string,FALSE);
}

void add_remote_ppp_option (char *cptr_port_number_and_option_string)
{
	enum NCP_STACK_INDEX stack_index;
	USHORT port_number;
	char port_option_string[256];
	char *cptr_value_portion;
	OPTION_LISTS *sptr_option_lists;

	port_number = get_port_number_and_string (cptr_port_number_and_option_string,port_option_string);

	stack_index = get_stack_index (port_option_string);

	if (stack_index == NUMBER_OF_NCP_STACKS)
	{
#if defined (CCP)
		if (is_ccp_option (port_option_string) == TRUE)
		{
			sptr_option_lists = &ppp.port[port_number].ccp.option_lists;
		}
		else
		{
			sptr_option_lists = &ppp.port[port_number].option_lists;
		}
#else
		sptr_option_lists = &ppp.port[port_number].option_lists;
#endif
	}
	else
	{
#ifdef __MLPPP__
		sptr_option_lists = &mlppp.port[port_number].ncp[stack_index].option_lists;
#else
		sptr_option_lists = &ppp.port[port_number].ncp[stack_index].option_lists;
#endif
	}

	cptr_value_portion = strchr (cptr_port_number_and_option_string,',');

	strcpy (port_option_string,cptr_value_portion + 1);

	add_option_type (sptr_option_lists,cptr_port_number_and_option_string,port_option_string,TRUE);
}

void add_ppp_port_ras_option (char *cptr_port_number_and_option_string)
{
	enum NCP_STACK_INDEX stack_index;
	USHORT port_number;
	char port_option_string[256];
	char *cptr_value_portion;
	OPTION_LISTS *sptr_option_lists;

	
	port_number = get_port_number_and_string (cptr_port_number_and_option_string,port_option_string);

	stack_index = get_stack_index (port_option_string);

	if (stack_index == NUMBER_OF_NCP_STACKS)
/*		sptr_option_lists = &ppp.port[port_number].option_lists; */
		sptr_option_lists = &ppp.port[port_number].ras_option_lists;
	else
		{
#ifdef __MLPPP__
		sptr_option_lists = &mlppp.port[port_number].ncp[stack_index].ras_option_lists;
#else
		sptr_option_lists = &ppp.port[port_number].ncp[stack_index].ras_option_lists;
#endif
		}

	cptr_value_portion = strchr (cptr_port_number_and_option_string,',');

	strcpy (port_option_string,cptr_value_portion + 1);

	add_option_type (sptr_option_lists,cptr_port_number_and_option_string,port_option_string,FALSE);
	return;
}

void add_ppp_port_ras_remote_option (char *cptr_port_number_and_option_string)
{
	enum NCP_STACK_INDEX stack_index;
	USHORT port_number;
	char port_option_string[256];
	char *cptr_value_portion;
	OPTION_LISTS *sptr_option_lists;

	
	port_number = get_port_number_and_string (cptr_port_number_and_option_string,port_option_string);

	stack_index = get_stack_index (port_option_string);

	if (stack_index == NUMBER_OF_NCP_STACKS)
/*		sptr_option_lists = &ppp.port[port_number].option_lists; */
		sptr_option_lists = &ppp.port[port_number].ras_option_lists;

	else
		{
#ifdef __MLPPP__
		sptr_option_lists = &mlppp.port[port_number].ncp[stack_index].ras_option_lists;
#else
		sptr_option_lists = &ppp.port[port_number].ncp[stack_index].ras_option_lists;
#endif
		}

	cptr_value_portion = strchr (cptr_port_number_and_option_string,',');

	strcpy (port_option_string,cptr_value_portion + 1);

	add_option_type (sptr_option_lists,cptr_port_number_and_option_string,port_option_string,TRUE);
	return;
}
/****************************************************************************/
static void add_option_type (OPTION_LISTS *sptr_option_lists,char *cptr_port_number_and_option_string,char *cptr_option_string,
	enum BOOLEAN remote_configuration)
{
	BYTE option_data[128];
	BYTE length;
	char ncp_name[16];
	char option_name[80];
	enum BOOLEAN value_swapped;
	BYTE option_number;
	enum BOOLEAN negotiation_required;
	enum BOOLEAN negotiable;
	enum BOOLEAN automatic_nak_processing;
	enum TEST return_value;
	OPTION_LIST *sptr_option_list;
	ULONG magic_number;

	if (remote_configuration == TRUE)
	{
		sptr_option_list = &sptr_option_lists->remote_configured;
	}
	else
	{
		sptr_option_list = &sptr_option_lists->configured;
	}

	if (strstr (cptr_port_number_and_option_string,"Negotia") != NULL)
	{
		return_value = get_configuration_option_values (cptr_option_string,&ncp_name[0],&option_name[0],&option_number,
			&option_data[0],&length,&value_swapped,&negotiation_required,&negotiable,&automatic_nak_processing);

		if (return_value == FAIL)
		{
			return;
		}

		if (remote_configuration == FALSE)
		{
			if (strstr (cptr_port_number_and_option_string,"Magic Number") != NULL)
			{
				magic_number = get_my_magic_number ();

				memcpy (&option_data[0],&magic_number,sizeof (magic_number));
			}
#ifdef __MLPPP__
         else
         {
            if (strstr (cptr_port_number_and_option_string,"EPD") != NULL)
            {
               if (option_data[0] == 3) /* The EPD class is Ethernet Address */
                  memcpy (&option_data[1], &ethernet_address[0], 6) ;
            }
         }
#endif
		}

		add_configuration_option (sptr_option_list,OPTION_DEFAULT_STATE,option_number,length,
			&option_data[0],&option_name[0],&ncp_name[0],value_swapped,negotiation_required,negotiable,automatic_nak_processing);
	}
#ifdef _BIG_PROXY_
	else
	if (strstr (cptr_port_number_and_option_string,"Alternate") != NULL)
	{
		return_value = get_alternate_option_values (cptr_option_string,&ncp_name[0],&option_name[0],&option_number,
			&option_data[0],&length,&value_swapped);

		if (return_value == FAIL)
		{
			return;
		}

		add_alternate_to_configuration_option (sptr_option_list,option_number,length,&option_data[0],&option_name[0],
			&ncp_name[0],value_swapped);
	}
	else
	if (strstr (cptr_port_number_and_option_string,"Range") != NULL)
	{
		return_value = get_range_option_values (cptr_option_string,&ncp_name[0],&option_name[0],&option_number,
			&option_data[0],&length,&value_swapped);

		if (return_value == FAIL)
		{
			return;
		}

		add_configuration_option_range (sptr_option_list,option_number,length,&option_data[0],&option_name[0],&ncp_name[0],
			value_swapped);
	}
#endif
	else
	{
		ppp_printf (PPP_ALARM_PRINTF,"Unknown Configuration String %s\r\n",cptr_port_number_and_option_string);
	}
}
/****************************************************************************/
/* IPCP Address,3,Auto,Negotiation Not Required,Negotiable,IP,128.1.60.1 */
/****************************************************************************/
static enum TEST get_configuration_option_values (char *cptr_option_string,char *cptr_return_ncp_name,
	char *cptr_return_option_name,BYTE *bptr_return_option_number,BYTE *bptr_return_data,BYTE *bptr_return_length,
	enum BOOLEAN *eptr_return_value_swapped,enum BOOLEAN *eptr_negotiation_required,enum BOOLEAN *eptr_negotiable,
	enum BOOLEAN *eptr_automatic_nak_processing)
{
	char negotiation_required_string[30];
	char automatic_nak_processing_string[14];
	char negotiable_string[14];
	BYTE number_of_fields_scanned;
	char *cptr_value;

	number_of_fields_scanned = 0x00;

	cptr_value = parse_ppp_option_line (cptr_option_string,cptr_return_ncp_name,cptr_return_option_name,
		bptr_return_option_number,automatic_nak_processing_string,negotiation_required_string,negotiable_string,
		&number_of_fields_scanned);

	if (number_of_fields_scanned != 6)
		{
		ppp_printf (PPP_ALARM_PRINTF,"Illegal Number of PPP Options %02x Entered %s!!!\r\n",number_of_fields_scanned,
			cptr_option_string);

		return (FAIL);
		}

	if (strstr (negotiation_required_string,"Not") != NULL)
		{
		*eptr_negotiation_required = FALSE;
		}
	else
		{
		*eptr_negotiation_required = TRUE;
		}

	if (strstr (negotiable_string,"Not") != NULL)
		{
		*eptr_negotiable = FALSE;
		}
	else
		{
		*eptr_negotiable = TRUE;
		}

	if (strstr (automatic_nak_processing_string,"Not") != NULL)
		{
		*eptr_automatic_nak_processing = FALSE;
		}
	else
		{
		*eptr_automatic_nak_processing = TRUE;
		}

	parse_option_value (cptr_value,bptr_return_data,bptr_return_length,eptr_return_value_swapped);

	return (PASS);
}
/****************************************************************************/
static char *parse_ppp_option_line (char *cptr_option_string,char *cptr_return_ncp_name,char *cptr_return_option_name,
	BYTE *bptr_return_option_number,char *cptr_automatic_nak_processing_string,char *cptr_negotiation_required_string,
	char *cptr_negotiable_string,BYTE *bptr_number_of_parameters_processed)
{
	char *cptr_parameter;
	char option_number_string[4];
	ULONG option_number;

	cptr_parameter = strtok (cptr_option_string,",\n");

	cptr_parameter = copy_parameter (cptr_return_ncp_name,cptr_parameter,bptr_number_of_parameters_processed);
	cptr_parameter = copy_parameter (cptr_return_option_name,cptr_parameter,bptr_number_of_parameters_processed);
	cptr_parameter = copy_parameter (&option_number_string[0],cptr_parameter,bptr_number_of_parameters_processed);
	cptr_parameter = copy_parameter (cptr_automatic_nak_processing_string,cptr_parameter,bptr_number_of_parameters_processed);
	cptr_parameter = copy_parameter (cptr_negotiation_required_string,cptr_parameter,bptr_number_of_parameters_processed);
	cptr_parameter = copy_parameter (cptr_negotiable_string,cptr_parameter,bptr_number_of_parameters_processed);

	sscanf (option_number_string,"%d",&option_number);
	*bptr_return_option_number = (BYTE) option_number;

	return (cptr_parameter);
}
/****************************************************************************/
char *copy_parameter (char *cptr_parameter,char *cptr_option,BYTE *bptr_number_of_parameters_processed)
{
	char *cptr_next_option;

	cptr_next_option = strtok (NULL,",\n");

	if (cptr_option != NULL)
		{
		strcpy (cptr_parameter,cptr_option);

		*bptr_number_of_parameters_processed = (BYTE) (*bptr_number_of_parameters_processed + 1);
		}

	return (cptr_next_option);
}
/****************************************************************************/
static void parse_option_value (char *cptr_value,BYTE *bptr_option_data,BYTE *bptr_length_of_all_options,
	enum BOOLEAN *eptr_return_value_swapped)
{
	char *cptr_parameter;
	BYTE number_of_value_strings_processed;
	char value_type_string[12];
	char value_string[80];
	BYTE option_length;

	number_of_value_strings_processed = 0x00;
	option_length = 0x00;
	*bptr_length_of_all_options = 0x00;

	cptr_parameter = copy_parameter (&value_type_string[0],cptr_value,&number_of_value_strings_processed);
	cptr_parameter = copy_parameter (&value_string[0],cptr_parameter,&number_of_value_strings_processed);

	while (cptr_parameter != NULL)
		{
		get_option_value (&value_type_string[0],&value_string[0],bptr_option_data,&option_length,eptr_return_value_swapped);

		*bptr_length_of_all_options = (BYTE) (*bptr_length_of_all_options + option_length);

		bptr_option_data += option_length;

		cptr_parameter = copy_parameter (&value_type_string[0],cptr_parameter,&number_of_value_strings_processed);
		cptr_parameter = copy_parameter (&value_string[0],cptr_parameter,&number_of_value_strings_processed);
		}

	get_option_value (&value_type_string[0],&value_string[0],bptr_option_data,&option_length,eptr_return_value_swapped);

	*bptr_length_of_all_options = (BYTE) (*bptr_length_of_all_options + option_length);
}
/****************************************************************************/
void get_option_value (char *value_type_string,char *value_string,BYTE *bptr_return_data,BYTE *bptr_return_length,
	enum BOOLEAN *eptr_return_value_swapped)
{
	char *value_format_string;

	if (get_option_value_type (value_type_string,value_string,bptr_return_data,bptr_return_length,eptr_return_value_swapped) ==
		TRUE)
		{
		return;
		}

	*bptr_return_length = get_size_of_numeric_string (value_type_string);

	if (strstr (value_type_string,"H") != NULL)
		{
		value_format_string = cptr_hex_values[*bptr_return_length];
		}
	else
		{
		value_format_string = "%hu";
		}

	if (*bptr_return_length > 0x00)
		{
		sscanf (value_string,value_format_string,(int *) &bptr_return_data[0],(int *) &bptr_return_data[1],
			(int *) &bptr_return_data[2],(int *) &bptr_return_data[3],(int *) &bptr_return_data[4],(int *) &bptr_return_data[5],
			(int *) &bptr_return_data[6],(int *) &bptr_return_data[7]);
		}
}
/****************************************************************************/
static enum BOOLEAN get_option_value_type (char *value_type_string,char *value_string,BYTE *bptr_return_data,
	BYTE *bptr_return_length,enum BOOLEAN *eptr_return_value_swapped)
{
	ULONG ip_address;
	ULONG size_of_string;

	if (strstr (value_type_string,"String") != NULL)
		{
		if (strlen (value_type_string) != strlen ("String"))
			{
			size_of_string = 0x00000000L;

			sscanf (value_type_string + strlen ("String"),"%u",(int *) &size_of_string);

			memset (bptr_return_data,(int) NULL,size_of_string);

			*bptr_return_length = (BYTE) size_of_string;
			}
		else
			{
			*bptr_return_length = (BYTE) strlen (value_string);
			}

		strcpy ((char *) bptr_return_data,value_string);

		return (TRUE);
		}
	else if (strstr (value_type_string,"S") != NULL)
		{
		*eptr_return_value_swapped = TRUE;
		}
	else
		{
		*eptr_return_value_swapped = FALSE;
		}

	if (strstr (value_type_string,"IP") != NULL)
		{
		ip_address = get_ip_address_string (value_string);

		memcpy (bptr_return_data,&ip_address,sizeof (ULONG));

		*bptr_return_length = sizeof (ULONG);

		return (TRUE);
		}

	return (FALSE);
}

#endif
/* Jo */
/****************************************************************************/
static BYTE get_size_of_numeric_string (enum CNF_DATA_VALUE_DATA_TYPE value_type)
{
	BYTE size_of_string;

/*	ppp_printf (PPP_ALARM_PRINTF, "PPP:value type in get %d\n", value_type) ;*/	if (value_type == H1)
		{
		size_of_string = 0x01;
		}
	else if ((value_type == H2)	|| (value_type == D2))
		{
		size_of_string = 0x02;
		}
	else if (value_type == H3)
		{
		size_of_string = 0x03;
		}
	else if ((value_type == H4) || (value_type == H4S))
		{
		size_of_string = 0x04;
		}
	else if (value_type == H6)
		{
		size_of_string = 0x06;
		}
	else if (value_type == H7)
		{
		size_of_string = 0x07;
		}
	else
		{
		size_of_string = 0x00;
		}
/*   ppp_printf (PPP_ALARM_PRINTF, "PPP: length %d\n", size_of_string) ;*/
	return (size_of_string);
}
/****************************************************************************/
static ULONG get_ip_address_string (char *cptr_ip_address_string)
{
	USHORT ip_address_array[4];
	ULONG   ret_value;

	sscanf (cptr_ip_address_string,"%03hu.%03hu.%03hu.%03hu",(int *) &ip_address_array[0],(int *) &ip_address_array[1],
		(int *) &ip_address_array[2],(int *) &ip_address_array[3]);

#ifdef RTRERROR
	ip_address_array[0] = convert_4_bytes_to_ulong ((BYTE) ip_address_array[0],(BYTE) ip_address_array[1],
		(BYTE) ip_address_array[2],(BYTE) ip_address_array[3]);
	return (ip_address_array[0]);
#endif

	ret_value = convert_4_bytes_to_ulong ((BYTE) ip_address_array[0],(BYTE) ip_address_array[1],
		(BYTE) ip_address_array[2],(BYTE) ip_address_array[3]);

	return (ret_value);

}
/****************************************************************************/
static ULONG get_my_magic_number (void)
{
	ULONG my_magic_number;

	while (TRUE)
		{
		my_magic_number = lsl_control (GET_RANDOM_NUMBER);

		if (my_magic_number != 0x00000000L)
			{
			break;
			}
		}

	return (my_magic_number);
}
/****************************************************************************/

#ifdef _BIG_PROXY_
ULONG get_ppp_configuration_table_address (void)
{
	return ((ULONG) (&ppp_configuration_table));
}
#endif

/* Kamalanath 16\08\1996 */

void ppp_dhcp_control_function (int port_num, ULONG dhcp_command, ULONG parameter_0)
{
	OPTION_LIST_ENTRY *sptr_configured_option;
   ULONG ip_address;
   port_num = port_num - ppp.number_of_lan_ports;
	
	switch (dhcp_command)
	{
		case (DHCP_SERVER_NOT_FOUND) :
			printf ("DHCP_SERVER_NOT_FOUND command to ppp_dhcp_control()\n") ;
			if (is_dhcp_client_enabled(port_num + ppp.number_of_lan_ports)) 
			{
				if (ppp.port[port_num].dhcp_status = DHCP_STATUS_DISCOVER_REQUEST_MADE);
				{
					ppp.port[port_num].dhcp_status = DHCP_STATUS_NO_OPERATION ;
				}
			}
			break ;
		
		case (DHCP_IP_ADDRESS_OBTAINED) :
			printf ("DHCP_IP_ADDRESS_OBTAINED command to ppp_dhcp_control()\n") ;
			if (is_dhcp_client_enabled(port_num + ppp.number_of_lan_ports)) 
			{
				if (ppp.port[port_num].dhcp_status == DHCP_STATUS_DISCOVER_REQUEST_MADE)
				{
					ip_address = parameter_0 ;
#ifdef __MLPPP__
					sptr_configured_option = find_matching_option (&mlppp.port[port_num].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.remote_configured,
                                                   IP_ADDRESS_OPTION_TYPE) ;
#else
					sptr_configured_option = find_matching_option (&ppp.port[port_num].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.remote_configured,
                                                   IP_ADDRESS_OPTION_TYPE) ;
#endif
					memcpy (sptr_configured_option->uptr_data, &ip_address, sizeof(ULONG)) ;
					ppp.port[port_num].dhcp_status = DHCP_STATUS_IP_ADDRESS_OBTAINED ;
				}
			}	
			break ;

		case (DHCP_LEASE_TIME_EXPIRED) :
			printf ("DHCP_LEASE_TIME_EXPIRED command to ppp_dhcp_control()\n") ;
			if (is_dhcp_client_enabled(port_num + ppp.number_of_lan_ports)) 
			{
				if (ppp.port[port_num].dhcp_status == DHCP_STATUS_IP_ADDRESS_OBTAINED)
				{
					ppp.port[port_num].dhcp_status = DHCP_STATUS_LEASE_TIME_EXPIRED ;
					ip_bring_down_ncp (port_num) ;
				}
			}
			break ;

		default :
			break ;
	}
}

static void ip_bring_down_ncp (int real_port_number)
{
	PPP_NCP_CLASS *sptr_ncp ;

#ifdef __MLPPP__
	sptr_ncp = &mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX] ;
#else
	sptr_ncp = &ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX] ;
#endif

	if ((sptr_ncp->protocol_stack_id != ILLEGAL_STACK_ID) &&
	    (sptr_ncp->enabled))
	{
		execute_ncp_state_machine (PPP_DOWN_EVENT, sptr_ncp, real_port_number, NULL, 0) ;
	}
}

/* Kamalanath 16\08\1996 */

/* Jo 6/5/99 */
#if 0
/* Srikar, Mar 17, 1997. Added the following function to inform ncp state machine from IPX module */
/* when a circuit's operational status is set to down */
enum BOOLEAN set_port_ipx_operational_state(USHORT port_number, enum BOOLEAN new_state)
{


#if VIDY_CUT
	PPP_NCP_CLASS	*sptr_ncp;
#ifdef __MLPPP__
	 sptr_ncp = &mlppp.port[port_number].ncp[PPP_IPX_NCP_STACK_INDEX];
#else
	 sptr_ncp = &ppp.port[port_number].ncp[PPP_IPX_NCP_STACK_INDEX];
#endif

	 if (sptr_ncp->enabled && ppp.port[port_number].state == PPP_OPENED_STATE)
	 {
		if (sptr_ncp->state == PPP_OPENED_STATE && new_state == FALSE)
		{
		 	execute_ncp_state_machine(PPP_DOWN_EVENT, sptr_ncp, port_number, NULL, 0);
			return TRUE;
		}
		else if (sptr_ncp->state == PPP_STARTING_STATE && new_state == TRUE)
		{
		 	execute_ncp_state_machine(PPP_UP_EVENT, sptr_ncp, port_number, NULL, 0);
			return TRUE;
		}
		else
			return FALSE;
	 }
	 else
	 	return FALSE;
#else
	return FALSE;
#endif
}

/* Srikar, Apr 11, 1997. Added the following function to access the operational state of wan ports */
enum BOOLEAN get_port_ipx_operational_state(USHORT port_number)
{

#if VIDY_CUT
#ifdef __MLPPP__
	 if (mlppp.port[port_number].ncp[PPP_IPX_NCP_STACK_INDEX].state == PPP_OPENED_STATE)
#else
	 if (ppp.port[port_number].ncp[PPP_IPX_NCP_STACK_INDEX].state == PPP_OPENED_STATE)
#endif
	 	return TRUE;
	else
		return FALSE;
#else
	return FALSE;
#endif
}
#endif
/* Jo 6/5/99 */


/* Jo 24/07/98 : reads the PPP configuration from flash into PPP_CLASS 
					  starting from the location specified by cptr_config */

int ppp_read_configuration (char *cptr_config)
{
	 CNF_PPP *ppp_ptr ;
	 USHORT port_index ;
	 BYTE	temp_option_buffer[19] ; 	
	 CNF_PPP_OPTION *temp_option_ptr = (CNF_PPP_OPTION *) temp_option_buffer ;
	 int temp_len = 0 ;
	 ppp_ptr = (CNF_PPP *)cptr_config ;
	 if (ppp_ptr->ppp_header.magic_number != CNF_PPP_MAGIC_NUMBER)
			return (0) ;

	 ppp.number_of_ppp_ports = ppp_ptr->ppp_header.number_of_ports ;
	 ppp.need_to_dial_out_initially = ppp_ptr->ppp_header.need_to_dial_out_initially ;
    ppp.maximum_number_of_configuration_requests = 6 ;
	 ppp.maximum_number_of_termination_requests = 10 ;
	 ppp.maximum_number_of_unacknowledged_echo_requests = 6 ;
	 ppp.maximum_configuration_request_send_interval = 5 ;
	 ppp.maximum_termination_request_send_interval = 5 ;
	 ppp.maximum_configuration_request_backoff_interval = 10 ;
	 ppp.printing_enabled = ppp_ptr->ppp_header.printf ;
	 ppp.ncp_printing_enabled = ppp_ptr->ppp_header.printf_NCP ;
	 ppp.lcp_printing_enabled = ppp_ptr->ppp_header.printf_LCP ;
	 ppp.alarm_printing_enabled = ppp_ptr->ppp_header.printf_alarm ;

	 for (port_index = 0; port_index < ppp.number_of_ppp_ports; port_index++)
	 {
		ppp.port[port_index].enabled = ppp_ptr->ppp_ports[port_index].enabled ;		

		strcpy (ppp.port[port_index].authentication.user_name, ppp_ptr->ppp_ports[port_index].user_name) ;
		strcpy (ppp.port[port_index].authentication.password, ppp_ptr->ppp_ports[port_index].user_password) ;   
		ppp.port[port_index].lcp_mibs.pppLinkStatusLocalMRU = 1500 ;
		ppp.port[port_index].lcp_mibs.pppLinkStatusRemoteMRU = 1500 ;
		ppp.port[port_index].authentication.maximum_number_of_retries = 5 ;
		ppp.port[port_index].configuration.enabled.send_id = FALSE ;
		ppp.port[port_index].configuration.enabled.time_remaining = FALSE ;
		strcpy (ppp.port[port_index].configuration.tx_identification_message, "Multi-Tech Systems") ;
		mlppp.port[port_index].ncp[PPP_IP_NCP_STACK_INDEX].enabled = TRUE ;   

		if (ppp_ptr->ppp_ports[port_index].lcp_epd.valid == 1)
		  mlppp.enabled = TRUE ;
		else
		  mlppp.enabled = FALSE ;
		ppp.port[port_index].configuration.link_quality_reporting_interval = 100 ;
		ppp.port[port_index].authentication.timeout = 5 ;
		ppp.port[port_index].dial_on_demand = ppp_ptr->ppp_ports[port_index].connection_dod ;
		ppp.port[port_index].idle_timeout = (ULONG)ppp_ptr->ppp_ports[port_index].hangup_time ;
		ppp.port[port_index].async.enabled = TRUE ;
		ppp.port[port_index].client_only = ppp_ptr->ppp_ports[port_index].remote_port_client_only ;

	 	add_ppp_option (&ppp_ptr->ppp_ports[port_index].lcp_accm, "LCP", "ACCM", port_index, FALSE) ;
	   add_ppp_option (&ppp_ptr->ppp_ports[port_index].remote_lcp_accm, "LCP", "ACCM", port_index, TRUE) ;
	 	add_ppp_option (&ppp_ptr->ppp_ports[port_index].lcp_mru, "LCP", "MRU", port_index, FALSE) ;
	 	add_ppp_option (&ppp_ptr->ppp_ports[port_index].remote_lcp_mru, "LCP", "MRU", port_index, TRUE) ;
		if (ppp_ptr->ppp_ports[port_index].authentication_type == 0) 
		{
		 	add_ppp_option (&ppp_ptr->ppp_ports[port_index].remote_lcp_authentication, "LCP", "Authentication (PAP)", port_index, TRUE) ;
		 	add_ppp_port_ras_option (&ppp_ptr->ppp_ports[port_index].ras_lcp_authentication, "LCP", "Authentication (PAP)", port_index, FALSE) ;
		}
		else
			if (ppp_ptr->ppp_ports[port_index].authentication_type == 1)
			{
			 	add_ppp_option (&ppp_ptr->ppp_ports[port_index].remote_lcp_authentication, "LCP", "Authentication (CHAP)", port_index, TRUE) ;
		 		add_ppp_port_ras_option (&ppp_ptr->ppp_ports[port_index].ras_lcp_authentication, "LCP", "Authentication (PAP)", port_index, FALSE) ;
			}
			else
				if (ppp_ptr->ppp_ports[port_index].authentication_type == 2)
				{
				 	add_ppp_option (&ppp_ptr->ppp_ports[port_index].remote_lcp_authentication, "LCP", "Authentication (PAP/CHAP)", port_index, TRUE) ;
				 	add_ppp_port_ras_option (&ppp_ptr->ppp_ports[port_index].ras_lcp_authentication, "LCP", "Authentication (PAP)", port_index, FALSE) ;
				}
	 	add_ppp_option (&ppp_ptr->ppp_ports[port_index].lcp_magic_number, "LCP", "Magic Number", port_index, FALSE) ;
	 	add_ppp_option (&ppp_ptr->ppp_ports[port_index].remote_lcp_magic_number, "LCP", "Magic Number", port_index, TRUE) ;
	 	add_ppp_option (&ppp_ptr->ppp_ports[port_index].ipcp_ip_address, "IPCP", "IP Address", port_index, FALSE) ;
	 	add_ppp_option (&ppp_ptr->ppp_ports[port_index].remote_ipcp_ip_address, "IPCP", "IP Address", port_index, TRUE) ;
#ifdef __MLPPP__
	 	add_ppp_option (&ppp_ptr->ppp_ports[port_index].lcp_epd, "LCP", "EPD", port_index, FALSE) ;
	 	add_ppp_option (&ppp_ptr->ppp_ports[port_index].remote_lcp_epd, "LCP", "EPD", port_index, TRUE) ;
	 	add_ppp_option (&ppp_ptr->ppp_ports[port_index].lcp_mrru, "LCP", "MRRU", port_index, FALSE) ;
	 	add_ppp_option (&ppp_ptr->ppp_ports[port_index].remote_lcp_mrru, "LCP", "MRRU", port_index, TRUE) ;
#endif
	 	add_ppp_option (&ppp_ptr->ppp_ports[port_index].remote_lcp_callback, "LCP", "CallBack", port_index, TRUE) ;
	 	add_ppp_option (&ppp_ptr->ppp_ports[port_index].ipcp_dns_address1, "IPCP", "IP Address", port_index, FALSE) ;
	 	add_ppp_option (&ppp_ptr->ppp_ports[port_index].ipcp_dns_address2, "IPCP", "IP Address", port_index, FALSE) ;

	 	add_ppp_port_ras_option (&ppp_ptr->ppp_ports[port_index].ras_remote_ipcp_dns_address1, "IPCP", "IP Address", port_index, TRUE) ;
	 	add_ppp_port_ras_option (&ppp_ptr->ppp_ports[port_index].ras_remote_ipcp_dns_address2, "IPCP", "IP Address", port_index, TRUE) ;
	 	add_ppp_port_ras_option (&ppp_ptr->ppp_ports[port_index].ras_ipcp_ip_address, "IPCP", "IP Address", port_index, FALSE) ;
	 	add_ppp_port_ras_option (&ppp_ptr->ppp_ports[port_index].ras_remote_ipcp_ip_address, "IPCP", "IP Address", port_index, TRUE) ;
	 }

#if PRINT_CONFIG
	 print_ppp_configured_parameters () ;
	 print_ppp_options(&ppp.port[0].option_lists.configured) ;
	 print_ppp_options(&ppp.port[0].option_lists.remote_configured) ;
	 print_ppp_options(&mlppp.port[0].ncp[0].option_lists.configured) ;
	 print_ppp_options(&mlppp.port[0].ncp[0].option_lists.remote_configured) ;
#endif
	 return (ppp_ptr->ppp_header.section_length) ;
}

/* Jo 19/04/99 */
#if PRINT_CONFIG
void print_ppp_configured_parameters ()
{
	 char buffer1[1300], buffer2[1300] ;

	 sprintf (buffer1, "no of ports : %lu\n"
				 "need to dial out initially : %d\n"
				 "max no of config requests : %lu\n"
				 "max no of terminate requests : %lu\n"
				 "max no of unack echo requests : %lu\n"
				 "max no of config request send interval : %lu\n"
				 "max no of terminate request send interval: %lu\n"
				 "max no of config request backoff interval: %lu\n"
				 "printing enabled : %d\n"
				 "NCP printing enabled : %d\n"
				 "LCP printing enabled : %d\n"
				 "ALARM printing enabled : %d\n"
				 "PORT 1 enabled : %d\n"
				 "user name : %s\n"
				 "user password : %s\n"
				 "Local MRU : %lu\n"
				 "Remote MRU : %lu\n"
				 "authentication max retries : %d\n"
				 "send id : %d\n"
				 "time remaining : %d\n"
				 "identification msg : %s\n"
				 "mlppp : %d\n"
				 "link quality reporting time : %lu\n"
				 "authentication timeout : %lu\n"
				 "DOD : %d\n"
				 "idle timeout : %lu\n"
				 "async enabled : %d\n",
				 ppp.number_of_ppp_ports,
				 ppp.need_to_dial_out_initially,
				 ppp.maximum_number_of_configuration_requests,
				 ppp.maximum_number_of_termination_requests,
				 ppp.maximum_number_of_unacknowledged_echo_requests,
				 ppp.maximum_configuration_request_send_interval,
				 ppp.maximum_termination_request_send_interval,
				 ppp.maximum_configuration_request_backoff_interval,
				 ppp.printing_enabled,
				 ppp.ncp_printing_enabled,
				 ppp.lcp_printing_enabled,
				 ppp.alarm_printing_enabled,
				 ppp.port[0].enabled,
				 ppp.port[0].authentication.user_name,
				 ppp.port[0].authentication.password,
				 ppp.port[0].lcp_mibs.pppLinkStatusLocalMRU, 
				 ppp.port[0].lcp_mibs.pppLinkStatusRemoteMRU,
				 ppp.port[0].authentication.maximum_number_of_retries,
				 ppp.port[0].configuration.enabled.send_id,
				 ppp.port[0].configuration.enabled.time_remaining,
				 ppp.port[0].configuration.tx_identification_message,
				 mlppp.port[0].ncp[0].enabled,
				 ppp.port[0].configuration.link_quality_reporting_interval,
				 ppp.port[0].authentication.timeout,
				 ppp.port[0].dial_on_demand,
				 ppp.port[0].idle_timeout,
				 ppp.port[0].async.enabled) ;

	 sprintf (buffer2, "PORT 1 enabled : %d\n"
				 "user name : %s\n"
				 "user password : %s\n"
				 "Local MRU : %lu\n"
				 "Remote MRU : %lu\n"
				 "authentication max retries : %d\n"
				 "send id : %d\n"
				 "time remaining : %d\n"
				 "identification msg : %s\n"
				 "mlppp : %d\n"
				 "link quality reporting time : %lu\n"
				 "authentication timeout : %lu\n"
				 "DOD : %d\n"
				 "idle timeout : %lu\n"
				 "async enabled : %d\n"
	 			 "PORT 2 enabled : %d\n"
				 "user name : %s\n"
				 "user password : %s\n"
				 "Local MRU : %lu\n"
				 "Remote MRU : %lu\n"
				 "authentication max retries : %d\n"
				 "send id : %d\n"
				 "time remaining : %d\n"
				 "identification msg : %s\n"
				 "mlppp : %d\n"
				 "link quality reporting time : %lu\n"
				 "authentication timeout : %lu\n"
				 "DOD : %d\n"
				 "idle timeout : %lu\n"
				 "async enabled : %d\n",
				 ppp.port[1].enabled,
				 ppp.port[1].authentication.user_name,
				 ppp.port[1].authentication.password,
				 ppp.port[1].lcp_mibs.pppLinkStatusLocalMRU, 
				 ppp.port[1].lcp_mibs.pppLinkStatusRemoteMRU,
				 ppp.port[1].authentication.maximum_number_of_retries,
				 ppp.port[1].configuration.enabled.send_id,
				 ppp.port[1].configuration.enabled.time_remaining,
				 ppp.port[1].configuration.tx_identification_message,
				 mlppp.port[1].ncp[0].enabled,
				 ppp.port[1].configuration.link_quality_reporting_interval,
				 ppp.port[1].authentication.timeout,
				 ppp.port[1].dial_on_demand,
				 ppp.port[1].idle_timeout,
				 ppp.port[1].async.enabled,
				 ppp.port[2].enabled,
				 ppp.port[2].authentication.user_name,
				 ppp.port[2].authentication.password,
				 ppp.port[2].lcp_mibs.pppLinkStatusLocalMRU, 
				 ppp.port[2].lcp_mibs.pppLinkStatusRemoteMRU,
				 ppp.port[2].authentication.maximum_number_of_retries,
				 ppp.port[2].configuration.enabled.send_id,
				 ppp.port[2].configuration.enabled.time_remaining,
				 ppp.port[2].configuration.tx_identification_message,
				 mlppp.port[2].ncp[0].enabled,
				 ppp.port[2].configuration.link_quality_reporting_interval,
				 ppp.port[2].authentication.timeout,
				 ppp.port[2].dial_on_demand,
				 ppp.port[2].idle_timeout,
				 ppp.port[2].async.enabled) ;

	 printf ("buffer1 : %s\n", buffer1) ;
	 printf ("buffer2 : %s\n", buffer2) ;

}

void print_ppp_options(OPTION_LIST *sptr_option_list)
{
	 OPTION_LIST_ENTRY *sptr_matching_option = NULL ;

	 for (sptr_matching_option = sptr_option_list->sptr_forward_link; sptr_matching_option != NULL;
		sptr_matching_option = sptr_matching_option->sptr_forward_link)
    { 
		ppp_printf (PPP_ALARM_PRINTF,"PPP: option_name %s\n", sptr_matching_option->cptr_option_name) ;
		ppp_printf (PPP_ALARM_PRINTF,"PPP: option_type %d\n", sptr_matching_option->type.generic) ;
		ppp_printf (PPP_ALARM_PRINTF,"PPP: option_data %lu\n", sptr_matching_option->uptr_data) ;
		if (sptr_matching_option->automatic_nak_processing == TRUE)
				ppp_printf (PPP_ALARM_PRINTF,"PPP: automatic_nak_processing %d\n", 1) ;
		else
				ppp_printf (PPP_ALARM_PRINTF,"PPP: automatic_nak_processing %d\n", 0) ;
		if (sptr_matching_option->negotiation_required == TRUE)
				ppp_printf (PPP_ALARM_PRINTF,"PPP: negotiation_required %d\n", 1) ;
		else
				ppp_printf (PPP_ALARM_PRINTF,"PPP: negotiation_required %d\n", 0) ;
		if (sptr_matching_option->negotiable == TRUE)
				ppp_printf (PPP_ALARM_PRINTF,"PPP: negotiable %d\n", 1) ;
		else
				ppp_printf (PPP_ALARM_PRINTF,"PPP: negotiable %d\n", 0) ;
	 }
}
#endif
