#include	"defs.h"
/*	$Modname: pppinit.c$  $version: 1.47$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 11/11/93 ross Initial version.
1.1 12/10/93 ross Inserted function ppp_return_buffer_to_device_driver
1.2 01/05/94 ross Added get_nvram_configuration function to get the configuration.
1.3 01/05/94 keyur added version control support
1.4 01/05/94 keyur No major change is made in this release.
1.5 01/20/94 keyur Reshuffled some of the initialization parameters.
1.6 01/28/94 keyur LCP and NCP statistics was added and some more initialization parameters added.
1.7 02/01/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John. Ch
1.8 02/02/94 keyur This version has been unchanged except a carraiage return from the previous one
1.9 02/02/94 keyur This version has been unchanged except a carriage return from the previous one.
1.10 02/22/94 keyur Moved statistics initialization at its proper place.
1.11 02/28/94 keyur deleted the function call get_nvram_configuration and updated to new nvram style
1.12 03/09/94 keyur There is no change from its previous version.
1.13 03/09/94 keyur Added function call for getting number of lan ports.
1.14 03/09/94 keyur Deleted C++ comment.
1.15 03/23/94 keyur Added ini parameters for Async PPP.
1.16 03/24/94 keyur Deleted dummy port number parameter.
1.17 03/26/94 keyur Added and tested Asynchronous Support and ATCP for Appletalk Support
1.18 03/26/94 keyur Ran Lint compiler and code style program and got rid of unnecessary warnings
1.19 04/04/94 keyur Cosmetic Changes while documenting
1.20 04/04/94 keyur Assigned appletalk stack id to ILLEGAL_STACK_ID, after the testing.
1.21 04/12/94 keyur Added State Machine support for LCP according to RFC1548
1.22 04/13/94 keyur Added support for NCP state machine
1.23 04/19/94 keyur Added ordering of options for LCP and NCP, courtesy of John
1.24 05/02/94 keyur
1.25 05/02/94 keyur took out memcheck header file.
1.26 06/15/94 keyur added __LSL__ conditional compile.
1.27 06/23/94 ross Put in reinitialize ppp for dialers.  Courtesy of Lori.
1.28 07/18/94 ross general cleanup with options, added header compression, accm features.
1.29 08/11/94 ross adding rfc1570 lcp support
1.30 08/24/94 ross adding new ncps.
1.31 08/30/94 ross added registration functions for vj and cipx.
1.32 09/06/94 ross altered cipx registration function.
1.33 09/29/94 ross fixes for Chap, courtesy of Danny.  Added STP and Netbios.
1.34 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.35 11/04/94 ross Testing against net manage ppp.  VJC testing.
1.36 12/02/94 ross testing NT3.5 RAS
1.37 12/03/94 ross testing Windows 95 RAS
1.38 12/05/94 ross dynamic option support.  Portions courtesy of Dan.
1.39 12/13/94 ross connected to NT RAS with Netbios
1.40 01/26/95 ross changes for rwutils
1.41 01/30/95 ross removing duplicate configuration options
1.42 02/27/95 ross dynamic load changes including lsl_control.
1.43 03/03/95 ross added up calls.
1.44 03/10/95 ross general fixes.  see change.doc
1.45 05/15/95 ross changed OPEN_DEVICE_DRIVER_PORT to allow going from disabled to enabled.
1.46 06/26/95 ross initial version of BCP
1.47 10/19/95 biao added Compression Control Protocol (CCP) support. Please refer to change.doc for details.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#define GLOBAL_FILE

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include "ppp.h"
#include <udb.h>
#include "wanmgr.h"
#include <softquot.h>

extern enum BOOLEAN is_wan_port_answering (USHORT port_number) ;
extern char *process_back_slash (char *) ;

/* Kamalnath SLIP 18\03\1997 */
extern enum BOOLEAN is_wan_port_answering (USHORT port_number) ;
extern ULONG get_ip_remote_address (USHORT) ;
/* Jo enum BOOLEAN check_if_slip_on_is_set_to_true(USHORT port_number);*/
enum BOOLEAN check_if_slip_is_enabled(USHORT port_number);

extern BYTE is_dialing_initiated_by_this_end (USHORT port_number);
extern enum BOOLEAN is_remote_access_enabled_on_port (USHORT port_number);

/* Kamalnath SLIP 18\03\1997 */


extern BYTE is_remote_access_client_active (USHORT port_number);
extern void ppp_port_down_by_no_demand (real_port_number) ;

extern enum BOOLEAN is_dial_out_initially_is_needed(); /* sudha 1 Dec 1998 */

/****************************************************************************/
static void initialize_ppp_ports (void);
static void	stack_has_been_registered (char *cptr_stack_name,ULONG protocol_stack_id);
static void ppp_open_device_driver (void);
static void ppp_open_device_driver_port (USHORT port_number);
static void ppp_close_device_driver (void);
static void ppp_close_device_driver_port (USHORT port_number);
void free_lcp_and_ncp_option_lists (USHORT port_number);
#if defined (CCP)
	void free_ccp_option_lists (USHORT real_port_number);
	static ULONG get_device_driver_id (USHORT real_port_number);
	static ULONG get_maximum_number_of_termination_requests (void);
	static ULONG get_ppp_remote_MRU (USHORT real_port_number);
	static OPTION_LISTS *get_ccp_option_lists_created_by_ppp (USHORT real_port_number);
	void initialize_ccp_tx_accepted_option_list(USHORT port_number);
	extern	void reset_ccp_state_machine(USHORT port_number);
#endif
static ULONG ppp_register_serial_device_driver (USHORT port_number,LOW_LEVEL_DEVICE_DRIVER_API *sptr_serial_driver_api);
void initialize_ppp_snmp_static_information(USHORT real_port_number);
extern void cipx_reset_connection_states (USHORT port_number);
extern void vjc_reset_connection_states (USHORT port_number);
extern void ppp_debug_information();
/*************************************************************************/ 
#if defined (_MSC_VER)
/*************************************************************************/ 

ULONG routerware_control (enum ROUTERWARE_CONTROL_OPERATION command,...)
{
	va_list argptr;
	ULONG return_value;
	ULONG parameter[10];
	BYTE parameter_index;

	check_for_ppp_initialization_breakpoint ();

	va_start (argptr,command);

	for (parameter_index = 0x00; parameter_index < 6; parameter_index = (BYTE) (parameter_index + 1))
		parameter[parameter_index] = va_arg (argptr,ULONG);

	return_value = 0x00000000L;

	switch (command)
	{
		case RW_INITIALIZE:
			
			return_value = (ULONG) initialize_ppp (parameter[0x00]);
			
			break;
		
		case RW_GET_CLASS_ADDRESS:
			
			return_value = (ULONG) &ppp;
			
			break;
		
		case RW_GET_CLASS_SIZE:
			
			return_value = sizeof (ppp);
			
			break;
		
		case RW_GET_CONFIGURATION_TABLE_ADDRESS:
			
			return_value = get_ppp_configuration_table_address ();
			
			break;
		}

	return (return_value);
}
#endif

/****************************************************************************/

#if 0 /* Jo 04/06/99 */
enum TEST initialize_ppp (ULONG clock_ticks_per_second)
{
	int real_port_number, protocol_stack_index;

/* Jo	initialize_ppp_config_parameters ();
	initialize_ppp_port_config_parameters ();  */

#if 0
/* Jo 04/06/99 Added for RAS */
	initialize_user_database () ;
#endif 
	for (real_port_number = 0 ; real_port_number < ppp.number_of_ppp_ports ; real_port_number++)
	{
		for (protocol_stack_index = 0x00 ; protocol_stack_index < NUMBER_OF_NCP_STACKS ;
		     protocol_stack_index = (BYTE) (protocol_stack_index + 1))
		{
#ifdef __MLPPP__
			mlppp.port[real_port_number].ncp[protocol_stack_index].configured =
			mlppp.port[real_port_number].ncp[protocol_stack_index].enabled ;
#else
			ppp.port[real_port_number].ncp[protocol_stack_index].configured =
			ppp.port[real_port_number].ncp[protocol_stack_index].enabled ;
#endif
		}
/* Copy the configured proxy IPCP address options */

/* Jo No RAS include later */

	}

	for (real_port_number = 0 ; real_port_number < ppp.number_of_ppp_ports ; real_port_number++)
	{
/* sudha 30 Nov 1998... */
		if ( (is_dial_out_initially_is_needed() == FALSE) && 
				(trigger_port_open[real_port_number] == REQUIRED))
			trigger_port_open[real_port_number]	= INITIALLY_NOT_REQUIRED ;
/* ...sudha 30 Nov 1998 */
   }

#ifdef __MLPPP__ /* Sachin - 5th Nov. 1997 */
   /* Set this field depending on whether the epd option is present
   for port 0 */
   if (find_matching_option (&ppp.port[0].option_lists.configured,
	                                    LCP_ENDPOINT_DISCRIMINATOR))
      mlppp.enabled = TRUE ;
   else
      mlppp.enabled = FALSE ;

   if (mlppp.enabled)
   {
#ifdef CCP
      ppp.ccp.enabled = FALSE ;
#endif
/*      printf ("PPP: MLPPP enabled, Disabling CCP\n") ;*/
   }
#endif

	ppp.number_of_lan_ports = (USHORT) lsl_control (GET_NUMBER_OF_LAN_PORTS);

	ppp_register_event_upcall (ppp_event_upcall_example);

	if (ppp.number_of_ppp_ports == 0x0000)
		{
		return (PASS);
		}

	ppp.clock_ticks_per_second = clock_ticks_per_second;

#if defined (CCP)
	if (ppp.ccp.enabled == TRUE)
		{
		initialize_ccp (ppp.number_of_ppp_ports, 
			&ppp.ccp.fptr_execute_ccp_state_machine_function,	
			&ppp.ccp.fptr_get_sender_compression_function_function, 
			&ppp.ccp.fptr_get_receiver_decompression_function_function,
			&ppp.ccp.fptr_ccp_timer_routine, 
			&ppp.ccp.fptr_ccp_packet_received_function, 
			&ppp.ccp.fptr_get_ccp_option_lists_function,
			&ppp.ccp.fptr_get_ccp_state_function, 
			&ppp.ccp.fptr_get_sender_compression_database_initialization_status_function,
			&ppp.ccp.fptr_get_receiver_compression_database_initialization_status_function,
			&ppp.ccp.fptr_get_ccp_port_status_function,
			&ppp.ccp.fptr_get_last_id_of_ccp_packet_sent_function, 
			
			get_device_driver_id, 
			get_maximum_number_of_termination_requests,
			get_ppp_remote_MRU, 
			get_ccp_option_lists_created_by_ppp);
		}
#endif

	initialize_ppp_ports ();

#ifdef __MLPPP__
   initialize_mlppp_ports ();
#endif /*__MLPPP__*/
   register_debugger(ppp_debug_information, "PPP INFO");

	return (PASS);
}
#endif 

enum TEST initialize_ppp (ULONG clock_ticks_per_second)
{
	int real_port_number, protocol_stack_index ;
	OPTION_LIST_ENTRY *sptr_option_list_entry;
	
/* Jo 04/06/99 Added for RAS */
	initialize_user_database () ;

	for (real_port_number = 0 ; real_port_number < ppp.number_of_ppp_ports ; real_port_number++)
	{
/* sudha 30 Nov 1998 */
/* Jo 28/06/99 Added for RAS */
		if (is_proxy_enabled_only_port(real_port_number) == TRUE)
		{
			if ((is_dial_out_initially_is_needed() == FALSE) && 
				(trigger_port_open[real_port_number] == REQUIRED))
					trigger_port_open[real_port_number]	= INITIALLY_NOT_REQUIRED ;
		}
/* Jo 28/06/99 Added for RAS */

		for (protocol_stack_index = 0x00 ; protocol_stack_index < NUMBER_OF_NCP_STACKS ;
		     protocol_stack_index = (BYTE) (protocol_stack_index + 1))
		{
#ifdef __MLPPP__
			mlppp.port[real_port_number].ncp[protocol_stack_index].configured =
			mlppp.port[real_port_number].ncp[protocol_stack_index].enabled ;
#else
			ppp.port[real_port_number].ncp[protocol_stack_index].configured =
			ppp.port[real_port_number].ncp[protocol_stack_index].enabled ;
#endif
		}
/* Copy the configured proxy IPCP address options */

#ifndef __MLPPP__
/* Introduced by Naveen 30/6/1998 */
		ppp.port[real_port_number].expecting_ras_link_coming_up = FALSE;
		ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_proxy_ipcp_remote_address_option = 
			find_matching_option (&ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.remote_configured, 
					IP_ADDRESS_OPTION_TYPE);
/* Initialize the ras_option_list_entry RAS option list */
		ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_ras_ipcp_remote_address_option = 
			find_matching_option (&ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].ras_option_lists.remote_configured, 
					IP_ADDRESS_OPTION_TYPE);

		ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_proxy_ipcp_local_address_option = 
			find_matching_option (&ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.configured, 
					IP_ADDRESS_OPTION_TYPE);
/* Initialize the ras_option_list_entry RAS option list */
		ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_ras_ipcp_local_address_option = 
			find_matching_option (&ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].ras_option_lists.configured, 
					IP_ADDRESS_OPTION_TYPE);
#else
/* Introduced by Naveen 30/6/1998 */
		mlppp.port[real_port_number].expecting_ras_link_coming_up = FALSE;
		sptr_option_list_entry = 
			find_matching_option (&mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.remote_configured, 
					IP_ADDRESS_OPTION_TYPE);

/* printf("1: %08x\n", &mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_proxy_ipcp_remote_address_option ); */
		if (sptr_option_list_entry)
			mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_proxy_ipcp_remote_address_option = 
					duplicate_option (sptr_option_list_entry);
		
/* Initialize the ras_option_list_entry RAS option list */
		sptr_option_list_entry = 
			find_matching_option (&mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].ras_option_lists.remote_configured, 
					IP_ADDRESS_OPTION_TYPE);
/* printf("2: %08x\n", &mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_ras_ipcp_remote_address_option ); */
		if (sptr_option_list_entry)
			mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_ras_ipcp_remote_address_option = 
				duplicate_option (sptr_option_list_entry); 
		
		sptr_option_list_entry = 
			find_matching_option (&mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.configured, 
					IP_ADDRESS_OPTION_TYPE);
/* printf("3: %08x\n", &mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_proxy_ipcp_local_address_option ); */
		if (sptr_option_list_entry)
				mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_proxy_ipcp_local_address_option = 
					duplicate_option (sptr_option_list_entry); 
			
/* Initialize the ras_option_list_entry RAS option list */
		sptr_option_list_entry = 
			find_matching_option (&mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].ras_option_lists.configured, 
					IP_ADDRESS_OPTION_TYPE);
/* printf("4: %08x\n", &mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_ras_ipcp_local_address_option ); */
		if (sptr_option_list_entry)
			mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_ras_ipcp_local_address_option = 
				duplicate_option (sptr_option_list_entry);


		sptr_option_list_entry = 
			find_matching_option (&mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.remote_configured, 
					IP_PRIMARY_DNS_OPTION_TYPE);

		if (sptr_option_list_entry)
			mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_proxy_dns_pri_server_remote_address_option = 
				duplicate_option (sptr_option_list_entry);
/*		printf ("RASDNS1: %08x\n",sptr_option_list_entry); */

		sptr_option_list_entry = 
			find_matching_option (&mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].ras_option_lists.remote_configured, 
					IP_PRIMARY_DNS_OPTION_TYPE);

		if (sptr_option_list_entry)
			mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_ras_dns_pri_server_remote_address_option = 
				duplicate_option (sptr_option_list_entry);
/*		printf ("RASDNS2: %08x\n",sptr_option_list_entry); */
	
	
		sptr_option_list_entry = 
			find_matching_option (&mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.remote_configured, 
					IP_SECONDARY_DNS_OPTION_TYPE);

		if (sptr_option_list_entry)
			mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_proxy_dns_sec_server_remote_address_option = 
				duplicate_option (sptr_option_list_entry);
/*		printf ("RASDNS3: %08x\n",sptr_option_list_entry); */

		sptr_option_list_entry = 
			find_matching_option (&mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].ras_option_lists.remote_configured, 
					IP_SECONDARY_DNS_OPTION_TYPE);

		if (sptr_option_list_entry)
			mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_ras_dns_sec_server_remote_address_option = 
				duplicate_option (sptr_option_list_entry);
/*		printf ("RASDNS4: %08x\n",sptr_option_list_entry); */
		
		sptr_option_list_entry = 
			find_matching_option (&ppp.port[real_port_number].option_lists.remote_configured, LCP_AUTHENTICATION_PROTOCOL); 
		
		if (sptr_option_list_entry)
			ppp.port[real_port_number].sptr_proxy_remote_authentication = 
				duplicate_option (sptr_option_list_entry);
		else
			printf ("PPP: PROXY Remote Authentication is NULL for port %d\n", real_port_number);

		sptr_option_list_entry = 
			find_matching_option (&ppp.port[real_port_number].ras_option_lists.configured, LCP_AUTHENTICATION_PROTOCOL); 

		if (sptr_option_list_entry)
			ppp.port[real_port_number].sptr_ras_local_authentication = 
				duplicate_option (sptr_option_list_entry);
/*		else
			printf ("RAS Local Option is NULL\n"); */

/* Jo 23/09/99 Added to fix Initial Need To Dial Out problem when port type is Proxy/RAS */

	if (is_wan_port_answering (real_port_number) ||
		((is_dial_out_initially_is_needed() == FALSE) && 
		(trigger_port_open[real_port_number] == REQUIRED) &&
		((is_wan_port_answering (real_port_number) == FALSE) && 
			ppp.port[real_port_number].client_only)))
	{
/* Jo 23/09/99 Added to fix Initial Need To Dial Out problem when port type is Proxy/RAS */

/* Introduced by Naveen 30/6/1998 */
		mlppp.port[real_port_number].expecting_ras_link_coming_up = TRUE;

		sptr_option_list_entry = 
			find_matching_option (&ppp.port[real_port_number].option_lists.remote_configured, LCP_AUTHENTICATION_PROTOCOL); 

		if (sptr_option_list_entry)
		{
/*			printf ("PPP: Removing entry from existig list\n"); */
			delete_entry_from_option_list (&ppp.port[real_port_number].option_lists.remote_configured, 
				sptr_option_list_entry);
		}

		add_new_lcp_option_to_list (&ppp.port[real_port_number].option_lists.configured,
				ppp.port[real_port_number].sptr_ras_local_authentication);		
		
/*	 	printf("1: %08x\n", &mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_proxy_ipcp_remote_address_option);  */

/*		printf("2: %08x\n", &mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_proxy_ipcp_local_address_option);  */

		replace_configuration_option (&mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.remote_configured,
			mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_ras_ipcp_remote_address_option,
			OPTION_DEFAULT_STATE);

		replace_configuration_option (&mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.configured,
			mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_ras_ipcp_local_address_option,
			OPTION_DEFAULT_STATE);

		replace_configuration_option (&mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.remote_configured,
			mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_ras_dns_pri_server_remote_address_option,
			OPTION_DEFAULT_STATE);
		replace_configuration_option (&mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.remote_configured,
			mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].sptr_ras_dns_sec_server_remote_address_option,
			OPTION_DEFAULT_STATE);

		copy_remote_configuration_options_to_tx_accepted_list (&ppp.port[real_port_number].option_lists);
	}			
#endif		
	

	}

/* Jo 04/06/99 Added for RAS */

#ifdef __MLPPP__ /* Sachin - 5th Nov. 1997 */
   /* Set this field depending on whether the epd option is present
   for port 0 */
   if (find_matching_option (&ppp.port[0].option_lists.configured,
	                                    LCP_ENDPOINT_DISCRIMINATOR))
      mlppp.enabled = TRUE ;
   else
      mlppp.enabled = FALSE ;

   if (mlppp.enabled)
   {
#if defined (CCP)
      ppp.ccp.enabled = FALSE ;
      printf ("PPP: MLPPP enabled, Disabling CCP\n") ;
#endif
   }
#endif

	ppp.number_of_lan_ports = (USHORT) lsl_control (GET_NUMBER_OF_LAN_PORTS);

	ppp_register_event_upcall (ppp_event_upcall_example);

	if (ppp.number_of_ppp_ports == 0x0000)
		return (PASS);

	ppp.clock_ticks_per_second = clock_ticks_per_second;

#if defined (CCP)
	if (ppp.ccp.enabled == TRUE)
		{
		initialize_ccp (ppp.number_of_ppp_ports, 
			&ppp.ccp.fptr_execute_ccp_state_machine_function,	
			&ppp.ccp.fptr_get_sender_compression_function_function, 
			&ppp.ccp.fptr_get_receiver_decompression_function_function,
			&ppp.ccp.fptr_ccp_timer_routine, 
			&ppp.ccp.fptr_ccp_packet_received_function, 
			&ppp.ccp.fptr_get_ccp_option_lists_function,
			&ppp.ccp.fptr_get_ccp_state_function, 
			&ppp.ccp.fptr_get_sender_compression_database_initialization_status_function,
			&ppp.ccp.fptr_get_receiver_compression_database_initialization_status_function,
			&ppp.ccp.fptr_get_ccp_port_status_function,
			&ppp.ccp.fptr_get_last_id_of_ccp_packet_sent_function, 
			
			get_device_driver_id, 
			get_maximum_number_of_termination_requests,
			get_ppp_remote_MRU, 
			get_ccp_option_lists_created_by_ppp);
		}
#endif

	initialize_ppp_ports ();

/* Sudha taken this change from Chris.Sachin 17/06/1997 */
#if defined (CCP)
	if (ppp.ccp.enabled == TRUE)
   {
      for (real_port_number = 0 ; real_port_number < ppp.number_of_ppp_ports ; real_port_number++)
      {
         ccp_preallocate_buffer (real_port_number) ;
      }
   }
#endif
/* Sudha taken this change from Chris.Sachin 17/06/1997 */

#ifdef __MLPPP__
   initialize_mlppp_ports ();
#endif /*__MLPPP__*/
   register_debugger(ppp_debug_information, "PPP INFO");

	return (PASS);
}

/****************************************************************************/
enum TEST reinitialize_ppp (ULONG clock_ticks_per_second)
{
	PPP_NCP_CLASS *sptr_ncp;
	USHORT real_port_number;

	ppp.number_of_lan_ports = (USHORT) lsl_control (GET_NUMBER_OF_LAN_PORTS);

	if (ppp.number_of_ppp_ports == 0x0000)
		return (PASS);

	initialize_ppp_ports ();

	ppp.clock_ticks_per_second = clock_ticks_per_second;

	for (real_port_number = 0x0000; real_port_number < ppp.number_of_ppp_ports; ++real_port_number)
	{
		ppp.port[real_port_number].state = PPP_OPENED_STATE;

#ifdef __MLPPP__
		sptr_ncp = &mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX];
#else
		sptr_ncp = &ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX];
#endif /*__MLPPP__*/

		sptr_ncp->state = PPP_OPENED_STATE;
		sptr_ncp->old_state = PPP_OPENED_STATE;

#if VIDY_CUT
#ifdef __MLPPP__
      sptr_ncp = &mlppp.port[real_port_number].ncp[PPP_IPX_NCP_STACK_INDEX];
#else
		sptr_ncp = &ppp.port[real_port_number].ncp[PPP_IPX_NCP_STACK_INDEX];
#endif /* __MLPPP__ */

		sptr_ncp->state = PPP_OPENED_STATE;
		sptr_ncp->old_state = PPP_OPENED_STATE;

#ifdef __MLPPP__
      sptr_ncp = &mlppp.port[real_port_number].ncp[PPP_APPLETALK_NCP_STACK_INDEX];
#else
		sptr_ncp = &ppp.port[real_port_number].ncp[PPP_APPLETALK_NCP_STACK_INDEX];
#endif /* __MLPPP__ */

		sptr_ncp->state = PPP_OPENED_STATE;
		sptr_ncp->old_state = PPP_OPENED_STATE;
#endif
	}

	return (PASS);
}
/****************************************************************************/
static void initialize_ppp_ports (void)
{
	USHORT real_port_number;
   char decrypted_password[256] ;

	for (real_port_number = 0x0000; real_port_number < ppp.number_of_ppp_ports; ++real_port_number)
	{
/* Jo 	if ((ppp.port[real_port_number].enabled == FALSE) &&
			(ppp.port[real_port_number].slip_enabled == FALSE)) */

			if (ppp.port[real_port_number].enabled == FALSE)
				continue;

/* Sachin 24/07/1996 */
/*
	Chidanand 20 Nov 1996 : Boolean parameter was passed instead of a string 
		process_back_slash (ppp.port[real_port_number].configuration.enabled.send_id) ;
*/
		process_back_slash (ppp.port[real_port_number].configuration.tx_identification_message) ;

/* Sachin 24/07/1996 */

		if (ppp.port[real_port_number].authentication.password[0])
		{
      	decrypt (&ppp.port[real_port_number].authentication.password[0], &decrypted_password[0]) ;
      	strcpy (&ppp.port[real_port_number].authentication.password[0], &decrypted_password[0]) ;
		}

		ppp.port[real_port_number].state = PPP_INITIAL_STATE;

/* Kamalnath 31/10/1996 */
		ppp.port[real_port_number].dhcp_status = DHCP_STATUS_NO_OPERATION;
/* Kamalnath 31/10/1996 */

#ifndef SOFTWARE_QUOTING
		ppp.port[real_port_number].async.enabled = FALSE;
#endif /* SOFTWARE_QUOTING */

		initialize_ppp_snmp_static_information(real_port_number);

		initialize_lcp (real_port_number);

		initialize_ncp (real_port_number);

		ppp.port[real_port_number].port_number = real_port_number;

#ifdef __DOD__
			ppp.port[real_port_number].connect_state = LINK_DOWN;
#endif /* __DOD__ */

		strcpy(ppp.port[real_port_number].configuration.tx_identification_message,
			"Multi-Tech Systems");

#ifdef __LSL__
#ifndef __MLPPP__
		if ((enum TEST) lsl_control (REGISTER_HIGH_LEVEL_DEVICE_DRIVER,"PPP Driver",PPP_DEVICE_DRIVER,
			send_ppp_packet,ppp_packet_transmitted,ppp_receive,ppp_timer_routine,ppp_device_driver_control,
			ppp_return_buffer_to_device_driver,&ppp.port[real_port_number].device_driver_id) == FAIL)
			{
			ppp_printf (PPP_ALARM_PRINTF,"PPP:Problem registering device driver");
			}
#else
		if ((enum TEST) lsl_control (REGISTER_HIGH_LEVEL_DEVICE_DRIVER,"PPP Driver",PPP_DEVICE_DRIVER,
			send_mlppp_packet,mlppp_packet_transmitted,mlppp_receive,mlppp_port_timer_routine,ppp_device_driver_control,
			mlppp_return_buffer_to_device_driver,&ppp.port[real_port_number].device_driver_id) == FAIL)
			{
			ppp_printf (PPP_ALARM_PRINTF,"PPP:Problem registering device driver");
			}
#endif /* __MLPPP__ */
#endif
	}
}
/****************************************************************************/
void initialize_LQR_counters (USHORT real_port_number)
{
	memset (&ppp.port[real_port_number].link_quality_counters,(int) NULL,sizeof (LINK_QUALITY_COUNTERS));
}
/******************************************************************************/
enum TEST ppp_device_driver_control (enum DEVICE_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1)
{
	int real_port_number;
	PPP_NCP_CLASS *sptr_ncp;
   ULONG ip_stack_id ;
	ULONG *ptr_to_ip_stack_id = &ip_stack_id ;
	OPTION_LIST_ENTRY *sptr_option_list_entry;
	
   get_protocol_stack_id ("IP Routing", ptr_to_ip_stack_id) ;

	switch (command)
		{
		case OPEN_DEVICE_DRIVER:
			ppp_open_device_driver ();
			break;

		case LOWER_DEVICE_DRIVER_SLIP_UP:
/* 17/05/99 Jo Slip not handled in LCPR */
#ifdef _BIG_PROXY_
			parameter_0 -= ppp.number_of_lan_ports;
/*			printf ("SLIP: Lower device driver UP on port %04X\r\n",parameter_0);*/

		 	if (ppp.port[parameter_0].slip_enabled == TRUE)
			{
				ppp.port[parameter_0].slip_on = TRUE;	
				set_wan_port_owner ((USHORT)parameter_0, OWNED_BY_SLIP) ;
				
				if ( is_wan_port_answering ((USHORT)parameter_0) == TRUE)
				{
					ppp.port[parameter_0].slip_compression_on = FALSE;
					ppp.port[parameter_0].answering = TRUE;
				}
				else
				{
					ppp.port[parameter_0].slip_compression_on = TRUE;
					ppp.port[parameter_0].answering = FALSE;
				}
				
				get_protocol_stack_id ("IP Routing", ptr_to_ip_stack_id);
            lsl_control (PROTOCOL_STACK_PORT,parameter_0 + ppp.number_of_lan_ports,*ptr_to_ip_stack_id,OPEN_VIRTUAL_PORT,
					get_ip_remote_address ((USHORT) (parameter_0 + ppp.number_of_lan_ports)), ppp.port[parameter_0].slip_port.maximum_transmit_bufsize);
	   	}							
#endif
/* 17/05/99 Jo Slip not handled in LCPR */
			break;

		case LOWER_DEVICE_DRIVER_UP:
			parameter_0 -= ppp.number_of_lan_ports;

#ifdef __MLPPP__
         ppp.port[(USHORT)parameter_0].virtual_port_number = 
							map_physical_port_to_virtual_port((USHORT)parameter_0);
#endif /* __MLPPP__ */

			set_wan_port_owner ((USHORT)parameter_0, OWNED_BY_PPP) ;
/*			printf ("PPP: Lower device driver up on port %04X\r\n",parameter_0); */

/* reset the call back flag */
			ppp.port[parameter_0].callback_on = FALSE ;

#ifdef __DOD__
			ppp.port[parameter_0].connect_state = LINK_UP;
			reset_ppp_idle_timer (parameter_0);
			if (ppp.port[parameter_0].dod_active == SCRIPT_ACTIVATED_DOD)
			{
				ppp.port[parameter_0].dod_active = TRUE;
				printf("Script Activated DOD-port %d\n", parameter_0);
			}
			else
			ppp.port[parameter_0].dod_active = is_dialing_initiated_by_this_end (parameter_0);
#endif /* __DOD__ */
			
#ifdef __MLPPP__
/* Jo 04/06/99 Added for RAS */
			if ((mlppp.port[parameter_0].ncp[PPP_IP_NCP_STACK_INDEX].enabled) &&
				 is_remote_access_enabled_on_port(parameter_0) &&
			    (is_dhcp_client_enabled(parameter_0 + ppp.number_of_lan_ports)))
#else
			if ((ppp.port[parameter_0].ncp[PPP_IP_NCP_STACK_INDEX].enabled) &&
			    (is_dhcp_client_enabled(parameter_0 + ppp.number_of_lan_ports)))
#endif
			{
/* Jo 04/06/99 Added for DHCP Client */
				if (ppp.port[parameter_0].dhcp_status == DHCP_STATUS_NO_OPERATION)
				{
					printf("DHCP CLIENT: Issuing DHCP Discover for client on port %04X\r\n", parameter_0);
					lsl_control(DHCP_CONTROL_OPERATION, DHCP_APPLICATION, ISSUE_DHCP_BROADCAST, parameter_0 + ppp.number_of_lan_ports, DHCPDISCOVER);
					ppp.port[parameter_0].dhcp_status = DHCP_STATUS_DISCOVER_REQUEST_MADE;
				}
/* Jo 04/06/99 Added for DHCP Client */
			}
			else
         {
         }
/* Kamalnath 16/08/1996 */

			if (ppp.port[(USHORT) parameter_0].enabled == TRUE)
				{
				execute_ppp_state_machine (PPP_UP_EVENT,(USHORT) parameter_0,NULL,0x0000);
				}

			break;

		case LOWER_DEVICE_DRIVER_DOWN:
			parameter_0 -= ppp.number_of_lan_ports;

/* 17/05/99 Jo Slip not handled in LCPR */
#ifdef _BIG_PROXY_
			if (ppp.port[parameter_0].slip_on == TRUE)
			{
/*			   printf ("SLIP: Lower device driver DOWN on port %04X\r\n",parameter_0);*/
				lsl_control (PROTOCOL_STACK_PORT,parameter_0 + ppp.number_of_lan_ports,*ptr_to_ip_stack_id,CLOSE_VIRTUAL_PORT, NULL, NULL);
				set_wan_port_owner ((USHORT)parameter_0, OWNED_BY_NONE) ;
				ppp.port[parameter_0].slip_on = FALSE;
				ppp.port[parameter_0].slip_compression_on = FALSE;
				break;
			}
#endif
/* 17/05/99 Jo Slip not handled in LCPR */

/* Jo 04/06/99 Added for DHCP Client */
			if( (ppp.port[parameter_0].dhcp_status == DHCP_STATUS_IP_ADDRESS_OBTAINED) &&
			    (is_dhcp_client_enabled(parameter_0 + ppp.number_of_lan_ports)) )
			{
				printf("PPP: Releasing DHCP assigned IP address for client on port %04X\r\n", parameter_0);
				lsl_control(DHCP_CONTROL_OPERATION, DHCP_APPLICATION, GIVE_BACK_IP_ADDRESS, parameter_0 + ppp.number_of_lan_ports, DHCPRELEASE);
				ppp.port[parameter_0].dhcp_status = DHCP_STATUS_NO_OPERATION ;
			}
/* Jo 04/06/99 Added for DHCP Client */
#ifdef __DOD__
			if (ppp.port[parameter_0].connect_state == LINK_GOING_DOWN)
			{
				printf("PPP:Port %04x Down for no demand\r\n", parameter_0);
				ppp.port[parameter_0].connect_state = LINK_DOWN_BY_DEMAND;
				set_wan_port_owner (parameter_0, OWNED_BY_NONE) ;

/* Jo 04/06/99 Added for RAS */
#ifndef __MLPPP__
				if (is_remote_access_enabled_on_port (parameter_0) == TRUE)
				{
					replace_configuration_option (&ppp.port[parameter_0].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.remote_configured,
						ppp.port[parameter_0].ncp[PPP_IP_NCP_STACK_INDEX].sptr_ras_ipcp_remote_address_option,
						OPTION_DEFAULT_STATE);
					replace_configuration_option (&ppp.port[parameter_0].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.configured,
						ppp.port[parameter_0].ncp[PPP_IP_NCP_STACK_INDEX].sptr_ras_ipcp_local_address_option,
						OPTION_DEFAULT_STATE);
				}
#else
				if (is_remote_access_enabled_on_port (parameter_0) == TRUE)
				{
					replace_configuration_option (&mlppp.port[parameter_0].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.remote_configured,
						mlppp.port[parameter_0].ncp[PPP_IP_NCP_STACK_INDEX].sptr_ras_ipcp_remote_address_option,
						OPTION_DEFAULT_STATE);

					replace_configuration_option (&mlppp.port[parameter_0].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.configured,
						mlppp.port[parameter_0].ncp[PPP_IP_NCP_STACK_INDEX].sptr_ras_ipcp_local_address_option,
						OPTION_DEFAULT_STATE);

					replace_configuration_option (&mlppp.port[parameter_0].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.remote_configured,
						mlppp.port[parameter_0].ncp[PPP_IP_NCP_STACK_INDEX].sptr_ras_dns_pri_server_remote_address_option,
						OPTION_DEFAULT_STATE);

					replace_configuration_option (&mlppp.port[parameter_0].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.remote_configured,
						mlppp.port[parameter_0].ncp[PPP_IP_NCP_STACK_INDEX].sptr_ras_dns_sec_server_remote_address_option,
						OPTION_DEFAULT_STATE);

					sptr_option_list_entry = 
						find_matching_option (&ppp.port[parameter_0].option_lists.remote_configured, LCP_AUTHENTICATION_PROTOCOL); 
					if (sptr_option_list_entry)
					{
						delete_entry_from_option_list (&ppp.port[parameter_0].option_lists.remote_configured, 
							sptr_option_list_entry);
					}
					add_new_lcp_option_to_list (&ppp.port[parameter_0].option_lists.configured,
						ppp.port[parameter_0].sptr_ras_local_authentication);		

					copy_remote_configuration_options_to_tx_accepted_list (&ppp.port[parameter_0].option_lists);

				}
#endif
/* Jo 04/06/99 Added for RAS */
			}
			else
			{
				printf("PPP:Port %04x Link down.\r\n", parameter_0);
				if (ppp.port[parameter_0].callback_on == FALSE)
				{
					/* Set ownership to none only if the port is an answering port
					   and dial on demand is disabled */

					if (is_wan_port_answering (parameter_0))  /* looking for configured auto answer */
					{
/*						set_wan_port_owner (parameter_0, OWNED_BY_NONE) ; */
					}

					set_wan_port_owner (parameter_0, OWNED_BY_NONE) ;
					ppp_port_client_disconnected ((USHORT)parameter_0 + 1);

/* Vidy & Sudha 25 Nov 1998 */
/* Jo 29/06/99 Added from Jessi */
					if (is_dialing_initiated_from_proxy_successful_to_bring_link_up(parameter_0) == FALSE)
						trigger_port_open[parameter_0] = REOPEN_REQUIRED;
				}
				ppp.port[parameter_0].connect_state = LINK_DOWN;
			}

#endif /* __DOD__ */

			if (ppp.port[(USHORT) parameter_0].enabled == TRUE)
			{
				execute_ppp_state_machine (PPP_DOWN_EVENT,(USHORT) parameter_0,NULL,0x0000);

				ppp_close_device_driver_port ((USHORT) parameter_0);
			}
#ifdef __MLPPP__
         remove_link_from_bundle((USHORT) parameter_0,ppp.port[(USHORT) parameter_0].virtual_port_number);
#endif
			break;

		case OPEN_DEVICE_DRIVER_PORT: 
			parameter_0 -= ppp.number_of_lan_ports;

		   mlppp.dod_enabled_bundle[(USHORT)parameter_0].link_down_by_demand = FALSE;

/* 17/05/99 Jo Slip not handled in LCPR */
#ifdef _BIG_PROXY_
/* Kamalnath 06\03\1997 */
			if(ppp.port[(USHORT)parameter_0].slip_on == TRUE)
			{
				build_slip_buffer_list (parameter_0);
				break;
			}
/* Kamalnath 06\03\1997 */
#endif
/* 17/05/99 Jo Slip not handled in LCPR */

			if (ppp.port[(USHORT) parameter_0].enabled == FALSE)
				ppp.port[(USHORT) parameter_0].enabled = TRUE;

			ppp_open_device_driver_port ((USHORT) parameter_0);

			execute_ppp_state_machine (PPP_OPEN_EVENT,(USHORT) parameter_0,NULL,0x0000);
			
			break;


		case CLOSE_DEVICE_DRIVER:
			ppp_close_device_driver ();
			break;

		case CLOSE_DEVICE_DRIVER_PORT:
			parameter_0 -= ppp.number_of_lan_ports;

			if (ppp.port[(USHORT) parameter_0].enabled == TRUE)
			{
				execute_ppp_state_machine (PPP_CLOSE_EVENT,(USHORT) parameter_0,NULL,0x0000);

				ppp.port[(USHORT) parameter_0].enabled = FALSE;

				ppp_close_device_driver_port ((USHORT) parameter_0);
			}
			else
			{
				free_lcp_and_ncp_option_lists ((USHORT) parameter_0);
#if defined (CCP)
				if (ppp.ccp.enabled == TRUE)
				{
					if ((ppp.ccp.fptr_get_ccp_port_status_function != NULL) && 
						((*ppp.ccp.fptr_get_ccp_port_status_function) ((USHORT) parameter_0) == TRUE))
					{
						free_ccp_option_lists ((USHORT) parameter_0);
						reset_ccp_state_machine(parameter_0);
						initialize_ccp_tx_accepted_option_list(parameter_0);
					}
				}
#endif				
				initialize_lcp_statistics_counters ((USHORT)parameter_0);

				initialize_lcp_tx_accepted_option_list((USHORT)parameter_0);
				initialize_ncp_tx_accepted_option_list((USHORT)parameter_0);
#ifdef _BIG_PROXY_
				cipx_reset_connection_states (parameter_0);
				vjc_reset_connection_states (parameter_0);
#endif

				}

			break;

		case DEVICE_QUERY:
			break;

		case STACK_HAS_REGISTERED:

			++ppp.number_of_ports_times_number_of_protocol_stacks_loaded;

/* this asssumes that the protocol registers to all ppp ports */

			ppp.number_of_protocol_stacks_loaded = (USHORT) (ppp.number_of_ports_times_number_of_protocol_stacks_loaded /
				ppp.number_of_ppp_ports);

			stack_has_been_registered ((char *) parameter_0,parameter_1);

			break;

		case REGISTER_SERIAL_DEVICE_DRIVER:
			parameter_0 -= ppp.number_of_lan_ports;

			ppp_register_serial_device_driver ((USHORT) parameter_0,(LOW_LEVEL_DEVICE_DRIVER_API *) parameter_1);

#if 0

/* Sachin 13/09/1996 */

			/* Set ownership to PPP forever if
				(a). The port is a router's dialing port
				(b). The port is answering and dial-on-demand is enabled
			*/

			for (real_port_number = 0 ; real_port_number < ppp.number_of_ppp_ports ; real_port_number++)
			{
				if (is_wan_port_answering (real_port_number) == FALSE)
				{
					set_wan_port_owner (real_port_number, OWNED_BY_PPP) ;
				}
				else
				if (ppp.port[real_port_number].dial_on_demand == TRUE)
				{
					set_wan_port_owner (real_port_number, OWNED_BY_PPP) ;
				}
			}
/* Sachin 13/09/1996 */
#endif /* RAS */
			break;

		case PASSWORD_VERIFICATION:
			/*	real_port_number,&ppp.port[real_port_number].authentication.password[0] or enum TEST pap_pass_or_fail*/
			ppp_upper_layer_authentication_verification ((USHORT) parameter_0,parameter_1);
			break;

		case PROTOCOL_DOWN:
			parameter_0 -= ppp.number_of_lan_ports;

			sptr_ncp = find_ppp_ncp ((USHORT) parameter_0,(enum PROTOCOL_STACK_TYPE) parameter_1);

			if (sptr_ncp != NULL)
				execute_ncp_state_machine (PPP_DOWN_EVENT,sptr_ncp,(USHORT) parameter_0,NULL,0x0000);

			break;

		case PROTOCOL_UP:
			parameter_0 -= ppp.number_of_lan_ports;

			sptr_ncp = find_ppp_ncp ((USHORT) parameter_0,(enum PROTOCOL_STACK_TYPE) parameter_1);

			if (sptr_ncp != NULL)
				execute_ncp_state_machine (PPP_UP_EVENT,sptr_ncp,(USHORT) parameter_0,NULL,0x0000);

			break;

#ifdef DOD_RECONNECT		/* vidy 12/02/98 */
		case LOWER_DEVICE_DRIVER_LOST_CD:
			real_port_number = parameter_0 - ppp.number_of_lan_ports;

#ifdef __MLPPP__
			/* if MLPPP is enabled, we need to map the WAN link to the
			corresponding ppp port (ie the bundle) */
			real_port_number = ppp.port[real_port_number].virtual_port_number;

#endif
			if ( (ppp.port[real_port_number].dial_on_demand == TRUE)
					&& (ppp.port[real_port_number].connect_state == LINK_UP) &&
						(ppp.port[real_port_number].dod_active == TRUE) )
			{
				if (ppp.port[real_port_number].idle_timer < 20)
				{
					/* if link idle timer has less than only 20 secs to go
					call shutdown on this link and 
					return FALSE so that we don't initiate a call now */
					ppp_link_idle(real_port_number);
					return FAIL;
				}
				else
				{

					/* after reconnection, the counter must start from
					the time remaining, rather than max_value */
					ppp.port[real_port_number].saved_idle_timer = 
						ppp.port[real_port_number].idle_timer;
				}
			}
			break;
#endif

		default:
#if 0  /* Sachin took this printf off */
			ppp_printf (PPP_ALARM_PRINTF,"PPP: Illegal Device Control Command\n");
#endif

			break;

		}

	return (PASS);
}
/*************************************************************************/
static void	stack_has_been_registered (char *cptr_stack_name,ULONG protocol_stack_id)
{
	BYTE protocol_stack_index;
	USHORT real_port_number;
	PPP_NCP_CLASS *sptr_ncp;
	
	for (protocol_stack_index = 0x00; protocol_stack_index < NUMBER_OF_NCP_STACKS;
		protocol_stack_index = (BYTE) (protocol_stack_index + 1))
	{
		for (real_port_number = 0x0000; real_port_number < ppp.number_of_ppp_ports; ++real_port_number)
		{
#ifdef __MLPPP__
			sptr_ncp = &mlppp.port[real_port_number].ncp[protocol_stack_index];
#else
			sptr_ncp = &ppp.port[real_port_number].ncp[protocol_stack_index];
#endif /*__MLPPP__*/

			if (strcmp ((char *) cptr_stack_name,sptr_ncp->name) == STRINGS_MATCH)
			{
				if (ppp.port[real_port_number].enabled == TRUE)
				{
					if (sptr_ncp->protocol_stack_id == ILLEGAL_STACK_ID)
					{
#ifdef __MLPPP__
						sptr_ncp = &mlppp.port[real_port_number].ncp[protocol_stack_index];
#else
						sptr_ncp = &ppp.port[real_port_number].ncp[protocol_stack_index];
#endif

						sptr_ncp->protocol_stack_id = protocol_stack_id;

						execute_ncp_state_machine (PPP_OPEN_EVENT,sptr_ncp,real_port_number,NULL,0x0000);

						return;
					}
				}
			}
		}
	}
}
/*************************************************************************/
PPP_NCP_CLASS *find_ppp_ncp (USHORT real_port_number,enum PROTOCOL_STACK_TYPE type)
{
	USHORT protocol_stack_index;

	for (protocol_stack_index = 0x00; protocol_stack_index < NUMBER_OF_NCP_STACKS; ++protocol_stack_index)
		{
#ifdef __MLPPP__
		if (type == mlppp.port[real_port_number].ncp[protocol_stack_index].type)
			{
			return (&mlppp.port[real_port_number].ncp[protocol_stack_index]);
			}
#else
		if (type == ppp.port[real_port_number].ncp[protocol_stack_index].type)
			{
			return (&ppp.port[real_port_number].ncp[protocol_stack_index]);
			}
#endif
		}

	ppp_printf (PPP_ALARM_PRINTF,"PPP: No NCP found on port %04x,%04x\r\n",real_port_number,(USHORT) type);

	return (NULL);
}
/*************************************************************************/
PPP_NCP_CLASS *find_ppp_ncp_using_protocol_type (USHORT real_port_number,enum PPP_PROTOCOL_TYPE ncp_protocol_type)
{
	USHORT protocol_stack_index;

	for (protocol_stack_index = 0x00; protocol_stack_index < NUMBER_OF_NCP_STACKS; ++protocol_stack_index)
	{
#ifdef __MLPPP__
		if (ncp_protocol_type == mlppp.port[real_port_number].ncp[protocol_stack_index].ncp_protocol_type)
			return (&mlppp.port[real_port_number].ncp[protocol_stack_index]);
#else
		if (ncp_protocol_type == ppp.port[real_port_number].ncp[protocol_stack_index].ncp_protocol_type)
			return (&ppp.port[real_port_number].ncp[protocol_stack_index]);
#endif
	}

	ppp_printf (PPP_ALARM_PRINTF,"PPP: No NCP found on port %04x,%04x\r\n",real_port_number,(USHORT) ncp_protocol_type);

	return (NULL);
}
/*************************************************************************/
static void ppp_open_device_driver (void)
{
	USHORT port_number;

	for (port_number = 0x0000; port_number < ppp.number_of_ppp_ports; ++port_number)
		{
		ppp_open_device_driver_port (port_number);
		}
}
/*************************************************************************/
static void ppp_open_device_driver_port (USHORT port_number)
{
#if 0
	int protocol_stack_index ;
#endif

#if 0

	for (protocol_stack_index = 0x00 ; protocol_stack_index < NUMBER_OF_NCP_STACKS ;
	     protocol_stack_index = (BYTE) (protocol_stack_index + 1))
	{
		ppp.port[port_number].ncp[protocol_stack_index].enabled =
		ppp.port[port_number].ncp[protocol_stack_index].configured ;
	}


	if (ppp.port[port_number].async.enabled == TRUE)
		{
		build_async_buffer_list (port_number);
		}
#endif

	ppp.port[port_number].authentication.status = UNSUCCESSFUL;

	ppp.port[port_number].authentication.rxed_authentication_ack = FALSE;
	ppp.port[port_number].authentication.txed_authentication_ack = FALSE;

	ppp.port[port_number].number_of_configuration_requests = 0x0000;
	ppp.port[port_number].number_of_echo_requests = 0x0000;
	ppp.port[port_number].number_of_lcp_termination_requests = 0x0000;

	ppp.port[port_number].configuration_request_send_interval = 0x0000;
	ppp.port[port_number].configuration_request_backoff_interval = 0x0000;

	ppp.port[port_number].time_to_send_LQR = 0x0000;
}
/*************************************************************************/
static void ppp_close_device_driver (void)
{
	USHORT port_number;

	for (port_number = 0x0000; port_number < ppp.number_of_ppp_ports; ++port_number)
		{
		ppp_close_device_driver_port (port_number);
		}
}
/*************************************************************************/
static void ppp_close_device_driver_port (USHORT port_number)
{
/* Jo #ifdef RAS */
	int protocol_stack_index ;
/* Jo #endif ....#ifdef RAS */

	free_lcp_and_ncp_option_lists (port_number);

#if defined (CCP)
	if (ppp.ccp.enabled == TRUE)
	{
		if ((ppp.ccp.fptr_get_ccp_port_status_function != NULL) && 
			((*ppp.ccp.fptr_get_ccp_port_status_function) (port_number) == TRUE))
		{
			free_ccp_option_lists (port_number);
			reset_ccp_state_machine(port_number);
			initialize_ccp_tx_accepted_option_list(port_number);
		}
	}
#endif				

	initialize_lcp_statistics_counters (port_number);

	initialize_lcp_tx_accepted_option_list(port_number);

#ifndef __MLPPP__
	initialize_ncp_tx_accepted_option_list(port_number);

#ifdef _BIG_PROXY_
	cipx_reset_connection_states (port_number);
	vjc_reset_connection_states (port_number);
#endif

#endif

	if (ppp.port[port_number].serial_driver.fptr_control_routine != NULL)
	{
			(*ppp.port[port_number].serial_driver.fptr_control_routine) (CLOSE_SERIAL_PORT,
			   (ULONG) port_number,
				(ULONG) &ppp.port[port_number].ras_user_database_record);
	}

	/* Restore the enabled field from the configured field */
/* Jo #ifdef RAS */

	for (protocol_stack_index = 0x00 ; protocol_stack_index < NUMBER_OF_NCP_STACKS ;
	     protocol_stack_index = (BYTE) (protocol_stack_index + 1))
	{
#ifdef __MLPPP__
		mlppp.port[port_number].ncp[protocol_stack_index].enabled = 
		mlppp.port[port_number].ncp[protocol_stack_index].configured ;
#else
		ppp.port[port_number].ncp[protocol_stack_index].enabled = 
		ppp.port[port_number].ncp[protocol_stack_index].configured ;
#endif
	}

/* Jo #endif ...#ifdef RAS */
}
/*************************************************************************/
void free_lcp_and_ncp_option_lists (USHORT port_number)
{
	USHORT protocol_stack_index;

	free_ppp_option_lists (&ppp.port[port_number].option_lists);

#ifndef __MLPPP__
	for (protocol_stack_index = 0x00; protocol_stack_index < NUMBER_OF_NCP_STACKS; ++protocol_stack_index)
		free_ppp_option_lists (&ppp.port[port_number].ncp[protocol_stack_index].option_lists);
#endif
}
#if defined (CCP)
/*************************************************************************/
void free_ccp_option_lists (USHORT real_port_number)
{
	OPTION_LISTS *sptr_ccp_option_lists;

	if (ppp.ccp.fptr_get_ccp_option_lists_function != NULL)
	{
		sptr_ccp_option_lists = (*ppp.ccp.fptr_get_ccp_option_lists_function) (real_port_number);

		free_ppp_option_lists (sptr_ccp_option_lists); 

	}
}
/****************************************************************************/
static ULONG get_device_driver_id (USHORT real_port_number)
{
	return (ppp.port[real_port_number].device_driver_id); 
}
/****************************************************************************/
static ULONG get_maximum_number_of_termination_requests (void)
{
	return (ppp.maximum_number_of_termination_requests); 
}
/****************************************************************************/
static ULONG get_ppp_remote_MRU (USHORT real_port_number)
{
	return (ppp.port[real_port_number].lcp_mibs.pppLinkStatusRemoteMRU); 
}
/****************************************************************************/
static OPTION_LISTS *get_ccp_option_lists_created_by_ppp (USHORT real_port_number)
{
	return (&ppp.port[real_port_number].ccp.option_lists); 
}
#endif
/*************************************************************************/
void ppp_return_buffer_to_device_driver (USHORT real_port_number,void *vptr_buffer)
{
	real_port_number = (USHORT) (real_port_number - ppp.number_of_lan_ports);

	if (ppp.port[real_port_number].serial_driver.fptr_rx_buffer_return != NULL)
	{
		(*ppp.port[real_port_number].serial_driver.fptr_rx_buffer_return) (real_port_number,vptr_buffer);
	}
}
/****************************************************************************/
static ULONG ppp_register_serial_device_driver (USHORT port_number,LOW_LEVEL_DEVICE_DRIVER_API *sptr_serial_driver_api)
{
	strcpy (ppp.port[port_number].serial_driver.name,sptr_serial_driver_api->cptr_device_name);

	ppp.port[port_number].serial_driver.type = sptr_serial_driver_api->device_driver_type;

	ppp.port[port_number].serial_driver.fptr_tx_routine =
		(enum TEST (*) (USHORT port_number,USHORT virtual_port_number,void *sptr_tx_buffer,
			USHORT number_of_bytes,enum BOOLEAN bridged_packet,enum BOOLEAN device_driver_buffer,
			void (*fptr_tx_completion)	(USHORT port_number,void *vptr_tx_buffer),void *vptr_async_buffer))
		sptr_serial_driver_api->fptr_tx_routine;
	ppp.port[port_number].serial_driver.fptr_tx_complete = sptr_serial_driver_api->fptr_tx_complete;
	ppp.port[port_number].serial_driver.fptr_rx_routine = sptr_serial_driver_api->fptr_rx_routine;
	ppp.port[port_number].serial_driver.fptr_timer_routine = sptr_serial_driver_api->fptr_timer_routine;
	ppp.port[port_number].serial_driver.fptr_control_routine = sptr_serial_driver_api->fptr_control_routine;
	ppp.port[port_number].serial_driver.fptr_rx_buffer_return = sptr_serial_driver_api->fptr_rx_buffer_return;

	return (ppp.port[port_number].device_driver_id);
}
/****************************************************************************/
#ifdef _BIG_PROXY
void ppp_register_vj_compression (USHORT port_number,BYTE (*fptr_vj_compress_tcp_header)
	(USHORT real_port_number,void **ptr_to_sptr_ip_packet, USHORT *usptr_number_of_bytes),
	BYTE (*fptr_vj_get_maximum_connection_states) (USHORT real_port_number),
	enum BOOLEAN (*fptr_vj_get_compress_connection_id) (USHORT real_port_number),
	void (*fptr_vj_uncompress_tcp_header) (USHORT receive_port_number, void **ptr_to_sptr_ip_packet,USHORT *usptr_number_of_bytes,
	BYTE type_of_packet))
{
#ifdef __MLPPP__
	mlppp.port[port_number].vjc.fptr_compress_tcp_header = fptr_vj_compress_tcp_header;
	mlppp.port[port_number].vjc.fptr_get_maximum_connection_states = fptr_vj_get_maximum_connection_states;
	mlppp.port[port_number].vjc.fptr_get_compress_connection_id = fptr_vj_get_compress_connection_id;
	mlppp.port[port_number].vjc.fptr_uncompress_tcp_header = fptr_vj_uncompress_tcp_header;
#else /*__MLPPP__*/
	ppp.port[port_number].vjc.fptr_compress_tcp_header = fptr_vj_compress_tcp_header;
	ppp.port[port_number].vjc.fptr_get_maximum_connection_states = fptr_vj_get_maximum_connection_states;
	ppp.port[port_number].vjc.fptr_get_compress_connection_id = fptr_vj_get_compress_connection_id;
	ppp.port[port_number].vjc.fptr_uncompress_tcp_header = fptr_vj_uncompress_tcp_header;
#endif /*__MLPPP__*/
}

/****************************************************************************/
void ppp_register_ipx_compression (USHORT port_number,void (*fptr_compress_ipx_header)
	(USHORT real_port_number,void **ptr_to_sptr_ip_packet, USHORT *usptr_number_of_bytes),
	BYTE (*fptr_ipx_get_maximum_connection_states) (USHORT real_port_number),
	enum BOOLEAN (*fptr_ipx_get_compress_connection_id) (USHORT real_port_number),
	enum TEST (*fptr_uncompress_ipx_header) (USHORT receive_port_number, void **ptr_to_sptr_ip_packet,
	USHORT *usptr_number_of_bytes))
{
#ifdef __MLPPP__
	mlppp.port[port_number].cipx.fptr_compress_ipx_header = fptr_compress_ipx_header;
	mlppp.port[port_number].cipx.fptr_get_maximum_connection_states = fptr_ipx_get_maximum_connection_states;
	mlppp.port[port_number].cipx.fptr_get_compress_connection_id = fptr_ipx_get_compress_connection_id;
	mlppp.port[port_number].cipx.fptr_uncompress_ipx_header = fptr_uncompress_ipx_header;
#else
	ppp.port[port_number].cipx.fptr_compress_ipx_header = fptr_compress_ipx_header;
	ppp.port[port_number].cipx.fptr_get_maximum_connection_states = fptr_ipx_get_maximum_connection_states;
	ppp.port[port_number].cipx.fptr_get_compress_connection_id = fptr_ipx_get_compress_connection_id;
	ppp.port[port_number].cipx.fptr_uncompress_ipx_header = fptr_uncompress_ipx_header;
#endif /* __MLPPP__ */
}
#endif
/****************************************************************************/
void ppp_register_ncp_protocol_reject (USHORT real_port_number,enum PPP_PROTOCOL_TYPE ncp_protocol_type,
	void (*fptr_protocol_reject_alarm) (USHORT real_port_number,struct PPP_NCP_CLASS *sptr_ncp))
{
	PPP_NCP_CLASS *sptr_ncp;

	sptr_ncp = find_ppp_ncp_using_protocol_type (real_port_number,ncp_protocol_type);

	if (sptr_ncp != NULL)
		sptr_ncp->fptr_protocol_reject_alarm = fptr_protocol_reject_alarm;
}
/****************************************************************************/
void ppp_register_event_upcall (ULONG (*fptr_event_upcall) (USHORT real_port_number,USHORT event,...))
{
	ppp.fptr_event_upcall = fptr_event_upcall; 
}


#if defined (CCP)
/****************************************************************************/
void initialize_ccp_tx_accepted_option_list(USHORT port_number)
{
	OPTION_LISTS *sptr_ccp_option_lists;

	if (ppp.ccp.fptr_get_ccp_option_lists_function != NULL)
	{
		sptr_ccp_option_lists = (*ppp.ccp.fptr_get_ccp_option_lists_function) (port_number);

		copy_configuration_options_to_tx_accepted_options (sptr_ccp_option_lists);
 		
	}
}
#endif				

void initialize_ppp_snmp_static_information(USHORT real_port_number)
{
	OPTION_LIST_ENTRY *sptr_option_entry;


		/* Link Status Table Entry */
		ppp.port[real_port_number].lcp_mibs.pppLinkStatusPhysicalIndex = real_port_number;

		/* Link Configuration Table Entry */
		/* Do not use DEFAULT_MAXIMUM_MRU for the following. 0 implies that
		** the default will be used.
		*/
		ppp.port[real_port_number].lcp_mibs.pppLinkConfigInitialMRU = 0;
		ppp.port[real_port_number].lcp_mibs.pppLinkConfigFcsSize = 16;

#ifdef RTRERROR
		ppp.port[real_port_number].lcp_mibs.pppLinkConfigReceiveACCMap = DEFAULT_ASYNC_CONTROL_CHARACTER_MAP;
		ppp.port[real_port_number].lcp_mibs.pppLinkConfigTransmitACCMap = DEFAULT_ASYNC_CONTROL_CHARACTER_MAP;
#endif

		ppp.port[real_port_number].lcp_mibs.pppLinkConfigReceiveACCMap = 0;
		ppp.port[real_port_number].lcp_mibs.pppLinkConfigTransmitACCMap = 0;

		sptr_option_entry = find_matching_option(&ppp.port[real_port_number].option_lists.configured, (BYTE) LCP_MAGIC_NUMBER);
		if (sptr_option_entry == NULL)
			ppp.port[real_port_number].lcp_mibs.pppLinkConfigMagicNumber = FALSE;
		else 
			ppp.port[real_port_number].lcp_mibs.pppLinkConfigMagicNumber = sptr_option_entry->negotiation_required;

		/* Link Quality Reports Table */
		ppp.port[real_port_number].lcp_mibs.pppLqrQuality = LQR_NOT_DETERMINED;
}


/* Sachin 21/09/1996 */

void callback_attempt_failed (USHORT port_number)
{
	if (ppp.port[port_number].callback_on == TRUE)
	{
		ppp.port[port_number].callback_on = FALSE ;
/*		printf ("Callback attempts failed on port %d, releasing ownership\n", port_number) ;*/
		set_wan_port_owner (port_number, OWNED_BY_NONE) ;
	}
}
/* Sachin 21/09/1996 */

/* Jo 23/04/99 */
#if 0
/* Kamalnath SLIP 07\03\1997 */
enum BOOLEAN check_if_slip_on_is_set_to_true(USHORT port_num)
{
	return(ppp.port[port_num].slip_on);
}
#endif
/* Jo 23/04/99 */

enum BOOLEAN check_if_slip_is_enabled(USHORT port_num)
{
	return (FALSE)	;
/*	Jo return(ppp.port[port_num].slip_enabled);*/
}

/* vidy added these two from pppasync.c */
/*************************************************************************/
PPP_PACKET_WITH_MAC_HEADER *compress_ppp_header (PPP_PACKET_WITH_MAC_HEADER *sptr_tx_packet,
	USHORT *usptr_number_of_bytes_tx, enum BOOLEAN address_and_control_fields_compression_enabled,
	enum BOOLEAN protocol_field_compression_enabled)
{
/*we should  check if the protocol field is compressable. This is not done
we straight away discard the first byte.*/

	if ((sptr_tx_packet->header.hdlc_address == HDLC_ADDRESS) &&
		(sptr_tx_packet->header.hdlc_control == UNNUMBERED_INFORMATION) &&
		((sptr_tx_packet->header.protocol_type & BIG_ENDIAN_CONSTANT (0xff00)) != 0x0000))
		{
		return (sptr_tx_packet);
		}

	if (address_and_control_fields_compression_enabled == TRUE)
		{
		sptr_tx_packet = (PPP_PACKET_WITH_MAC_HEADER *) ((ULONG) sptr_tx_packet + sizeof (sptr_tx_packet->header.hdlc_address) +
			sizeof (sptr_tx_packet->header.hdlc_control));

		*usptr_number_of_bytes_tx -= (USHORT) (sizeof (sptr_tx_packet->header.hdlc_address) +
			sizeof (sptr_tx_packet->header.hdlc_control));

		if (protocol_field_compression_enabled == TRUE)
			{
			sptr_tx_packet = (PPP_PACKET_WITH_MAC_HEADER *) ((ULONG) sptr_tx_packet + 1);

			*usptr_number_of_bytes_tx -= (USHORT) 1;
			}
		}
	else if (protocol_field_compression_enabled == TRUE)
		{
		sptr_tx_packet = (PPP_PACKET_WITH_MAC_HEADER *) ((ULONG) sptr_tx_packet + 1);

		sptr_tx_packet->header.hdlc_address = HDLC_ADDRESS;
		sptr_tx_packet->header.hdlc_control = UNNUMBERED_INFORMATION;

		*usptr_number_of_bytes_tx -= (USHORT) 1;
		}

	return (sptr_tx_packet);
}
/*************************************************************************/
PPP_PACKET *decompress_ppp_header (PPP_PACKET *sptr_rxed_packet, USHORT *usptr_number_of_bytes_rxed,
	enum BOOLEAN address_and_control_fields_compression_enabled, enum BOOLEAN protocol_field_compression_enabled)
{

/*we should  check if the protocol field is compressed. This is not done
we straight away add a first byte of 00.*/

	BYTE protocol_type_in_bytes[sizeof (USHORT_ENUM (PPP_PROTOCOL_TYPE))];
	enum BOOLEAN address_and_control_fields_are_compressed;
	enum BOOLEAN protocol_field_is_compressed;
	PPP_HEADER ppp_header;

	if ((sptr_rxed_packet->header.hdlc_address == HDLC_ADDRESS) &&
		(sptr_rxed_packet->header.hdlc_control == UNNUMBERED_INFORMATION) &&
		(sptr_rxed_packet->header.protocol_type == LCP_PROTOCOL))
	{
		return (sptr_rxed_packet);
	}

	address_and_control_fields_are_compressed = FALSE;
	protocol_field_is_compressed = FALSE;

	ppp_header.hdlc_address = HDLC_ADDRESS;
	ppp_header.hdlc_control = UNNUMBERED_INFORMATION;

	if ((address_and_control_fields_compression_enabled == TRUE) &&
		 (sptr_rxed_packet->header.hdlc_address != HDLC_ADDRESS))
/*	&&		(sptr_rxed_packet->header.hdlc_control != UNNUMBERED_INFORMATION)) */
	{
		address_and_control_fields_are_compressed = TRUE;

		memcpy (&protocol_type_in_bytes[0],sptr_rxed_packet,sizeof (USHORT_ENUM (PPP_PROTOCOL_TYPE)));
	}
	else
	{
		memcpy (&protocol_type_in_bytes[0],&sptr_rxed_packet->header.protocol_type,sizeof (USHORT_ENUM (PPP_PROTOCOL_TYPE)));
	}

	if (protocol_field_compression_enabled == TRUE)
	{
		if ((protocol_type_in_bytes[0] != 0x80) && (protocol_type_in_bytes[0] != 0xc0) &&
			(protocol_type_in_bytes[0] != 0x00) &&	(protocol_type_in_bytes[0] != 0xc2) &&
			(protocol_type_in_bytes[0] != 0x02))
		{
			protocol_field_is_compressed = TRUE;

			*((BYTE *) &ppp_header.protocol_type) = 0x00;
			*((BYTE *) &ppp_header.protocol_type + 1) = protocol_type_in_bytes[0];
		}
		else
			memcpy (&ppp_header.protocol_type,&protocol_type_in_bytes[0],sizeof (USHORT_ENUM (PPP_PROTOCOL_TYPE)));
	}
	else
		memcpy (&ppp_header.protocol_type,&protocol_type_in_bytes[0],sizeof (USHORT_ENUM (PPP_PROTOCOL_TYPE)));

	if (address_and_control_fields_are_compressed == TRUE)
	{
		sptr_rxed_packet = (PPP_PACKET *) ((ULONG) sptr_rxed_packet -
			(sizeof (ppp_header.hdlc_address) + sizeof (ppp_header.hdlc_control)));

		*usptr_number_of_bytes_rxed += (USHORT) (sizeof (ppp_header.hdlc_address) + sizeof (ppp_header.hdlc_control));
	}

	if (protocol_field_is_compressed == TRUE)
	{
		sptr_rxed_packet = (PPP_PACKET *) ((ULONG) sptr_rxed_packet - sizeof (BYTE));

		*usptr_number_of_bytes_rxed += (USHORT) sizeof (BYTE);
	}

	memcpy (sptr_rxed_packet,&ppp_header,sizeof (PPP_HEADER));

	return (sptr_rxed_packet);
}
