#include	"defs.h"
/*	$Modname: pppncptx.c$  $version: 1.20$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 01/05/94 keyur Initial Release.
1.1 01/05/94 keyur Added support for version control.
1.2 01/05/94 keyur Added some statistics.
1.3 01/20/94 keyur Added support for sending NCP options.
1.4 01/28/94 keyur Added code for resetting the link in case of unexpected event.
1.5 02/02/94 keyur Deleted code to get ip address from IP Stack. Instead get it from nvram now.
1.6 02/22/94 keyur There is no major change in this release.
1.7 03/23/94 keyur Obsoleting File because it's broken into three files
1.8 05/02/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John.
1.9 05/02/94 keyur took out memcheck header file.
1.10 06/15/94 keyur cosmetic changes.
1.11 07/18/94 ross general cleanup with options, added header compression, accm features.
1.12 08/11/94 ross adding rfc1570 lcp support
1.13 08/24/94 ross adding new ncps.
1.14 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.15 11/04/94 ross Testing against net manage ppp.  VJC testing.
1.16 12/03/94 ross testing Windows 95	RAS
1.17 12/13/94 ross connected to NT RAS with Netbios
1.18 02/27/95 ross dynamic load changes including lsl_control.
1.19 03/10/95 ross general fixes.  see change.doc
1.20 10/19/95 biao got rid of Microsoft Visual C++ 2.2 level 4 warnings.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1993-1994 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <string.h>
#include "ppp.h"
/************************************************************************************/
static void send_ncp_packet (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,PPP_PACKET *sptr_tx_packet,
	USHORT number_of_bytes_to_send,enum PPP_CONTROL_CODE code,BYTE id);
/************************************************************************************/
void send_ncp_configuration_request (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number)
{
	NCP_CONFIGURE_REQUEST *sptr_ncp_configure_packet;
	USHORT number_of_bytes_to_send;

	ppp_printf (PPP_NCP_PRINTF,"PPP NCP: %s Configuration Request Tx on port: %04x\r\n",sptr_ncp->name,real_port_number);

	number_of_bytes_to_send = get_size_of_ppp_options (&sptr_ncp->option_lists.tx_accepted);

	number_of_bytes_to_send +=
		(USHORT) (sizeof (sptr_ncp_configure_packet->ppp_header) + sizeof (sptr_ncp_configure_packet->ncp_header));

	sptr_ncp_configure_packet = (NCP_CONFIGURE_REQUEST *) ppp_get_a_send_packet (real_port_number,number_of_bytes_to_send);

	if (sptr_ncp_configure_packet == NULL)
		{
		return;
		}

	sptr_ncp->configuration_request_send_interval = 0x0000;

	store_ppp_options_in_packet (&sptr_ncp->option_lists.tx_accepted,(PPP_OPTION *) &sptr_ncp_configure_packet->options);

	ppp.port[real_port_number].id_sequence_number = (BYTE) (ppp.port[real_port_number].id_sequence_number + 1);

	sptr_ncp->last_request_id = ppp.port[real_port_number].id_sequence_number;
	sptr_ncp->length_of_last_txed_request = number_of_bytes_to_send;

	send_ncp_packet (sptr_ncp,real_port_number,(PPP_PACKET *) sptr_ncp_configure_packet,number_of_bytes_to_send,
		CONFIGURE_REQUEST,ppp.port[real_port_number].id_sequence_number);
}

/* Sachin 14/07/1997 */
static void ppp_ncp_send_completion (USHORT port_number, void *sptr_tx_packet)
{
   if (ppp.port[port_number].accm_applied == FALSE)
   {
      apply_tx_accm (port_number) ;
      ppp.port[port_number].accm_applied = TRUE ;      
   }
   ppp_send_completion (port_number, sptr_tx_packet) ;
}
/* Sachin 14/07/1997 */


/*************************************************************************************************/
static void send_ncp_packet (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,PPP_PACKET *sptr_tx_packet,
	USHORT number_of_bytes_to_send,enum PPP_CONTROL_CODE code,BYTE id)
{
	sptr_tx_packet->code = (BYTE_ENUM (PPP_CONTROL_CODE)) code;
	sptr_tx_packet->id = id;
	sptr_tx_packet->length = swap ((USHORT) (number_of_bytes_to_send - sizeof (PPP_HEADER)));

	sptr_tx_packet->header.protocol_type = (USHORT_ENUM (PPP_PROTOCOL_TYPE)) sptr_ncp->ncp_protocol_type;

	++sptr_ncp->statistics.number_of_tx_packets;
	++sptr_ncp->statistics.number_of_tx_control_packets[code];

	sptr_ncp->statistics.number_of_tx_bytes += number_of_bytes_to_send;

	if (code == CONFIGURE_REQUEST)
		{
		sptr_tx_packet->header.hdlc_address = HDLC_ADDRESS;
		sptr_tx_packet->header.hdlc_control = UNNUMBERED_INFORMATION;

		if (memcmp (&sptr_ncp->last_txed_configuration_request_packet[0],sptr_tx_packet,number_of_bytes_to_send) == (int) NULL)
			{
			ppp.port[real_port_number].id_sequence_number = (BYTE) (ppp.port[real_port_number].id_sequence_number - 1);

			sptr_ncp->last_request_id = ppp.port[real_port_number].id_sequence_number;
			}

		memcpy (&sptr_ncp->last_txed_configuration_request_packet[0],sptr_tx_packet,number_of_bytes_to_send);
		}

      /* Sachin changed the send completion function to ppp_ncp_send_complete.
      This was done for the accm problem - 14/07/1997 */

#ifndef __MLPPP__
#if 0
	send_native_ppp_packet (real_port_number,sptr_tx_packet,number_of_bytes_to_send,ppp_send_completion);
#else
	send_native_ppp_packet (real_port_number,sptr_tx_packet,number_of_bytes_to_send,ppp_ncp_send_completion);
#endif
#else
#if 0
	send_native_ppp_packet (mlppp.port[real_port_number].LinkInfo[0].port->port_number,
			sptr_tx_packet,number_of_bytes_to_send,ppp_send_completion);
#else
	send_native_ppp_packet (mlppp.port[real_port_number].LinkInfo[0].port->port_number,
			sptr_tx_packet,number_of_bytes_to_send,ppp_ncp_send_completion);
#endif
#endif
}
/*************************************************************************************************/
void send_ncp_configuration_ack (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,UNION_NCP_PACKET *sptr_ncp_rx_packet,
	USHORT number_of_bytes_rxed)
{
	NCP_CONFIGURE_ACK *sptr_ncp_configuration_ack_packet;
	 
	ppp_printf (PPP_NCP_PRINTF,"PPP NCP:Configuration Ack Tx on port: %04x\r\n",real_port_number);

	if (sptr_ncp_rx_packet->generic.configure_ack.ncp_header.code != CONFIGURE_REQUEST)
		{
		return;
		}

	sptr_ncp_configuration_ack_packet = (NCP_CONFIGURE_ACK *) ppp_get_a_send_packet (real_port_number,number_of_bytes_rxed);

	if (sptr_ncp_configuration_ack_packet == NULL)
		{
		return;
		}

	memcpy (sptr_ncp_configuration_ack_packet,sptr_ncp_rx_packet,number_of_bytes_rxed);

	sptr_ncp_configuration_ack_packet->ncp_header.code = CONFIGURE_ACK;

	++sptr_ncp->statistics.number_of_tx_packets;
	++sptr_ncp->statistics.number_of_tx_control_packets[CONFIGURE_ACK];

	sptr_ncp->statistics.number_of_tx_bytes += number_of_bytes_rxed;

#ifndef __MLPPP__
	send_native_ppp_packet (real_port_number,(PPP_PACKET *) sptr_ncp_configuration_ack_packet,
		number_of_bytes_rxed,ppp_send_completion);
#else
	send_native_ppp_packet (mlppp.port[real_port_number].LinkInfo[0].port->port_number,
		(PPP_PACKET *) sptr_ncp_configuration_ack_packet,number_of_bytes_rxed,ppp_send_completion);
#endif
}
/******************************************************************************/
void send_ncp_configuration_nak (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,NCP_PACKET *sptr_ncp_rx_packet)
{
	NCP_CONFIGURE_NAK *sptr_ncp_configure_nak_packet;
	USHORT number_of_bytes_to_send;

	ppp_printf (PPP_NCP_PRINTF,"PPP NCP: %s Configuration Nak Request Tx on port: %04x\r\n",sptr_ncp->name,real_port_number);

	number_of_bytes_to_send = get_size_of_ppp_options (&sptr_ncp->option_lists.tx_nak);

	number_of_bytes_to_send += (USHORT) (sizeof (sptr_ncp_configure_nak_packet->ppp_header) +
		sizeof (sptr_ncp_configure_nak_packet->ncp_header));

	sptr_ncp_configure_nak_packet = (NCP_CONFIGURE_NAK *) ppp_get_a_send_packet (real_port_number,number_of_bytes_to_send);

	if (sptr_ncp_configure_nak_packet == NULL)
		{
		return;
		}

	sptr_ncp->configuration_request_send_interval = 0x0000;

	store_ppp_options_in_packet (&sptr_ncp->option_lists.tx_nak,(PPP_OPTION *) &sptr_ncp_configure_nak_packet->options);

	send_ncp_packet (sptr_ncp,real_port_number,(PPP_PACKET *) sptr_ncp_configure_nak_packet,number_of_bytes_to_send,
		CONFIGURE_NAK,sptr_ncp_rx_packet->ncp_header.id);
}
/******************************************************************************/
void send_ncp_configuration_reject (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,NCP_PACKET *sptr_ncp_rx_packet)
{
	NCP_CONFIGURE_REJECT *sptr_ncp_configure_reject_packet;
	USHORT number_of_bytes_to_send;

	ppp_printf (PPP_NCP_PRINTF,"PPP NCP: %s Configuration Reject Tx on port: %04x\r\n",sptr_ncp->name,real_port_number);

	number_of_bytes_to_send = get_size_of_ppp_options (&sptr_ncp->option_lists.tx_reject);

	number_of_bytes_to_send += (USHORT) (sizeof (sptr_ncp_configure_reject_packet->ppp_header) +
		sizeof (sptr_ncp_configure_reject_packet->ncp_header));

	sptr_ncp_configure_reject_packet = (NCP_CONFIGURE_REJECT *) ppp_get_a_send_packet (real_port_number,number_of_bytes_to_send);

	if (sptr_ncp_configure_reject_packet == NULL)
		{
		return;
		}

	sptr_ncp->configuration_request_send_interval = 0x0000;

	store_ppp_options_in_packet (&sptr_ncp->option_lists.tx_reject,(PPP_OPTION *) &sptr_ncp_configure_reject_packet->options);

	send_ncp_packet (sptr_ncp,real_port_number,(PPP_PACKET *) sptr_ncp_configure_reject_packet,number_of_bytes_to_send,
		CONFIGURE_REJECT,sptr_ncp_rx_packet->ncp_header.id);
}
/******************************************************************************/
void send_ncp_termination_request (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number)
{
	NCP_TERMINATE_REQUEST *sptr_ncp_termination_request_packet;
	 
	ppp_printf (PPP_NCP_PRINTF,"PPP NCP:Termination Request Tx on port: %04x\r\n",real_port_number);

	sptr_ncp_termination_request_packet =
		(NCP_TERMINATE_REQUEST *) ppp_get_a_send_packet (real_port_number,sizeof (TERMINATE_REQUEST));

	if (sptr_ncp_termination_request_packet == NULL)
		{
		return;
		}

	ppp.port[real_port_number].id_sequence_number = (BYTE) (ppp.port[real_port_number].id_sequence_number + 1);

	send_ncp_packet (sptr_ncp,real_port_number,(PPP_PACKET *) sptr_ncp_termination_request_packet,sizeof (NCP_TERMINATE_REQUEST),
		TERMINATION_REQUEST,ppp.port[real_port_number].id_sequence_number);
}
/****************************************************************************/
void send_ncp_termination_ack (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number, NCP_PACKET *sptr_ncp_rx_packet)
{
	NCP_TERMINATE_ACK *sptr_ncp_termination_ack_packet;

	ppp_printf (PPP_NCP_PRINTF,"PPP NCP:Termination Ack Tx on port: %04x\r\n",real_port_number);

	sptr_ncp_termination_ack_packet = (NCP_TERMINATE_ACK *) ppp_get_a_send_packet (real_port_number,sizeof (NCP_TERMINATE_ACK));

	if (sptr_ncp_termination_ack_packet == NULL)
		{
		return;
		}

	send_ncp_packet (sptr_ncp,real_port_number,(PPP_PACKET *) sptr_ncp_termination_ack_packet,sizeof (NCP_TERMINATE_ACK),
		TERMINATION_ACK,sptr_ncp_rx_packet->ncp_header.id);
}
/****************************************************************************/
void send_ncp_code_reject (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number, NCP_PACKET *sptr_ncp_rx_packet,
	USHORT number_of_bytes_rxed)
{
	NCP_CODE_REJECT_PACKET *sptr_ncp_code_reject_packet;
	USHORT number_of_bytes_in_tx_packet;

	ppp_printf (PPP_LCP_PRINTF,"PPP NCP:Code Reject Tx on port: %04x\r\n",real_port_number);

	number_of_bytes_in_tx_packet = (USHORT) (sizeof (PPP_HEADER) + sizeof (LCP_HEADER) + number_of_bytes_rxed);

	sptr_ncp_code_reject_packet =
		(NCP_CODE_REJECT_PACKET *) ppp_get_a_send_packet (real_port_number,number_of_bytes_in_tx_packet);

	if (sptr_ncp_code_reject_packet == NULL)
		{
		return;
		}

	memcpy (&sptr_ncp_code_reject_packet->rejected_packet,sptr_ncp_rx_packet,number_of_bytes_rxed);

	send_ncp_packet (sptr_ncp,real_port_number,(PPP_PACKET *) sptr_ncp_code_reject_packet,
		sizeof (number_of_bytes_in_tx_packet),CODE_REJECT,sptr_ncp_rx_packet->ncp_header.id);
}
/*************************************************************************/
void signal_up_event_to_ncp (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number)
{
	USHORT virtual_port_number;

	ppp_printf (PPP_NCP_PRINTF,"PPP NCP:Port Up: %04x\r\n",real_port_number);

	virtual_port_number = (USHORT) (real_port_number + ppp.number_of_lan_ports);

	if (sptr_ncp != NULL)
		{
		(*sptr_ncp->fptr_protocol_stack_up) (virtual_port_number,sptr_ncp);
		}
}
/*************************************************************************/
void signal_down_event_to_ncp (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number)
{
	USHORT virtual_port_number;

	virtual_port_number = (USHORT) (real_port_number + ppp.number_of_lan_ports);

#ifdef __DOD__
	/* Protocol Stacks should not be informed when the link is down 
	due to no traffic */

/* sudhir  */
#if 0
	if (ppp.port[real_port_number].connect_state == LINK_DOWN_BY_DEMAND)
		return;
#endif
/* sudhir  */

#endif /* __DOD__ */

	if (sptr_ncp != NULL)
		{
		ppp_printf (PPP_NCP_PRINTF,"PPP NCP:Port Down: %04x\r\n",real_port_number);

		lsl_control (PROTOCOL_STACK_PORT,virtual_port_number,sptr_ncp->protocol_stack_id,CLOSE_VIRTUAL_PORT,virtual_port_number);
		}
}
