#include	"defs.h"
/*	$Modname: pppoptnp.c$  $version: 1.8$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 12/05/94 ross
1.1 12/11/94 ross adding multiple value option support
1.2 12/13/94 ross added copyrights in some files
1.3 01/26/95 ross changes for rwutils
1.4 02/27/95 ross dynamic load changes including lsl_control.
1.5 03/03/95 ross added up calls.
1.6 03/10/95 ross general fixes.  see change.doc
1.7 03/20/95 ross changed negotiation error parameter and upcall.
1.8 10/19/95 biao fixed bugs. Please refer to change.doc for details.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1993 - 1994 RouterWare, Inc.   								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA 92660	*/
/************************************************************************/
#include <string.h>
#include "ppp.h"
/****************************************************************************/
static enum BOOLEAN option_is_zero (OPTION_LIST_ENTRY *sptr_remote_option);
static OPTION_LIST_ENTRY *find_next_matching_option (OPTION_LIST_ENTRY *sptr_option);
static void increment_range_option (UNION_OPTION_DATA_TYPES *uptr_matching_option_data,
	UNION_OPTION_DATA_TYPES *uptr_step_size,BYTE length);
static ALTERNATE_OPTION *find_alternate_option_to_nak_with (BYTE nak_option_number_to_match,OPTION_LIST_ENTRY *sptr_local_option);
static void find_range_option_to_nak_with (BYTE nak_option_number_to_match,OPTION_LIST_ENTRY *sptr_local_option,
	OPTION_LIST_ENTRY *sptr_range_option);
static void ppp_negotiation_error (enum BOOLEAN ncp,void *vptr_context,USHORT port_number,OPTION_LIST_ENTRY *sptr_received_option,
	OPTION_LISTS *sptr_option_lists);
/****************************************************************************/
enum TEST ppp_ncp_configure_request_option_processor (OPTION_LIST_ENTRY *sptr_remote_option,PPP_NCP_CLASS *sptr_ncp)
{
	OPTION_LIST_ENTRY *sptr_local_option;

	sptr_local_option = find_matching_option (&sptr_ncp->option_lists.remote_configured,sptr_remote_option->type.generic);

	if (sptr_local_option == NULL)  /* this should never happen but just in case */
		{
		return (FAIL); 
		}

	/* Srikar, Mar 23, 1997. Added to support administrative enable/disable of IP options. Returning FAIL here */
	/* would force a nak for this option. */

	if (sptr_local_option->admin_status != SNMP_PPP_OPTION_ADMIN_ENABLED)
		{
		return(FAIL);
		}

	if (sptr_local_option->negotiable == TRUE)
		{
		if (option_is_zero (sptr_remote_option) == FALSE)
			{
			return (PASS);
			}
		}

	if (option_value_match (sptr_local_option,sptr_remote_option) != NULL)
		{
		return (PASS);
		}

	if (alternate_option_value_match (sptr_local_option,sptr_remote_option) != NULL)
		{
		return (PASS);
		}

	if (range_option_value_match (sptr_local_option,sptr_remote_option) == TRUE)
		{
		return (PASS);
		}

	if (set_option_values_for_nak (sptr_local_option,sptr_remote_option) == FAIL)
		{
		ppp_negotiation_error (TRUE,sptr_ncp,sptr_ncp->real_port_number,sptr_remote_option,&sptr_ncp->option_lists);
		}

	return (FAIL);
}
/****************************************************************************/
static enum BOOLEAN option_is_zero (OPTION_LIST_ENTRY *sptr_remote_option)
{
	if (sptr_remote_option->length == sizeof (USHORT))
		{
		if (sptr_remote_option->uptr_data->_ushort == 0x0000)
			{
			return (TRUE);
			}
		}

	if (sptr_remote_option->length == sizeof (ULONG))
		{
		if (sptr_remote_option->uptr_data->_ulong == 0x00000000L)
			{
			return (TRUE);
			}
		}

	return (FALSE);
}
/****************************************************************************/
enum TEST ppp_ncp_configure_nak_option_processor (OPTION_LIST_ENTRY *sptr_remote_option,PPP_NCP_CLASS *sptr_ncp)
{
	OPTION_LIST_ENTRY *sptr_local_option;
	ALTERNATE_OPTION *sptr_alternate_option;

	sptr_local_option = find_matching_option (&sptr_ncp->option_lists.tx_accepted,sptr_remote_option->type.generic);

	if (sptr_local_option == NULL)  /* this should never happen but just in case */
		{
		return (FAIL); 
		}

	if (sptr_local_option->negotiable == TRUE)
		{
		if (option_value_match (sptr_local_option,sptr_remote_option) != NULL)
			{
			return (PASS);
			}

		sptr_alternate_option = alternate_option_value_match (sptr_local_option,sptr_remote_option);

		if (sptr_alternate_option != NULL)
			{
			replace_data_field_in_option (sptr_local_option,sptr_alternate_option->uptr_data,sptr_alternate_option->length);

			return (PASS);
			}

		if (range_option_value_match (sptr_local_option,sptr_remote_option) == TRUE)
			{
			replace_data_field_in_option (sptr_local_option,sptr_remote_option->uptr_data,sptr_remote_option->length);

			return (PASS);
			}

		replace_data_field_in_option (sptr_local_option,sptr_remote_option->uptr_data,sptr_remote_option->length);

		return (PASS);
		}
	else
		{
		ppp_negotiation_error (TRUE,sptr_ncp,sptr_ncp->real_port_number,sptr_remote_option,&sptr_ncp->option_lists);

		return (FAIL);
		}
}
/****************************************************************************/
enum TEST ppp_lcp_configure_request_option_processor (OPTION_LIST_ENTRY *sptr_remote_option,PPP_PORT_CLASS *sptr_port)
{
	OPTION_LIST_ENTRY *sptr_local_option;

	sptr_local_option = find_matching_option (&sptr_port->option_lists.remote_configured,sptr_remote_option->type.generic);

	if (sptr_local_option == NULL)  /* this should never happen but just in case */
		{
		return (FAIL); 
		}

	/* Srikar, Mar 23, 1997. Added to support administrative enable/disable of IP options. */

	if (sptr_local_option->admin_status == SNMP_PPP_OPTION_ADMIN_DISABLED)
		{
		return(FAIL);
		}

	if (sptr_local_option->negotiable == TRUE)
		{
		return (PASS);
		}

	if (option_value_match (sptr_local_option,sptr_remote_option) != NULL)
		{
		return (PASS);
		}

	if (alternate_option_value_match (sptr_local_option,sptr_remote_option) != NULL)
		{
		return (PASS);
		}

	if (range_option_value_match (sptr_local_option,sptr_remote_option) == TRUE)
		{
		return (PASS);
		}

	if (set_option_values_for_nak (sptr_local_option,sptr_remote_option) == FAIL)
		{
		ppp_negotiation_error (FALSE,sptr_port,sptr_port->port_number,sptr_remote_option,&sptr_port->option_lists);
		}

	return (FAIL);
}
/****************************************************************************/
enum TEST ppp_lcp_configure_nak_option_processor (OPTION_LIST_ENTRY *sptr_remote_option,PPP_PORT_CLASS *sptr_port)
{
	OPTION_LIST_ENTRY *sptr_local_option;
	ALTERNATE_OPTION *sptr_alternate_option;

	sptr_local_option = find_matching_option (&sptr_port->option_lists.tx_accepted,sptr_remote_option->type.generic);

	if (sptr_local_option == NULL)  /* this should never happen but just in case */
		{
		return (FAIL); 
		}

	if (sptr_local_option->negotiable == TRUE)
		{
		if (option_value_match (sptr_local_option,sptr_remote_option) != NULL)
			{
			return (PASS);
			}

		sptr_alternate_option = alternate_option_value_match (sptr_local_option,sptr_remote_option);

		if (sptr_alternate_option != NULL)
			{
			replace_data_field_in_option (sptr_local_option,sptr_alternate_option->uptr_data,sptr_alternate_option->length);

			return (PASS);
			}

		if (range_option_value_match (sptr_local_option,sptr_remote_option) == TRUE)
			{
			replace_data_field_in_option (sptr_local_option,sptr_remote_option->uptr_data,sptr_remote_option->length);

			return (PASS);
			}

		replace_data_field_in_option (sptr_local_option,sptr_remote_option->uptr_data,sptr_remote_option->length);

		return (PASS);
		}
	else
		{
		ppp_negotiation_error (TRUE,sptr_port,sptr_port->port_number,sptr_remote_option,&sptr_port->option_lists);

		return (FAIL);
		}
}
/****************************************************************************/
OPTION_LIST_ENTRY *option_value_match (OPTION_LIST_ENTRY *sptr_local_option,OPTION_LIST_ENTRY *sptr_remote_option)
{
	OPTION_LIST_ENTRY *sptr_next_local;

	if (sptr_local_option->length != sptr_remote_option->length)
		{
		for (sptr_next_local = find_next_matching_option (sptr_local_option); sptr_next_local != NULL;
			sptr_next_local = find_next_matching_option (sptr_next_local))
			{
			if (sptr_local_option->length == sptr_remote_option->length)
				{
				if (memcmp (sptr_next_local->uptr_data,sptr_remote_option->uptr_data,sptr_local_option->length) == (int) NULL)
					{
					return (sptr_next_local);
					}
				}
			}
		}
	else
		{
		if (memcmp (sptr_local_option->uptr_data,sptr_remote_option->uptr_data,sptr_local_option->length) == (int) NULL)
			{
			return (sptr_local_option);
			}
		}

	return (NULL);
}
/****************************************************************************/
static OPTION_LIST_ENTRY *find_next_matching_option (OPTION_LIST_ENTRY *sptr_option)
{
	OPTION_LIST_ENTRY *sptr_matching_option;

	for (sptr_matching_option = sptr_option->sptr_forward_link; sptr_matching_option != NULL;
		sptr_matching_option = sptr_matching_option->sptr_forward_link)
		{
		if (sptr_matching_option->type.generic == sptr_option->type.generic)
			{
			break;
			}
		}

	return (sptr_matching_option);
}
/****************************************************************************/
ALTERNATE_OPTION *alternate_option_value_match (OPTION_LIST_ENTRY *sptr_local_option,OPTION_LIST_ENTRY *sptr_remote_option)
{
	ALTERNATE_OPTION *sptr_alternate_option;

	if (sptr_local_option->alternate_checking_enabled == FALSE)
		{
		return (NULL);
		}

	for (sptr_alternate_option = sptr_local_option->alternate_option_list.sptr_forward_link; sptr_alternate_option != NULL;
		sptr_alternate_option = sptr_alternate_option->links.sptr_forward_link)
		{
		if (sptr_alternate_option->length == sptr_remote_option->length)
			{
			if (memcmp (sptr_alternate_option->uptr_data,sptr_remote_option->uptr_data,sptr_local_option->length) == (int) NULL)
				{
				return (sptr_alternate_option);
				}
			}
		}

	return (NULL);
}
/****************************************************************************/
enum BOOLEAN range_option_value_match (OPTION_LIST_ENTRY *sptr_local_option,OPTION_LIST_ENTRY *sptr_remote_option)
{
	UNION_OPTION_DATA_TYPES	*uptr_matching_option_data;
	USHORT option_length;
	BYTE *bptr_step_option;

	if (sptr_local_option->range_checking_enabled == FALSE)
		{
		return (FALSE);
		}

	if (sptr_local_option->length != sptr_remote_option->length)
		{
		return (FALSE);
		}

	bptr_step_option = (BYTE *) sptr_local_option->uptr_step;

	for (option_length = 0x0000; option_length < sptr_local_option->length; ++option_length)
		{
		if (*bptr_step_option != 0x00)
			{
			break;
			}

		++bptr_step_option;
		}

	if (*bptr_step_option == 0x00)
		{
		switch (sptr_local_option->length)
			{
			case sizeof (USHORT):
				if ((sptr_local_option->uptr_lowest_value->_ushort < sptr_remote_option->uptr_data->_ushort) &&
					(sptr_remote_option->uptr_data->_ushort < sptr_local_option->uptr_highest_value->_ushort))
					{
					return (TRUE);
					}
				break;
			case sizeof (ULONG):
				if ((sptr_local_option->uptr_lowest_value->_ulong < sptr_remote_option->uptr_data->_ulong) &&
					(sptr_remote_option->uptr_data->_ulong < sptr_local_option->uptr_highest_value->_ulong))
					{
					return (TRUE);
					}

				break;
			default:
				break;
			}
		}

	for (uptr_matching_option_data = sptr_local_option->uptr_lowest_value;
		memcmp (uptr_matching_option_data, sptr_local_option->uptr_highest_value, sptr_remote_option->length) != (int) NULL;
		increment_range_option (uptr_matching_option_data,sptr_local_option->uptr_step,sptr_local_option->length))
		{
		if (memcmp (uptr_matching_option_data,sptr_remote_option->uptr_data,sptr_remote_option->length) == (int) NULL)
			{
			return (TRUE);
			}
		}
		
	if (memcmp (uptr_matching_option_data,sptr_remote_option->uptr_data,sptr_remote_option->length) == (int) NULL)
		{
		return (TRUE);
		}

	return (FALSE);
}
/****************************************************************************/
static void increment_range_option (UNION_OPTION_DATA_TYPES *uptr_matching_option_data,
	UNION_OPTION_DATA_TYPES *uptr_step_size,BYTE length)
{
	BYTE *bptr_option_data;
	BYTE *bptr_step_data;
	BYTE data_index;

	bptr_option_data = (BYTE *) uptr_matching_option_data;
	bptr_step_data = (BYTE *) uptr_step_size;

	for (data_index = 0x00; data_index < length; data_index = (BYTE) (data_index + 1))
		{
		*bptr_option_data = (BYTE) (*bptr_option_data + *bptr_step_data);

		++bptr_option_data;
		++bptr_step_data;
		}
}
/****************************************************************************/
enum TEST set_option_values_for_nak (OPTION_LIST_ENTRY *sptr_local_option,OPTION_LIST_ENTRY *sptr_remote_option)
{
	UNION_OPTION_DATA_TYPES	*uptr_preferred_data;
	BYTE length_of_preferred_data;
	ALTERNATE_OPTION *sptr_alternate_option;
	OPTION_LIST_ENTRY range_option;

	if (sptr_local_option->nak_option_selected == 0x00)
		{
		uptr_preferred_data = sptr_local_option->uptr_data;
		}
	else
		{
		sptr_alternate_option = find_alternate_option_to_nak_with (sptr_local_option->nak_option_selected,sptr_local_option);

		if (sptr_alternate_option == NULL)
			{
			find_range_option_to_nak_with (sptr_local_option->nak_option_selected,sptr_local_option,&range_option);

			if (range_option.uptr_data == NULL)
				{
				sptr_local_option->nak_option_selected = 0x00;

				return (FAIL);
				}

			uptr_preferred_data = range_option.uptr_data;
			}
		else
			{
			uptr_preferred_data = sptr_alternate_option->uptr_data;
			}
		}

	length_of_preferred_data =	sptr_local_option->length;

	if (sptr_local_option->length == sptr_remote_option->length)
		{
		memcpy (sptr_remote_option->uptr_data,uptr_preferred_data,length_of_preferred_data);
		}
	else
		{
		replace_data_field_in_option (sptr_remote_option,uptr_preferred_data,length_of_preferred_data);
		}

	if ((sptr_local_option->alternate_checking_enabled == TRUE) || (sptr_local_option->range_checking_enabled == TRUE))
		{
		sptr_local_option->nak_option_selected = (BYTE) (sptr_local_option->nak_option_selected + 1);
		}

	return (PASS);
}
/****************************************************************************/
static ALTERNATE_OPTION *find_alternate_option_to_nak_with (BYTE nak_option_number_to_match,OPTION_LIST_ENTRY *sptr_local_option)
{
	ALTERNATE_OPTION *sptr_alternate_option;
	BYTE nak_option_selected;

	nak_option_selected = 0x01;

	if (sptr_local_option->alternate_checking_enabled == FALSE)
		{
		return (NULL);
		}

	for (sptr_alternate_option = sptr_local_option->alternate_option_list.sptr_forward_link; sptr_alternate_option != NULL;
		sptr_alternate_option = sptr_alternate_option->links.sptr_forward_link)
		{
		if (nak_option_number_to_match == nak_option_selected)
			{
			break;
			}

		nak_option_selected = (BYTE) (nak_option_selected + 1);
		}

	return (sptr_alternate_option);
}
/****************************************************************************/
static void find_range_option_to_nak_with (BYTE nak_option_number_to_match,OPTION_LIST_ENTRY *sptr_local_option,
	OPTION_LIST_ENTRY *sptr_range_option)
{
	UNION_OPTION_DATA_TYPES	*uptr_matching_option_data;
	BYTE nak_option_selected;

	nak_option_selected = 0x01;

	sptr_range_option->uptr_data = NULL;

	if (sptr_local_option->range_checking_enabled == FALSE)
		{
		return;
		}

	for (uptr_matching_option_data = sptr_local_option->uptr_lowest_value; uptr_matching_option_data != NULL;
		increment_range_option (uptr_matching_option_data,sptr_local_option->uptr_step,sptr_local_option->length))
		{
		if (nak_option_number_to_match == nak_option_selected)
			{
			return;
			}

		nak_option_selected = (BYTE) (nak_option_selected + 1);
		}
}
/****************************************************************************/
static void ppp_negotiation_error (enum BOOLEAN ncp,void *vptr_context,USHORT port_number,OPTION_LIST_ENTRY *sptr_received_option,
	OPTION_LISTS *sptr_option_lists)
{
	enum BOOLEAN close_connection;

	close_connection = TRUE;

	if (ppp.fptr_event_upcall != NULL)
		{
		close_connection = (enum BOOLEAN) (*ppp.fptr_event_upcall) (PPP_EVENT_OPTIONS_EXHAUSTED,port_number,ncp,vptr_context,
			sptr_received_option,sptr_option_lists);
		}

	if (close_connection == TRUE)
		{
		if (ncp == TRUE)
			{
			execute_ncp_state_machine (PPP_CLOSE_EVENT,vptr_context,port_number,NULL,0x0000);
			}
		else
			{
			execute_ppp_state_machine (PPP_CLOSE_EVENT,port_number,NULL,0x0000);
			}
		}
}

/* Added by Naveen... */
/****************************************************************************/
enum TEST ppp_lcp_configure_nak_option_processor_for_epd (OPTION_LIST_ENTRY *sptr_remote_option,PPP_PORT_CLASS *sptr_port)
{
/*	This should never happen. According to rfc you MUST NOT nak EPD.
	rfc says if u receive a nak for EPD, u should remove it from further request*/

	OPTION_LIST_ENTRY *sptr_local_option;

	sptr_local_option = find_matching_option (&sptr_port->option_lists.tx_accepted,sptr_remote_option->type.generic);

	if (sptr_local_option == NULL)  /* this should never happen but just in case */
		{
		return (FAIL); 
		}

	delete_entry_from_option_list (&sptr_port->option_lists.tx_accepted, sptr_local_option);

	return (PASS);
}
/* ... Added by Naveen */

