#include	"defs.h"
/*	$Modname: pppupcal.c$  $version: 1.3$      $date: 05/15/95$   */
/*
* 	$lgb$
1.0 03/11/95 ross initial version.
1.1 03/11/95 ross added copyright.
1.2 03/16/95 ross fixed vararg.
1.3 05/15/95 ross cosmetic.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1995 RouterWare, Inc.   											*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA 92660	*/
/************************************************************************/
#include <stdarg.h>
#include "ppp.h"
#include <udb.h>
#include "vpppcb.h"
extern void *memcpy (void *, void *, int) ;
extern void *memset (void *, int, int) ;

/****************************************************************************/
extern enum BOOLEAN is_dial_in_permitted_for_port (RAS_USER_DATABASE_RECORD *udb_record, char port_number);
static ULONG ppp_event_lcp_this_layer_up (USHORT real_port_number,USHORT event,void *vptr_argument_list);
static ULONG ppp_event_lcp_this_layer_down (USHORT real_port_number,USHORT event,void *vptr_argument_list);
static ULONG ppp_event_lcp_this_layer_finished (USHORT real_port_number,USHORT event,void *vptr_argument_list);
static ULONG ppp_event_lcp_termination_request (USHORT real_port_number,USHORT event,void *vptr_argument_list);
static ULONG ppp_event_lcp_id_request (USHORT real_port_number,USHORT event,void *vptr_argument_list);
static ULONG ppp_event_lcp_id_received (USHORT real_port_number,USHORT event,void *vptr_argument_list);
static ULONG ppp_event_lcp_time_remaining_request (USHORT real_port_number,USHORT event,void *vptr_argument_list);
static ULONG ppp_event_lcp_time_remaining_received (USHORT real_port_number,USHORT event,void *vptr_argument_list);
static ULONG ppp_event_ncp_this_layer_up (USHORT real_port_number,USHORT event,void *vptr_argument_list);
static ULONG ppp_event_ncp_this_layer_down (USHORT real_port_number,USHORT event,void *vptr_argument_list);
static ULONG ppp_event_ncp_this_layer_finished (USHORT real_port_number,USHORT event,void *vptr_argument_list);
static ULONG ppp_event_authenticate_request (USHORT real_port_number,USHORT event,void *vptr_argument_list);
static ULONG ppp_event_authenticate_lookup (USHORT real_port_number,USHORT event,void *vptr_argument_list);
static ULONG ppp_event_authenticate_verify (USHORT real_port_number,USHORT event,void *vptr_argument_list);
static ULONG ppp_event_authenticate_ack_transmitted (USHORT real_port_number,USHORT event,void *vptr_argument_list);
static ULONG ppp_event_authenticate_ack_received (USHORT real_port_number,USHORT event,void *vptr_argument_list);
static ULONG ppp_event_authentication_failed (USHORT real_port_number,USHORT event,void *vptr_argument_list);
static ULONG ppp_event_authentication_refused (USHORT real_port_number,USHORT event,void *vptr_argument_list);
static ULONG ppp_event_options_exhausted (USHORT real_port_number,USHORT event,void *vptr_argument_list);

/* Jo 26/04/99 */
static const ULONG (*fptr_upcall[]) (USHORT event,USHORT real_port_number,void *vptr_argument_list) =
{
	ppp_event_lcp_this_layer_up,
	ppp_event_lcp_this_layer_down,
	ppp_event_lcp_this_layer_finished,
	ppp_event_lcp_termination_request,
	ppp_event_lcp_id_request,
	ppp_event_lcp_id_received,
	ppp_event_lcp_time_remaining_request,
	ppp_event_lcp_time_remaining_received,
	ppp_event_ncp_this_layer_up,
	ppp_event_ncp_this_layer_down,
	ppp_event_ncp_this_layer_finished,
	ppp_event_authenticate_request,
	ppp_event_authenticate_lookup,
	ppp_event_authenticate_verify,
	ppp_event_authenticate_ack_transmitted,
	ppp_event_authenticate_ack_received,
	ppp_event_authentication_failed,
	ppp_event_authentication_refused,
	ppp_event_options_exhausted
};
/****************************************************************************/
ULONG ppp_event_upcall_example (USHORT event,USHORT real_port_number,...)
{
	ULONG return_value;
	va_list argptr;

	va_start (argptr,real_port_number);

	if (event > PPP_EVENT_OPTIONS_EXHAUSTED)
	{
		ppp_printf (PPP_ALARM_PRINTF,"Illegal Up Call %04x\r\n",event);
	}

#ifdef DEBUG
	ppp_printf (PPP_ALARM_PRINTF,"PPP: OEM Upcall Event on Port %04x event %04x occurred\n",real_port_number,event);
#endif

	return_value = (*fptr_upcall[event]) (real_port_number,event,argptr);

	va_end (argptr);

	return (return_value);
}
/****************************************************************************/
static ULONG ppp_event_lcp_this_layer_up (USHORT real_port_number,USHORT event,void *vptr_argument_list)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (event);
	PARAMETER_NOT_USED (vptr_argument_list);

	return ((ULONG) NULL);
}
/****************************************************************************/
static ULONG ppp_event_lcp_this_layer_down (USHORT real_port_number,USHORT event,void *vptr_argument_list)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (event);
	PARAMETER_NOT_USED (vptr_argument_list);

	return ((ULONG) NULL);
}
/****************************************************************************/
static ULONG ppp_event_lcp_this_layer_finished (USHORT real_port_number,USHORT event,void *vptr_argument_list)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (event);
	PARAMETER_NOT_USED (vptr_argument_list);

	return ((ULONG) NULL);
}
/****************************************************************************/
static ULONG ppp_event_lcp_termination_request (USHORT real_port_number,USHORT event,void *vptr_argument_list)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (event);
	PARAMETER_NOT_USED (vptr_argument_list);

	return ((ULONG) NULL);
}
/****************************************************************************/
static ULONG ppp_event_lcp_id_request (USHORT real_port_number,USHORT event,void *vptr_argument_list)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (event);
	PARAMETER_NOT_USED (vptr_argument_list);

	return ((ULONG) NULL);
}
/****************************************************************************/
static ULONG ppp_event_lcp_id_received (USHORT real_port_number,USHORT event,void *vptr_argument_list)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (event);
	PARAMETER_NOT_USED (vptr_argument_list);

	return ((ULONG) NULL);
}
/****************************************************************************/
static ULONG ppp_event_lcp_time_remaining_request (USHORT real_port_number,USHORT event,void *vptr_argument_list)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (event);
	PARAMETER_NOT_USED (vptr_argument_list);

	return ((ULONG) NULL);
}
/****************************************************************************/
static ULONG ppp_event_lcp_time_remaining_received (USHORT real_port_number,USHORT event,void *vptr_argument_list)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (event);
	PARAMETER_NOT_USED (vptr_argument_list);

	return ((ULONG) NULL);
}
/****************************************************************************/
static ULONG ppp_event_ncp_this_layer_up (USHORT real_port_number,USHORT event,void *vptr_argument_list)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (event);
	PARAMETER_NOT_USED (vptr_argument_list);

	return ((ULONG) NULL);
}
/****************************************************************************/
static ULONG ppp_event_ncp_this_layer_down (USHORT real_port_number,USHORT event,void *vptr_argument_list)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (event);
	PARAMETER_NOT_USED (vptr_argument_list);

	return ((ULONG) NULL);
}
/****************************************************************************/
static ULONG ppp_event_ncp_this_layer_finished (USHORT real_port_number,USHORT event,void *vptr_argument_list)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (event);
	PARAMETER_NOT_USED (vptr_argument_list);

	return ((ULONG) NULL);
}
/****************************************************************************/
static ULONG ppp_event_authenticate_request (USHORT real_port_number,USHORT event,void *vptr_argument_list)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (event);
	PARAMETER_NOT_USED (vptr_argument_list);

	return ((ULONG) NULL);
}
/****************************************************************************/
static ULONG ppp_event_authenticate_lookup (USHORT real_port_number,USHORT event, void *vptr_argument_list)
{
	/* Called if authentication protocol is CHAP */

	RAS_USER_DATABASE_RECORD *sptr_udb_record ;
	char *name, *temp_ptr ;
	ULONG temp ;
	OPTION_LIST_ENTRY *sptr_option ;
	LCP_EXTENSION_CALLBACK *sptr_lcp_ext_callback ;
#if 0
	int protocol_stack_index = 0 ;
#endif

	temp = *((ULONG *) vptr_argument_list) ;
	vptr_argument_list = (char *)vptr_argument_list + sizeof(ULONG) ;
	name = (char *)temp ;
	temp_ptr = name ;

	memset (&ppp.port[real_port_number].ras_user_database_record, 0, sizeof (RAS_USER_DATABASE_RECORD)) ;

	if (get_ras_number_of_users() == 0)
	{
		/* So that if there is no user database, every user gets
		   user specified callback permissions */

/* Jo Added on 23/09/99 If No RAS Users, callback should not be negotiated */

/*		ppp.port[real_port_number].ras_user_database_record.call_back_enabled = 1 ;*/
		ppp.port[real_port_number].ras_user_database_record.call_back_enabled = 0 ;

/* Jo Added on 23/09/99 If No RAS Users, callback should not be negotiated */

		ppp.port[real_port_number].authentication.remote_user_name[0] = 0 ;
		ppp.port[real_port_number].authentication.remote_password[0] = 0 ;
		ppp_device_driver_control (PASSWORD_VERIFICATION, real_port_number, (ULONG)PASS) ;
		return ((ULONG) NULL) ;
	}

	/* The comparison is case-insensitive */
/*	printf ("PPP: User name is %s\n",name);*/
	sptr_udb_record = get_ptr_to_udb_record (name) ;
	if (sptr_udb_record == NULL)
	{
		printf ("User database : User %s not found in database\n", name) ;
		ppp_device_driver_control (PASSWORD_VERIFICATION, real_port_number, (ULONG)FAIL) ;
		return ((ULONG)NULL) ;
	}
	strcpy (&ppp.port[real_port_number].authentication.remote_password,
	        &sptr_udb_record->password[0]) ;
	strcpy (&ppp.port[real_port_number].authentication.remote_user_name,
	        &sptr_udb_record->user_name[0]) ;

	if (sptr_udb_record)
		memcpy (&ppp.port[real_port_number].ras_user_database_record, sptr_udb_record, sizeof (RAS_USER_DATABASE_RECORD))	;
/*
	Important : ppp_upper_layer_authentication_verification () is coded such that
	the last parameter is taken as a pointer to the password if the authentication
	protocol used is CHAP. A small change is made there to work around this. If
	the auth.-protocol is CHAP and the parameter is FAIL, it is treated as if the
	response values do not match.
*/

/* Jo 04/06/99 Added for RAS */
	if (is_dial_in_permitted_for_port (sptr_udb_record, real_port_number) == FALSE)
	{
		printf ("User database : User %s does not have dial-permission for port %d\n", name, real_port_number) ;
		ppp_device_driver_control (PASSWORD_VERIFICATION,real_port_number,(ULONG) FAIL);
		return ((ULONG) NULL);
	}
/* Jo 04/06/99 Added for RAS */
#ifdef _BIG_PROXY_ /* Jo 04/06/99 */
	if (is_ipx_permitted (sptr_udb_record) == FALSE)
	{
		printf ("User database : User %s does not have permission to use IPX\n", name) ;
#ifdef __MLPPP__
		mlppp.port[real_port_number].ncp[PPP_IPX_NCP_STACK_INDEX].enabled = FALSE ;
#else
		ppp.port[real_port_number].ncp[PPP_IPX_NCP_STACK_INDEX].enabled = FALSE ;
#endif
	}

	if (is_stp_permitted (sptr_udb_record) == FALSE)
	{
		printf ("User database : User %s does not have permission to use STP\n", name) ;
#ifdef __MLPPP__
		mlppp.port[real_port_number].ncp[PPP_BRIDGING_NCP_STACK_INDEX].enabled = FALSE ;
#else
		ppp.port[real_port_number].ncp[PPP_BRIDGING_NCP_STACK_INDEX].enabled = FALSE ;
#endif
	}
#endif /* Jo 04/06/99 */

	if (is_ip_permitted (sptr_udb_record) == FALSE)
	{
		printf ("User database : User %s does not have permission to use IP\n", name) ;
#ifdef __MLPPP__
		mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].enabled = FALSE ;
#else
		ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].enabled = FALSE ;
#endif
	}


	sptr_option = find_matching_option (&ppp.port[real_port_number].option_lists.rx_accepted,
	                                    LCP_CALLBACK) ;

	if (sptr_option != NULL)
	{
		/* Callback negotiated */

		sptr_lcp_ext_callback = (LCP_EXTENSION_CALLBACK *) &sptr_option->uptr_data->byte_array[0] ;
		
		if ((sptr_udb_record->call_back_security == 1) &&
		    ((sptr_lcp_ext_callback->operation != LOCATION_DETERMINED_BY_AUTHENTICATION)
			  &&(sptr_lcp_ext_callback->operation != LOC_DETERMINED_BY_CBCP_PROTOCOL)))
		{
			printf ("User database : User %s does not have required callback permissions\n", name) ;
			ppp_device_driver_control (PASSWORD_VERIFICATION,real_port_number,(ULONG) FAIL);
			return ((ULONG) NULL);
		}
	}

	ppp_device_driver_control (PASSWORD_VERIFICATION,real_port_number,
		(ULONG)&sptr_udb_record->password[0]) ;

	return ((ULONG) NULL);
}

/*
	Changes made by Sachin :
		To determine and affect the protocol permissions, what we do is, have a
	new boolean feild in the ncp class for each port. This boolean is used to
	remember if the protocols are enabled for that particular port. Actually,
	during the life-time of the ppp-connection, it is the feild "enabled", which
	is used. So to disable any ncp for that user, we only need to set the "enable"
	feild to FALSE. But what is VERY VERY important is that the value of the
	"enable" feild be restored (from the new feild called configured) on closing
	the connection.
*/



/****************************************************************************/
static ULONG ppp_event_authenticate_verify (USHORT real_port_number,USHORT event,void *vptr_argument_list)
{
	/* Called if authentication protocol is PAP */

	ULONG  tmpulong ;
	char *name, *temp_ptr ;
	char *password ;

	RAS_USER_DATABASE_RECORD *sptr_udb_record ;
	LCP_EXTENSION_CALLBACK *sptr_lcp_ext_callback ;
	OPTION_LIST_ENTRY *sptr_option ;

	tmpulong = *((ULONG *) vptr_argument_list);
	name =  (char *) tmpulong;
	vptr_argument_list = (char *)vptr_argument_list + sizeof(ULONG);
	tmpulong = *((ULONG *) vptr_argument_list);
	password =  (char *) tmpulong;

	memset (&ppp.port[real_port_number].ras_user_database_record, 0, sizeof (RAS_USER_DATABASE_RECORD)) ;

	if (get_ras_number_of_users() == 0)
	{
		/* So that if there is no user database, every user gets
		   user specified callback permissions */

/* Jo Added on 23/09/99 If No RAS Users, callback should not be negotiated */

/*		ppp.port[real_port_number].ras_user_database_record.call_back_enabled = 1 ;*/
		ppp.port[real_port_number].ras_user_database_record.call_back_enabled = 0 ;

/* Jo Added on 23/09/99 If No RAS Users, callback should not be negotiated */

		ppp.port[real_port_number].authentication.remote_user_name[0] = 0 ;
		ppp.port[real_port_number].authentication.remote_password[0] = 0 ;
		ppp_device_driver_control (PASSWORD_VERIFICATION, real_port_number, (ULONG)PASS) ;
		return ((ULONG) NULL) ;
	}

	/* The comparison is case-insensitive */
	sptr_udb_record = get_ptr_to_udb_record (name) ;
	if (sptr_udb_record == NULL)
	{
		ppp_device_driver_control (PASSWORD_VERIFICATION, real_port_number, (ULONG)FAIL) ;
		return ((ULONG)  NULL) ;
	}

	strcpy (&ppp.port[real_port_number].authentication.remote_password,
	        &sptr_udb_record->password[0]) ;
	strcpy (&ppp.port[real_port_number].authentication.remote_user_name,
	        &sptr_udb_record->user_name[0]) ;

	if (sptr_udb_record)
		memcpy (&ppp.port[real_port_number].ras_user_database_record, sptr_udb_record, sizeof (RAS_USER_DATABASE_RECORD)) ;

	/* If password is non-NULL compare passwords */
	if (do_passwords_match (sptr_udb_record, password) == FALSE)
	{
		printf ("User database : passwords do not match\n") ;
		ppp_device_driver_control (PASSWORD_VERIFICATION,real_port_number,(ULONG) FAIL);
		return ((ULONG) NULL);
	}

/* Jo 04/06/99 Added for RAS */
	if (is_dial_in_permitted_for_port (sptr_udb_record, real_port_number) == FALSE)
	{
		printf ("User database : User %s does not have dial-in permission for port %d", name, real_port_number) ;
		ppp_device_driver_control (PASSWORD_VERIFICATION,real_port_number,(ULONG) FAIL);
		return ((ULONG) NULL);
	}
/* Jo 04/06/99 Added for RAS */

#ifdef _BIG_PROXY_ /* Jo 04/06/99 */
	if (is_ipx_permitted (sptr_udb_record) == FALSE)
	{
		printf ("User database : User %s does not have permission to use IPX", name) ;
#ifdef __MLPPP__
		mlppp.port[real_port_number].ncp[PPP_IPX_NCP_STACK_INDEX].enabled = FALSE ;
#else
		ppp.port[real_port_number].ncp[PPP_IPX_NCP_STACK_INDEX].enabled = FALSE ;
#endif
	}

	if (is_stp_permitted (sptr_udb_record) == FALSE)
	{
		printf ("User database : User %s does not have permission to use STP", name) ;
#ifdef __MLPPP__
		mlppp.port[real_port_number].ncp[PPP_BRIDGING_NCP_STACK_INDEX].enabled = FALSE ;
#else
		ppp.port[real_port_number].ncp[PPP_BRIDGING_NCP_STACK_INDEX].enabled = FALSE ;
#endif
	}
#endif /* Jo 04/06/99 */

	if (is_ip_permitted (sptr_udb_record) == FALSE)
	{
		printf ("User database : User %s does not have permission to use IP", name) ;
#ifdef __MLPPP__
		mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].enabled = FALSE ;
#else
		ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].enabled = FALSE ;
#endif
	}


	sptr_option = find_matching_option (&ppp.port[real_port_number].option_lists.rx_accepted,
	                                    LCP_CALLBACK) ;
	
	if (sptr_option != NULL)
	{
		sptr_lcp_ext_callback = (LCP_EXTENSION_CALLBACK *) &sptr_option->uptr_data->byte_array[0] ;

		if ((sptr_udb_record->call_back_security == 1) &&
		    ((sptr_lcp_ext_callback->operation != LOCATION_DETERMINED_BY_AUTHENTICATION)
			  &&(sptr_lcp_ext_callback->operation != LOC_DETERMINED_BY_CBCP_PROTOCOL)))
		{
			printf ("PPP : User %s does not have required callback permissions\n", name) ;
			ppp_device_driver_control (PASSWORD_VERIFICATION,real_port_number,(ULONG) FAIL);
			return ((ULONG) NULL);
		}
	}
	/* authentication successful */
	ppp_device_driver_control (PASSWORD_VERIFICATION,real_port_number,(ULONG) PASS);

	return ((ULONG) NULL);
}
/****************************************************************************/
static ULONG ppp_event_authenticate_ack_transmitted (USHORT real_port_number,USHORT event,void *vptr_argument_list)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (event);
	PARAMETER_NOT_USED (vptr_argument_list);

	return ((ULONG) NULL);
}
/****************************************************************************/
static ULONG ppp_event_authenticate_ack_received (USHORT real_port_number,USHORT event,void *vptr_argument_list)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (event);
	PARAMETER_NOT_USED (vptr_argument_list);

	return ((ULONG) NULL);
}
/****************************************************************************/
static ULONG ppp_event_authentication_failed (USHORT real_port_number,USHORT event,void *vptr_argument_list)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (event);
	PARAMETER_NOT_USED (vptr_argument_list);

	return ((ULONG) NULL);
}
/****************************************************************************/
static ULONG ppp_event_authentication_refused (USHORT real_port_number,USHORT event,void *vptr_argument_list)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (event);
	PARAMETER_NOT_USED (vptr_argument_list);

	return ((ULONG) NULL);
}
/****************************************************************************/
static ULONG ppp_event_options_exhausted (USHORT real_port_number,USHORT event,void *vptr_argument_list)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (event);
	PARAMETER_NOT_USED (vptr_argument_list);

	return ((ULONG) NULL);
}
