#include	"defs.h"
/*	$Modname: ppputil.c$  $version: 1.28$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 12/10/93 ross Initial Release.
1.1 01/05/94 ross Chnaged include files.
1.2 01/05/94 keyur Added support for version control.
1.3 01/20/94 keyur Added call to device driver malloc function instead of calloc.
1.4 01/21/94 keyur Added heapcheck () function for checking memory clobbering.
1.5 01/28/94 keyur Added functions reset_link () and call to protocol stacks for up or down signal.
1.6 02/01/94 keyur Added virtual port support for IP stack.
1.7 02/02/94 keyur          Added function for getting local ip address.
1.8 02/22/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John. Ad
1.9 03/09/94 keyur There is no major change in this release.
1.10 03/23/94 keyur Added functions for async PPP.
1.11 03/26/94 keyur Added and tested Asynchronous Support and ATCP for Appletalk Support
1.12 04/04/94 keyur Cosmetic Changes while documenting
1.13 04/12/94 keyur Added State Machine support for LCP according to RFC1548
1.14 04/13/94 keyur Added support for NCP state machine
1.15 04/19/94 keyur Added ordering of options for LCP and NCP, courtesy of John
1.16 05/02/94 keyur
1.17 05/02/94 keyur took out memcheck header file.
1.18 06/15/94 keyur cosmetic changes.
1.19 08/11/94 ross adding rfc1570 lcp support
1.20 08/24/94 ross adding new ncps.
1.21 09/06/94 ross added stand alone routines.
1.22 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.23 12/02/94 ross testing NT3.5 RAS
1.24 12/13/94 ross connected to NT RAS with Netbios
1.25 01/26/95 ross changes for rwutils
1.26 03/10/95 ross general fixes.  see change.doc
1.27 06/26/95 ross initial version of BCP
1.28 10/19/95 biao made no changes.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 RouterWare, Inc.							   	*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include "ppp.h"

#ifdef STATUS_DEBUG
#include <wanmgr.h>
extern enum WAN_PORT_OWNER get_wan_port_owner(USHORT port_number);
extern USHORT get_modem_state_for_port(USHORT port_number);
#endif

/****************************************************************************/
static void packet_allocation_error (USHORT port_number,ULONG size_of_packet);
static void ppp_free_a_send_packet (USHORT real_port_number,void *sptr_tx_packet);
extern enum BOOLEAN is_port_dial_on_demand(USHORT port_number);
/****************************************************************************/
void *ppp_get_a_send_packet (USHORT port_number,ULONG size_of_packet)
{
	void *vptr_send_packet;

	vptr_send_packet = (void *) buffer_malloc (size_of_packet);

/*	ppp_printf (PPP_MEMORY_PRINTF,"PPP: Pointer to send packet for port %04x, %p\r\n",port_number,vptr_send_packet);*/

	if (vptr_send_packet == NULL)
		packet_allocation_error (port_number,size_of_packet);

	return (vptr_send_packet);
}
/*************************************************************************/
static void ppp_free_a_send_packet (USHORT real_port_number,void *vptr_tx_packet)
{
	PARAMETER_NOT_USED (real_port_number);

#ifdef __BORLANDC__
	if (((ULONG) vptr_tx_packet) & 0x00000001)
		ppp_printf (PPP_ALARM_PRINTF,"Free Error of %p\r\n",vptr_tx_packet);
#endif

	vptr_tx_packet = (void *) ((ULONG) vptr_tx_packet + sizeof (MAC_HEADER) - sizeof (PPP_HEADER));
	
	ppp_printf (PPP_MEMORY_PRINTF,"PPP:Free of %08lx\r\n",(ULONG) vptr_tx_packet);

	buffer_free (vptr_tx_packet);
}
/*************************************************************************/
static void packet_allocation_error (USHORT port_number,ULONG size_of_packet)
{
	ppp_printf (PPP_ALARM_PRINTF,"PPP: Error Allocating Packet port number %04x size %08x\r\n",port_number,size_of_packet);
}
/*************************************************************************/
void ppp_send_completion (USHORT port_number,void *sptr_tx_packet)
{
	ppp_free_a_send_packet (port_number,sptr_tx_packet);
}
/*************************************************************************/
void reset_counters_on_this_port (USHORT real_port_number)
{
	ppp_printf (PPP_DATA_PRINTF,"PPP:Link Reset Port %04x\r\n",real_port_number);

	ppp.port[real_port_number].authentication.status = UNSUCCESSFUL;
	ppp.port[real_port_number].authentication.rxed_authentication_ack = FALSE;
	ppp.port[real_port_number].authentication.txed_authentication_ack = FALSE;

	ppp.port[real_port_number].number_of_configuration_requests = 0x0000;
	ppp.port[real_port_number].number_of_echo_requests = 0x0000;
	ppp.port[real_port_number].number_of_lcp_termination_requests = 0x0000;
	
	ppp.port[real_port_number].configuration_request_send_interval = 0x0000;
	ppp.port[real_port_number].configuration_request_backoff_interval = 0x0000;
	ppp.port[real_port_number].time_to_send_LQR = 0x0000;
}
/*************************************************************************/
void ppp_printf (enum PPP_PRINTF_GROUPS printf_group,const char *cptr_format, ...)
{
	enum BOOLEAN print_string;

	va_list argptr;

	va_start (argptr,cptr_format);

	if (ppp.printing_enabled == FALSE)
		{
		va_end (argptr);

		return;
		}

	print_string = FALSE;

	switch (printf_group)
	{
		case PPP_MEMORY_PRINTF:
			print_string = FALSE	;
			break;
		case PPP_ALARM_PRINTF:
			print_string = ppp.alarm_printing_enabled;
			break;
		case PPP_DATA_PRINTF:
			print_string = FALSE ;
			break;
		case PPP_LCP_PRINTF:
			print_string = ppp.lcp_printing_enabled;
			break;
		case PPP_NCP_PRINTF:
			print_string = ppp.ncp_printing_enabled;
			break;
#ifdef __MLPPP__
		case PPP_MLPPP_PRINTF:
			print_string = FALSE ;
			break;
#endif
	}

	if (print_string == TRUE)
		vprintf (cptr_format,argptr);

	va_end (argptr);
}
/****************************************************************************/
void set_ppp_class_to_zero (void)
{
	memset (&ppp,(int) NULL,sizeof (PPP_CLASS));
}

enum BOOLEAN is_port_dial_on_demand(USHORT port_number)
{
	return ppp.port[port_number].dial_on_demand;
}

/* Sudhir 30/10/1996 */

enum BOOLEAN is_chap_enabled (int port_number)
{
	OPTION_LIST_ENTRY *sptr_option ;

	sptr_option = find_matching_option (&ppp.port[port_number].option_lists.rx_accepted,
	                                     LCP_AUTHENTICATION_PROTOCOL) ;

	if (sptr_option != NULL)
	{
		if (sptr_option->uptr_data->_ushort == CHAP_PROTOCOL)
			return (TRUE) ;
	}

	return (FALSE) ;
}

enum BOOLEAN get_configured_mru (USHORT port_number, int *iptr_mru)
{
	OPTION_LIST_ENTRY *sptr_option_list_entry;

	if (port_number >= MAXIMUM_NUMBER_OF_PPP_PORTS)
		return (FALSE) ;

	sptr_option_list_entry = find_matching_option (&ppp.port[port_number].option_lists.configured, LCP_MAXIMUM_RECEIVE_UNIT); 
	if (sptr_option_list_entry == NULL)
		return (FALSE);

	*iptr_mru = sptr_option_list_entry->uptr_data->_ushort ;
	return (TRUE) ;
}  

enum BOOLEAN get_configured_remote_mru (USHORT port_number, int *iptr_mru)
{
	OPTION_LIST_ENTRY *sptr_option_list_entry;

	if (port_number >= MAXIMUM_NUMBER_OF_PPP_PORTS)
		return (FALSE) ;

	sptr_option_list_entry = find_matching_option (&ppp.port[port_number].option_lists.remote_configured, LCP_MAXIMUM_RECEIVE_UNIT); 
	if (sptr_option_list_entry == NULL)
		return (FALSE);

	*iptr_mru = sptr_option_list_entry->uptr_data->_ushort ;
	return (TRUE) ;
}  


enum BOOLEAN get_negotiated_mru (USHORT port_number, int *iptr_mru)
{
	OPTION_LIST_ENTRY *sptr_option_list_entry;

	if (port_number >= MAXIMUM_NUMBER_OF_PPP_PORTS)
		return (FALSE) ;

	if (ppp.port[port_number].state != PPP_OPENED_STATE)
		return (FALSE);

	sptr_option_list_entry = find_matching_option (&ppp.port[port_number].option_lists.rx_accepted, LCP_MAXIMUM_RECEIVE_UNIT); 
	if (sptr_option_list_entry == NULL)
		return (FALSE);

	*iptr_mru = sptr_option_list_entry->uptr_data->_ushort ;
	return (TRUE) ;
}

enum BOOLEAN get_negotiated_remote_mru (USHORT port_number, int *iptr_mru)
{
	OPTION_LIST_ENTRY *sptr_option_list_entry;

	if (port_number >= MAXIMUM_NUMBER_OF_PPP_PORTS)
		return (FALSE) ;

	if (ppp.port[port_number].state != PPP_OPENED_STATE)
		return (FALSE);

	sptr_option_list_entry = find_matching_option (&ppp.port[port_number].option_lists.tx_accepted, LCP_MAXIMUM_RECEIVE_UNIT); 
	if (sptr_option_list_entry == NULL)
		return (FALSE);

	*iptr_mru = sptr_option_list_entry->uptr_data->_ushort ;
	return (TRUE) ;
}  



enum BOOLEAN get_configured_accm (USHORT port_number, ULONG *ulptr_accm)
{
	OPTION_LIST_ENTRY *sptr_option_list_entry;

	if (port_number >= MAXIMUM_NUMBER_OF_PPP_PORTS)
		return (FALSE) ;

	sptr_option_list_entry = find_matching_option (&ppp.port[port_number].option_lists.configured, LCP_ASYNC_CONTROL_CHARACTER_MAP); 
	if (sptr_option_list_entry == NULL)
		return (FALSE);

	*ulptr_accm = sptr_option_list_entry->uptr_data->_ushort;
	return (TRUE) ;
}  

enum BOOLEAN get_configured_remote_accm (USHORT port_number, ULONG *ulptr_accm)
{
	OPTION_LIST_ENTRY *sptr_option_list_entry;

	if (port_number >= MAXIMUM_NUMBER_OF_PPP_PORTS)
		return (FALSE) ;

	sptr_option_list_entry = find_matching_option (&ppp.port[port_number].option_lists.remote_configured, LCP_ASYNC_CONTROL_CHARACTER_MAP); 
	if (sptr_option_list_entry == NULL)
		return (FALSE);

	*ulptr_accm = sptr_option_list_entry->uptr_data->_ulong ;
	return (TRUE) ;
}  


enum BOOLEAN get_negotiated_accm (USHORT port_number, ULONG *ulptr_accm)
{
	OPTION_LIST_ENTRY *sptr_option_list_entry;

	if (port_number >= MAXIMUM_NUMBER_OF_PPP_PORTS)
		return (FALSE) ;

	if (ppp.port[port_number].state != PPP_OPENED_STATE)
		return (FALSE);

	sptr_option_list_entry = find_matching_option (&ppp.port[port_number].option_lists.rx_accepted, LCP_ASYNC_CONTROL_CHARACTER_MAP); 
	if (sptr_option_list_entry == NULL)
		return (FALSE);

	*ulptr_accm = sptr_option_list_entry->uptr_data->_ulong ;
	return (TRUE) ;
}

enum BOOLEAN get_negotiated_remote_accm (USHORT port_number, ULONG *ulptr_accm)
{
	OPTION_LIST_ENTRY *sptr_option_list_entry;

	if (port_number >= MAXIMUM_NUMBER_OF_PPP_PORTS)
		return (FALSE) ;

	if (ppp.port[port_number].state != PPP_OPENED_STATE)
		return (FALSE);

	sptr_option_list_entry = find_matching_option (&ppp.port[port_number].option_lists.tx_accepted, LCP_ASYNC_CONTROL_CHARACTER_MAP); 
	if (sptr_option_list_entry == NULL)
		return (FALSE);

	*ulptr_accm = sptr_option_list_entry->uptr_data->_ulong ;
	return (TRUE) ;
}

/* Jo 26/04/99 */
const char *protocol_none = "None", *protocol_pap = "PAP", *protocol_chap = "CHAP", *protocol_unknown = "Unknown" ;
char *get_configured_authentication_protocol (USHORT port_number)
{
	OPTION_LIST_ENTRY *sptr_option_list_entry;

	if (port_number >= MAXIMUM_NUMBER_OF_PPP_PORTS)
		return (&protocol_none[0]) ;

	sptr_option_list_entry = find_matching_option (&ppp.port[port_number].option_lists.configured, LCP_AUTHENTICATION_PROTOCOL); 
	if (sptr_option_list_entry == NULL)
		return (&protocol_none[0]);

	switch (sptr_option_list_entry->uptr_data->_ushort)
	{
		case (PAP_PROTOCOL) :
			return (&protocol_pap[0]) ;
			break ;

		case (CHAP_PROTOCOL) :
			return (&protocol_chap[0]) ;
			break ;

		default :
			return (&protocol_unknown[0]) ;
	}
}  

char *get_configured_remote_authentication_protocol (USHORT port_number)
{
	OPTION_LIST_ENTRY *sptr_option_list_entry;

	if (port_number >= MAXIMUM_NUMBER_OF_PPP_PORTS)
		return (&protocol_none[0]) ;

	sptr_option_list_entry = find_matching_option (&ppp.port[port_number].option_lists.remote_configured, LCP_AUTHENTICATION_PROTOCOL); 
	if (sptr_option_list_entry == NULL)
		return (&protocol_none[0]) ;


	switch (sptr_option_list_entry->uptr_data->_ushort)
	{
		case (PAP_PROTOCOL) :
			return (&protocol_pap[0]) ;
			break ;

		case (CHAP_PROTOCOL) :
			return (&protocol_chap[0]) ;
			break ;

		default :
			return (&protocol_unknown[0]) ;
	}
}

/* Sudhir 30/10/1996 */

enum BOOLEAN is_ppp_enabled_for_port (USHORT port_number)
{
   return (ppp.port[port_number].enabled); 
}


/* Sachin 14/07/1997 */
void apply_tx_accm (USHORT real_port_number)
{
   OPTION_LIST_ENTRY *sptr_accm_option ;
   ULONG rx_accm, tx_accm ;

   sptr_accm_option = find_matching_option (&ppp.port[real_port_number].option_lists.tx_accepted,LCP_ASYNC_CONTROL_CHARACTER_MAP);
   if (sptr_accm_option != NULL)
      tx_accm = (ULONG) sptr_accm_option->uptr_data->_ulong ;
   else
      tx_accm = 0xFFFFFFFFL ;

   sptr_accm_option = find_matching_option (&ppp.port[real_port_number].option_lists.rx_accepted,LCP_ASYNC_CONTROL_CHARACTER_MAP);
   if (sptr_accm_option != NULL)
      rx_accm = (ULONG) sptr_accm_option->uptr_data->_ulong ;
   else
      rx_accm = 0xFFFFFFFFL ;

   if (ppp.port[real_port_number].enabled == TRUE &&
			ppp.port[real_port_number].serial_driver.fptr_control_routine != NULL)
	{
			(*ppp.port[real_port_number].serial_driver.fptr_control_routine) (SET_TX_ACCM_SERIAL_PORT,
				(ULONG) real_port_number,
				rx_accm | tx_accm);
	}
}
/*RFC???? says you need to OR the rx and tx accms to apply for TXing.
It is a must in case of SHIVA client. */
/* Sachin 14/07/1997 */

/* Jo 23/04/99 */
#if 0
enum BOOLEAN is_slip_enabled_for_port (USHORT port_number)
{
   return (ppp.port[port_number].slip_enabled); 
}
#endif
/* Jo 23/04/99 */



#ifdef __MLPPP__
void	add_fragment_sorted_linked_list(LINK *sptr_link, MLPPP_RX_DESCRIPTOR	*sptr_link_to_add)
{
	MLPPP_RX_DESCRIPTOR	*sptr_list_entry;
	MLPPP_RX_DESCRIPTOR	*sptr_previous_entry;


	if (sptr_link == NULL)
		return;

	if (sptr_link_to_add == NULL)
		return;

	sptr_list_entry = (MLPPP_RX_DESCRIPTOR *)sptr_link->sptr_forward_link;
	sptr_previous_entry = (MLPPP_RX_DESCRIPTOR *)sptr_link;

	while (sptr_list_entry != NULL)
	{
		if (sptr_list_entry->sequence_number > sptr_link_to_add->sequence_number)
			break;
		else if (sptr_list_entry->sequence_number == sptr_link_to_add->sequence_number)
		{
			return;
		}
		sptr_previous_entry = sptr_list_entry;
		sptr_list_entry = (MLPPP_RX_DESCRIPTOR	*)sptr_list_entry->links.sptr_forward_link;
	}

	sptr_link_to_add->links.sptr_forward_link = (LINK *)sptr_list_entry;
	sptr_previous_entry->links.sptr_forward_link = (LINK *)sptr_link_to_add;

	if (sptr_list_entry == NULL)
	{
		sptr_link->sptr_backward_link = (LINK *)sptr_link_to_add;
		if ((LINK *)sptr_previous_entry == (LINK *)sptr_link)
			sptr_link_to_add->links.sptr_backward_link = (LINK *)NULL;
		else
			sptr_link_to_add->links.sptr_backward_link = (LINK *)sptr_previous_entry;
	}
	else
	{
		sptr_link_to_add->links.sptr_backward_link = sptr_list_entry->links.sptr_backward_link;
		sptr_list_entry->links.sptr_backward_link = (LINK *)sptr_link_to_add;
	}
}

#endif



#ifdef STATUS_DEBUG
#ifdef __MLPPP__
void ppp_debug_information()
{  
   USHORT port_number, bundle_number, link_number;
	MLPPP_PORT_CLASS	*sptr_mlppp ;
   BYTE members_string[80], temp_string[20];

/*   printf("MLPPP: Running WITH Multilink PPP Code with %d WAN ports...\n", ppp.number_of_ppp_ports);*/

   for(port_number = 0 ; port_number < ppp.number_of_ppp_ports ; ++port_number)
   {
		sptr_mlppp = &mlppp.port[port_number];

      /* Is the port Busy */
      if (sptr_mlppp->used)
      {
         /* Is this a bundle? */
         if (sptr_mlppp->multilink_enabled)
         {
            /* This port is a bundle */

            /* Lets find out its members */
            members_string[0] = 0;
            for(link_number = 0 ; link_number < sptr_mlppp->NoOfLinks ; ++link_number)
            {
               sprintf(temp_string, "Port%04X  ", sptr_mlppp->LinkInfo[link_number].port->port_number);
               strcat(members_string, temp_string);
            }
            printf("MLPPP: On Port %d Bundle has been formed with %s ...\n", port_number, members_string);
         }
         else
            printf("MLPPP: Multilink not negotiated on Port %d ...\n", port_number);
      }
      else
      {
         /* Bundle is free but we have to find out whether the Port is free
            or is it a member of some bundle. If it is not a member of 
            any bundle then it means to say that 'current port_number '
            is free 
         */
         bundle_number = is_the_link_member_of_some_bundle(port_number);
         if (bundle_number == NOT_A_MEMBER_OF_ANY_BUNDLE)
            printf("MLPPP: Port/Bundle %d is Free ...\n", port_number);
         else
            printf("MLPPP: Bundle %d is free ::: Port %d is a member of BUNDLE %d ...\n", port_number, port_number, bundle_number);
      }
   }
}

#else /* __MLPPP__ */

void ppp_debug_information()
{
   USHORT port_number;

/*   printf("PPP: Running WITHOUT Multilink PPP Code with %d WAN ports...\n", ppp.number_of_ppp_ports);*/
   for (port_number = 0 ; port_number < ppp.number_of_ppp_ports ; ++port_number)
   {
      if (get_wan_port_owner(port_number) == OWNED_BY_PPP)
         printf("PPP: Port %d is Busy ...\n", port_number);
      else
         printf("PPP: Port %d is Free ...\n", port_number);
   }
}

#endif /* __MLPPP__ */
#endif /* STATUS_DEBUG */

void	ppp_hangup_and_redial_wan_port(int port_number)
{
	set_hangup_and_redial_flag_in_wan (port_number);
   if (ppp.port[port_number].serial_driver.fptr_control_routine != NULL)
   {
	   (*ppp.port[port_number].serial_driver.fptr_control_routine) (CLOSE_SERIAL_PORT,
		   (ULONG) port_number,(ULONG) ppp.port[port_number].device_driver_id);
   }
}

enum BOOLEAN is_remote_access_enabled_on_port (USHORT port_number)
{
	return (ppp.port[port_number].client_only);
}

/* sudha taken from BIG_PROXY sources on 8 Jan 1999...*/
void activate_dod (port_number)
{
	printf("Script Activating DOD for port %d\n", port_number);
	ppp.port[port_number].dod_active = SCRIPT_ACTIVATED_DOD;
}
/* ...sudha taken from BIG_PROXY sources on 8 Jan 1999 */

/* 04/06/99 Jo Added for RAS */
BYTE is_ras_link_coming_up(USHORT real_port_number)
{
	return(mlppp.port[real_port_number].expecting_ras_link_coming_up);
}

enum BOOLEAN is_proxy_enabled_only_port (USHORT port_number)
{
	if (ppp.port[port_number].client_only == 0) 
		return (TRUE) ;
	else
		return (FALSE) ;
}
/* 04/06/99 Jo Added for RAS */
