/* --------------------------------------------------------------------------
Module: SLIP (CSLIP)
Author: Kamalnath
Duration: Feb 1997 - April 1997
 --------------------------------------------------------------------------*/
#include "defs.h"
#include "ppp.h"
#include <stdlib.h>

/* 17/05/99 Jo Slip not handled in LCPR */
#ifdef _BIG_PROXY_
static enum TEST decode_rx_slip_packet (BYTE **ptr_to_sptr_rxed_packet, USHORT *usptr_number_of_bytes_rxed);
static enum TEST uncompress_slip_packet (USHORT real_port_number, BYTE **ptr_to_sptr_rxed_packet, USHORT *usptr_number_of_bytes_rxed); 

static void *encode_tx_packet (USHORT real_port_number, void *usptr_tx_packet,USHORT *number_of_bytes,void **vptr_slip_buffer);

/* SLIP RECEPTION */
enum TEST receive_slip_packet (USHORT real_port_number, BYTE **ptr_to_sptr_rxed_packet, USHORT *usptr_number_of_bytes_rxed)
{
/*	slip_printf (SLIP_DATA_PRINTF,"SLIP: Rx Packet size = %d on port %d\r\n",*usptr_number_of_bytes_rxed, real_port_number);*/
	
	if (decode_rx_slip_packet (ptr_to_sptr_rxed_packet, usptr_number_of_bytes_rxed) == FAIL)
	{
	  return (FAIL);
	}
 
#ifdef __LSL__
	*usptr_number_of_bytes_rxed = (USHORT) (*usptr_number_of_bytes_rxed + sizeof (UNION_MAC_HEADER));
	*ptr_to_sptr_rxed_packet = *ptr_to_sptr_rxed_packet - sizeof (UNION_MAC_HEADER);
#endif
	
	if (uncompress_slip_packet (real_port_number, ptr_to_sptr_rxed_packet, usptr_number_of_bytes_rxed) == FAIL)
	{
		return (FAIL);
	}
	
#ifdef __LSL__
	((ETHERNET_MAC_HEADER *) *ptr_to_sptr_rxed_packet)->length_or_type.type = SNAP_IP_PACKET;
	((ETHERNET_MAC_HEADER *) *ptr_to_sptr_rxed_packet)->destination_address._ushort = 0xffff;
	((ETHERNET_MAC_HEADER *) *ptr_to_sptr_rxed_packet)->destination_address._ulong = 0xffffffffL;
	((ETHERNET_MAC_HEADER *) *ptr_to_sptr_rxed_packet)->source_address._ushort = 0x0000;
	((ETHERNET_MAC_HEADER *) *ptr_to_sptr_rxed_packet)->source_address._ulong = 0x00000000L;
#endif

	return (PASS);
}

static enum TEST decode_rx_slip_packet (BYTE **ptr_to_sptr_rxed_packet, USHORT *usptr_number_of_bytes_rxed)
{
	BYTE *ptr_to_packet_begin;
	BYTE *var_ptr;
	BYTE rx_byte;
	USHORT byte_counter;

	/* The length of the packet is not including C0, I feel the length should also include even C0 */
	if (*(*ptr_to_sptr_rxed_packet + *usptr_number_of_bytes_rxed) != END)
	{
/*		slip_printf (SLIP_ALARM_PRINTF,"SLIP: Packet received with no ending END, check Baud Rate at the slip peer");*/
		return (FAIL);
	}
	
	ptr_to_packet_begin = *ptr_to_sptr_rxed_packet;
	var_ptr = *ptr_to_sptr_rxed_packet;

	for (byte_counter =0; byte_counter <*usptr_number_of_bytes_rxed; byte_counter++)
	{
		rx_byte = *(*ptr_to_sptr_rxed_packet+byte_counter);
		
		switch(rx_byte)
		{
			case END:
				break;
			
			case ESC:
				byte_counter++;
				switch(*(*ptr_to_sptr_rxed_packet+byte_counter))
				{
					case ESC_END:
						*(var_ptr++)= END;
					  	break;
	
					case ESC_ESC:
						*(var_ptr++) = ESC;
					  	break;

					default:
/*					  	slip_printf (SLIP_ALARM_PRINTF,"SLIP: ESC control character in the data without encoding");*/
		 			  	return(FAIL);
				} 
				break;

			default:
				*(var_ptr++) = rx_byte;
				break;
		}
	}
	
	*usptr_number_of_bytes_rxed = var_ptr - ptr_to_packet_begin;
	*ptr_to_sptr_rxed_packet = ptr_to_packet_begin;
	return (PASS);
}

static enum TEST uncompress_slip_packet (USHORT real_port_number, BYTE **ptr_to_sptr_rxed_packet, USHORT *usptr_number_of_bytes_rxed)
{
	enum VAN_JACOBSON_COMPRESSION_TYPE compression_type;
	BYTE type_of_packet;

	type_of_packet = *(*ptr_to_sptr_rxed_packet + sizeof (UNION_MAC_HEADER));

	if (type_of_packet & 0x80)
   	compression_type = VJ_COMPRESSED_TCP_TYPE;
   else if (type_of_packet >= 0x70) 
	{
     	compression_type = VJ_UNCOMPRESSED_TCP_TYPE;
     	(*(*ptr_to_sptr_rxed_packet + sizeof (UNION_MAC_HEADER))) &=~ 0x30;
   } 
	else
		compression_type = VJ_IP_TYPE;

	switch (compression_type)
	{
		case VJ_COMPRESSED_TCP_TYPE:
			if (!ppp.port[real_port_number].slip_compression_on)
			{
				return (FAIL);
			}
			break;
		case VJ_UNCOMPRESSED_TCP_TYPE:
			ppp.port[real_port_number].slip_compression_on = TRUE;
			break;
		case VJ_IP_TYPE:
			if (ppp.port[real_port_number].answering == TRUE)
			{
				ppp.port[real_port_number].slip_compression_on = FALSE; /*beware..*/
			}
			break;
		default:
			return (FAIL);
	}		
#ifdef __MLPPP__	
	if (mlppp.port[real_port_number].vjc.fptr_uncompress_tcp_header != NULL)
#else
	if (ppp.port[real_port_number].vjc.fptr_uncompress_tcp_header != NULL)
#endif
	{
#ifdef __MLPPP__
		(*mlppp.port[real_port_number].vjc.fptr_uncompress_tcp_header) (real_port_number,ptr_to_sptr_rxed_packet, usptr_number_of_bytes_rxed,
			(BYTE) compression_type);
#else
		(*ppp.port[real_port_number].vjc.fptr_uncompress_tcp_header) (real_port_number,ptr_to_sptr_rxed_packet, usptr_number_of_bytes_rxed,
			(BYTE) compression_type);
#endif
	}
	
	return (PASS);
}

/* SLIP TRANSMISSION */
USHORT send_slip_packet (USHORT real_port_number,void **sptr_tx_packet,	USHORT number_of_bytes,USHORT protocol_virtual_port_number,
	enum BOOLEAN device_driver_buffer, void (*fptr_tx_completion)(USHORT port_number,void *vptr_ethernet_buffer),void **vptr_async_buffer)
{
	void *sptr_original_tx_packet;
	enum VAN_JACOBSON_COMPRESSION_TYPE vj_return_code;
	USHORT tx_data_size;
	sptr_original_tx_packet = *sptr_tx_packet;
	
	/* 24\04\1997 MTU check */
	tx_data_size = number_of_bytes - (USHORT) sizeof (UNION_MAC_HEADER);
	
	if (tx_data_size > ppp.port[real_port_number].slip_port.maximum_transmit_bufsize)
	{
/*		slip_printf (SLIP_ALARM_PRINTF,"SLIP: Tx Packet size %d is more than MTU",number_of_bytes);*/
		return (0x0000);
	}
	
	if ((ppp.port[real_port_number].cslip_enabled == TRUE) && (ppp.port[real_port_number].slip_compression_on == TRUE) &&
#ifdef __MLPPP__
			(mlppp.port[real_port_number].vjc.fptr_compress_tcp_header != NULL)) 
#else
			(ppp.port[real_port_number].vjc.fptr_compress_tcp_header != NULL)) 
#endif
	{
/*		slip_printf (SLIP_DATA_PRINTF,"SLIP: Tx Packet size before compression = %d on port %d\r\n",number_of_bytes,real_port_number);*/

#ifdef __MLPPP__	
		vj_return_code = (enum VAN_JACOBSON_COMPRESSION_TYPE)(*mlppp.port[real_port_number].vjc.fptr_compress_tcp_header)
			(real_port_number,(void **) sptr_tx_packet,&number_of_bytes);
#else
		vj_return_code = (enum VAN_JACOBSON_COMPRESSION_TYPE)(*ppp.port[real_port_number].vjc.fptr_compress_tcp_header)
			(real_port_number,(void **) sptr_tx_packet,&number_of_bytes);
#endif	
/*		slip_printf (SLIP_DATA_PRINTF,"SLIP: Tx Packet size after compression = %d on port %d\r\n",number_of_bytes,real_port_number);*/

		*((BYTE*)((ULONG)*sptr_tx_packet + sizeof (UNION_MAC_HEADER))) |=  vj_return_code;
	}

	*sptr_tx_packet = (void *)((ULONG) *sptr_tx_packet + sizeof (UNION_MAC_HEADER));
	number_of_bytes = number_of_bytes - sizeof (UNION_MAC_HEADER);
	
	*sptr_tx_packet = encode_tx_packet (real_port_number, (void *) *sptr_tx_packet,&number_of_bytes,vptr_async_buffer);

	if (fptr_tx_completion != NULL)
	{
		(fptr_tx_completion) (protocol_virtual_port_number,sptr_original_tx_packet);
	}

	if (device_driver_buffer == TRUE)
	{
		packet_forward_device_driver_free (real_port_number,ppp.port[real_port_number].device_driver_id,
			(void *) ((ULONG) sptr_original_tx_packet));
	}

	if (*sptr_tx_packet == NULL)
	{
		return (0x0000);
	}
/*	slip_printf (SLIP_DATA_PRINTF,"SLIP: Tx Packet size = %d on port %d\r\n", number_of_bytes, real_port_number);*/

	return (number_of_bytes);
}

static void *encode_tx_packet (USHORT real_port_number, void *usptr_tx_packet, USHORT *number_of_bytes, void **vptr_slip_buffer)
{
	SLIP_TX_BUFFER_LIST_ENTRY *sptr_slip_tx_buffer_list_entry;
	BYTE *source_buffer;
	BYTE *bptr_buffer;
	USHORT byte_counter;

	source_buffer = (BYTE *)usptr_tx_packet;

	sptr_slip_tx_buffer_list_entry = (SLIP_TX_BUFFER_LIST_ENTRY *)
			get_entry_from_list (&ppp.port[real_port_number].slip_port.buffer_free_list);

	if (sptr_slip_tx_buffer_list_entry == NULL)
	{
		return (NULL);
	}
	
	*vptr_slip_buffer = sptr_slip_tx_buffer_list_entry;
		
	bptr_buffer = &sptr_slip_tx_buffer_list_entry->data[0];
	
	*(bptr_buffer++) = END;
	
	for (byte_counter = 0; byte_counter < *number_of_bytes; source_buffer++,byte_counter++)
	{
		switch (*source_buffer)
		{
			case END:
				*(bptr_buffer++) = ESC;
				*(bptr_buffer++) = ESC_END;
				break;

			case ESC:
				*(bptr_buffer++) = ESC;
				*(bptr_buffer++) = ESC_ESC;
				break;
			
			default:
				*(bptr_buffer++) = *source_buffer;
				break;
		}
	}
	
	*(bptr_buffer++) = END;
	*number_of_bytes = (USHORT) ((ULONG)bptr_buffer -(ULONG)&sptr_slip_tx_buffer_list_entry->data[0]);

#if 0	/* KVSP */
	printf ("SLIP: Txed List Entry= 0x%x\r\n", sptr_slip_tx_buffer_list_entry);
#endif
	return ((void *)&sptr_slip_tx_buffer_list_entry->data[0]);
}

void slip_packet_transmitted (USHORT real_port_number,void *vptr_txed_packet)
{
	/*vptr_txed_packet = (void *) ((ULONG) vptr_txed_packet - sizeof (LINK));*/ /*No need */

#if 0	/* KVSP */
	printf ("SLIP: Freed List Entry = 0x%x\r\n", vptr_txed_packet);
#endif
	add_entry_to_list ((LINK *) &ppp.port[real_port_number].slip_port.buffer_free_list,(LINK *) vptr_txed_packet);
}
/* SLIP TRANSMISSION */
#endif 
/* 17/05/99 Jo Slip not handled in LCPR */

#if 0
BYTE *uncode_the_rx_slip_packet (BYTE *sptr_rxed_packet, USHORT *usptr_number_of_bytes_rxed)
{
	BYTE actual_byte;
	BYTE *ptr_temp_packet_begin, *ptr_temp_packet;
	USHORT byte_counter =0;
	USHORT actual_byte_counter;
	
	printf("SLIP Packet of size %d is received\n", (USHORT)*usptr_number_of_bytes_rxed);
	
	if (*(sptr_rxed_packet + *usptr_number_of_bytes_rxed) != END)
	{
		printf("SLIP packet with no ending END byte received\n"); 
		return (NULL);
	}

	ptr_temp_packet = (BYTE *) malloc (*usptr_number_of_bytes_rxed);

	if (ptr_temp_packet == NULL)
	{
		printf ("ERROR:SLIP could not allocate buffer\n");
		return (NULL);
	}

	ptr_temp_packet_begin = ptr_temp_packet;

	for (actual_byte_counter = 0x0000; actual_byte_counter < *usptr_number_of_bytes_rxed ; ++actual_byte_counter)
	{
		actual_byte = *(sptr_rxed_packet + actual_byte_counter);

		switch (actual_byte)
		{
			case END:
				break;
			
			case ESC:
				++actual_byte_counter;

				switch(*(sptr_rxed_packet + actual_byte_counter))
				{
				 	case ESC_END:
					  *(ptr_temp_packet++)= END;
					  byte_counter++;
					  break;
	
					case ESC_ESC:
					  *(ptr_temp_packet++) = ESC;
					  byte_counter++;
					  break;

					default:
		 			  return(NULL);
				} 
				break;

			default:
				*(ptr_temp_packet++) = actual_byte;
				byte_counter++;
				break;
		}

	}
	memcpy (sptr_rxed_packet,ptr_temp_packet_begin, byte_counter);

	free (ptr_temp_packet_begin);

	*usptr_number_of_bytes_rxed = byte_counter ;
	
	return (sptr_rxed_packet);
}
#endif

#if 0
enum BOOLEAN receive_slip_packet (BYTE **ptr_to_sptr_rxed_packet, USHORT *usptr_number_of_bytes_rxed)
{
	BYTE *ptr_to_packet_begin;
	BYTE *var_ptr;
	BYTE rx_byte;
	USHORT byte_counter;

	/* The length of the packet is not including C0, I feel to length should also include even C0 */
	if (*(*ptr_to_sptr_rxed_packet + *usptr_number_of_bytes_rxed) != END)
	{
		printf("SLIP packet with no ending END byte received\n"); 
		return (FALSE);
	}
	
	ptr_to_packet_begin = *ptr_to_sptr_rxed_packet;
	var_ptr = *ptr_to_sptr_rxed_packet;

	for (byte_counter =0; byte_counter <*usptr_number_of_bytes_rxed; byte_counter++)
	{
		rx_byte = *(*ptr_to_sptr_rxed_packet+byte_counter);
		
		switch(rx_byte)
		{
			case END:
				break;
			
			case ESC:
				byte_counter++;
				switch(*(*ptr_to_sptr_rxed_packet+byte_counter))
				{
				 	case ESC_END:
					  *(var_ptr++)= END;
					  break;
	
					case ESC_ESC:
					  *(var_ptr++) = ESC;
					  break;

					default:
					  printf("SLIP rx processing failed\n");
		 			  return(FALSE);
				} 
				break;

			default:
				*(var_ptr++) = rx_byte;
				break;
		}
	}
	
	*usptr_number_of_bytes_rxed = var_ptr - ptr_to_packet_begin;
	
	add_mac_header_to_the_slip_packet_received (ptr_to_packet_begin, (void **)&ptr_to_packet_begin,
		usptr_number_of_bytes_rxed);
 
	*ptr_to_sptr_rxed_packet = ptr_to_packet_begin;
	

	return (TRUE);
}
#endif

