/*	$Modname: vlcpstr.h$  $version: 1.29$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 01/05/94 keyur Initial Release.
1.1 01/05/94 keyur Added support for version control.
1.2 01/20/94 keyur Added some more structures for statistics.
1.3 01/28/94 keyur Added some more structures for LCP options.
1.4 02/22/94 keyur There is no major change.
1.5 03/23/94 keyur Added some statistics.
1.6 04/04/94 keyur Cosmetic Changes while documenting
1.7 04/12/94 keyur Added State Machine support for LCP according to RFC1548
1.8 04/19/94 keyur Added ordering of options for LCP and NCP, courtesy of John
1.9 05/02/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John.
1.10 06/23/94 ross aligned members in structures.  Cosmetic.
1.11 06/23/94 ross cosmetic.
1.12 06/23/94 ross cosmetic.
1.13 06/23/94 ross more cosmetic.
1.14 07/18/94 ross general cleanup with options, added header compression, accm features.
1.15 08/08/94 ross working on adding version 2
1.16 08/11/94 ross adding rfc1570 lcp support
1.17 08/24/94 ross adding new ncps.
1.18 09/29/94 ross fixes for Chap, courtesy of Danny.  Added STP and Netbios.
1.19 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.20 11/04/94 ross Testing against net manage ppp.  VJC testing.
1.21 12/02/94 ross testing NT3.5 RAS
1.22 12/03/94 ross testing Windows 95 RAS
1.23 12/05/94 ross dynamic option support.  Portions courtesy of Dan.
1.24 12/13/94 ross connected to NT RAS with Netbios
1.25 01/26/95 ross changes for rwutils
1.26 01/30/95 ross removing duplicate configuration options
1.27 03/10/95 ross general fixes.  see change.doc
1.28 03/11/95 ross general fixes.  see change.doc
1.29 10/19/95 biao replaced enum declarations with RouterWare ENUM declaration macros.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/

typedef	struct	LCP_OPTIONS_BOOLEAN
{
	BYTE_ENUM (BOOLEAN)	send_id;
	BYTE_ENUM (BOOLEAN)	time_remaining;

} LCP_OPTIONS_BOOLEAN;

typedef	struct	LCP_CONFIGURATION
{
	LCP_OPTIONS_BOOLEAN							enabled;

	ULONG												seconds_remaining;
#if VIDY_CUT
	char												time_remaining_message[NAME_SIZE];
#endif
	BYTE_ENUM (CALLBACK_OPERATION)			operation;
#if VIDY_CUT
	char												callback_message[NAME_SIZE];
#endif

	ULONG												link_quality_reporting_interval;

	USHORT											size_of_rx_message;
	char												rx_identification_message[NAME_SIZE];

	USHORT											size_of_tx_message;
#if VIDY_CUT
	char												tx_identification_message[NAME_SIZE];
#else
	char												tx_identification_message[40];
#endif

} LCP_CONFIGURATION;

typedef	struct	PPP_HEADER
{
	BYTE										hdlc_address;
	BYTE_ENUM (LLC_FRAME_TYPE) 		hdlc_control;
	USHORT_ENUM (PPP_PROTOCOL_TYPE) 	protocol_type;
} PPP_HEADER;

typedef	union	UNION_OPTION_TYPES
{
	BYTE_ENUM (LCP_OPTION_TYPE) 	lcp;
	BYTE_ENUM (IPCP_OPTION_TYPE) 	ipcp;
#if 0
	BYTE_ENUM (ATCP_OPTION_TYPE) 	atcp;
	BYTE_ENUM (IPXCP_OPTION_TYPE) ipxcp;
#endif
	BYTE									generic;
} UNION_OPTION_TYPES;

typedef	union	UNION_OPTION_DATA_TYPES
{
	BYTE_ENUM (BOOLEAN)	boolean;
	BYTE						byte_array[VARIABLE_NUMBER_OF_BYTES];
	ULONG						_ulong;
	USHORT					_ushort;
	BYTE						_byte;
	MAC_ADDRESS				mac_address;
} UNION_OPTION_DATA_TYPES;

typedef struct PPP_OPTION
{
	UNION_OPTION_TYPES			type;

	BYTE								length;
	UNION_OPTION_DATA_TYPES		data;
} PPP_OPTION;

typedef	struct	OPTION_LIST
{
	struct OPTION_LIST_ENTRY	*sptr_forward_link;
	struct OPTION_LIST_ENTRY	*sptr_backward_link;
} OPTION_LIST;

typedef	struct	ALTERNATE_OPTION_LINK
{
	struct ALTERNATE_OPTION	*sptr_forward_link;
	struct ALTERNATE_OPTION	*sptr_backward_link;
} ALTERNATE_OPTION_LINK;

typedef	struct	ALTERNATE_OPTION
{
	ALTERNATE_OPTION_LINK		links;

	UNION_OPTION_DATA_TYPES		*uptr_data;
	BYTE								length;
} ALTERNATE_OPTION;

typedef	struct	OPTION_LIST_ENTRY
{
	struct OPTION_LIST_ENTRY	*sptr_forward_link;
	struct OPTION_LIST_ENTRY	*sptr_backward_link;

	char								*cptr_option_name;

	BYTE_ENUM (BOOLEAN)			automatic_nak_processing;

	BYTE_ENUM (BOOLEAN)			negotiation_required;

	BYTE_ENUM (BOOLEAN)			negotiable;

	BYTE_ENUM (OPTION_STATE)	state;

	UNION_OPTION_TYPES			type;

	BYTE								length;

	/* Srikar, Mar 22, 1997. Added the following field 'admin_status' to support administrative */
	/* disabling of certain PPP options like, IP protocol, VJ compression. */

	BYTE	admin_status;

	UNION_OPTION_DATA_TYPES		*uptr_data;

	BYTE_ENUM (BOOLEAN)			alternate_checking_enabled;

	ALTERNATE_OPTION_LINK		alternate_option_list;

	BYTE_ENUM (BOOLEAN)			range_checking_enabled;

	UNION_OPTION_DATA_TYPES		*uptr_lowest_value;
	UNION_OPTION_DATA_TYPES		*uptr_highest_value;

	UNION_OPTION_DATA_TYPES		*uptr_step;

	BYTE								nak_option_selected;

} OPTION_LIST_ENTRY;

typedef	struct	OPTION_LISTS
{
	OPTION_LIST	configured;
	OPTION_LIST	remote_configured;
	OPTION_LIST	received;
	OPTION_LIST	tx_nak;
	OPTION_LIST	rx_nak;
	OPTION_LIST	tx_reject;
	OPTION_LIST	rx_reject;
	OPTION_LIST	tx_accepted;
	OPTION_LIST	rx_accepted;
} OPTION_LISTS;

typedef	struct	PROTOCOL_FIELD_COMPRESSION
{
	BYTE_ENUM (LCP_OPTION_TYPE) 	type;
	USHORT								length;
} PROTOCOL_FIELD_COMPRESSION;

typedef	struct	ADDRESS_AND_CONTROL_FIELD_COMPRESSION
{
	BYTE_ENUM (LCP_OPTION_TYPE) 	type;
	USHORT								length;
} ADDRESS_AND_CONTROL_FIELD_COMPRESSION;

typedef	struct	PPP_LCP_STATISTICS
{
	ULONG	number_of_tx_packets;
	ULONG	number_of_tx_bytes;
	ULONG	number_of_rx_packets;
	ULONG	number_of_rx_bytes;
	ULONG	number_of_packets_rxed_greater_than_maximum_size;
	ULONG	number_of_packets_rxed_less_than_minimum_size;
	ULONG	number_of_control_tx_packets[NUMBER_OF_PPP_CONTROL_CODES];
	ULONG	number_of_control_rx_packets[NUMBER_OF_PPP_CONTROL_CODES];
} PPP_LCP_STATISTICS;

typedef struct LINK_QUALITY_REPORT
{
	PPP_HEADER							header;
	ULONG									magic_number;

	ULONG									LastOutLQRs;
	ULONG									LastOutPackets;
	ULONG									LastOutOctets;
	ULONG									PeerInLQRs;
	ULONG									PeerInPackets;
	ULONG									PeerInDiscards;
	ULONG									PeerInErrors;
	ULONG									PeerInOctets;
	ULONG									PeerOutLQRs;
	ULONG									PeerOutPackets;
	ULONG									PeerOutOctets;
	ULONG									SaveInLQRs;
	ULONG									SaveInPackets;
	ULONG									SaveInDiscards;
	ULONG									SaveInErrors;
	ULONG									SaveInOctets;
} LINK_QUALITY_REPORT;

typedef	struct	PPP_LCP_MIBS
{
	ULONG						pppLinkStatusPhysicalIndex;
	ULONG						pppLinkStatusBadAddresses;
	ULONG						pppLinkStatusBadControls;
	ULONG						pppLinkStatusPacketTooLongs;
	ULONG						pppLinkStatusBadFCSs;
	ULONG						pppLinkStatusLocalMRU;
	ULONG						pppLinkStatusRemoteMRU;
	ULONG						pppLinkStatusLocalToPeerACCMap;
	ULONG						pppLinkStatusPeerToLocalACCMap;
	ULONG						pppLinkStatusLocalToRemoteProtocolCompression;
	ULONG						pppLinkStatusRemoteToLocalProtocolCompression;
	ULONG						pppLinkStatusLocalToRemoteACCompression;
	ULONG						pppLinkStatusRemoteToLocalACCompression;
	ULONG						pppLinkStatusTransmitFcsSize;
	ULONG						pppLinkStatusReceiveFcsSize;

	ULONG						pppRemoteAuthenticationProtocol;
	ULONG						pppLocalAuthenticationProtocol;

	ULONG						pppLinkConfigInitialMRU;
	ULONG						pppLinkConfigReceiveACCMap;
	ULONG						pppLinkConfigTransmitACCMap;
	ULONG						pppLinkConfigMagicNumber;
	ULONG						pppLinkConfigFcsSize;
	
	ULONG						pppLqrQuality;
	ULONG						pppLqrInGoodOctets;
	ULONG						pppLqrLocalPeriod;
	ULONG						pppLqrRemotePeriod;
	ULONG						pppLqrOutLQRs;
	ULONG						pppLqrInLQRs;

	ULONG						pppLqrConfigPeriod;
	ULONG						pppLqrConfigStatus;

	LINK_QUALITY_REPORT	pppLqrExtnsLastReceivedLqrPacket;

} PPP_LCP_MIBS;

typedef	struct	PROTOCOL_REJECT_HEADER
{
	USHORT_ENUM (PPP_PROTOCOL_TYPE) 	protocol;
	BYTE										information[MAXIMUM_PACKET_LENGTH];
} PROTOCOL_REJECT_HEADER;

typedef struct MRU_OPTION
{
	BYTE_ENUM (LCP_OPTION_TYPE) 	type;

	BYTE									length;
	USHORT								maximum_receive_unit;
} MRU_OPTION;

typedef struct ASYNC_CONTROL_CHARACTER_MAP_OPTION
{
	BYTE_ENUM (LCP_OPTION_TYPE)	type;

	BYTE									length;
	ULONG									async_control_character_map;
} ASYNC_CONTROL_CHARACTER_MAP_OPTION;

typedef struct AUTHENTICATION_OPTION
{
	BYTE_ENUM (LCP_OPTION_TYPE) 				type;

	BYTE												length;
	USHORT_ENUM (PPP_PROTOCOL_TYPE) 			authentication_protocol;
	BYTE_ENUM (AUTHENTICATION_ALGORITHM)	algorithm;
} AUTHENTICATION_OPTION;

typedef struct ENCRYPTION_OPTION
{
	BYTE_ENUM (LCP_OPTION_TYPE) 		type;

	BYTE										length;
	USHORT_ENUM (PPP_PROTOCOL_TYPE) 	encryption_protocol;
} ENCRYPTION_OPTION;

typedef	struct	MAGIC_NUMBER_OPTION
{
	BYTE_ENUM (LCP_OPTION_TYPE)	type;

	BYTE									length;
	ULONG									magic_number;
}	MAGIC_NUMBER_OPTION;

typedef struct LINK_QUALITY_OPTION
{
	BYTE_ENUM (LCP_OPTION_TYPE) 	type;
	BYTE	 								length;

	USHORT_ENUM (PPP_PROTOCOL_TYPE) 	quality_protocol;
	ULONG										reporting_time;
} LINK_QUALITY_OPTION;

typedef struct PROTOCOL_FIELD_COMPRESSION_OPTION
{
	BYTE_ENUM (LCP_OPTION_TYPE)	type;

	BYTE									length;
} PROTOCOL_FIELD_COMPRESSION_OPTION;

typedef struct AC_FIELD_COMPRESSION_OPTION
{
	BYTE_ENUM (LCP_OPTION_TYPE)	type;

	BYTE									length;
} AC_FIELD_COMPRESSION_OPTION;


/* Sachin 25/06/1996 */
#ifdef LCP_EXT_CALLBACK
typedef struct CALLBACK_OPTION
{
	BYTE_ENUM (LCP_OPTION_TYPE)    type ;
	BYTE                           length ;
	BYTE_ENUM (CALLBACK_OPERATION) operation ;
	char                           message[NAME_SIZE] ;
} CALLBACK_OPTION ;
#endif
/* Sachin 25/06/1996 */


typedef	struct	LCP_OPTIONS_RECEIVED
{
	MRU_OPTION										MRU_option;
	ASYNC_CONTROL_CHARACTER_MAP_OPTION		async_control_character_map_option;
	AUTHENTICATION_OPTION 						authentication_option;
	ENCRYPTION_OPTION								encryption_option;
	MAGIC_NUMBER_OPTION							magic_number_option;
	LINK_QUALITY_OPTION							link_quality_option;
	PROTOCOL_FIELD_COMPRESSION_OPTION		protocol_field_compression_option;
	AC_FIELD_COMPRESSION_OPTION				address_and_control_field_compression_option;
/* Sachin 25/06/1996 */
#ifdef LCP_EXT_CALLBACK
	CALLBACK_OPTION            				callback_option ;
#endif
/* Sachin 25/06/1996 */
} LCP_OPTIONS_RECEIVED;

typedef	union		UNION_LCP_OPTIONS
{
	MRU_OPTION										MRU_option;
	ASYNC_CONTROL_CHARACTER_MAP_OPTION		async_control_character_map_option;
	AUTHENTICATION_OPTION 						authentication_option;
	ENCRYPTION_OPTION								encryption_option;
	MAGIC_NUMBER_OPTION							magic_number_option;
	LINK_QUALITY_OPTION							link_quality_option;
	PROTOCOL_FIELD_COMPRESSION_OPTION		protocol_field_compression_option;
	AC_FIELD_COMPRESSION_OPTION				address_and_control_field_compression_option;
/* Sachin 25/06/1996 */
#ifdef LCP_EXT_CALLBACK
	CALLBACK_OPTION            				callback_option ;
#endif
/* Sachin 25/06/1996 */
} UNION_LCP_OPTIONS;

typedef	struct	LCP_HEADER
{
	BYTE_ENUM (PPP_CONTROL_CODE) 	code;

	BYTE									id;
	USHORT 								length;
} LCP_HEADER;

typedef	struct	LCP_PACKET
{
	PPP_HEADER						ppp_header;

	LCP_HEADER						lcp_header;

	UNION_LCP_OPTIONS				options;
} LCP_PACKET;

typedef	struct	LCP_CONFIGURE_REQUEST
{
	PPP_HEADER										header;

	BYTE_ENUM (PPP_CONTROL_CODE) 				code;

	BYTE												id;
	USHORT 											length;
	
	MRU_OPTION										MRU_option;
	ASYNC_CONTROL_CHARACTER_MAP_OPTION		async_control_character_map_option;
	AUTHENTICATION_OPTION 						authentication_option;
	ENCRYPTION_OPTION								encryption_option;
	MAGIC_NUMBER_OPTION							magic_number_option;
	LINK_QUALITY_OPTION							link_quality_option;
	PROTOCOL_FIELD_COMPRESSION_OPTION		protocol_field_compression_option;
	AC_FIELD_COMPRESSION_OPTION				address_and_control_field_compression_option;
/* Sachin 25/06/1996 */
#ifdef LCP_EXT_CALLBACK
	CALLBACK_OPTION            				callback_option ;
#endif
/* Sachin 25/06/1996 */
} LCP_CONFIGURE_REQUEST;

typedef	struct	LCP_CONFIGURE_REQUEST_PACKET
{
	PPP_HEADER							header;

	BYTE_ENUM (PPP_CONTROL_CODE) 	code;

	BYTE									id;
	USHORT 								length;

	UNION_LCP_OPTIONS					options;
} LCP_CONFIGURE_REQUEST_PACKET;

typedef	struct	CONFIGURE_ACK_PACKET
{
	PPP_HEADER							header;

	BYTE_ENUM (PPP_CONTROL_CODE) 	code;

	BYTE									id;
	USHORT 								length;

	UNION_LCP_OPTIONS	 				union_lcp_options[VARIABLE_NUMBER_OF_BYTES];
} CONFIGURE_ACK_PACKET;

typedef	struct	CONFIGURE_NAK_PACKET
{
	PPP_HEADER							header;

	BYTE_ENUM (PPP_CONTROL_CODE) 	code;

	BYTE									id;
	USHORT 								length;

	UNION_LCP_OPTIONS	 				options;
} CONFIGURE_NAK_PACKET;

typedef	struct	CONFIGURE_REJECT_PACKET
{
	PPP_HEADER							header;

	BYTE_ENUM (PPP_CONTROL_CODE) 	code;

	BYTE									id;
	USHORT 								length;

	UNION_LCP_OPTIONS	 				options;
} CONFIGURE_REJECT_PACKET;

typedef	struct	TERMINATE_REQUEST
{
	PPP_HEADER							header;

	BYTE_ENUM (PPP_CONTROL_CODE) 	code;

	BYTE									id;
	USHORT 								length;
} TERMINATE_REQUEST;

typedef	struct	TERMINATE_ACK
{
	PPP_HEADER							header;

	BYTE_ENUM (PPP_CONTROL_CODE) 	code;

	BYTE									id;
	USHORT 								length;
} TERMINATE_ACK;

typedef	struct	CODE_REJECT_PACKET
{
	PPP_HEADER	  						header;

	BYTE_ENUM (PPP_CONTROL_CODE) 	code;

	BYTE			  						id;
	USHORT 		  						length;

	LCP_PACKET	  						rejected_packet;

} CODE_REJECT_PACKET;

typedef	struct	PROTOCOL_REJECT_PACKET
{
	PPP_HEADER							header;

	BYTE_ENUM (PPP_CONTROL_CODE) 	code;

	BYTE									id;
	USHORT 								length;
	PROTOCOL_REJECT_HEADER			rejected_protocol_and_information;

} PROTOCOL_REJECT_PACKET;

typedef	struct	ECHO_REQUEST_PACKET
{
	PPP_HEADER					header;

	BYTE_ENUM (PPP_CONTROL_CODE) code;

	BYTE							id;
	USHORT 						length;

	ULONG							magic_number;
} ECHO_REQUEST_PACKET;

typedef	struct	ECHO_REPLY_PACKET
{
	PPP_HEADER					header;

	BYTE_ENUM (PPP_CONTROL_CODE) code;

	BYTE							id;
	USHORT 						length;

	ULONG							magic_number;
} ECHO_REPLY_PACKET;

typedef	struct 	DISCARD_REQUEST_PACKET
{
	PPP_HEADER							header;

	BYTE_ENUM (PPP_CONTROL_CODE) 	code;

	BYTE									id;
	USHORT 								length;

	ULONG									magic_number;
} DISCARD_REQUEST_PACKET;

typedef struct LINK_QUALITY_COUNTERS
{
	ULONG	OutLQRs;
	ULONG	InLQRs;
	ULONG	InGoodOctets;
	ULONG	ifInOctets;
	ULONG	ifInErrors;
	ULONG	ifInDiscards;
	ULONG	ifOutOctets;
	ULONG	ifOutUniPackets;
	ULONG	ifInUniPackets;
} LINK_QUALITY_COUNTERS;

typedef struct IDENTIFICATION_PACKET
{
	PPP_HEADER							header;
	BYTE_ENUM (PPP_CONTROL_CODE) 	code;

	BYTE									id;
	USHORT								length;
	
	ULONG									magic_number;

	char									message[VARIABLE_NUMBER_OF_BYTES];
	
} IDENTIFICATION_PACKET;

typedef struct TIME_REMAINING_PACKET
{
	PPP_HEADER							header;
	BYTE_ENUM (PPP_CONTROL_CODE) 	code;

	BYTE									id;
	USHORT								length;
	
	ULONG									magic_number;

	ULONG									seconds_remaining;

	char									message[VARIABLE_NUMBER_OF_BYTES];
	
} TIME_REMAINING_PACKET;

typedef	struct	CALLBACK_PACKET
{
	PPP_HEADER								header;
	BYTE_ENUM (PPP_CONTROL_CODE) 		code;

	BYTE										id;
	USHORT									length;
	
	BYTE_ENUM (CALLBACK_OPERATION)	operation;

	char										message[VARIABLE_NUMBER_OF_BYTES];
} CALLBACK_PACKET;

/* ppplcptx.c */

void send_lcp_configuration_request (USHORT real_port_number);
void send_lcp_configuration_ack (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed);
void send_lcp_configuration_nak (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet);
void send_lcp_configuration_reject (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet);
void send_lcp_echo_request (USHORT real_port_number);
void send_lcp_echo_reply (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed);
void send_lcp_termination_request (USHORT real_port_number);
void send_lcp_termination_ack (USHORT real_port_number, LCP_PACKET *sptr_lcp_rx_packet);
void send_lcp_protocol_reject (USHORT real_port_number,LCP_PACKET *sptr_bad_rx_protocol_packet,USHORT number_of_bytes_rxed );
void send_lcp_code_reject (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes);
void send_lcp_discard_request (USHORT real_port_number);
void send_lcp_link_quality_report (USHORT real_port_number);
void send_lcp_id_packet (USHORT real_port_number);
void send_lcp_time_remaining_packet (USHORT real_port_number);

/* pppauth.c */

void send_lcp_authentication_ack (USHORT real_port_number,BYTE id_from_request_packet);
void send_lcp_authentication_nak (USHORT real_port_number,BYTE id_from_request_packet);

/* ppplcprx.c */

enum TEST lcp_packet_received (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed);
void link_quality_report_received (USHORT real_port_number,LINK_QUALITY_REPORT *sptr_link_quality_report,
	USHORT number_of_bytes_rxed);

/* ppplrxop.c */

enum TEST process_configuration_nak_options (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,
	USHORT number_of_bytes_rxed,USHORT number_of_bytes_processed);
