#ifdef __MLPPP__

typedef	struct	ENDPOINT_DISCRIMINATOR
{
	BYTE	length;
	BYTE	class;
	BYTE	address[20];
} ENDPOINT_DISCRIMINATOR;

typedef struct	MLPPP_RX_DESCRIPTOR
{
	LINK									links;
	int									port_number;
	USHORT								number_of_bytes_rxed;
	UNION_PPP_PACKET					*sptr_rx_packet;
	ULONG									sequence_number;
	MLPPP_HEADER						header;
} MLPPP_RX_DESCRIPTOR;

typedef	struct	LINKS_CLASS
{
	USHORT								port_number;
	ULONG									LastSequenceNumber;
	USHORT								speed_multipler;
	USHORT								queue_depth;
	USHORT								mlppp_payload;
	USHORT								max_queue_depth;
	PPP_PORT_CLASS						*port;
	USHORT								link_discriminator;
} LINKS_CLASS;

typedef	struct	MLPPP_PORT_CLASS
{
	BYTE_ENUM (BOOLEAN)				multilink_enabled;
	USHORT								port_number;
	BYTE_ENUM (BOOLEAN)				used;
	BYTE_ENUM (BOOLEAN)				sequence_number_wrap_around;

	MLPPP_RX_DESCRIPTOR				rx_descriptor_array[NO_OF_REASSEMBLE_RESOURCES];
	LINK									reassembly_rx_list;
	LINK									free_rx_list;
	LINK									assembled_rx_list;

	ULONG									MinimumSequenceNumber;
	ULONG									ExpectedSequenceNumber;

	ULONG									NextSendSequenceNumber;

	int									LastTxLink;

	WORD									LocalMRRU;
	WORD									RemoteMRRU;
	ENDPOINT_DISCRIMINATOR			LocalEPD;
	ENDPOINT_DISCRIMINATOR			RemoteEPD;
	BYTE									UserName[UDB_USER_NAME_LENGTH];

//	WORD									number_of_buffers;
//	WORD									size_of_buffers;
	
	BYTE_ENUM (BOOLEAN)				EnableShortSequenceNumberHeader;
	BYTE									NoOfLinks;
	LINKS_CLASS							LinkInfo[MAX_NO_OF_PORTS_IN_A_MULTILINK];
	ULONG									device_driver_id;

	PPP_NCP_CLASS						ncp[NUMBER_OF_NCP_STACKS];
	PPP_IPX_COMPRESSION_CLASS		cipx;
	PPP_VJ_COMPRESSION_CLASS		vjc;

#if defined (CCP)
	PPP_CCP_PORT_CLASS				ccp;
#endif

#ifdef __BACP__
	BAP_PORT_CLASS							bacp;
#endif

/* Introduced by Naveen 30/6/1998 */
	BYTE									expecting_ras_link_coming_up;	

} MLPPP_PORT_CLASS;

/* Added By Naveen for DOD Support ... */
#ifdef __DOD__
typedef  struct DOD_BUNDLE 
{
   BYTE link_down_by_demand;
   USHORT number_of_links;
   USHORT link_port_number[MAXIMUM_NUMBER_OF_PPP_PORTS];
}DOD_BUNDLE;
#endif
/* ... Added By Naveen for DOD Support */


typedef	struct	MLPPP_CLASS
{
	BYTE_ENUM (BOOLEAN)				enabled;
#ifdef _BIG_PROXY_ /* Jo 18/5/99 */
	BYTE_ENUM (BOOLEAN)				bacp_enabled; 
	BYTE						link_types_available; 
	BYTE						PPPPortToMultilinkPort[MAXIMUM_NUMBER_OF_PPP_PORTS];
	int						CurrentNoOfMultilink;
#endif /* Jo 18/5/99 */

	int						number_of_ports;
	MLPPP_PORT_CLASS				port[MAXIMUM_NUMBER_OF_PPP_PORTS];
/* Added By Naveen for DOD ... */
#ifdef __DOD__
   DOD_BUNDLE           dod_enabled_bundle[MAXIMUM_NUMBER_OF_PPP_PORTS];
#endif
/* ...Added By Naveen for DOD */
} MLPPP_CLASS;


typedef	struct	FRAGMENTATION_INFO
{
	int									link_number;
	int									fragment_size;
} FRAGMENTATION_INFO;





enum BOOLEAN mlppp_receive (USHORT real_port_number,UNION_PPP_PACKET **sptr_return_packet,USHORT *usptr_number_of_bytes_rxed);
enum TEST send_mlppp_packet (ULONG protocol_stack_id,USHORT real_port_number,USHORT protocol_virtual_port_number,
	PPP_PACKET_WITH_MAC_HEADER *sptr_tx_packet,USHORT number_of_bytes,enum BOOLEAN do_not_calculate_crc,
	enum BOOLEAN device_driver_buffer,void (*fptr_tx_completion) (USHORT port_number,void *vptr_buffer));
void mlppp_port_timer_routine (USHORT real_port_number);
enum BOOLEAN is_this_link_multilink(USHORT port_number);


#endif
