/*	$Modname: vncpstr.h$  $version: 1.19$      $date: 12/13/94$   */
/*
* 	$lgb$
1.0 01/05/94 keyur Initial Release.
1.1 01/05/94 keyur Added support for version control.
1.2 01/05/94 keyur Added some more structures for statistics.
1.3 01/20/94 keyur Added some more structures for statistics.
1.4 01/28/94 keyur Added some more structures for NCP options.
1.5 02/22/94 keyur There is no major change to this release.
1.6 03/23/94 keyur Added some statistics for Appletalk.
1.7 03/26/94 keyur Added and tested Asynchronous Support and ATCP for Appletalk Support
1.8 04/04/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John. Co
1.9 04/12/94 keyur Added State Machine support for LCP according to RFC1548
1.10 04/13/94 keyur Added support for NCP state machine
1.11 04/19/94 keyur Added ordering of options for LCP and NCP, courtesy of John
1.12 04/19/94 keyur Cosmetic Changes
1.13 05/02/94 keyur cosmetic changes.
1.14 07/18/94 ross general cleanup with options, added header compression, accm features.
1.15 08/08/94 ross working on adding version 2
1.16 08/11/94 ross adding rfc1570 lcp support
1.17 08/24/94 ross adding new ncps.
1.18 12/02/94 ross testing NT3.5 RAS
1.19 12/13/94 ross connected to NT RAS with Netbios
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
typedef	struct	NCP_HEADER
{
	BYTE_ENUM (PPP_CONTROL_CODE) 	code;

	BYTE									id;
	USHORT 								length;
} NCP_HEADER;

typedef	struct	GENERIC_OPTION
{
	BYTE	type;
	BYTE	length;

	BYTE	data[VARIABLE_NUMBER_OF_BYTES];					
} GENERIC_OPTION;

typedef	struct	NCP_PACKET
{
	PPP_HEADER	ppp_header;
	NCP_HEADER	ncp_header;													  
} NCP_PACKET;

typedef	struct	NCP_CONFIGURE_REQUEST
{
	PPP_HEADER		ppp_header;

	NCP_HEADER		ncp_header;

	GENERIC_OPTION	options;
} NCP_CONFIGURE_REQUEST;

typedef	struct	NCP_CONFIGURE_ACK
{
	PPP_HEADER	ppp_header;

	NCP_HEADER	ncp_header;													  
} NCP_CONFIGURE_ACK;

typedef	struct	NCP_CONFIGURE_NAK
{
	PPP_HEADER		ppp_header;

	NCP_HEADER		ncp_header;
	GENERIC_OPTION	options;
} NCP_CONFIGURE_NAK;

typedef	struct	NCP_CONFIGURE_REJECT
{
	PPP_HEADER		ppp_header;

	NCP_HEADER		ncp_header;													  
	GENERIC_OPTION	options;
} NCP_CONFIGURE_REJECT;

typedef	struct	NCP_TERMINATE_REQUEST
{
	PPP_HEADER	ppp_header;

	NCP_HEADER	ncp_header;													  
} NCP_TERMINATE_REQUEST;

typedef	struct	NCP_TERMINATE_ACK
{
	PPP_HEADER	ppp_header;

	NCP_HEADER	ncp_header;													  
} NCP_TERMINATE_ACK;

typedef	struct	NCP_CODE_REJECT_PACKET
{
	PPP_HEADER	ppp_header;

	NCP_HEADER	ncp_header;													  
	NCP_PACKET  rejected_packet;
} NCP_CODE_REJECT_PACKET;

typedef	struct	NCP_PACKET_WITH_OPTIONS
{
	PPP_HEADER		ppp_header;

	NCP_HEADER		ncp_header;

	GENERIC_OPTION	options;
} NCP_PACKET_WITH_OPTIONS;

typedef	union	UNION_NCP_GENERIC_PACKET
{
	NCP_CONFIGURE_REQUEST		configure_request;
	NCP_CONFIGURE_ACK				configure_ack;
	NCP_CONFIGURE_NAK				configure_nak;
	NCP_CONFIGURE_REJECT			configure_reject;
	NCP_TERMINATE_REQUEST		terminate_request;
	NCP_TERMINATE_ACK				terminate_ack;
	NCP_CODE_REJECT_PACKET		reject;
	NCP_PACKET_WITH_OPTIONS		packet_with_options;
} UNION_NCP_GENERIC_PACKET;

typedef	struct	PPP_NCP_STATISTICS
{
	ULONG	number_of_tx_packets;
	ULONG	number_of_tx_bytes;

	ULONG	number_of_rx_packets;
	ULONG	number_of_rx_bytes;

	ULONG	number_of_packets_rxed_greater_than_maximum_size;
	ULONG	number_of_packets_rxed_less_than_minimum_size;
	ULONG	number_of_packets_rxed_in_down_port;

	ULONG	number_of_tx_control_packets[NUMBER_OF_PPP_CONTROL_CODES];
	ULONG	number_of_rx_control_packets[NUMBER_OF_PPP_CONTROL_CODES];

} PPP_NCP_STATISTICS;

typedef	union	UNION_NCP_OPTIONS
{
	IPCP_OPTIONS		ip;

#ifdef _BIG_PROXY_
	IPXCP_OPTIONS		ipx;
	ATCP_OPTIONS		appletalk;
#endif
} UNION_NCP_OPTIONS;

typedef	union	UNION_NCP_OPTION_TYPES
{
	BYTE_ENUM (IPCP_OPTION_TYPE) 	ipcp;
#ifdef _BIG_PROXY_
	BYTE_ENUM (ATCP_OPTION_TYPE) 	atcp;
	BYTE_ENUM (IPXCP_OPTION_TYPE) ipxcp;
#endif
	BYTE									generic;
} UNION_NCP_OPTION_TYPES;

typedef	union	UNION_NCP_PACKET
{
	UNION_IPCP_PACKET				ip;
#ifdef _BIG_PROXY_
	UNION_IPXCP_PACKET			ipx;
	UNION_ATCP_PACKET				appletalk;
#endif
	UNION_NCP_GENERIC_PACKET	generic;
} UNION_NCP_PACKET;

