/*	$Modname: vnipxstr.h$  $version: 1.12$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 04/19/94 keyur
1.1 04/19/94 keyur Added support for version control.
1.2 05/02/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John.
1.3 07/18/94 ross general cleanup with options, added header compression, accm features.
1.4 08/08/94 ross working on adding version 2
1.5 08/11/94 ross adding rfc1570 lcp support
1.6 08/24/94 ross adding new ncps.
1.7 09/06/94 ross
1.8 12/03/94 ross testing Windows 95	RAS
1.9 12/13/94 ross connected to NT RAS with Netbios
1.10 01/26/95 ross changes for rwutils
1.11 03/10/95 ross general fixes.  see change.doc
1.12 10/19/95 biao replaced enum declarations with RouterWare ENUM declaration macros.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#ifdef _BIG_PROXY_
typedef	struct	IPX_OPTIONS_BOOLEAN
{
	BYTE_ENUM (BOOLEAN) 	network_number;
	BYTE_ENUM (BOOLEAN) 	node_number;
	BYTE_ENUM (BOOLEAN) 	compression;
	BYTE_ENUM (BOOLEAN) 	routing_protocol;
	BYTE_ENUM (BOOLEAN) 	router_name;
	BYTE_ENUM (BOOLEAN) 	configuration_complete;
}	IPX_OPTIONS_BOOLEAN;

typedef	struct	PPP_IPX_CONFIGURATION
{
	IPX_OPTIONS_BOOLEAN									enabled;

	ULONG														network_number;
	MAC_ADDRESS 											node_number;
	USHORT_ENUM (IPXCP_COMPRESSION_OPTION_TYPE)	compression_protocol;
	USHORT_ENUM (IPXCP_ROUTING_PROTOCOL_TYPE)		routing_protocol;
	BYTE														size_of_router_name;
	char 														router_name[PPP_IPX_NAME_SIZE];
	BYTE_ENUM (BOOLEAN)											configuration_complete;

	char 														remote_router_name[PPP_IPX_NAME_SIZE];

	BYTE														maximum_slot_id;	
	BYTE														compression_slot_id;
} PPP_IPX_CONFIGURATION;

typedef	struct	IPXCP_CONFIGURE_REQUEST
{
	PPP_HEADER					header;

	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE							id;
	USHORT 						length;
} IPXCP_CONFIGURE_REQUEST;

typedef	struct	IPXCP_CONFIGURE_ACK
{
	PPP_HEADER					header;

	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE							id;
	USHORT 						length;
} IPXCP_CONFIGURE_ACK;

typedef	struct	IPXCP_CONFIGURE_NAK
{
	PPP_HEADER					header;

	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE							id;
	USHORT 						length;
} IPXCP_CONFIGURE_NAK;

typedef	struct	IPXCP_CONFIGURATION_REJECT
{
	PPP_HEADER					header;

	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE							id;
	USHORT 						length;
} IPXCP_CONFIGURATION_REJECT;

typedef	struct	IPXCP_TERMINATE_REQUEST
{
	PPP_HEADER					header;

	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE							id;
	USHORT 						length;
} IPXCP_TERMINATE_REQUEST;

typedef	struct	IPXCP_TERMINATE_ACK
{
	PPP_HEADER					header;

	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE							id;
	USHORT 						length;
} IPXCP_TERMINATE_ACK;

typedef	struct	IPXCP_CODE_REJECT_PACKET
{
	PPP_HEADER					header;

	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE							id;
	USHORT 						length;
	BYTE  						rejected_packet[VARIABLE_NUMBER_OF_BYTES];
} IPXCP_CODE_REJECT_PACKET;

typedef	struct IPX_NETWORK_NUMBER_OPTION
{
	BYTE_ENUM (IPXCP_OPTION_TYPE)	type;
	BYTE							length;

	ULONG							network_number;
} IPX_NETWORK_NUMBER_OPTION;

typedef	struct IPX_NODE_NUMBER_OPTION
{
	BYTE_ENUM (IPXCP_OPTION_TYPE)	type;
	BYTE							length;

	MAC_ADDRESS					node_number;
} IPX_NODE_NUMBER_OPTION;

typedef	struct IPX_COMPRESSION_OPTION
{
	BYTE_ENUM (IPXCP_OPTION_TYPE)					type;
	BYTE											length;
	USHORT_ENUM (IPXCP_COMPRESSION_OPTION_TYPE)	compression_protocol;
} IPX_COMPRESSION_OPTION;

typedef	struct IPX_ROUTING_PROTOCOL_OPTION
{
	BYTE_ENUM (IPXCP_OPTION_TYPE)							type;
	BYTE													length;
	USHORT_ENUM (IPXCP_ROUTING_PROTOCOL_TYPE)				routing_protocol;
} IPX_ROUTING_PROTOCOL_OPTION;

typedef	struct IPX_ROUTER_NAME_OPTION
{
	BYTE_ENUM (IPXCP_OPTION_TYPE)	type;
	BYTE							length;
	char 							router_name[PPP_IPX_NAME_SIZE];
} IPX_ROUTER_NAME_OPTION;

typedef	struct IPX_CONFIGURATION_COMPLETE_OPTION
{
	BYTE_ENUM (IPXCP_OPTION_TYPE)	type;
	BYTE							length;
} IPX_CONFIGURATION_COMPLETE_OPTION;

typedef	struct	GENERIC_IPXCP_OPTION
{
	BYTE_ENUM (IPXCP_OPTION_TYPE)	type;
	BYTE							length;
} GENERIC_IPXCP_OPTION;

typedef	union	UNION_IPXCP_OPTIONS
{
	IPX_NETWORK_NUMBER_OPTION				network_number;
	IPX_NODE_NUMBER_OPTION					node_number;
	IPX_COMPRESSION_OPTION					compression;
	IPX_ROUTING_PROTOCOL_OPTION			routing_protocol;
	IPX_ROUTER_NAME_OPTION					router_name;
	IPX_CONFIGURATION_COMPLETE_OPTION	configuration_complete;
	GENERIC_IPXCP_OPTION						generic;
}	UNION_IPXCP_OPTIONS;

typedef	struct	IPXCP_OPTIONS
{
	IPX_NETWORK_NUMBER_OPTION				network_number;
	IPX_NODE_NUMBER_OPTION					node_number;
	IPX_COMPRESSION_OPTION					compression;
	IPX_ROUTING_PROTOCOL_OPTION			routing_protocol;
	IPX_ROUTER_NAME_OPTION					router_name;
	IPX_CONFIGURATION_COMPLETE_OPTION	configuration_complete;
}	IPXCP_OPTIONS;

typedef	struct	IPXCP_PACKET
{
	PPP_HEADER					header;
	
	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE							id;
	USHORT 						length;

	UNION_IPXCP_OPTIONS 		options;
} IPXCP_PACKET;

typedef	union	UNION_IPXCP_PACKET
{
	IPXCP_PACKET					generic;
	IPXCP_CONFIGURE_REQUEST		configure_request;
	IPXCP_CONFIGURE_ACK			configuration_ack;
	IPXCP_CONFIGURE_NAK			configuration_nak;
	IPXCP_CONFIGURATION_REJECT	configuration_reject;
	IPXCP_TERMINATE_REQUEST		terminate_request;
	IPXCP_TERMINATE_ACK			terminate_ack;
	IPXCP_CODE_REJECT_PACKET	reject;
} UNION_IPXCP_PACKET;

typedef	struct	IPX_PPP_ACCEPTED_PARAMETERS
{
	ULONG														network_number;
	MAC_ADDRESS 											node_number;
	USHORT_ENUM (IPXCP_COMPRESSION_OPTION_TYPE)	compression_protocol;
	USHORT_ENUM (IPXCP_ROUTING_PROTOCOL_TYPE)		routing_protocol;
	char 														*cptr_router_name;
	BYTE_ENUM (BOOLEAN)									configuration_complete;
} IPX_PPP_ACCEPTED_PARAMETERS;

void initialize_ipx_ncp (USHORT real_port_number);
#endif

