#ifndef __SCRTCONS__

#define __SCRTCONS__

#include "scrtenum.h"

#define MAX_LEVELS	2
#define MAX_NO_OF_PORTS 3

/*	Table to store offsets of instruction beginning in code buffer.	*/
#define ADDR_TABLE_SIZE	65536

/*	Memory to read instructions.	*/
#define CODE_BUFFER_SIZE 65536

#define BUILT_IN_FUNCTION 0x04	/*	Built in fn, for optional args.	*/

#define MAX_TOKEN_LEN 81      	/*	Max length of a token, 80 + null. */

#define CONDN_VARIABLE 0		/*	Index for condn variable.	*/
#define RETURN_VARIABLE 1

#define DO_NOT_REMOVE_PARAMETERS 5


#define	INTEGER			(1 << E_INTEGER)
#define	INT_CONST		(1 << E_INT_CONST)
#define	STRING			(1 << E_STRING)
#define	STRING_CONST	(1 << E_STRING_CONST)
#define	REAL			   (1 << E_REAL)
#define	REAL_CONST		(1 << E_REAL_CONST)


#define	STRLEN				1
#define	STRCMP				2
#define	STRCAT				3
#define	STRCPY				4

#define RESET_SCRIPT_VARIABLES -3

#define DONT_CARE	(INTEGER | INT_CONST | REAL | REAL_CONST | STRING | STRING_CONST)

#define PARITY_NONE  (0x00 | 0x00 | 0x00)
#define PARITY_ODD   (0x10 | 0x00 | 0x00)
#define PARITY_EVEN  (0x10 | 0x08 | 0x02)

#define SET_CONF_SET_SIGS 0x01
#define SET_CONF_RESET_SIGS 0x02
#define LINE_STAT_DTR 0x20	
#define LINE_STAT_RTS 0x10

#endif
