#include <stdio.h>
#include <stdlib.h>
#include <kstart.h>
#include <string.h>

#include "scrtdefs.h"
#include "scrtfuns.h"
#include "scrtargs.h"
#include "scrtenum.h"
#include "scrtcons.h"
#include "scrtwan.h"
#include "scrtasm.h"
#include "scrtutls.h"
#include "scrttype.h"

BYTE *RgetsBuf[MAX_NO_OF_PORTS] = {0, 0, 0} ;
WORD RgetsCount[MAX_NO_OF_PORTS] = {0, 0, 0} ;
BYTE AlreadyCheckedWait[MAX_NO_OF_PORTS] = {0, 0, 0} ;

long NumOfBrkCharsRemaining[MAX_NO_OF_PORTS] = {0, 0, 0} ;
BYTE CheckedBreak[MAX_NO_OF_PORTS] = {0, 0, 0} ;

BYTE *HangUpPtr[MAX_NO_OF_PORTS] = {0, 0, 0} ;
BYTE CheckedHangUp[MAX_NO_OF_PORTS] = {0, 0, 0} ;
BYTE HandlingBreak[MAX_NO_OF_PORTS] = {0, 0, 0} ;

int RgetcHdlr (BYTE PortNum) 
{
	ArgType *a_ptr ;
	ArgType arg ;
	BYTE char_got ;
	BYTE val[3] ;
	int ReadStatus ;

	char_got = 0 ;
	if (ScriptPortClass[PortNum].ScriptOnWait &&
				!ScriptPortClass[PortNum].ScriptWaitTimer)
	{
		ScriptPortClass[PortNum].ScriptOnWait = 0 ;
		goto ignore_exit ;
	}

	if (!AlreadyCheckedWait[PortNum])
	{
		AlreadyCheckedWait[PortNum] = 1 ;
/*		script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
									"Port %d : RGETC\n\r", PortNum) ; */
		/*	If optional parameter timeout is given, read it off the stack.	*/
		if ((WORD) (ScriptPortClass[PortNum].StackTop - 1)->IntVal > 1) 
		{
			/*	Get the timeout.	*/
			if (a_ptr = GetParamAddress (2, INT_CONST | INTEGER, PortNum)) 
			{
				ScriptPortClass[PortNum].ScriptWaitTimer = (WORD) *a_ptr->IntPtr ;
				ScriptPortClass[PortNum].ScriptWaitTimer *= 20 ;
				ScriptPortClass[PortNum].ScriptOnWait = 1 ;
			}
			else
			{
				goto ignore_exit ;
			}
		}
	}

	/*	Get string variable name to update.	*/
	if (!(a_ptr = GetParamAddress (1, STRING, PortNum))) 
	{
		goto error_exit ;
	}

	ReadStatus = ReadFromPort ((WORD) PortNum, &val[0], 1, NULL) ;

   if (ReadStatus == 1)
		char_got = 1 ;
	else
		return DO_NOT_REMOVE_PARAMETERS ;

	ScriptPortClass[PortNum].ScriptOnWait = 0 ;
	ScriptPortClass[PortNum].ScriptWaitTimer = 0 ;
	val[1] = 0 ;		/*	Terminate the string.	*/

	if (UpdateStrVar (a_ptr->StrPtr, val, PortNum) < 0)
		char_got = 0 ;	/*	To return failure.	*/

ignore_exit :
	AlreadyCheckedWait[PortNum] = 0 ;
	arg.IntVal = char_got ;
	arg.ArgType = E_INTEGER ;
	SetPreDefVariable (PreDefVars[RETURN_VARIABLE].VarName, &arg, PortNum) ;
	return 0 ;

error_exit :
	return -2 ;
}


int RgetsHdlr (BYTE PortNum) 
{
	ArgType *a_ptr ;
	ArgType arg ;
	int ReadStatus ;

	if (ScriptPortClass[PortNum].ScriptOnWait &&
				!ScriptPortClass[PortNum].ScriptWaitTimer)
	{
		goto ignore_exit ;
	}

	if (!ScriptPortClass[PortNum].ScriptOnWait && !AlreadyCheckedWait[PortNum])
	{
/*		script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
									"Port %d : RGETS\n\r", PortNum) ; */
		AlreadyCheckedWait[PortNum] = 1 ;
		if ((WORD) (ScriptPortClass[PortNum].StackTop - 1)->IntVal > 2) 
		{
			/*	Get the timeout.	*/
			if (a_ptr = GetParamAddress (3, INT_CONST | INTEGER, PortNum)) 
			{
				ScriptPortClass[PortNum].ScriptWaitTimer = (WORD) *a_ptr->IntPtr ;
				ScriptPortClass[PortNum].ScriptWaitTimer *= 20 ;
				ScriptPortClass[PortNum].ScriptOnWait = 1 ;
			}
			else
			{
				goto ignore_exit ;
			}
		}

		/* Get the maximum length of string */
		if (a_ptr = GetParamAddress (2, INT_CONST | INTEGER, PortNum)) 
		{
			RgetsCount[PortNum] = (WORD) *a_ptr->IntPtr ;
			if (!(RgetsBuf[PortNum] = (BYTE *) malloc (RgetsCount[PortNum] + 1)))
			{
/*				script_printf (ALARM_SCRIPT_PRINTF,
						"Insufficient memory (RGETS) : Port %d\n\r", PortNum) ;*/
				goto error_exit ;
			}
			RgetsBuf[PortNum][RgetsCount[PortNum]] = 0 ; /* terimate with a null */
			ScriptPortClass[PortNum].RecvCharCount = 0 ;
		}
		else
		{
			goto error_exit ;
		}
	}

	/*	Get string variable name to update.	*/
	if (!(a_ptr = GetParamAddress (1, STRING, PortNum))) 
	{
		goto error_exit ;
	}

	ReadStatus = ReadFromPort ((WORD) PortNum, 
			&RgetsBuf[PortNum][ScriptPortClass[PortNum].RecvCharCount], 
				RgetsCount[PortNum] - ScriptPortClass[PortNum].RecvCharCount,
					&ScriptPortClass[PortNum].RecvCharCount) ;
	if (ReadStatus == 1)
	{
		if (ScriptPortClass[PortNum].RecvCharCount < RgetsCount[PortNum])
			return DO_NOT_REMOVE_PARAMETERS ;
	}
	else
		return DO_NOT_REMOVE_PARAMETERS ;


ignore_exit :
	/* terminate with a null */
	RgetsBuf[PortNum][ScriptPortClass[PortNum].RecvCharCount] = 0 ;
	if (UpdateStrVar (a_ptr->StrPtr, RgetsBuf[PortNum], PortNum) < 0)
		ScriptPortClass[PortNum].RecvCharCount = 0 ;	/*	To return failure.	*/
	AlreadyCheckedWait[PortNum] = 0 ;
	ScriptPortClass[PortNum].ScriptOnWait = 0 ;
	ScriptPortClass[PortNum].ScriptWaitTimer = 0 ;
	arg.IntVal = ScriptPortClass[PortNum].RecvCharCount ;
	arg.ArgType = E_INTEGER ;
	SetPreDefVariable (PreDefVars[RETURN_VARIABLE].VarName, &arg, PortNum) ;
	if (RgetsBuf[PortNum])
		free (RgetsBuf[PortNum]) ;
	RgetsBuf[PortNum] = 0 ;
	ScriptPortClass[PortNum].RecvCharCount = 0 ;
	RgetsCount[PortNum] = 0 ;
	return 0 ;

error_exit :
	ScriptPortClass[PortNum].ScriptOnWait = 0 ;
	ScriptPortClass[PortNum].ScriptWaitTimer = 0 ;
	AlreadyCheckedWait[PortNum] = 0 ;
	if (RgetsBuf[PortNum])
		free (RgetsBuf[PortNum]) ;
	RgetsBuf[PortNum] = 0 ;
	ScriptPortClass[PortNum].RecvCharCount = 0 ;
	RgetsCount[PortNum] = 0 ;
	return -2 ;
}

int GetDCDHdlr (BYTE PortNum) 
{
	ArgType arg ;

	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : GETDCD\n\r", PortNum) ;
	if (is_DCD_present ((USHORT) PortNum))
		arg.IntVal = 1 ;	/*	Set return value.	*/
	else
		arg.IntVal = 0 ;	/*	Set return value.	*/
	arg.ArgType = E_INTEGER ;
	SetPreDefVariable (PreDefVars[RETURN_VARIABLE].VarName, &arg, PortNum) ;
	return 0 ;
}


#if 0
/*----------------------------------------------------------------------------
	Synopsis :
			Check whether CD is de-asserted.
			If yes then the job is done.
			If not bring DTR down.
			Check again for CD.
			If CD is down job is done.
			If not wait for some time for CD to come down
			If CD is down fine else nothing can be done about it.
----------------------------------------------------------------------------*/
int DropConnectionHdlr (BYTE PortNum) 
{
	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : DROPCONNECTION\n\r", PortNum) ;
	if (!is_DCD_present ((USHORT) PortNum))
	{
		SetLineConfigUART ((USHORT) SET_CONF_SET_SIGS,
								(USHORT) LINE_STAT_DTR, (USHORT) PortNum) ;
		ScriptPortClass[PortNum].ScriptOnWait = 0 ;
		ScriptPortClass[PortNum].ScriptWaitTimer = 0 ;
		return 0 ;
	}

	if (!ScriptPortClass[PortNum].ScriptOnWait)
	{
		/* Bring down DTR forcefully */
		SetLineConfigUART ((USHORT) SET_CONF_RESET_SIGS,
								(USHORT) LINE_STAT_DTR, (USHORT) PortNum) ;
		/* check for CD */
		if (is_DCD_present ((USHORT) PortNum))
		{
			ScriptPortClass[PortNum].ScriptWaitTimer = 10 * 20 ; /* 10 seconds */
			ScriptPortClass[PortNum].ScriptOnWait = 1 ;
			return DO_NOT_REMOVE_PARAMETERS ;
		}
		else
		{
			ScriptPortClass[PortNum].ScriptOnWait = 0 ;
			ScriptPortClass[PortNum].ScriptWaitTimer = 0 ;
			/* Bring up DTR */
			SetLineConfigUART ((USHORT) SET_CONF_SET_SIGS,
									(USHORT) LINE_STAT_DTR, (USHORT) PortNum) ;
			return 0 ;
		}
	}

	/* If waiting for CD down upon bringing DTR down is over */
	if (!ScriptPortClass[PortNum].ScriptWaitTimer)
	{
		if (is_DCD_present ((USHORT) PortNum))
		{
			SetLineConfigUART ((USHORT) SET_CONF_SET_SIGS,
									(USHORT) LINE_STAT_DTR, (USHORT) PortNum) ;
			ScriptPortClass[PortNum].ScriptWaitTimer = BREAK_TIME * 20 ; 
			SendBreak ((ULONG) PortNum, BREAK_TIME * 1000) ; */
		}
		else
		{
			SetLineConfigUART ((USHORT) SET_CONF_SET_SIGS,
									(USHORT) LINE_STAT_DTR, (USHORT) PortNum) ;
			ScriptPortClass[PortNum].ScriptOnWait = 0 ;			
			return 0 ;
		}
	}

   return DO_NOT_REMOVE_PARAMETERS ;
}

/*----------------------------------------------------------------------------
		Hangup string may be something like this
			~~~+++~~~ATH0^M
					or
			<BREAK>ATH0^M
					or
			+++ATH0^M  (for TIES modems)
----------------------------------------------------------------------------*/
int HangupHdlr (BYTE PortNum) 
{
	#define BREAK_TIME 2 /* in seconds */
	BYTE *HangupPtr ;

	if (!AlreadyCheckedWait[PortNum])
	{
		script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
									"Port %d : HANGUP\n\r", PortNum) ;
	}

	if (!is_DCD_present ((USHORT) PortNum) && AlreadyCheckedWait[PortNum])
	{
		SetLineConfigUART ((USHORT) SET_CONF_SET_SIGS,
									(USHORT) LINE_STAT_DTR, (USHORT) PortNum) ;
		goto ignore_exit ;
	}

	if (ScriptPortClass[PortNum].ScriptOnWait
				&& ScriptPortClass[PortNum].ScriptWaitTimer)
	{
		return DO_NOT_REMOVE_PARAMETERS ;
	}

	if (!AlreadyCheckedWait[PortNum])
	{
		HangupPtr = (BYTE *) get_wan_modem_hangup_string ((USHORT) PortNum) ;
		if (ScriptPortClass[PortNum].RecvStr)
			free (ScriptPortClass[PortNum].RecvStr) ;
		ScriptPortClass[PortNum].RecvStr = (BYTE *) malloc (strlen (HangupPtr) + 1) ; 
		if (!ScriptPortClass[PortNum].RecvStr)
		{
			script_printf (ALARM_SCRIPT_PRINTF, 
					"Out of memory (HANGUP) : Port %d\n\r", PortNum) ;
			goto error_exit ;
		}
		AlreadyCheckedWait[PortNum] = 1 ;
		RgetsCount[PortNum] = 0 ;
		ConvertControls (ScriptPortClass[PortNum].RecvStr, HangupPtr) ;
		/* Just get DTR down for modem to Hang up */
		/* If not successful send the Hangup string */
		SetLineConfigUART ((USHORT) SET_CONF_RESET_SIGS,
								(USHORT) LINE_STAT_DTR, (USHORT) PortNum) ;
		ScriptPortClass[PortNum].ScriptOnWait = 1 ;
		ScriptPortClass[PortNum].ScriptWaitTimer = 2 * 20 ;
		return DO_NOT_REMOVE_PARAMETERS ;
	}

	/* This is in case a break was sent earlier */
	/* In sending a break STOP_TRANSMIT is written to the CR */
	if (ScriptPortClass[PortNum].ScriptOnWait)
	{
		WriteToCommandRegister ((ULONG) RESTART_TRANSMIT, (ULONG) PortNum) ;
	}

	HangupPtr = &ScriptPortClass[PortNum].RecvStr[RgetsCount[PortNum]] ;
	if (*HangupPtr)
	{
		if (*HangupPtr == '~')   /* Is it a pause character ? */
		{
			ScriptPortClass[PortNum].ScriptWaitTimer = 20 / 2 ; /* 0.5 seconds pause */
			ScriptPortClass[PortNum].ScriptOnWait = 1 ;
			RgetsCount[PortNum] ++ ;
			return DO_NOT_REMOVE_PARAMETERS ;
		}

		if (HangupPtr = strstr (
				&ScriptPortClass[PortNum].RecvStr[RgetsCount[PortNum]], "<BREAK>"))
		{
			/* try and send anything before the break here */
			SendBreak ((ULONG) PortNum, BREAK_TIME * 1000) ;	  /* in milli seconds */
			ScriptPortClass[PortNum].ScriptWaitTimer = BREAK_TIME * 20 ;
			ScriptPortClass[PortNum].ScriptOnWait = 1 ;
			RgetsCount[PortNum] +=
				HangupPtr - &ScriptPortClass[PortNum].RecvStr[RgetsCount[PortNum]] ;
			RgetsCount[PortNum] += strlen ("<BREAK>") ;
			return DO_NOT_REMOVE_PARAMETERS ;
		}

		if (HangupPtr = strchr (
				&ScriptPortClass[PortNum].RecvStr[RgetsCount[PortNum]], '~'))
		{
			WriteToPort ((USHORT) PortNum,
           &ScriptPortClass[PortNum].RecvStr[RgetsCount[PortNum]], 
         	HangupPtr - &ScriptPortClass[PortNum].RecvStr[RgetsCount[PortNum]]) ;
         RgetsCount[PortNum] +=
			  HangupPtr - &ScriptPortClass[PortNum].RecvStr[RgetsCount[PortNum]] ;
			ScriptPortClass[PortNum].ScriptOnWait = 0 ;
			return DO_NOT_REMOVE_PARAMETERS ;
		}
		else
		{
			WriteToPort ((USHORT) PortNum,
           &ScriptPortClass[PortNum].RecvStr[RgetsCount[PortNum]], 0) ;
		}
	}

ignore_exit :
	if (ScriptPortClass[PortNum].RecvStr)
		free (ScriptPortClass[PortNum].RecvStr) ;
	ScriptPortClass[PortNum].RecvStr = 0 ;
	RgetsCount[PortNum] = 0 ;
	AlreadyCheckedWait[PortNum] = 0 ;
	ScriptPortClass[PortNum].ScriptOnWait = 0 ;
	ScriptPortClass[PortNum].ScriptWaitTimer = 0 ;
   return 0 ;

error_exit :
	return -2 ;
}
#endif


/*----------------------------------------------------------------------------
		Hangup string may be something like this
			~~~+++~~~ATH0^M
					or
			<BREAK>ATH0^M
					or
			+++ATH0^M  (for TIES modems)

		If CD is not present do nothing
		else
		First bring down the DTR and wait for some time
		If still the CD is present
		fetch the Hangup string and transmit it
----------------------------------------------------------------------------*/
int HangupHdlr (BYTE PortNum) 
{
	BYTE *StrPointer ;
	USHORT Len ;
	int Temp ;

	/* Even if CD is absent we may want to bring the modem
		to idle state.So at least bring down the DTR the first time */
	if (is_DCD_present ((USHORT) PortNum) ||
					!ScriptPortClass[PortNum].ScriptOnWait)
	{
		if (!ScriptPortClass[PortNum].ScriptOnWait)
		{
			script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
										"Port %d : HANGUP\n\r", PortNum) ;
			/* Bring down DTR forcefully */
			SetLineConfigUART ((USHORT) SET_CONF_RESET_SIGS,
									(USHORT) LINE_STAT_DTR, (USHORT) PortNum) ;
			ScriptPortClass[PortNum].ScriptOnWait = 1 ;
			ScriptPortClass[PortNum].ScriptWaitTimer = 10 * 20 ; /* 10 seconds */
			return DO_NOT_REMOVE_PARAMETERS ;
		}

		if (ScriptPortClass[PortNum].ScriptOnWait
				&& ScriptPortClass[PortNum].ScriptWaitTimer)
		{
			return DO_NOT_REMOVE_PARAMETERS ;
		}

		/* Just bringing down the DTR did not succeed.
			So send the hangup string */
		if (ScriptPortClass[PortNum].ScriptOnWait
				&& !ScriptPortClass[PortNum].ScriptWaitTimer
					&& !CheckedHangUp[PortNum])
		{
			/* Bring up DTR */
			SetLineConfigUART ((USHORT) SET_CONF_SET_SIGS,
									(USHORT) LINE_STAT_DTR, (USHORT) PortNum) ;
			StrPointer = (BYTE *) get_wan_modem_hangup_string ((USHORT) PortNum) ;
			if (StrPointer)
			{
				Len = strlen (StrPointer) ;
				if (ScriptPortClass[PortNum].RecvStr)
					free (ScriptPortClass[PortNum].RecvStr) ;
				ScriptPortClass[PortNum].RecvStr = (BYTE *) malloc (Len + 1) ;
				if (ScriptPortClass[PortNum].RecvStr == NULL)
				{
		  			script_printf (ALARM_SCRIPT_PRINTF,
							"Memory exhausted (HANGUP), Port %d\n\r", PortNum) ;
					goto error_exit ;
				}
				CheckedHangUp[PortNum] = 1 ;
				strcpy (ScriptPortClass[PortNum].RecvStr, StrPointer) ;
				HangUpPtr[PortNum] = ScriptPortClass[PortNum].RecvStr ;
			}
			else
			{
				goto ignore_exit ;
			}
		}

handle_break :
		/* In case of MultiTech's BL Modem BREAK is part of
			the Hangup string */
		if (HandlingBreak[PortNum])
		{
			if (NumOfBrkCharsRemaining[PortNum])
			{
				NumOfBrkCharsRemaining[PortNum] -= 65535 ;
				if (NumOfBrkCharsRemaining[PortNum] < 0)
				{
					Temp = NumOfBrkCharsRemaining[PortNum] + 65535 ;
					NumOfBrkCharsRemaining[PortNum] = 0 ;
				}
				else
					Temp = 65535 ;

				ScriptPortClass[PortNum].ScriptWaitTimer = 
						(((GetDataBits (PortNum) +
								GetParityBits (PortNum) +
									GetStopBits (PortNum)) * (ULONG) Temp) * 20)  /
												GetBaudRate (PortNum) ;
				SetNoOfBrkChars ((ULONG) PortNum, (USHORT) Temp) ;
				WriteToCommandRegister ((ULONG) STOP_TRANSMIT, (ULONG) PortNum) ;
				ScriptPortClass[PortNum].ScriptOnWait = 1 ;
				return DO_NOT_REMOVE_PARAMETERS ;
			}
			else
				HandlingBreak[PortNum] = 0 ;
		}

		if (HangUpPtr[PortNum])
		{
			if (!*HangUpPtr[PortNum])
				goto ignore_exit ;

			if (strncmp (HangUpPtr[PortNum], 
						"<BREAK>", strlen ("<BREAK>")) == 0)
			{
				HangUpPtr[PortNum] += strlen ("<BREAK>") ;
				NumOfBrkCharsRemaining[PortNum] = 
						(GetBaudRate (PortNum) /
							(GetDataBits (PortNum) + GetParityBits (PortNum)
								+ GetStopBits (PortNum))) * 4 ; /* 4 seconds BREAK */
				HandlingBreak[PortNum] = 1 ;
				goto handle_break ;
			}

			/* Pause character */
			if (*HangUpPtr[PortNum] == '~')
			{
				ScriptPortClass[PortNum].ScriptWaitTimer = 20 / 2 ; /* 0.5 seconds */
				ScriptPortClass[PortNum].ScriptOnWait = 1 ;
				HangUpPtr[PortNum] ++ ;
				return DO_NOT_REMOVE_PARAMETERS ;
			}

			if (strncmp (HangUpPtr[PortNum], "+++", 3) == 0)
			{
				WriteToPort ((USHORT) PortNum, HangUpPtr[PortNum], 3) ;
				HangUpPtr[PortNum] += 3 ;
				return DO_NOT_REMOVE_PARAMETERS ;
			}

			WriteToPort ((USHORT) PortNum, HangUpPtr[PortNum] ++, 1) ;
			return DO_NOT_REMOVE_PARAMETERS ;
		}
		else
			goto ignore_exit ;
	}
	else
	{
ignore_exit :
		ScriptPortClass[PortNum].ScriptWaitTimer = 0 ;		
		ScriptPortClass[PortNum].ScriptOnWait = 0 ;
		if (ScriptPortClass[PortNum].RecvStr)
			free (ScriptPortClass[PortNum].RecvStr) ;
		ScriptPortClass[PortNum].RecvStr = 0 ;
		HangUpPtr[PortNum] = 0 ;
		CheckedHangUp[PortNum] = 0 ;
		HandlingBreak[PortNum] = 0 ;
		NumOfBrkCharsRemaining[PortNum] = 0 ;
		SetNoOfBrkChars ((ULONG) PortNum, (USHORT) 0) ;
		WriteToCommandRegister ((ULONG) RESTART_TRANSMIT, (ULONG) PortNum) ;
		/* Bring up DTR */
		SetLineConfigUART ((USHORT) SET_CONF_SET_SIGS,
							(USHORT) LINE_STAT_DTR, (USHORT) PortNum) ;
		return 0 ;
	}

error_exit :
	ScriptPortClass[PortNum].ScriptWaitTimer = 0 ;		
	ScriptPortClass[PortNum].ScriptOnWait = 0 ;
	if (ScriptPortClass[PortNum].RecvStr)
 		free (ScriptPortClass[PortNum].RecvStr) ;
 	ScriptPortClass[PortNum].RecvStr = 0 ;
 	HangUpPtr[PortNum] = 0 ;
 	CheckedHangUp[PortNum] = 0 ;
 	HandlingBreak[PortNum] = 0 ;
 	NumOfBrkCharsRemaining[PortNum] = 0 ;
 	SetNoOfBrkChars ((ULONG) PortNum, (USHORT) 0) ;
 	WriteToCommandRegister ((ULONG) RESTART_TRANSMIT, (ULONG) PortNum) ;
 	/* Bring up DTR */
	SetLineConfigUART ((USHORT) SET_CONF_SET_SIGS,
							(USHORT) LINE_STAT_DTR, (USHORT) PortNum) ;
	return -2 ;
}


int BaudRateHdlr (BYTE PortNum) 
{
	ArgType *a_ptr ;
	ArgType arg ;
	BYTE valid_baud ;
	long Baud ;
	BYTE *str ;

	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : BAUDRATE\n\r", PortNum) ;
	arg.IntVal = 0 ;	/*	Set to indicate failure.	*/
	/*	Get the baud rate.	*/
	if (!(a_ptr = GetParamAddress (1, DONT_CARE, PortNum))) 
	{
		goto error_exit ;
	}

	valid_baud = 0 ;   /* assume an invalid baud */
	switch (a_ptr->ArgType) 
	{
		case E_INT_CONST :
		case E_INTEGER :
			Baud = *a_ptr->IntPtr ;	/*	Vaidate baud rate (integer).	*/
			valid_baud = 1 ;
			break ;

		case E_STRING_CONST :
		case E_STRING :
			str = *a_ptr->StrPtr;
			Baud = atoi (str) ;
			valid_baud = 1 ;
			break ;

		default :
			goto ignore_exit ;
	}

	if (valid_baud)
	{
		arg.IntVal = 1 ;
		SetBaudRate ((ULONG) PortNum, Baud) ; 
	}
	else
	{
		script_printf (NON_CRITICAL_SCRIPT_PRINTF,
			"Parameter out of bounds for BaudRate, Port %d\n\r", PortNum) ;
	}
		
ignore_exit :
	arg.ArgType = E_INTEGER ;
	SetPreDefVariable (PreDefVars[RETURN_VARIABLE].VarName, &arg, PortNum) ;
	return 0 ;

error_exit :
	return -2 ;
}

/* Sudha 08/07/98 */

/*----------------------------------------------------------------------------
	Name		:	DataBitsHdlr											
	Input		:	None													
	Output	:	Zero													
	Synopsis	:	Sets data bits.											
----------------------------------------------------------------------------*/
int DataBitsHdlr (BYTE PortNum) 
{
	ArgType *a_ptr ;
	ArgType arg ;
	BYTE val ;

	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : DATABITS\n\r", PortNum) ;
	arg.IntVal = 0 ;	/*	Set return value to failure.	*/
	/*	Get the data bits.	*/
	if (!(a_ptr = GetParamAddress (1, INT_CONST | INTEGER, PortNum))) 
	{
		goto error_exit ;
	}

	val = (BYTE) *a_ptr->IntPtr ;

	if (val == 5 || val == 6 || val == 7 || val == 8)
	{
		SetDataBits ((WORD) PortNum, (WORD) val) ; 
		arg.IntVal = 1 ;	/*	Set return value to success.	*/
	}
	else
	{
		script_printf (NON_CRITICAL_SCRIPT_PRINTF,
			"Parameter out of bounds for DataBits, Port %d\n\r\Should be within (6,7,8).", PortNum) ;
	}

	arg.ArgType = E_INTEGER ;
	SetPreDefVariable (PreDefVars[RETURN_VARIABLE].VarName, &arg, PortNum) ;
	return 0 ;

error_exit :
	return -2 ;
}

/* Sudha 08/07/98 */

/*----------------------------------------------------------------------------
	Name		:	StopBitsHdlr											
	Input		:	None													
	Output	:	Zero													
	Synopsis	:	Sets stop bits.											
----------------------------------------------------------------------------*/
int StopBitsHdlr (BYTE PortNum) 
{
	ArgType *a_ptr ;
	ArgType arg ;
	BYTE val ;

	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : STOPBITS\n\r", PortNum) ;
	arg.IntVal = 0 ;	/*	Set return value to failure.	*/
	/*	Get the stop bits.	*/
	if (!(a_ptr = GetParamAddress (1, INT_CONST | INTEGER, PortNum))) 
	{
		goto error_exit ;
	}

	val = (BYTE) *a_ptr->IntPtr ;

	if (val == 1 || val == 2)
	{
		SetStopBits ((WORD) PortNum, (WORD) val) ; 
		arg.IntVal = 1 ;	/*	Set return value to success.	*/
	}
	else
	{
		script_printf (NON_CRITICAL_SCRIPT_PRINTF,
			"Parameter out of bounds for StopBits, Port %d\n\r", PortNum) ;
	}

	arg.ArgType = E_INTEGER ;
	SetPreDefVariable (PreDefVars[RETURN_VARIABLE].VarName, &arg, PortNum) ;
	return 0 ;

error_exit :
	return -2 ;
}


/*----------------------------------------------------------------------------
	Name		:	ParityHdlr												
	Input		:	None													
	Output	:	Zero
	Synopsis	:	Sets parity.											
----------------------------------------------------------------------------*/
int ParityHdlr (BYTE PortNum) 
{
	ArgType *a_ptr ;
	ArgType arg ;
	WORD parity ;
	BYTE *ptr ;

	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : PARITY\n\r", PortNum) ;
	arg.IntVal = 0 ;	/*	Set return value to failure.	*/
	/*	Get the parity.	*/
	if (!(a_ptr = GetParamAddress (1, STRING_CONST | STRING, PortNum))) 
	{
		goto error_exit ; 
	}

	ptr = *a_ptr->StrPtr ;

	if (!strcmp (ptr, "NONE"))
		parity = PARITY_NONE ;
	else 
	{
		if (!strcmp (ptr, "ODD"))
			parity = PARITY_ODD ;
		else 
		{
			if (!strcmp (ptr, "EVEN"))
				parity = PARITY_EVEN ;
			else 
			{
				script_printf (NON_CRITICAL_SCRIPT_PRINTF,
					"Invalid parameter for parity, Port %d\n\r", PortNum) ;
				goto ignore_exit ;
			}
		}
	}

	SetParity ((WORD) PortNum, parity) ;
	arg.IntVal = 1 ;	/*	Set return value to success.	*/

ignore_exit :
	arg.ArgType = E_INTEGER ;
	SetPreDefVariable (PreDefVars[RETURN_VARIABLE].VarName, &arg, PortNum) ;
	return 0 ;

error_exit :
	return -2 ;
}

/*----------------------------------------------------------------------------
	Name		:	DecHdlr													
	Input		:	None													
	Output	:	Zero													
	Synopsis	:	Decrements the integer argument by one.					
----------------------------------------------------------------------------*/
int DecHdlr (BYTE PortNum) 
{
	ArgType *a_ptr ;
	ArgType arg ;

	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : DEC\n\r", PortNum) ;
	/*	Get integer variable address.	*/
	if (a_ptr = GetParamAddress ((WORD) 1, (WORD) INTEGER, PortNum))
		arg.IntVal = --*a_ptr->IntPtr ;
	else 
		goto error_exit ;

	arg.ArgType = E_INTEGER ;
	SetPreDefVariable (PreDefVars[RETURN_VARIABLE].VarName, &arg, PortNum) ;
	return 0 ;

error_exit :
	return -2 ;
}

/*----------------------------------------------------------------------------
	Name		:	IncHdlr													
	Input		:	None													
	Output	:	Zero	
	Synopsis	:	Increments the integer argument by one.					
----------------------------------------------------------------------------*/
int IncHdlr (BYTE PortNum) 
{
	ArgType *a_ptr ;
	ArgType arg ;

	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : INC\n\r", PortNum) ;
	/*	Get integer variable address.	*/
	if (a_ptr = GetParamAddress ((WORD) 1, (WORD) INTEGER, PortNum))
		arg.IntVal = ++*a_ptr->IntPtr ;
	else 
		goto error_exit ;

	arg.ArgType = E_INTEGER ;
	SetPreDefVariable (PreDefVars[RETURN_VARIABLE].VarName, &arg, PortNum) ;
	return 0 ;

error_exit :
	return -2 ;
}

int ExitHdlr (BYTE PortNum) 
{
	WORD arg_count ;
	WORD ret_address ;

	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : EXIT\n\r", PortNum) ;
	while (ScriptPortClass[PortNum].EntryCount) 
	{
		PurgeLocalSymbols (PortNum) ;	 /* Purge all local symbol values.	*/

		/*	Get the number of parameters on stack.	*/
		arg_count = (WORD) ((ScriptPortClass[PortNum].FramePtr - 4)->IntVal) ;
		ret_address = (WORD) ((ScriptPortClass[PortNum].FramePtr - 3)->IntVal) ;
		ScriptPortClass[PortNum].StackTop = ScriptPortClass[PortNum].FramePtr ;
		ScriptPortClass[PortNum].StackTop -- ;		/*	Restore old temporaries pointer.	*/
		ScriptPortClass[PortNum].TempsPtr = 
			(ArgType *) ScriptPortClass[PortNum].StackTop->ArgVal ;
		ScriptPortClass[PortNum].StackTop -- ;		/*	Restore old frame pointer.	*/
		ScriptPortClass[PortNum].FramePtr =
			(ArgType *) ScriptPortClass[PortNum].StackTop->ArgVal ;
		ScriptPortClass[PortNum].StackTop -= (arg_count + 2) ;	/*	Cleanup parameters on stack.	*/
		ScriptPortClass[PortNum].EntryCount -- ;	/*	One less nesting to clean up.	*/
	}
	return -1 ;	/*	To exit script.	*/

}

int AtoiHdlr (BYTE PortNum) 
{
	ArgType *a_ptr ;
	ArgType arg ;

	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : ATOI\n\r", PortNum) ;
	/*	Get the string to convert.	*/
	if (!(a_ptr = GetParamAddress (1, STRING_CONST | STRING, PortNum))) 
	{
		goto error_exit ;
	}

	arg.IntVal = atoi (*a_ptr->StrPtr) ;		/* Set return value.	*/

	arg.ArgType = E_INTEGER ;
	SetPreDefVariable (PreDefVars[RETURN_VARIABLE].VarName, &arg, PortNum) ;
	return 0 ;

error_exit :
	return -2 ;
}

int ItoaHdlr (BYTE PortNum) 
{
	ArgType *a_ptr ;
	ArgType arg ;
	BYTE str[(8 * sizeof (long)) + 1] ;	/*	Enough to convert a long.	*/
	long value ;
	long radix ;

	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : ITOA\n\r", PortNum) ;
	/*	Get the integer to convert.	*/
	if (a_ptr = GetParamAddress ((WORD) 1, (WORD) (INT_CONST | INTEGER), PortNum))
		value = *a_ptr->IntPtr ;
	else 
	{
		goto error_exit ;
	}

	radix = 10 ;	/*	Assume radix 10.	*/
	/*	If the optional radix is given, read it off stack.	*/
	if ((WORD) (ScriptPortClass[PortNum].StackTop - 1)->IntVal > 2) 
	{
		/*	Get the radix.	*/
		if (a_ptr = GetParamAddress ((WORD) 3, (WORD) (INT_CONST | INTEGER), PortNum))
			radix =  *a_ptr->IntPtr ;
	}

	/*	Get the string variable to update.	*/
	if (!(a_ptr = GetParamAddress (2, STRING, PortNum))) 
	{
		goto error_exit;
	}

	if (radix > 1)								  
		my_itoa (value, str, (int) radix) ;
	else											  
		str[0] = 0 ;

	if (UpdateStrVar (a_ptr->StrPtr, str, PortNum) < 0)
		arg.IntVal = 0 ;	/*	Set return value to failure.	*/
	else
		arg.IntVal = 1 ;	/*	Set return value to successs.	*/
	arg.ArgType = E_INTEGER ;
	SetPreDefVariable (PreDefVars[RETURN_VARIABLE].VarName, &arg, PortNum) ;
	return 0 ;

error_exit :
	return -2 ;
}

/*----------------------------------------------------------------------------
	Name		:	StrlenHdlr												
	Input		:	None													
	Output	:	Zero													
	Synopsis	:	Computes string length.									
----------------------------------------------------------------------------*/
int StrlenHdlr (BYTE PortNum) 
{

	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : STRLEN\n\r", PortNum) ;
	return (DoStrOperation (STRLEN, PortNum)) ;
}


/*----------------------------------------------------------------------------
	Name		:	StrcatHdlr												
	Input		:	None													
	Output 	:	Zero													
	Synopsis	:	Concatenates second string to first string.				
----------------------------------------------------------------------------*/
int StrcatHdlr (BYTE PortNum) 
{
	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : STRCAT\n\r", PortNum) ;
	return (DoStrOperation (STRCAT, PortNum)) ;
}

/*----------------------------------------------------------------------------
	Name		:	StrcmpHdlr												
	Input		:	None													
	Output	:	Zero													
	Synopsis	:	Compares first string and second string.				
----------------------------------------------------------------------------*/
int StrcmpHdlr (BYTE PortNum) 
{
	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : STRCMP\n\r", PortNum) ;
	return (DoStrOperation (STRCMP, PortNum)) ;
}


/*----------------------------------------------------------------------------
	Name		:	StrcpyHdlr												
	Input		:	None													
	Output	:	Zero													
	Synopsis	:	Copies second string to first string.					
----------------------------------------------------------------------------*/
int StrcpyHdlr (BYTE PortNum) 
{
	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : STRCPY\n\r", PortNum) ;
	return (DoStrOperation (STRCPY, PortNum)) ;
}


/*----------------------------------------------------------------------------
	Name		:	StrfmtHdlr												
	Input		:	None													
	Output	:	Zero													
	Synopsis	:	Formats and copies arguments according to the given		
					format string.										
----------------------------------------------------------------------------*/
int StrfmtHdlr (BYTE PortNum) 
{
	ArgType *a_ptr ;
	ArgType arg ;
	BYTE *ptr ;
	int args_converted ;		/*	Number of arguments converted.	*/

	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : STRFMT\n\r", PortNum) ;
	if ((args_converted = FormatArguments (2, &ptr, PortNum)) < 0)
		goto error_exit ;

	/*	Get string variable to update.	*/
	if (!(a_ptr = GetParamAddress (1, STRING, PortNum))) 
	{
		goto error_exit ;
	}
	if (ptr) 
	{
		if (UpdateStrVar (a_ptr->StrPtr, ptr, PortNum) < 0)
			args_converted = 0 ;	/*	Set arguments converted to zero.	*/
		free (ptr) ;
	}

	/*	Set return value to number of args converted.	*/
	arg.IntVal = args_converted ;
	arg.ArgType = E_INTEGER ;
	SetPreDefVariable (PreDefVars[RETURN_VARIABLE].VarName, &arg, PortNum) ;
	return 0 ;

error_exit :
	return -2 ;
}

/*----------------------------------------------------------------------------
	Name		:	ToUpperCaseHdlr											
	Input		:	None													
	Output 	:	Zero													
	Synopsis	:	Converts string to upper case.							
----------------------------------------------------------------------------*/
int ToUpperCaseHdlr (BYTE PortNum) 
{
	ArgType *a_ptr ;
	BYTE *str ;

	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : TOUPPER\n\r", PortNum) ;
	/*	Get string to convert to upper case.	*/
	if (a_ptr = GetParamAddress (1, STRING_CONST | STRING, PortNum))
		str = *a_ptr->StrPtr ;
	else 
	{
		goto error_exit ;
	}
	ConvertToUpperCase (str) ;
	return 0 ;

error_exit :
	return -2 ;
}

/*----------------------------------------------------------------------------
	Name		:	ToLowerCaseHdlr											
	Input		:	None													
	Output	:	Zero													
	Synopsis	:	Converts string to lower case.							
----------------------------------------------------------------------------*/
int ToLowerCaseHdlr (BYTE PortNum) 
{
	ArgType *a_ptr ; 
	BYTE *str ;

	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : TOLOWER\n\r", PortNum) ;
	/*	Get string to convert to upper case.	*/
	if (a_ptr = GetParamAddress (1, STRING_CONST | STRING, PortNum))
		str = *a_ptr->StrPtr ;
	else 
	{
		goto error_exit ;
	}
	ConvertToLowerCase (str) ;
	return 0 ;

error_exit :
	return -2 ;
}


/*----------------------------------------------------------------------------
	Name		:	TransmitHdlr											
	Input		:	None													
	Output	:	Zero													
	Synopsis	:	Sends a specified string to the WAN port.			
----------------------------------------------------------------------------*/
int TransmitHdlr (BYTE PortNum) 
{
	ArgType *a_ptr ;
	ArgType arg ;
	BYTE *str ;

	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : TRANSMIT\n\r", PortNum) ;
	arg.IntVal = 0 ;	/*	Set return value to failure.	*/
	/*	Get string to transmit.	*/
	if (a_ptr = GetParamAddress (1, STRING_CONST | STRING, PortNum))
		str = *a_ptr->StrPtr ;
	else 
	{
		goto error_exit ;
	}

	WriteToPort ((USHORT) PortNum, str, 0) ; 
	arg.IntVal = 1 ;	/*	Set return value to success.	*/
	arg.ArgType = E_INTEGER ;
	SetPreDefVariable (PreDefVars[RETURN_VARIABLE].VarName, &arg, PortNum) ;
	return 0 ;

error_exit :
	return -2 ;
}

int WaitForHdlr (BYTE PortNum) 
{
	ArgType *a_ptr ;
	ArgType arg ;
	BYTE *pat ;
	int ReadStatus ;
	BYTE pattern_got ;
	WORD MaxRcvBufLen ;
	WORD ExpPatLen ;

	pattern_got = 0 ; /* assume pattern is not received */

	/* If timeout was specified for this action i.e (Wait
		until requested pattern is received)
		and wait time value expired then no need waiting.
		So just come out */
	if (ScriptPortClass[PortNum].ScriptOnWait && 
										!ScriptPortClass[PortNum].ScriptWaitTimer)
	{
		goto ignore_exit ;
	}

	/* If this is the first time this function is entered
		then get in */
	if (!ScriptPortClass[PortNum].ScriptOnWait && !AlreadyCheckedWait[PortNum])
	{
		/* Set the entry flag */
		AlreadyCheckedWait[PortNum] = 1 ;
		script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : WAITFOR\n\r", PortNum) ;
		/*	Get the optional parameter timeout, if specified.	*/
		if ((WORD) (ScriptPortClass[PortNum].StackTop - 1)->IntVal > 1) 
		{
			if (a_ptr = GetParamAddress (2, INT_CONST | INTEGER, PortNum)) 
			{
				ScriptPortClass[PortNum].ScriptWaitTimer = (WORD) *a_ptr->IntPtr ;
				ScriptPortClass[PortNum].ScriptWaitTimer *= 20 ;	/*	Convert seconds to ticks.	*/
				ScriptPortClass[PortNum].ScriptOnWait = 1 ;
			}
			else
			{
				goto ignore_exit ;
			}
		}
		/* Get the MRBLR value */
		MaxRcvBufLen = GetMRBLR (PortNum) ;
		if (!MaxRcvBufLen)
			MaxRcvBufLen = 1 ;
		/* Read the required pattern that is expected */
		if (a_ptr = GetParamAddress (1, STRING_CONST | STRING, PortNum))
			pat = *a_ptr->StrPtr ;
		else 
		{
  			goto error_exit ;
  		}
		/* Length of expected pattern */
  		ExpPatLen = strlen (pat) ;
		/* Try to acquire memory in multiples of MRBLR */
		/* If MRBLR > req length, then MRBLR will do */
		/* else make it a multiple of MRBLR */
  		RgetsCount[PortNum] = (MaxRcvBufLen > ExpPatLen) ?
	  		MaxRcvBufLen : (((ExpPatLen / MaxRcvBufLen) + 1) * MaxRcvBufLen) ;
  		if (RgetsBuf[PortNum])
  			free (RgetsBuf[PortNum]) ;
  		RgetsBuf[PortNum] = (BYTE *) malloc (RgetsCount[PortNum] + 1) ;
  		if (!RgetsBuf[PortNum])
  		{
  			script_printf (ALARM_SCRIPT_PRINTF,
					"Memory exhausted (WAITFOR), Port %d\n\r", PortNum) ;
			goto error_exit ;
  		}
		/* Ensure null termination of buffer allocated */
  		RgetsBuf[PortNum][RgetsCount[PortNum]] = 0 ;
		/* Ensure that the buffer area exceeding the
			expected length is also written with nulls */
  		memset (&RgetsBuf[PortNum][ExpPatLen], 0,
							RgetsCount[PortNum] - ExpPatLen) ;
  		if (ScriptPortClass[PortNum].RecvStr)
  			free (ScriptPortClass[PortNum].RecvStr) ;
  		ScriptPortClass[PortNum].RecvStr = (BYTE *) malloc (ExpPatLen + 1) ;
  		if (!ScriptPortClass[PortNum].RecvStr)
  		{
  			free (RgetsBuf[PortNum]) ;
  			RgetsBuf[PortNum] = 0 ;
  			script_printf (ALARM_SCRIPT_PRINTF,
					"Memory exhausted (WAITFOR), Port %d\n\r", PortNum) ;
  			goto error_exit ;
  		}
  		ScriptPortClass[PortNum].RecvCharCount = 0 ;
  		strcpy (ScriptPortClass[PortNum].RecvStr, pat) ;
   }

	ReadStatus = 0 ;	
	ReadStatus = ReadFromPort ((WORD) PortNum,
			&RgetsBuf[PortNum][ScriptPortClass[PortNum].RecvCharCount], 
				RgetsCount[PortNum] - ScriptPortClass[PortNum].RecvCharCount,
					&ScriptPortClass[PortNum].RecvCharCount) ;
   if (ReadStatus == 1)
   {
		if (strstr (RgetsBuf[PortNum], ScriptPortClass[PortNum].RecvStr) != NULL)
		{
			pattern_got = 1 ;
			goto ignore_exit ;
		}
		else
		{
			if (ScriptPortClass[PortNum].RecvCharCount >= RgetsCount[PortNum])
				ScriptPortClass[PortNum].RecvCharCount = 0 ;				
			return DO_NOT_REMOVE_PARAMETERS ;
		}
	}
	else
		return DO_NOT_REMOVE_PARAMETERS ;

ignore_exit :
	AlreadyCheckedWait[PortNum] = 0 ;
	ScriptPortClass[PortNum].RecvCharCount = 0 ;
	if (ScriptPortClass[PortNum].RecvStr)
		free (ScriptPortClass[PortNum].RecvStr) ;
	ScriptPortClass[PortNum].RecvStr = 0 ;
	if (RgetsBuf[PortNum])
		free (RgetsBuf[PortNum]) ;
	RgetsBuf[PortNum] = 0 ;
	RgetsCount[PortNum] = 0 ;
	ScriptPortClass[PortNum].ScriptOnWait = 0 ;
	ScriptPortClass[PortNum].ScriptWaitTimer = 0 ;

	arg.IntVal = pattern_got ;
	arg.ArgType = E_INTEGER ;
	SetPreDefVariable (PreDefVars[RETURN_VARIABLE].VarName, &arg, PortNum) ;
	return 0 ;

error_exit :
	AlreadyCheckedWait[PortNum] = 0 ;
	ScriptPortClass[PortNum].RecvCharCount = 0 ;
	if (ScriptPortClass[PortNum].RecvStr)
		free (ScriptPortClass[PortNum].RecvStr) ;
	ScriptPortClass[PortNum].RecvStr = 0 ;
	if (RgetsBuf[PortNum])
		free (RgetsBuf[PortNum]) ;
	RgetsBuf[PortNum] = 0 ;
	RgetsCount[PortNum] = 0 ;
	ScriptPortClass[PortNum].ScriptOnWait = 0 ;
	ScriptPortClass[PortNum].ScriptWaitTimer = 0 ;
	return -2 ;

}


int WaitHdlr (BYTE PortNum) 
{
	ArgType *a_ptr ;

	/* If the timer has not expired the don't remove parameters */
	/* from the stack 													*/
	if (ScriptPortClass[PortNum].ScriptWaitTimer)
		return DO_NOT_REMOVE_PARAMETERS ;

	if (ScriptPortClass[PortNum].ScriptOnWait && 
							!ScriptPortClass[PortNum].ScriptWaitTimer)
	{
		ScriptPortClass[PortNum].ScriptOnWait = 0 ;
		AlreadyCheckedWait[PortNum] = 0 ;
		return 0 ;
	}

	/*	Get the wait duration.	*/
	if (a_ptr = GetParamAddress (1, INT_CONST | INTEGER, PortNum)) 
	{
		ScriptPortClass[PortNum].ScriptWaitTimer = (long) *a_ptr->IntPtr ;
		/*	Convert seconds to ticks.	20 ticks = 1 second */
		ScriptPortClass[PortNum].ScriptWaitTimer *= 20 ;	
		ScriptPortClass[PortNum].ScriptOnWait = 1 ;
		script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
									"Port %d : WAIT\n\r", PortNum) ;
	}
	else 
	{
		goto error_exit ;
	}
	return DO_NOT_REMOVE_PARAMETERS ;

error_exit :
	return -2 ;
}


/*----------------------------------------------------------------------------
	BREAK :
		The input parameter is the Break Time in milli seconds
		The 68360 processor sends a BREAK when the STOP TRANSMIT
		or GRACEFUL STOP TRANSMIT command is issued to the
		COMMAND REGISTER 
		It sends BRKCR number of Break characters
		BRKCR should be written based on the Break Time,
		Baud Rate, Data Bits, Stop Bits and Parity Bits
----------------------------------------------------------------------------*/
int BreakHdlr (BYTE PortNum)
{
	ArgType *a_ptr ;
	ArgType arg ;
	long val ;

	arg.IntVal = 0 ;	/*	Set return value to failure.	*/
	if (CheckedBreak[PortNum] && !NumOfBrkCharsRemaining[PortNum])
	{
		CheckedBreak[PortNum] = 0 ;
		ScriptPortClass[PortNum].ScriptWaitTimer = 0 ;
		ScriptPortClass[PortNum].ScriptOnWait = 0 ;
		SetNoOfBrkChars ((ULONG) PortNum, (USHORT) 0) ;
		WriteToCommandRegister ((ULONG) RESTART_TRANSMIT, (ULONG) PortNum) ;
		goto ignore_exit ;
	}

	if (!CheckedBreak[PortNum])
	{
		script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
									"Port %d : BREAK\n\r", PortNum) ;
		/*	Get the break time */
		if (!(a_ptr = GetParamAddress (1, INT_CONST | INTEGER, PortNum))) 
			goto error_exit ;
		val = (long) *a_ptr->IntPtr ;
		if (val < 0)
			val = -val ;
		CheckedBreak[PortNum] = 1 ;
		NumOfBrkCharsRemaining[PortNum]
			= ((GetBaudRate (PortNum) /
				(GetDataBits (PortNum) +
						GetParityBits (PortNum) +
								GetStopBits (PortNum))) * ((ULONG) val / 10)) / 100 ;
		ScriptPortClass[PortNum].ScriptOnWait = 1 ;
	}

	if (ScriptPortClass[PortNum].ScriptOnWait && 
				!ScriptPortClass[PortNum].ScriptWaitTimer)
	{
		NumOfBrkCharsRemaining[PortNum] -= 65535 ;
		if (NumOfBrkCharsRemaining[PortNum] >= 0)
		{
			val = 65535 ;
		}
		else
		{
			val = 65535 + NumOfBrkCharsRemaining[PortNum] ;
			NumOfBrkCharsRemaining[PortNum] = 0 ;
		}
		ScriptPortClass[PortNum].ScriptWaitTimer = 
					(((GetDataBits (PortNum) +
						GetParityBits (PortNum) +
							GetStopBits (PortNum)) * (ULONG) val) * 20)  /
										(GetBaudRate (PortNum) * 1000) ;
		SetNoOfBrkChars ((ULONG) PortNum, (USHORT) val) ;
		WriteToCommandRegister ((ULONG) STOP_TRANSMIT, (ULONG) PortNum) ;
		return DO_NOT_REMOVE_PARAMETERS ;
	}
	else
		return DO_NOT_REMOVE_PARAMETERS ;


ignore_exit :
	arg.IntVal = 1 ;	/*	Set return value to success.	*/
	arg.ArgType = E_INTEGER ;
	SetPreDefVariable (PreDefVars[RETURN_VARIABLE].VarName, &arg, PortNum) ;
	return 0 ;

error_exit :
	return -2 ;
}


int RxFlushHdlr (BYTE PortNum)
{
	int TmpSr ;

	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : RXFLUSH\n\r", PortNum) ;
	TmpSr = _GPL() ;	/* Get the current interrupt priority level */
	_SPL (7) ;			/* Disable any further interrupts */
	FlushReceiver ((USHORT) PortNum) ;
	_SPL (TmpSr) ;		/* Restore the previous interrupt priority level */
	return 0 ;
}


int TxFlushHdlr (BYTE PortNum)
{
	int TmpSr ;

	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : TXFLUSH\n\r", PortNum) ;
	TmpSr = _GPL() ;  /* Get the current interrupt priority level */
	_SPL (7) ;			/* Disable any further interrupts */
	FlushTransmitter ((USHORT) PortNum) ;
	_SPL (TmpSr) ;		/* Restore the previous interrupt priority level */
	return 0 ;
}


int ThisLayerUpHdlr (BYTE PortNum)
{
	ArgType arg ;
	
	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : THISLAYERUP\n\r", PortNum) ;
	if (EnquirePortOwner ((USHORT) PortNum) && is_DCD_present ((USHORT) PortNum))
	{
		arg.IntVal = 1 ;	/*	Set return value.	*/
		inform_hldd_and_change_to_async_hdlc ((USHORT) PortNum) ;
	}
	else
		arg.IntVal = 0 ;	/*	Set return value.	*/

	arg.ArgType = E_INTEGER ;
	SetPreDefVariable (PreDefVars[RETURN_VARIABLE].VarName, &arg, PortNum) ;
	return (arg.IntVal ? RESET_SCRIPT_VARIABLES : 0) ;
}


/* sudha 8 Jan 1999 taken from BIG_PROXY */

int ActivateDODHdlr (BYTE PortNum)
{
	ArgType arg ;
	
	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : Activate DOD\n\r", PortNum) ;
	if (is_DCD_present ((USHORT) PortNum))
	{
		arg.IntVal = 1 ;	/*	Set return value.	*/
		activate_dod(PortNum);
	}
	else
		arg.IntVal = 0 ;	/*	Set return value.	*/

	arg.ArgType = E_INTEGER ;
	SetPreDefVariable (PreDefVars[RETURN_VARIABLE].VarName, &arg, PortNum) ;
	return (arg.IntVal ? RESET_SCRIPT_VARIABLES : 0) ;
}
/* sudha 8 Jan 1999 */

int SetRTSHdlr (BYTE PortNum)
{
	ArgType *a_ptr ;
	ArgType arg ;

	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : SETRTS\n\r", PortNum) ;
	arg.IntVal = 0 ;	/*	Set return value to failure.	*/

	/* get the state to be set either up or down */
	/* if up rts is asserted else not */
	/* up is a non-zero value and down is zero */
	if (!(a_ptr = GetParamAddress (1, INT_CONST | INTEGER, PortNum))) 
	{
		goto error_exit ;
	}

	SetPortCAsOutPut ((int) PortNum) ;
	if (*a_ptr->IntPtr)
		EnableRTSOnWAN ((int) PortNum) ;
	else
		DisableRTSOnWAN ((int) PortNum) ;

	arg.IntVal = 1 ;
	arg.ArgType = E_INTEGER ;
	SetPreDefVariable (PreDefVars[RETURN_VARIABLE].VarName, &arg, PortNum) ;
	return 0 ;

error_exit :
	return -2 ;
}

int GetCTSHdlr (BYTE PortNum)
{
	ArgType arg ;

	script_printf (NON_CRITICAL_SCRIPT_PRINTF,
							"Port %d : GETCTS\n\r", PortNum) ;
	if (is_CTS_asserted ((USHORT) PortNum))
		arg.IntVal = 1 ;
	else
		arg.IntVal = 0 ;
	arg.ArgType = E_INTEGER ;
	SetPreDefVariable (PreDefVars[RETURN_VARIABLE].VarName, &arg, PortNum) ;
	return 0 ;
}


int SetDTRHdlr (BYTE PortNum)
{
	ArgType *a_ptr ;
	ArgType arg ;
	USHORT UpDownDTR ;

	script_printf (NON_CRITICAL_SCRIPT_PRINTF, 
								"Port %d : SETDTR\n\r", PortNum) ;
	arg.IntVal = 0 ;	/*	Set return value to failure.	*/

	/* get the state to be set either up or down */
	/* if up dtr is asserted else not */
	/* up is a non-zero value and down is zero */
	if (!(a_ptr = GetParamAddress (1, INT_CONST | INTEGER, PortNum))) 
	{
		goto error_exit ;
	}

	if (*a_ptr->IntPtr)
		UpDownDTR = SET_CONF_SET_SIGS ;
	else
		UpDownDTR = SET_CONF_RESET_SIGS ;
	SetLineConfigUART (UpDownDTR, (USHORT) LINE_STAT_DTR, (USHORT) PortNum) ;

	arg.IntVal = 1 ;
	arg.ArgType = E_INTEGER ;
	SetPreDefVariable (PreDefVars[RETURN_VARIABLE].VarName, &arg, PortNum) ;
	return 0 ;

error_exit :
	return -2 ;
}

#if 0
int GetDSRHdlr (BYTE PortNum)
{
	return 0 ;
}
#endif


/*----------------------------------------------------------------------------
	Name		:	DoStrOperation											
	Input		:	operation												
	Output 	:	None													
	Synopsis	:	Performs specified string operation.					
----------------------------------------------------------------------------*/
int DoStrOperation (BYTE operation, BYTE PortNum)
{
	ArgType *a_ptr ;
	ArgType arg ;
	BYTE *str1 ;
	BYTE *str2 ;
	BYTE *newstr ;

	if ((WORD) (ScriptPortClass[PortNum].StackTop - 1)->IntVal > 1) 
	{
		/*	Get the second string.	*/
		if (a_ptr = GetParamAddress (2, STRING_CONST | STRING, PortNum))
			str2 = *a_ptr->StrPtr ;
		else 
		{
			goto error_exit ;
		}
	}
	else
		str2 = 0 ;

	/*	Get the first string.	*/
	if (a_ptr = GetParamAddress (1, STRING_CONST | STRING, PortNum))
		str1 = *a_ptr->StrPtr ;
	else 
	{
		goto error_exit ;
	}

	arg.IntVal = 0 ;	/*	Set return value to failure.	*/
	switch (operation) 
	{
		case STRLEN :
			arg.IntVal = strlen (str1) ;
			break ;

		case STRCMP :
			arg.IntVal = strcmp (str1, str2) ;
			break;

		case STRCAT :
			if (a_ptr->ArgType == E_STRING_CONST) 
			{
				/*	Destination string cannot be a constant.	*/
				break;
			}
			if (!(newstr = (BYTE *) malloc (strlen (str1) + strlen (str2) + 1))) 
			{
				script_printf (ALARM_SCRIPT_PRINTF,
					"Memory exhausted (STRCAT), Port %d\n\r", PortNum) ;
				break;
			}
			strcpy (newstr, str1) ;
			strcat (newstr, str2) ;

			if (UpdateStrVar (a_ptr->StrPtr, newstr, PortNum) >= 0)
				arg.IntVal = 1 ;	/*	Set return value to success.	*/
			free (newstr) ;
			break ;

		case STRCPY :
			if (a_ptr->ArgType == E_STRING_CONST) 
			{
				/*	Destination string cannot be a constant.	*/
				script_printf (NON_CRITICAL_SCRIPT_PRINTF,
					"Expecting a string variable, Port %d\n\r", PortNum) ;
				break;
			}
			if (!(newstr = (BYTE *) malloc (strlen (str2) + 1))) 
			{
				script_printf (ALARM_SCRIPT_PRINTF,
						"Memory exhausted (STRCPY), Port %d\n\r", PortNum) ;
				break;
			}
			strcpy (newstr, str2) ;

			if (UpdateStrVar (a_ptr->StrPtr, newstr, PortNum) >= 0)
				arg.IntVal = 1 ;	/*	Set return value to success.	*/
			free (newstr) ;
			break ;

		default :
			break ;
	}
	arg.ArgType = E_INTEGER ;
	SetPreDefVariable (PreDefVars[RETURN_VARIABLE].VarName, &arg, PortNum) ;
	return 0 ;

error_exit :
	return -2 ;
}



/*----------------------------------------------------------------------------
	Name		:	FormatArguments											
	Input		:	arg_idx, argument number of format string,				
					str_ptr, pointer to formatted string.					
	Output 	:	Number of arguments converted.							
	Synopsis	:	Formats and copies arguments according format string.	
----------------------------------------------------------------------------*/
int FormatArguments (BYTE arg_idx, BYTE **str_ptr, BYTE PortNum)
{
	#define INTEGER_LEN 15	/*	Buffer length needed to convert long.	*/

	ArgType *a_ptr ;
	BYTE num_args ;
	int args_converted ;		/*	Number of arguments converted.	*/
	BYTE idx ;
	BYTE *str ;
	BYTE *fmt_str ;
	BYTE *ptr ;
	BYTE ch ;
	WORD size ;

	ptr = 0 ;
	args_converted = 0 ;
	/*	Get format string.	*/
	if (a_ptr = GetParamAddress (arg_idx, STRING_CONST | STRING, PortNum))
		fmt_str = *a_ptr->StrPtr ;
	else 
	{	
		goto error_exit ;
	}
	arg_idx ++ ;	/*	Move onto actual arguments.	*/

	num_args = (BYTE) (ScriptPortClass[PortNum].StackTop - 1)->IntVal ;
	size = 0 ;	/*	Compute memory needed for arguments.	*/
	for (idx = arg_idx ; idx <= num_args ; idx ++)
	{
		/*	Get the argument.	*/
		if (!(a_ptr = GetParamAddress (idx, DONT_CARE, PortNum))) 
		{
			goto error_exit ;
		}

		switch (a_ptr->ArgType)
		{
			case E_INT_CONST :
			case E_INTEGER :
				size += INTEGER_LEN ;
				break ;

			case E_STRING_CONST :
			case E_STRING :
				size += strlen (*a_ptr->StrPtr) ;
				break ;
		}
	}
	size += strlen (fmt_str) + 1 ;	/*	Add the size of format string.	*/
	ptr = malloc (size) ;
	if (!ptr) 
	{
		script_printf (ALARM_SCRIPT_PRINTF, 
				"Memory exhausted, Port %d\n\r", PortNum) ;
		goto ignore_exit ;
	}
	str = ptr ;
	*str = 0 ;
	idx = arg_idx ;
	while (*fmt_str)
	{
		switch (*fmt_str) 
		{
			case '%' :
				ch = *(fmt_str + 1) ;
				if (ch == 'd' || ch == 'f' || ch == 'x' || ch == 's' ||
															ch == 'c') 
				{
					/*	Get the next argument.	*/
					a_ptr = GetParamAddress (idx ++, DONT_CARE, PortNum) ;
				}
				switch (ch) 
				{
					case 'd' :
					case 'x' :
						if (a_ptr && (a_ptr->ArgType == E_INT_CONST ||
													a_ptr->ArgType == E_INTEGER)) 
						{
							my_itoa (*a_ptr->IntPtr, str, (ch == 'd' ? 10 : 16)) ;
							str += strlen (str) ;
							args_converted ++ ;
						}
						fmt_str += 2 ;
						break ;

					case 's' :
						if (a_ptr && (a_ptr->ArgType == E_STRING_CONST ||
														a_ptr->ArgType == E_STRING)) 
						{
							strcpy (str, *a_ptr->StrPtr) ;
							str += strlen (str) ;
							args_converted ++ ;
						}
						fmt_str += 2 ;
						break ;

					case 'c' :
						if (a_ptr) 
						{
							switch (a_ptr->ArgType) 
							{
								case E_INT_CONST :
								case E_INTEGER :
									*str = (BYTE) *a_ptr->IntPtr ;
									break ;

								case E_REAL :
								case E_REAL_CONST :
									/*	real param not allowed, put zero.	*/
									*str = '0';
									break ;

								case E_STRING_CONST :
								case E_STRING :
									*str = *(*a_ptr->StrPtr) ;
									break ;
							}
							str ++ ;
						}
						fmt_str += 2 ;
						break ;

					case '%' :
						*str++ = '%' ;
						fmt_str += 2 ;
						break ;

					default :
						*str++ = *fmt_str++ ;
						break ;
				}
				break ;

			case '\\' :
				switch (*(fmt_str + 1)) 
				{
					case '\\' :
						*str++ = '\\' ;
						fmt_str += 2 ;
						break ;

					case 'n' :
						*str++ = 0x0a ;
						fmt_str += 2 ;
						break ;

					case 'r' :
						*str++ = 0x0d ;
						fmt_str += 2 ;
						break ;

					case 'x' :
					case 'X' :
						ch = *(fmt_str + 2) ;
						if (!ch) 
						{	/*	Error in format string, quit.	*/
							fmt_str += 2 ;
							break ;
						}
						if (ch >= 'a' && ch <= 'f')
							ch -= 'a' - 'A' ;
						if (ch >= '1' && ch <= '9')
							ch -= '0' ;
						else
							ch -= 'A' - 10 ;
						*str = (BYTE) (16 * ch) ; 
						ch = *(fmt_str + 3) ;
						if (!ch) 
						{	/*	Error in format string, quit.	*/
							fmt_str += 3 ;
							break ;
						}
						if (ch >= 'a' && ch <= 'f')
							ch -= 'a' - 'A' ;
						if (ch >= '1' && ch <= '9')
							ch -= '0' ;
						else
							ch -= 'A' - 10 ;
						*str += ch ;
						str ++ ;
						fmt_str += 4 ;
						break ;

					default :
						*str++ = *fmt_str++ ;
						break ;
				}
				break ;

			default :
				*str++ = *fmt_str++ ;
				break ;
		}
	}
	*str = 0 ;

ignore_exit :
	*str_ptr = ptr ;	/*	Copy pointer to formatted string.	*/
	/*	Set return value to number of args converted.	*/
	return args_converted ;

error_exit :
	*str_ptr = 0 ;	/*	Set pointer to formatted string to zero.	*/
	if (ptr)
		free (ptr) ;
	return -1 ;
}
