/* SERASM.H -- C prototypes for functions exported from the assembly module
**			   SERIAL.68K
*/

#ifndef _SERASM_H_
#define _SERASM_H_

extern void serial_init_scc2(ULONG baud_pattern, USHORT max_rx_buffer_size, USHORT serial_mode_bits);
extern void serial_init_scc3(ULONG baud_pattern, USHORT max_rx_buffer_size, USHORT serial_mode_bits);
extern void serial_init_scc4(ULONG baud_pattern, USHORT max_rx_buffer_size, USHORT serial_mode_bits);

extern void turn_on_scc2_rts(void);
extern void turn_on_scc3_rts(void);
extern void turn_on_scc4_rts(void);

extern void turn_off_scc2_rts(void);
extern void turn_off_scc3_rts(void);
extern void turn_off_scc4_rts(void);

extern void serial_send_scc2(void *buf_ptr, USHORT buf_len);
extern void serial_send_scc3(void *buf_ptr, USHORT buf_len);
extern void serial_send_scc4(void *buf_ptr, USHORT buf_len);

extern void stop_rxtx_on_scc2(void);
extern void stop_rxtx_on_scc3(void);
extern void stop_rxtx_on_scc4(void);

extern void stop_rx_on_scc2(void);
extern void stop_rx_on_scc3(void);
extern void stop_rx_on_scc4(void);

extern void stop_tx_on_scc2(void);
extern void stop_tx_on_scc3(void);
extern void stop_tx_on_scc4(void);

extern void start_rx_on_scc2(void);
extern void start_rx_on_scc3(void);
extern void start_rx_on_scc4(void);

extern void start_tx_on_scc2(void);
extern void start_tx_on_scc3(void);
extern void start_tx_on_scc4(void);

extern void scc2_init_rx_descriptors(void);
extern void scc2_init_tx_descriptor(void);
extern void scc3_init_rx_descriptors(void);
extern void scc3_init_tx_descriptor(void);
extern void scc4_init_rx_descriptors(void);
extern void scc4_init_tx_descriptor(void);

extern void modify_scc2_serial_settings(USHORT);
extern void modify_scc3_serial_settings(USHORT);
extern void modify_scc4_serial_settings(USHORT);

extern void modify_scc2_serial_baud_rate(ULONG);
extern void modify_scc3_serial_baud_rate(ULONG);
extern void modify_scc4_serial_baud_rate(ULONG);

extern void serial_scc_set_dtr_status(ULONG);

extern void set_scc2_max_rx_buffer_size(USHORT);
extern void set_scc3_max_rx_buffer_size(USHORT);
extern void set_scc4_max_rx_buffer_size(USHORT);

extern enum BOOLEAN serial_is_cd_present_on_scc2(void);
extern enum BOOLEAN serial_is_cd_present_on_scc3(void);
extern enum BOOLEAN serial_is_cd_present_on_scc4(void);

#endif /* _SERASM_H_ */
