/****************************************************************************
File:		brcif.h
Synop:	This file contains bridge-user 
			interface data structure definitions and constants.
Mod	:	10/9/95 Vidy added support for SMC-WAN Chat (for ISDN support)
****************************************************************************/
#define	COLD_BOOT_MODE	0x00
#define	DOWNLOAD_MODE	0xA5		/* Number for download mode */
#define	WARM_BOOT_MODE	0x5A		/* Number for warm boot (after new cnf) mode */

#define		NO_ERR							0
#define		ERR_PKT_TYPE					1
#define		ERR_CRC							12		/* part of UI err codes */
#define		ERR_PASSWORD					13
#define		ERR_NO_BRD_GET_PASSWORD		18
#define		ERR_NO_BRD_NO_PASSWORD		19
#define		ERR_INV_MEM_RANGE				20
#define		ERR_ROUTER_UP					21
#define		ERR_INVALID_CHAT_PORT		22
#define		ERR_CHAT_PORT_OPEN			23
#define		ERR_NO_MUX_PRESENT			24
#define		ERR_READ_EVENT_LOG			25
#define		ERR_NO_LOGGING					26

/* packet types */
#define	TRGT_CMND_TYPE						0
#define	REQ_TYPE								1
#define	ONLINE_FLASH_WRITE_UDB			4
#define	RES_TYPE								12
#define	QUERY_BRIDGE_NAME					13
#define	QUERY_RMT_BRIDGE_NAME 			15
#define	REBOOT_TYPE							22
#define	READ_REQ_TYPE						31
#define	READ_RESP_TYPE						32
#define	PRINT_STR_TYPE						33

/* Added by Vidy on 10/9/95 for SMC-WAN Chat (ISDN support) */
#define	SMC_WAN_CHAT_START				40		/* start SMC-WAN Chat */
#define	MUX_INITIALIZATION_START		41		/* mux init */
#define	SET_WAN_DTR_SIGNAL_STATE		42

#define  GET_ROUCON_LOCK_TYPE				48
#define  FREE_ROUCON_LOCK_TYPE			49
#define  LOCK_RES_TYPE						50
#define	HANGUP_AND_REDIAL					51

#define	OPEN_EVENT_LOG						61
#define	READ_EVENT_LOG						62
#define	CLOSE_EVENT_LOG					63
#define	RESET_EVENT_LOG					64

#define	STATUS_PACKET_TYPES				100
#define	GET_PORT_STATUS (STATUS_PACKET_TYPES + 0)

#define	DEF_PKT_TYPE						0xff

#define NUMBER_OF_PORTS 3

/* Configuration manager lock command responses */
#define	LK_OK								0
#define	LK_LOCK_OWNED_BY_TELNET		1
#define	LK_LOCK_OWNED_BY_WEB			2
#define	LK_LOCK_OWNED_BY_DUMB_TTY	3
#define	LK_LOCK_OWNED_BY_ROUCON		4
#define	LK_LOCK_OWNED_BY_SOMEONE	5

/* Reboot Types */
#define	REBOOT_TO_DOWNLOAD	0
#define	REBOOT_SYSTEM			1

/* Router states */
#define	ROUTER_DOWN				0
#define	ROUTER_UP				1

/* NOTE : ALL STRUCTURES ARE OF SIZE = MULTIPLE OF 4 AND ARE PADDED WITH */
/* DUMMY VARIABLES SO AS TO PROPERLY ALIGN THE FIELDS WITHIN THEM. */

typedef struct
{
		BYTE	Ptype;			  /* 0  packet type  */
		BYTE	ReqType;			  /* 1 */
		BYTE	ReqSubType;		  /* 2 */
		BYTE	Dmy0;				  /* 3  Dummy to make multiple of 4 */
} ReqType;

/* The result of the  previous  user specification is sent
back to the ui module using the following data structure */

typedef struct	{
	BYTE	Ptype;		  /* 0 			packet type */
	BYTE	RouterState;  /* 1 			Whether Router is up and running or not; */
	USHORT	ErrCode;		/* 2 .. 3 	Zero if OK else error code of the error */
}	ResultType;

typedef struct {
	BYTE	Ptype;		/* 0 			packet type  */
	BYTE	BootType;	/* 1			Reboot type */
} RebootType;


typedef struct {
	BYTE	Ptype;				/* 0 */
	BYTE  Length;				/* 1 */
	BYTE	Dmy[2];				/* 2..3 */
	ULONG Address;				/* 4..7 */
}	ReadLocReqType;

typedef struct {
	BYTE	Ptype;				/* 0 */
	BYTE	ErrCode;				/* 1 */
	BYTE	Length;				/* 2 */
	BYTE	Dmy[1];				/* Vidy added this field 31st July */
	ULONG Address;				/* Vidy added this field 31st July */
	BYTE	buffer[128];		/* 3..131 */
}  ReadLocRespType;

typedef	struct
{
	BYTE	Ptype;				/* 0 */
	BYTE	Length;				/* 1 */
	BYTE	String[128];		/* 2..130 */
}	PrintPktType;


typedef struct
{
	BYTE TargetAction ;
	ULONG down_load_address ;
	USHORT buffer_length ;
	BYTE buffer[512] ;
	USHORT CRC ;
} OnLineFlashWriteUDBType ;

typedef struct
{
	BYTE RtnPktType ;		
	BYTE Dummy ;
	USHORT WriteReqPktLen ;
	ULONG down_load_address ;
} UDBRtnRespType ;



#if PROXY_SERVER

typedef struct
{
   BYTE packet_type ;
   BYTE major_version ;
   BYTE minor_version ;
   ULONG request_id ;
   BYTE start_port ;
   BYTE end_port ;
} PortStatusRequest ;

typedef struct
{
   BYTE port_number ;
   BYTE status ;
   char user_name[61] ;
   ULONG baud_rate ;
#ifndef MDM_TYPE_LEN
#define MDM_TYPE_LEN 50 /* This has to match the value in MODEM.H in wan driver */
#endif
   char modem_name[MDM_TYPE_LEN] ;
   char modem_report[30] ;
   ULONG local_ip_address ;
   ULONG remote_ip_address ;
   ULONG subnet_mask ;
   ULONG connection_up_time ;
   ULONG connection_tx_count ;
   ULONG connection_rx_count ;

   ULONG aggregate_tx_count ;
   ULONG aggregate_rx_count ;
   ULONG number_of_calls ;
   ULONG aggregate_connection_time ;

   /* Vidy added the following */
   ULONG connection_tx_packet_count ;
   ULONG connection_rx_packet_count ;

   ULONG aggregate_tx_packet_count ;
   ULONG aggregate_rx_packet_count ;


} PortStatusInfo ;

typedef struct
{
   BYTE packet_type ;
   BYTE error_code ;
   ULONG request_id ;
   BYTE start_port ;
   BYTE end_port ;
   BYTE number_of_records ;
	ULONG system_up_time;		/* vidy added on 18/02/98 */
   PortStatusInfo port_information[NUMBER_OF_PORTS] ;
} PortStatusResp ;

#endif /* PROXY_SERVER */

#ifdef EVENT_LOG
#define	OPEN_LOG
#define	READ_LOG
#define	CLOSE_LOG
#endif
