#include "defs.h"
/****************************************************************************
	file	: Chatinit.c
	Synop	: WANCHAT module. initializes chat
	Auth	: Vidyasagaran P
	Date	: 13th Sept 1995
	Modi	: 7/11/95 Sowmya added support for TELNET-WAN Chat
			  28/5/86 Sanjay ChatInitSCC? now accepts one more (serial mode)
			  		  parameter
			 30/07/96 Vidy added code to stop modem state machine.
****************************************************************************/

#define	GLOBAL_FILE

#include	"\rtrware\stdlib\stdlib.h"

#include "chat.h"
#include "..\kuim.h"
#include "..\vuimstr.h"
#include "uartmode.h"
#include <wanmgr.h>

/* External prototypes */
extern void ChatTurnOffTxAndRxOnSCC2(void);
extern void ChatTurnOffTxAndRxOnSCC4(void);
extern void ChatTurnOffTxAndRxOnSCC3(void);

/* Local prototypes */
static int GetBaudDivisorBits(ULONG BaudRate);
static void FreeWANBuffers(int port_number);
static void TurnOffTxAndRxOnPort(USHORT port_number);
extern   int   GetBaudDivisor(int BaudRate);

/* Vidy 13/11/98 moved the following from data to code segment */
WORD	ChatWan1EventReg;
WORD	ChatWan2EventReg;
WORD	ChatWan3EventReg;
BYTE	ChatWan1RxBdXpected;
BYTE	ChatWan2RxBdXpected;
BYTE	ChatWan3RxBdXpected;

int	ChatClient = 0;	/* non-zero => SMC or TELNET  */

/*----------------------------------------------------------------------------
	Start chat on a given WAN port. Call stop chat for any currently ongoing
	ports
----------------------------------------------------------------------------*/
enum WAN_PORT_AVAILABILITY wan_port_avail_error_code ;
enum BOOLEAN start_chat_on_port (int port_number, BYTE chatrequest)
{
	/* check if the port is free to start chat. */
#if 0
	if (get_wan_port_owner (port_number - 1) != OWNED_BY_NONE)
		return (FALSE) ;
#endif
	wan_port_avail_error_code = is_port_available_for_configuration (port_number - 1) ;
	if (wan_port_avail_error_code != PORT_AVAILABLE_FOR_CONFIGURATION)
	{
		return (FALSE) ;
	}

	if (ChatOnPort == 0)
	{
		/* need to allocate some receive and transmit buffers if not
		already chatting first */
		if (!initialize_chat_rxtx_descriptors(port_number - 1))
				return FALSE;

		/* when MTRouter is running the UIM buffers are very small.
		we need to increase the size of these to be equal to that of
		WAN chat receive buffers. This is because we are going to
		switch these buffers	from WAN receive to SMC Xmit without copying */
		if (chatrequest == SMC_CHAT)
			if (!reinitialize_uim_rxtx_descriptors_for_chat())
				return FALSE;
	}
	else
	{
		if (ChatClient == chatrequest) 
			stop_chat_on_port(ChatOnPort - 1);	/* Stop chat on prev. port */
		else
 			return FALSE;
	}

   /* Vidy, 17/07/1997 port_number passed here is 1-based */
	set_wan_port_owner(port_number-1, OWNED_BY_CHAT);

	/* Init the SCC for ASYNC at 19200 Baud. During init, one of the
	** parameters passed is the 'magic' value 0x3000. This is the serial
	** mode bits parameter meant to select 8 data bits, no parity and 1
	** stop bit. See the 68360 QUICC User's Manual Pg 7-160 for more
	** details.
	*/
	if (port_number == 1)
	{
#if 0
		ChatInitSCC2(0xA0, SIZE_RX_CHAT_BUFFER, 0x3000);
#else
		ChatInitSCC2(GetBaudDivisor(UIM_SPEED), SIZE_RX_CHAT_BUFFER, 0x3000);
#endif
		ChatTurnOnTXAndRXOfSCC2();
	}
	else if (port_number == 2)
	{
#if 0
		ChatInitSCC3(0xA0, SIZE_RX_CHAT_BUFFER, 0x3000);
#else
		ChatInitSCC3(GetBaudDivisor(UIM_SPEED), SIZE_RX_CHAT_BUFFER, 0x3000);
#endif
		ChatTurnOnTXAndRXOfSCC3();
	}
	else if (port_number == 3)
	{
#if 0
		ChatInitSCC4(0xA0, SIZE_RX_CHAT_BUFFER, 0x3000);
#else
		ChatInitSCC4(GetBaudDivisor(UIM_SPEED), SIZE_RX_CHAT_BUFFER, 0x3000);
#endif
		ChatTurnOnTXAndRXOfSCC4();
	}
	else
	{
		return FALSE;
	}
	ChatOnPort = port_number;
	ChatClient	= chatrequest;	/* 7/11/95 Sowmya */

	return TRUE;
}

/*****************************************************************************
	stop chat. Just turn off the Tx and Rx of the wan concerned
*****************************************************************************/
void	stop_chat_on_port(int port_number)
{
	/* need to turn off Tx and Rx of the SCCx */
	/* this is to be done before reclaiming buffers */

	/* reclaim all Rx and Tx buffers from current WAN */
	ReclaimBuffersFromWAN(port_number);

	set_wan_port_owner(port_number, OWNED_BY_NONE);
}
/****************************************************************************
****************************************************************************/
void ReclaimBuffersFromWAN(int port_number)
{
	USHORT descriptor_index;

	/* reclain Tx buffers */
	wan_chat.free_tx_list[port_number].sptr_forward_link = NULL;
	wan_chat.free_tx_list[port_number].sptr_backward_link = NULL;
	/* allocate mem for Tx descriptors and add descriptors to free_tx_list */
	for (descriptor_index = 0; descriptor_index < CHAT_NUMBER_OF_TX_DESCRIPTORS; ++descriptor_index)
	{
		wan_chat.tx_descriptor[port_number][descriptor_index].length = 0;
		add_entry_to_list (&wan_chat.free_tx_list[port_number], &wan_chat.tx_descriptor[port_number][descriptor_index].links);
	}
	wan_chat.sptr_current_tx_descriptor[port_number] = NULL;
	wan_chat.current_tx_list[port_number].sptr_forward_link = NULL;
	wan_chat.current_tx_list[port_number].sptr_backward_link = NULL;

	/* reclain Rx buffers */
	wan_chat.free_rx_list[port_number].sptr_forward_link = NULL;
	wan_chat.free_rx_list[port_number].sptr_backward_link = NULL;
	for (descriptor_index = 0; descriptor_index < CHAT_NUMBER_OF_RX_DESCRIPTORS; ++descriptor_index)
	{
		wan_chat.rx_descriptor[port_number][descriptor_index].length = 0;
		add_entry_to_list (&wan_chat.free_rx_list[port_number], &wan_chat.rx_descriptor[port_number][descriptor_index].links);
	}
	wan_chat.current_rx_list[port_number].sptr_forward_link = NULL;
	wan_chat.current_rx_list[port_number].sptr_backward_link = NULL;
	wan_chat.scheduled_for_rx[port_number].sptr_forward_link = NULL;
	wan_chat.scheduled_for_rx[port_number].sptr_backward_link = NULL;
}



/****************************************************************************/
int initialize_chat_rxtx_descriptors (int port_number)
{
	USHORT i, descriptor_index;

	/* allocate mem for Tx descriptors and add descriptors to free_tx_list */
	for (descriptor_index = 0; descriptor_index < CHAT_NUMBER_OF_TX_DESCRIPTORS; ++descriptor_index)
	{
		if ((wan_chat.tx_descriptor[port_number][descriptor_index].sptr_buffer =
								(BYTE *)malloc (SIZE_TX_CHAT_BUFFER)) != NULL)
		{
			wan_chat.tx_descriptor[port_number][descriptor_index].length = 0;
			add_entry_to_list (&wan_chat.free_tx_list[port_number], &wan_chat.tx_descriptor[port_number][descriptor_index].links);
		}
		else
		{
/* Sachin 01/02/1997 */
			/* Free up all that has been alloced so far */
			for (i = 0 ; i < descriptor_index ; i++)
				free (wan_chat.tx_descriptor[port_number][i].sptr_buffer) ;
/* Sachin 01/02/1997 */
			return 0;
		}
	}
	wan_chat.sptr_current_tx_descriptor[port_number] = NULL;
	wan_chat.current_tx_list[port_number].sptr_forward_link = NULL;
	wan_chat.current_tx_list[port_number].sptr_backward_link = NULL;

	
	/* allocate mem for Rx descriptors and add descriptors to free_rx_list */
	for (descriptor_index = 0; descriptor_index < CHAT_NUMBER_OF_RX_DESCRIPTORS; ++descriptor_index)
	{
		if ((wan_chat.rx_descriptor[port_number][descriptor_index].sptr_buffer =
								(BYTE *)malloc (SIZE_RX_CHAT_BUFFER)) != NULL)
		{
			wan_chat.rx_descriptor[port_number][descriptor_index].length = 0;
			add_entry_to_list (&wan_chat.free_rx_list[port_number], &wan_chat.rx_descriptor[port_number][descriptor_index].links);
		}
		else
		{
/* Sachin 01/02/1997 */
			/* Free up all that has been alloced so far */

			for (i = 0 ; i < CHAT_NUMBER_OF_TX_DESCRIPTORS ; i++)
				free (wan_chat.tx_descriptor[port_number][i].sptr_buffer) ;

			for (i = 0 ; i < descriptor_index ; i++)
				free (wan_chat.rx_descriptor[port_number][i].sptr_buffer) ;

/* Sachin 01/02/1997 */
			return 0;
		}
	}
	wan_chat.num_free_rx_buf[port_number] = CHAT_NUMBER_OF_RX_DESCRIPTORS;
	wan_chat.num_scheduled_rx_buf[port_number] = 0;
	wan_chat.current_rx_list[port_number].sptr_forward_link = NULL;
	wan_chat.current_rx_list[port_number].sptr_backward_link = NULL;
	wan_chat.scheduled_for_rx[port_number].sptr_forward_link = NULL;
	wan_chat.scheduled_for_rx[port_number].sptr_backward_link = NULL;

	return(1);
}

/* For the purpose of associating a session pointer with a particular port,
** the following array is used.
*/
BYTE *dialout_client_ptr[MAX_WAN_PORTS];

/* start_dialout_on_port()
**	Called to enable specified SCC port for dialout purposes.
**  NOTE: The 2nd parameter is retained here as a byte pointer and is never
**		  actually used in code here. In reality it is a pointer to a 
**		  structure. This is required to associate received character info
**		  with the right session.
** NOTE: For the DataBits parameter, you can use the values FIVE_DATA, 
**		 SIX_DATA, SEVEN_DATA, EIGHT_DATA.
**		 For the Parity parameter, you can use the values ODD, EVEN and NONE.
**		 For the StopBits parameter, you can use the values ONE_STOP and
**		 TWO_STOP.
**		 Include the file "UARTMODE.H" from the INCLUDES\ directory to get
**		 these constants.
*/
enum BOOLEAN start_dialout_on_port(USHORT port_number, BYTE *dialout_client,
	ULONG BaudRate, BYTE DataBits, BYTE Parity, BYTE StopBits)
{
	USHORT ModeBits = 0;
	int BaudDivisorBits;

	if (!initialize_chat_rxtx_descriptors(((int)port_number - 1)))
		return FALSE;

	/* Map baud rate to divisor pattern */
	BaudDivisorBits = GetBaudDivisorBits(BaudRate);

	/* NOTE: Below we set certain bit patterns into the 'ModeBits' variable.
	** For details on how this bit pattern is chosen, see section on
	** UART programming in MC68360 QUICC User's Manual, Pg 7-160.
	*/
	switch (DataBits)
	{
	case FIVE_DATA:
		ModeBits |= 0x0000;
		break;
	case SIX_DATA:
		ModeBits |= 0x1000;
		break;
	case SEVEN_DATA:
		ModeBits |= 0x2000;
		break;
	case EIGHT_DATA:
	default:
		ModeBits |= 0x3000;
		break;
	}

	switch (Parity)
	{
	case ODD:
		ModeBits |= 0x0010;
		break;
	case EVEN:
		ModeBits |= 0x001A;
		break;
	case NONE:
	default:
		ModeBits |= 0x0000;
		break;
	}

	switch (StopBits)
	{
	case ONE_STOP:
		ModeBits |= 0x0000;
		break;
	case TWO_STOP:
	default:
		ModeBits |= 0x4000;
		break;
	}

	switch (port_number)
	{
	case 1:
		dialout_client_ptr[0] = dialout_client;
		ChatInitSCC2(BaudDivisorBits, SIZE_RX_CHAT_BUFFER, ModeBits);
		ChatTurnOnTXAndRXOfSCC2();
		break;
	case 2:
		dialout_client_ptr[1] = dialout_client;
		ChatInitSCC3(BaudDivisorBits, SIZE_RX_CHAT_BUFFER, ModeBits);
		ChatTurnOnTXAndRXOfSCC3();
		break;
	case 3:
		dialout_client_ptr[2] = dialout_client;
		ChatInitSCC4(BaudDivisorBits, SIZE_RX_CHAT_BUFFER, ModeBits);
		ChatTurnOnTXAndRXOfSCC4();
		break;
	default:
		return FALSE;
	}

	return TRUE;
}

void stop_dialout_on_port(USHORT port_number)
{
 	dialout_client_ptr[port_number] = NULL;

	/* Turn off Tx and Rx on the SCCx */
	TurnOffTxAndRxOnPort(port_number);

	/* Free buffers */
	FreeWANBuffers(((int)port_number));
}

static void TurnOffTxAndRxOnPort(USHORT port_number)
{
	switch (port_number)
	{
	case 0:
		ChatTurnOffTxAndRxOfSCC2();
		break;
	case 1:
		ChatTurnOffTxAndRxOfSCC3();
		break;
	case 2:
		ChatTurnOffTxAndRxOfSCC4();
		break;
	}
}

static void FreeWANBuffers(int port_number)
{
	int i;
	BYTE *ptr;


	for (i = 0; i < CHAT_NUMBER_OF_TX_DESCRIPTORS; ++i) 
	{
		ptr = wan_chat.tx_descriptor[port_number][i].sptr_buffer;
		if (ptr != NULL) free(ptr);
	}

	for (i = 0; i < CHAT_NUMBER_OF_RX_DESCRIPTORS; ++i) 
	{
		ptr = wan_chat.rx_descriptor[port_number][i].sptr_buffer;
		if (ptr != NULL) free(ptr);
	}

	/* Set pointers to null for next time around -- tx pointers */
	wan_chat.free_tx_list[port_number].sptr_forward_link = NULL;
	wan_chat.free_tx_list[port_number].sptr_backward_link = NULL;

	wan_chat.current_tx_list[port_number].sptr_forward_link = NULL;
	wan_chat.current_tx_list[port_number].sptr_backward_link = NULL;

	/* Set pointers to null for next time around -- rx pointers */
	wan_chat.free_rx_list[port_number].sptr_forward_link = NULL;
	wan_chat.free_rx_list[port_number].sptr_backward_link = NULL;

	wan_chat.current_rx_list[port_number].sptr_forward_link = NULL;
	wan_chat.current_rx_list[port_number].sptr_backward_link = NULL;

	wan_chat.scheduled_for_rx[port_number].sptr_forward_link = NULL;
	wan_chat.scheduled_for_rx[port_number].sptr_backward_link = NULL;
}


#if 0
/* there is already a routine to calculate the baud divisor in wan driver.
use this. */


/* GetBaudDivisorBits()
**		Given a baud rate, returns a bit pattern representing the baud 
**		divisor to use and the prescaler value. This pattern has to be
**		written into the BRG? register of the MC68360 QUICC to get the
**		desired baud.
** NOTE: We assume a 25 MHz system clock and accordingly map the requested
**		 baud rate to a baud divisor using a look up table. See 68360 QUICC
**		 User's Manual Pg 7-111 for this table and to understand why the 
**		 pattern is generated in this particular manner.
*/
static int GetBaudDivisorBits(ULONG BaudRate)
{
	struct BaudCalc {
		ULONG BaudRate;
		int Divisor;
	};
	struct BaudCalc BaudCalcArray[13] =
	{
		{ 50, 1952 },		 	/* This table is from the QUICC user manual */
		{ 75, 1301 },
		{ 150, 650 },
		{ 300, 324 },
		{ 600, 2603 },
		{ 1200, 1301 },
		{ 2400, 650 },
		{ 4800, 324 },
		{ 9600, 162 },
		{ 19200, 80 },
		{ 38400, 40 },
		{ 57600, 26 },
		{ 115200, 13 }
	};
	int i, BaudDivisorPattern;


	for (i = 0; i < sizeof(BaudCalcArray)/sizeof(struct BaudCalc); i++)
	{
		if (BaudRate == BaudCalcArray[i].BaudRate)
			break;			/* Found a matching baud rate */
	}

	if (i == sizeof(BaudCalcArray)/sizeof(struct BaudCalc))
	{
		/* Passed baud not found, so default to 19200 value */

		BaudRate = 19200;
		for (i = 0; i < sizeof(BaudCalcArray)/sizeof(struct BaudCalc); i++)
		{
			if (BaudRate == BaudCalcArray[i].BaudRate)
				break;			/* Found a matching baud rate */
		}
	}

	BaudDivisorPattern = BaudCalcArray[i].Divisor << 1; 
			/* The divisor value starts from bit 1 onwards, so the shift */
	if (BaudRate <= 300)	/* For baud <= 300, set the Div16 bit */
		BaudDivisorPattern |= 0x00000001;

	return BaudDivisorPattern;
}
#else
extern	int GetBaudDivisor (int BaudRate);
static int GetBaudDivisorBits(ULONG BaudRate)
{
	return GetBaudDivisor ((int)BaudRate);
}
#endif

enum WAN_PORT_AVAILABILITY get_wan_port_avail_error_code ()
{
	return (wan_port_avail_error_code) ;
}
