/*----------------------------------------------------------------------------
	File	:	reserver.c
	Synop	:	handles the commands send from UI at the target.
	modi	:	31/7/95 Vidy added extra field in Memory Read to pass the read
				address back to cross check
				10/10/95 Vidy added support for SMC-WAN Chat mode
				24/10/95 Vidy added support for MMV101
				7/11/95 Sowmya added support for TELNET-WAN Chat mode
				21/7/97 Chetan : For READ Requests changed the way check
				is done for INvalid memory locations
	Jo : 		Made changes for Small Proxy
----------------------------------------------------------------------------*/
#include <defs.h>
#include <kstart.h>

/* Added by Chidanand ... */
#include <incall.h>
#include <cfgmgr.h>
#include <stdlib.h>

#include	"uim.h"
#include "brcif.h"
#include <udb.h>
#include	"chat\kchat.h"
#include <wanmgr.h>
#include	<logif.h>

#if PROXY_SERVER
void static fill_port_status (USHORT, USHORT, PortStatusInfo *) ;
#endif

void uim_user_database_write_complete (void) ;
extern int schedule_flash_write (char *dest_ptr, char *src_ptr, unsigned short block_length,
                                 void (*fptr_block_write_complete)(), char *buffer_to_free) ;

USHORT	GlobalErr=0;
#if SMALL_MEM_MAP
#include "..\..\store\boot.h"
extern	BootBinIOPBType BootBinIOPB;
#else
BYTE	*DownloadFlag;
#endif

#ifdef EVENT_LOG
int	uim_log_descriptor = LOG_INVALID_DESCRIPTOR;
int	uim_log_next_expected_address = 0;
char	uim_log_last_buffer[128];
int	uim_log_last_buffer_length;
#endif

extern	enum TEST close_lsl (void);

/* Sachin 17/06/1997 */
/* put a new function to be called on user database complete */
extern enum BOOLEAN user_database_updated ; 
/* Jo 29/06/99 Modified UDB read and write */
void uim_user_database_write_complete (void)
{
   user_database_updated = TRUE ;
}
/* Sachin 17/06/1997 */

USHORT	ProcessPkt(BYTE	*Packet)
{
	union{
		ResultType				*ResultPkt;
		RebootType				*ReBootPkt;
		ReadLocRespType		*RRspT;
		UDBRtnRespType *UDBRespType ;

#if PROXY_SERVER
      PortStatusResp *sptr_port_status_response ;
#endif /* PROXY_SERVER */
		BYTE					*SendPacket;
	} PacketType;

	USHORT	SendPktLen;
	ReadLocReqType *RRqT;
	ReqType	*request_type;
	int	NewChatOnPort;
	int	ret_len;
	int	ret_val;

	void (*fptr_write_complete)() = (void (*)(void)) NULL ;
	char *scheduled_block ;
	OnLineFlashWriteUDBType *online_flash_write_request =
										(OnLineFlashWriteUDBType *) Packet ;
	UDB_HEADER *sptr_udb_header ;

#if PROXY_SERVER
   PortStatusRequest *sptr_port_status_request = (PortStatusRequest *) Packet ;
#endif

	PacketType.SendPacket= uim.response_buffer + SMC_PKT_HEAD_SIZE;

	switch(Packet[0])
	{
		/* Vidy, Chida - 25 Apr 1997 */
      /* Chida - 9 May 1997 */
		case GET_ROUCON_LOCK_TYPE:
            switch (CM_INIT_SUCCESSFUL)
            /* switch (cm_initialize_configuration_manager (CM_OWNED_BY_UIM)) */
            {
            case CM_INIT_SUCCESSFUL :
			   case CM_MANAGER_IS_UIM:
   			   PacketType.ResultPkt->ErrCode = LK_OK;
               break;

			   case CM_MANAGER_IS_TELNET:
			      PacketType.ResultPkt->ErrCode = LK_LOCK_OWNED_BY_TELNET;
               break;

			   case CM_MANAGER_IS_HTTP:
			      PacketType.ResultPkt->ErrCode = LK_LOCK_OWNED_BY_WEB;
               break;

			   case CM_MANAGER_IS_DTTY:
			      PacketType.ResultPkt->ErrCode = LK_LOCK_OWNED_BY_DUMB_TTY;
               break;

			   case CM_MANAGER_IS_SNMP:
            default:
			      PacketType.ResultPkt->ErrCode = LK_LOCK_OWNED_BY_SOMEONE;
               break;
            }
			PacketType.ResultPkt->Ptype = LOCK_RES_TYPE;
			PacketType.ResultPkt->RouterState = ROUTER_UP;
			SendPktLen = sizeof(ResultType);
			break;

		case FREE_ROUCON_LOCK_TYPE:
         /* cm_deinitialize_configuration_manager (CM_OWNED_BY_UIM); */
			PacketType.ResultPkt->Ptype = LOCK_RES_TYPE;
			PacketType.ResultPkt->RouterState = ROUTER_UP;
			PacketType.ResultPkt->ErrCode = LK_OK;
			SendPktLen = sizeof(ResultType);
			break;
/* Chidanand */


		case QUERY_BRIDGE_NAME:
			/* Modem is online and we run the Config UI. Modem will
			not respond to the command but the UI will get a response from
			the router saying it is up. The router will no longer be in the
			RECV_MDM_RESP state and so in the Timer routine, uim.enabled
			will not be made TRUE when timeout occurs. */

			if (uim.enabled == FALSE)
				uim.enabled = TRUE;
			PacketType.ResultPkt->Ptype = RES_TYPE;
			PacketType.ResultPkt->ErrCode=ERR_ROUTER_UP;
			SendPktLen = sizeof(ResultType);
			break;

		case REBOOT_TYPE:
#if 0
ppp_hangup_and_redial_wan_port((int) 0);
PacketType.ResultPkt->Ptype = RES_TYPE;
PacketType.ResultPkt->RouterState = ROUTER_UP;
PacketType.ResultPkt->ErrCode = 0;
SendPktLen = sizeof(ResultType);
break;
#endif
#if SMALL_MEM_MAP
			if (Packet[1] == REBOOT_TO_DOWNLOAD)
				BootBinIOPB.BootMode = DOWNLOAD_MODE;
			else if (Packet[1] == WARM_BOOT_MODE)
				BootBinIOPB.BootMode = WARM_BOOT_MODE;
			else	if(Packet[1] != REBOOT_SYSTEM)
				break;
#else
			if (Packet[1] == REBOOT_TO_DOWNLOAD)
				*DownloadFlag = DOWNLOAD_MODE;
			else if (Packet[1] == WARM_BOOT_MODE)
				*DownloadFlag = WARM_BOOT_MODE;
			else	if(Packet[1] != REBOOT_SYSTEM)
				break;
#endif

			close_lsl ();

			Reset();
			break;

		case READ_REQ_TYPE:

			RRqT=( ReadLocReqType *)Packet;
			if ( RRqT->Length > 128)
				RRqT->Length = 128;

			PacketType.RRspT->Ptype = READ_RESP_TYPE;

			if ((unsigned long) RRqT->Address < (unsigned long) FL_ROMM_START
					|| (unsigned long) RRqT->Address + (unsigned long) RRqT->Length > (unsigned long) FL_PROM_END)
			{
				PacketType.RRspT->ErrCode = ERR_INV_MEM_RANGE ;
			}
			else
			{
				PacketType.RRspT->ErrCode = 0;
				PacketType.RRspT->Address = RRqT->Address;	/* Vidy added. 31-7-95 */
				PacketType.RRspT->Length = RRqT->Length;
				memcpy( (BYTE *)(PacketType.RRspT->buffer), (BYTE *)(RRqT->Address), RRqT->Length);
			}

			SendPktLen = sizeof(ReadLocRespType);		
			break;

		case SMC_WAN_CHAT_START:	/* start a SMC-WAN chat to specified port */
			request_type = (ReqType *) Packet;			
			NewChatOnPort = request_type->ReqSubType;	/* get the chat port */
			ChatIdleTimer = CHAT_IDLE_TIMER_VALUE;	/* set this before ints */
			if ((NewChatOnPort < 1) || (NewChatOnPort > 3))
			{
				/* this is error */
		 		PacketType.ResultPkt->ErrCode=ERR_INVALID_CHAT_PORT;
			}
			else if (start_chat_on_port(NewChatOnPort, SMC_CHAT))
			{
				/* 7/11/95 Sowmya */
		 		PacketType.ResultPkt->ErrCode=NO_ERR;
				StartTimer(0);
			}
			else
			{
		 		PacketType.ResultPkt->ErrCode=ERR_CHAT_PORT_OPEN;
			}
			PacketType.ResultPkt->Ptype=RES_TYPE;
			PacketType.ResultPkt->RouterState=ROUTER_UP;
			SendPktLen = sizeof(ResultType);
			break;

		case SET_WAN_DTR_SIGNAL_STATE:

			request_type = (ReqType *) Packet;			
			/* if request is to set DTR set for all ports and get out */
			if (request_type->ReqSubType) {
				ChatSetLocalIO14(0xC7);
				break;
			}
			if (ChatOnPort == 1)
					ChatSetLocalIO14(0xCF);
			else if (ChatOnPort == 2)
					ChatSetLocalIO14(0xD7);
			else if (ChatOnPort == 3)
					ChatSetLocalIO14(0xE7);
			break;

		case MUX_INITIALIZATION_START:
			/* all we need to do is to set bit 6 high in LocalIO */
		 	initialize_mux_module_talk();
			SendPktLen = 0;
			break;

		case ONLINE_FLASH_WRITE_UDB :
/* Jo 29/06/99 Modified UDB read and write */
			if (uim.enabled == FALSE)
				uim.enabled = TRUE ;

			PacketType.UDBRespType->RtnPktType = ONLINE_FLASH_WRITE_UDB ;
			PacketType.UDBRespType->WriteReqPktLen = online_flash_write_request->buffer_length ;
			PacketType.UDBRespType->down_load_address = online_flash_write_request->down_load_address ;
			SendPktLen = sizeof (UDBRtnRespType); 

			scheduled_block = malloc (520) ;
			if ((scheduled_block != NULL) && (online_flash_write_request->buffer_length))
			{

				sptr_udb_header = (UDB_HEADER *)&online_flash_write_request->buffer[0] ;
				if ((sptr_udb_header->magic_number == 0xABCD) &&
                  ((char *)online_flash_write_request->down_load_address == (char *)FL_UDB_HDR))
					fptr_write_complete = uim_user_database_write_complete ;
				else
					fptr_write_complete = NULL ;
				memcpy (scheduled_block, &online_flash_write_request->buffer[0],
				        online_flash_write_request->buffer_length) ;
#if SMALL_MEM_MAP
				c_write_to_AMD_flash((char *)scheduled_block,
					(char *)online_flash_write_request->down_load_address,
					online_flash_write_request->buffer_length);
				if (fptr_write_complete)
					fptr_write_complete();
#else
				schedule_flash_write ((char *)scheduled_block,
					(char *)online_flash_write_request->down_load_address,
					512, fptr_write_complete, scheduled_block) ;
#endif
			}

			break;

#if PROXY_SERVER

      case (GET_PORT_STATUS) :

         /* We assume that we can fit in all the port information in a 
         single packet. Since all the models have 3 ports or less, I have
         not taken any pains in designing the protocol in case there
         are more ports (or even in case we choose to add fields in the
         PortInformation so that the total packet length exceeds 1 K.
         Roucon can take care of that by modifying start_port and end_port
         accordingly. I mean, Roucon can do as much as send the requests
         with the start_port and end_port both set to 0 in the first
         request, 1 in the second and 2 in the third */

			if (uim.enabled == FALSE)
				uim.enabled = TRUE ;

			PacketType.sptr_port_status_response->packet_type = GET_PORT_STATUS ;
			PacketType.sptr_port_status_response->error_code = 0 ;
			PacketType.sptr_port_status_response->request_id = sptr_port_status_request->request_id ;
			PacketType.sptr_port_status_response->start_port = sptr_port_status_request->start_port ;
			PacketType.sptr_port_status_response->end_port = sptr_port_status_request->end_port ;
			PacketType.sptr_port_status_response->number_of_records = sptr_port_status_request->end_port - sptr_port_status_request->start_port + 1 ;
			PacketType.sptr_port_status_response->system_up_time =
					lsl.system_mib.sysUpTime/100;
			SendPktLen = sizeof (PortStatusResp) -
            sizeof (PortStatusInfo) * (NUMBER_OF_PORTS - PacketType.sptr_port_status_response->number_of_records) ;

         fill_port_status (sptr_port_status_request->start_port,
            sptr_port_status_request->end_port,
            &PacketType.sptr_port_status_response->port_information[0]) ;
         break ;

#endif

#if EVENT_LOG	/* vidy 18/02/98 */
		case (OPEN_EVENT_LOG) :
			uim_log_next_expected_address = 0;	//this is the block expected
			if (uim_log_descriptor != LOG_INVALID_DESCRIPTOR)
				close_log(uim_log_descriptor);
			uim_log_descriptor = open_log();
			if (uim_log_descriptor == LOG_INVALID_DESCRIPTOR)
	 			PacketType.ResultPkt->ErrCode=NO_ERR;
			else
		 		PacketType.ResultPkt->ErrCode=ERR_NO_LOGGING;
			PacketType.ResultPkt->Ptype=RES_TYPE;
			PacketType.ResultPkt->RouterState=ROUTER_UP;
			SendPktLen = sizeof(ResultType);
			break;

		case (READ_EVENT_LOG) :
			RRqT=( ReadLocReqType *)Packet;
			if ( RRqT->Length > 128)
				RRqT->Length = 128;

			PacketType.RRspT->Ptype = READ_RESP_TYPE;

			PacketType.RRspT->Address = RRqT->Address; /* just to match req/resp */
			if (uim_log_next_expected_address == PacketType.RRspT->Address)
			{
				ret_len = read_log(uim_log_descriptor,
						(BYTE *)PacketType.RRspT->buffer, RRqT->Length);
				uim_log_next_expected_address++;
			}
			else
			{
				ret_len = uim_log_last_buffer_length;
				memcpy(PacketType.RRspT->buffer, uim_log_last_buffer, ret_len);
			}

			if (ret_len < 0)	/* there was some error */
			{
				PacketType.RRspT->Length = 0;
				PacketType.RRspT->ErrCode = ERR_READ_EVENT_LOG;
			}
			else
			{
				PacketType.RRspT->Length = ret_len;
				PacketType.RRspT->ErrCode = 0;
				/* Store the data in case of a retransmission is later needed */
				memcpy(uim_log_last_buffer, PacketType.RRspT->buffer, ret_len);
				uim_log_last_buffer_length = ret_len;
			}
/*			SendPktLen = sizeof(ReadLocRespType) - (128 - ret_len); */
			SendPktLen = sizeof(ReadLocRespType);
			break;

		case (CLOSE_EVENT_LOG) :
			close_log(uim_log_descriptor);
			uim_log_descriptor = LOG_INVALID_DESCRIPTOR;
			PacketType.ResultPkt->Ptype=RES_TYPE;
	 		PacketType.ResultPkt->ErrCode=NO_ERR;
			PacketType.ResultPkt->RouterState=ROUTER_UP;
			SendPktLen = sizeof(ResultType);
			break;
			break;
		case (RESET_EVENT_LOG) :
			clean_log();
			PacketType.ResultPkt->Ptype=RES_TYPE;
	 		PacketType.ResultPkt->ErrCode=NO_ERR;
			PacketType.ResultPkt->RouterState=ROUTER_UP;
			SendPktLen = sizeof(ResultType);
			break;
#endif	/* EVENT_LOG */

		case (HANGUP_AND_REDIAL) :
			PacketType.ResultPkt->Ptype=RES_TYPE;
			ppp_hangup_and_redial_wan_port((int) Packet[1]);
 			PacketType.ResultPkt->ErrCode = 0;
			PacketType.ResultPkt->RouterState = ROUTER_UP;
			SendPktLen = sizeof(ResultType);
			break;

		default:
			PacketType.ResultPkt->Ptype=RES_TYPE;
			if(GlobalErr)
	 			PacketType.ResultPkt->ErrCode=GlobalErr;
			else
	 			PacketType.ResultPkt->ErrCode=ERR_PKT_TYPE;
			GlobalErr = 0;
			PacketType.ResultPkt->RouterState=ROUTER_UP;
			SendPktLen = sizeof(ResultType);
			break;
	} /* end of outer switch */

	/* Add the SMC header */
	SendPktLen += SMC_PKT_HEAD_SIZE ;
	/* Add the CRC in the end */
	AddCRC(uim.response_buffer , SendPktLen);
	SendPktLen += 2;	/* 16 bit CRC */
	return(SendPktLen);
}


#if PROXY_SERVER

void static fill_port_status (USHORT start_port, USHORT end_port, PortStatusInfo *sptr_port_status)
{
   USHORT port_number ;

   for (port_number = start_port ; port_number <= end_port ; port_number++)
   {
      sptr_port_status->port_number = port_number ;
      sptr_port_status->local_ip_address = proxy_get_local_ip_address (port_number) ;
      sptr_port_status->remote_ip_address = proxy_get_remote_ip_address (port_number) ;
      sptr_port_status->subnet_mask = proxy_get_subnet_mask (port_number) ;
      sptr_port_status->status = get_port_status (port_number) ;
      sptr_port_status->baud_rate = get_baud_rate (port_number) ;
      get_modem_name (port_number, &sptr_port_status->modem_name[0], MDM_TYPE_LEN) ;
      get_modem_connect_message (port_number, &sptr_port_status->modem_report[0], 30) ;
      get_ppp_user_name (port_number, &sptr_port_status->user_name[0], 61) ;

      sptr_port_status->connection_up_time = get_connection_up_time (port_number) ;
      sptr_port_status->connection_tx_count = get_connection_tx_count (port_number) ;
      sptr_port_status->connection_rx_count = get_connection_rx_count (port_number) ;

      sptr_port_status->aggregate_tx_count = get_aggregate_tx_count (port_number) ;
      sptr_port_status->aggregate_rx_count = get_aggregate_rx_count (port_number) ;
      sptr_port_status->number_of_calls = get_number_of_calls (port_number) ;
      sptr_port_status->aggregate_connection_time = get_aggregate_connection_time (port_number) ;

      sptr_port_status->connection_tx_packet_count = get_connection_tx_packet_count (port_number) ;
      sptr_port_status->connection_rx_packet_count = get_connection_rx_packet_count (port_number) ;

      sptr_port_status->aggregate_tx_packet_count = get_aggregate_tx_packet_count (port_number) ;
      sptr_port_status->aggregate_rx_packet_count = get_aggregate_rx_packet_count (port_number) ;

      sptr_port_status++ ;
   }
}

#endif
