#include "defs.h"
#include <kstart.h>
#include <udb.h>
#include <string.h>
#include "smcconf.h"
#include	"uim.h"
#include "kuim.h"
#include <ctype.h>

void accept_loginstring (BYTE C);

extern BYTE	SMCRxState;
extern BYTE loginstate;
extern BYTE loginstring_buffer[];
extern BYTE loginstring_buffer_index;

BYTE * dumbtty_key = NULL ;

extern BYTE *CompressString (BYTE *);
extern void send_packet_on_SMC (BYTE *, USHORT);
extern void display_denial_message (void);
extern int strcmpi (const char *,const char *);
extern BYTE *initialize_client_info_ptr_for_dumbtty (void);
extern deinitialize_client_info_ptr_for_dumbtty(BYTE *);

/*All strings reqd for DUMB_TTY module*/
/* Jo 26/04/99 */
const BYTE LoginStr[]="LOGIN"; 	  /*to incorporate DUMB_TTY*/
const BYTE exit_string[] = "exit";
const BYTE LoginDenied[] =	"\n\rAccess Denied\n\r" ;
const BYTE CarriageReturn[] = "\n\r";
const BYTE closing_smc_configuration[] = "\n\rClosing Connection\n\r";
const BYTE Invalidloginstring[] = "\n\rInvalid Login String\n\r";
const BYTE ResetStr[] = "ATRESETAT";  /* Jo 18/01/99 */
/* Jo 26/04/99 */
/* sudhir 16/5/97 */
USHORT dtty_timer=0;

/****************************************************************************
*  Routine 	 :  accept_loginstring														 *
*	Input     :  Characters sent by user to "login"									 *
*  Function  :  Here the characters sent by user to "login"	 are accepted.	 *
*					 'l' has already been accepted and filled in the buffer.Once *
*					 a	carriage return is encoutered the buffer is NULL          *
*					 terminated	and checked if the  buffer contains "login". 	 *
*					 If by pressing BACKSPACE the user erases 'l' it is assumed  *
*					 that the user does'nt want to conf thru' SMC and hence the  *
*					 SMCRxState is	made as RECV_7E indicating that a 7E is 		 *
*					 awaited.																	 *
*					 If password does'nt exist and "login" is correct the 		 *
*					 client_info_ptr is initialized otherwise passowrd is 		 *
*					 requested.	 																 *
****************************************************************************/

void accept_loginstring (BYTE C)
{
  	switch (C)
	{	
  		case BACKSPACE : 
   		if	(loginstring_buffer_index > 1)
      	{
           	loginstring_buffer_index--;
				send_packet_on_SMC (&C, (USHORT)sizeof(BYTE));
        	}
			else
			{
           		loginstring_buffer_index = 0;
					send_packet_on_SMC (&C, (USHORT)sizeof(BYTE));
		   		SMCRxState = RECV_7E;		/*If 'l' is also erased*/
			}
         return;
      
	  	case TAB :				  /*In the case of tab nothing is being done*/
          return;
                    
  		case ESCAPE :	 /*go back to RECV_7E state*/
			send_packet_on_SMC (CarriageReturn, strlen (CarriageReturn));
   		loginstring_buffer_index = 0;
	   	SMCRxState = RECV_7E;
         return;
             
  		case CARRIAGE_RETURN :
			send_packet_on_SMC (CarriageReturn, strlen (CarriageReturn));
  			loginstring_buffer[loginstring_buffer_index] = 0;
			CompressString (loginstring_buffer); 
         loginstring_buffer_index = 0;
	     	if (strcmpi ((char *)loginstring_buffer,(char *)LoginStr) != 0)
		   {
              SMCRxState = RECV_7E;
              return;
         }
         if ((dumbtty_key = initialize_client_info_ptr_for_dumbtty ()) == NULL)
			{
				SMCRxState = RECV_7E;
				return;
			}	
         loginstate = LOGIN_ACCEPTED;
/* sudhir 14/5/97 */
         dtty_timer = DTTY_TIMEOUT;
			return;
      
	   default :
		   if (loginstring_buffer_index == MAX_BUFFER_LENGTH)
			{
				send_packet_on_SMC (Invalidloginstring, strlen (Invalidloginstring));
				loginstring_buffer_index = 0;
				SMCRxState = RECV_7E;
	 			return;
			}
         loginstring_buffer[loginstring_buffer_index++] = C;
 			send_packet_on_SMC (&C,(USHORT)sizeof(BYTE));
		   return;
	}		
}

#if STATUS_DEBUG

#define MAX_NUMBER_OF_MODULES 10
#define MAX_SIGNATURE_SIZE 25
#define TEMP_BUFF_SIZE 512
#define DEBUG_STRING_POLL_PERIOD 3
typedef struct
{
   void (*fptr_module_debug_function)() ;
   char module_signature[MAX_SIGNATURE_SIZE] ;
} MODULE_DEBUG_INFO ;

MODULE_DEBUG_INFO debug_info[MAX_NUMBER_OF_MODULES] ;
char debug_temp_buff[TEMP_BUFF_SIZE] ;
int temp_buff_size = 0 ;

void add_to_debug_buffer (char c)
{
   int temp_buff_index ;

   if (temp_buff_size < (TEMP_BUFF_SIZE - 1))
   {
      debug_temp_buff[temp_buff_size++] = c ;
      debug_temp_buff[temp_buff_size] = 0 ;
      return ;
   }
   for (temp_buff_index = 1 ; temp_buff_index < temp_buff_size ; temp_buff_index++)
      debug_temp_buff[temp_buff_index-1] = debug_temp_buff[temp_buff_index] ;
   debug_temp_buff[TEMP_BUFF_SIZE - 2] = c ;
}


int has_string_occured (char *debug_signature)
{
   if (strstr (debug_temp_buff, debug_signature))
      return (1) ;

   return (0) ;
}


void call_all_debuggers ()
{
   int i ;
   enum BOOLEAN debugger_called = FALSE ;

   for (i = 0 ; i < MAX_NUMBER_OF_MODULES ; i++)
   {
      if (debug_info[i].fptr_module_debug_function)
      {
         if (has_string_occured (debug_info[i].module_signature))
         {
            (*debug_info[i].fptr_module_debug_function)() ;
            debugger_called = TRUE ;
         }
      }
   }

   for (i = 0 ; i < temp_buff_size ; i++)
      if (debug_temp_buff[i] == 0)
         debugger_called = TRUE ;

   /* If some debug signature occured or if there was a 0 clean up */
   if (debugger_called == TRUE)
   {
      temp_buff_size = 0 ;
      debug_temp_buff[0] = 0 ;
   }
}


enum BOOLEAN register_debugger (void (*fptr_debug_function)(), char *signature)
{
   int i ;

   for (i = 0 ; i < MAX_NUMBER_OF_MODULES ; i++)
   {
      if (debug_info[i].fptr_module_debug_function)
         continue ;

      debug_info[i].fptr_module_debug_function = fptr_debug_function ;
      strncpy (debug_info[i].module_signature, signature, MAX_SIGNATURE_SIZE-1) ;
      return (TRUE) ;
   }

   return (FALSE) ;
}

int temp_counter = DEBUG_STRING_POLL_PERIOD ;
void debug_manager_timer ()
{
   if (temp_counter)
   {
      temp_counter-- ;
      return ;
   }
   temp_counter = DEBUG_STRING_POLL_PERIOD ;
   call_all_debuggers () ;
}

#endif
