#define		MAX_PKT_LEN		256
#define		MIN_PKT_LEN		8		/* SMC hdr(4) + ReqPkt(4)*/

#define		MAX_CONFIG_PKT	270
#define		RX_BUF_LEN		256

#define		FRAME_DELIM		0x7e
#define		XON				0x11
#define		XOFF				0x13


#define		RECV_7E			0
#define		RECV_DATA		1
#define		RECV_QUOTE		2
#define		RECV_XON		3
#define		RECV_MDM_RESP	4

#define	SEC			18

#define	ADDR_LEN	6 

#define		INC_CIR_INDEX(indx, size)   indx++; indx &= (size -1)

typedef struct	{
	BYTE	BridgeNumber[4];
} SMCPktHeadType;


#define		SMC_PKT_HEAD_SIZE	sizeof(SMCPktHeadType)

extern	BYTE	SMCRxByte;

extern	BYTE	SMCRxBuffer[];

extern	BYTE	RequestBuffer[];

extern	BYTE	ResponseBuffer[];

extern	BYTE	SMCTxBuffer[];

extern	USHORT	SMCRxreadidx;
extern	USHORT	SMCRxwriteidx;
extern	BYTE	SMCRxState;
extern	USHORT	WriteIndex;
extern	BYTE	InSMCForeground;
extern	BYTE	SMCTxBDBusy;
extern	USHORT	RespWaitTimer;

void	SMCForeground(void);
void	GetPacket(void);
void	SendPktOnSMC(USHORT Length);
void 	SendModemCommand(void);
USHORT	SearchBuffForResp(char *String);
