

/**************************************************************************
modi : Vidy 15/08/96 added CheckForModem parameter for RF-200
***************************************************************************/

/*Deepak...*/
#include "defs.h"
/*...Deepak*/

#include	"uim.h"
#include "..\wandrv\modem.h"
#include	"brcif.h"
#include <wanmgr.h>
/*Deepak 28/12/1996...*/
#include <kstart.h>
#include <ctype.h>
#include "smcconf.h"
/* Jo 18/1/99 */
#include "..\..\store\boot.h"


BYTE loginstring_buffer[MAX_BUFFER_LENGTH];
BYTE loginstring_buffer_index = 0;
BYTE loginstate;

extern BYTE * dumbtty_key;

void send_packet_on_SMC (BYTE *,USHORT);

/* Jo 18/1/99 */

#if	SMALL_MEM_MAP
extern	BootBinIOPBType	BootBinIOPB;
#else
extern unsigned char *DownloadFlag ;
#endif

/* Jo 18/1/99 */
 
/* Added By Ravi On 17 Nov 1998 ... */
void check_for_resetstr_and_reset (BYTE);

extern BYTE ResetStr[];
int ResetStrIndex = 0;
/* ... Added By Ravi On 17 Nov 1998 */
/* Jo 18/1/99 */

extern int strcmp (const char *, const char *) ;
extern int strcmpi (const char *, const char *) ;
extern BYTE *initialize_client_info_ptr_for_dumbtty(void);
extern void deinitialize_client_info_ptr_for_dumbtty(BYTE *);
extern void accept_loginstring (BYTE);
extern enum BOOLEAN is_dtty_enabled();

/*...Deepak 28/12/1996*/

extern enum WAN_PORT_AVAILABILITY get_wan_port_avail_error_code () ;

#if STATUS_DEBUG
extern void add_to_debug_buffer (char) ;
#endif

/* sudhir 14/5/97 */
extern USHORT call_save_buffer (BYTE *, BYTE *);
extern USHORT dtty_timer;

extern	USHORT	GlobalErr;
BYTE	SMCRxBuffer[RX_BUF_LEN];

USHORT		SMCRxreadidx = 0;
USHORT		SMCRxwriteidx = 0;
BYTE			SMCRxState = RECV_7E;
USHORT		LastReadIndex = 0;

const BYTE	ModemCmds[NUM_MDM_STRS][]={
	"ATS0=1\r\n",
	"AT&E5\r\n",
	"ATE0\r\n",
};
USHORT		MdmCmdIdx = 0;
const char *RebootMessage = "\n\n\rWANTalk idle timer expired!!! Rebooting...\n\n\rATRZ";
const char *ChatStartMessage[] = {
	"",										/* Numbers start from 1 */
	"\n\n\r    Connected to WAN device on WAN Port 1\n\n\r",
	"\n\n\r    Connected to WAN device on WAN Port 2\n\n\r",
	"\n\n\r    Connected to WAN device on WAN Port 3\n\n\r",
};

const char port_not_available_mesg[] = 
	"\n\rSelected port not available for configuration\n\r" ;

const char	*MuxInitMessage[] = {
	"\n\n\r    Connected to MMV_101 setup\n\n\r",
	"\n\n\r    MMV_101 Hardware not detected\n\n\r",
};
enum TEST chat_send_wan_packet (BYTE *sptr_tx_buffer,	USHORT number_of_bytes, USHORT port_number);

int		ModemPresentOrNot = 1;
extern	int		InitializationDone;
/****************************************************************************
*	Routine	: SMCForeground 												*
*	Input	: None															*
*	Summary	: Called from the timer. Checks for configuration packets from	*
*			  the SMC or from the SCC										*
****************************************************************************/	
void SMCForeground(int CheckForModem)
{
   if (loginstate == LOGIN_ACCEPTED)
   {
/* sudhir 14/5/97 */
      if (!dtty_timer)
         close_dumbtty_connection (dumbtty_key);
      dtty_timer--;
   }

	if (CheckForModem)
	{
		int	call_counter = 0x1FFFF;
	
		while (ModemPresentOrNot)
		{
			GetPacket();
			if (!call_counter--)
			{
				/* if call counter expires just enable uim and return */

				uim.enabled = TRUE;
				return;
			}
		}
		return ;
	}
	/* Unquote characters in the circular buffer and process */
	GetPacket ();

#ifdef WAN_CHAT_TEST
	if (ModemPresentOrNot)
		return;
	{
		for (counter = 0; counter < 20000; counter++);

		ChatIdleTimer = CHAT_IDLE_TIMER_VALUE;	/* reset this */
		StartTimer(0);
		start_chat_on_port(1, SMC_CHAT);
	}
#endif

	if (SettingUpMux)
	{
		check_mux_initialization_done();
	}
}
/****************************************************************************
*	Routine	: GetPacket		 												*
*	Input	: None															*
*	Summary	: Called from SMCForeground. Checks for packets from the SMC.	*
*			  Moves the Rx state machine. Processes pkts if meant for this	*
*			  node else schedules requests to go to remote bridge.			*
****************************************************************************/	
void GetPacket(void)
{
	BYTE			*ActualDataPtr;
	USHORT		PktLength;
	int			save_pl;		/* location to save interupt priority level */
	BYTE			*sptr_tx_packet;
	BYTE			C;
	UIM_TX_DESCRIPTOR	*sptr_tx_descriptor;
	ResultType *return_packet ;

continue_processing :
	/* Read & Write index in the SMC circular buffer */
	if (SMCRxreadidx != SMCRxwriteidx)
	{
		ChatIdleTimer = CHAT_IDLE_TIMER_VALUE;	/* reset this */
		/* read the next characterr */
		C = SMCRxBuffer[SMCRxreadidx];
#if STATUS_DEBUG
      add_to_debug_buffer (C) ;
#endif
		INC_CIR_INDEX(SMCRxreadidx, RX_BUF_LEN);
		
		switch(SMCRxState)
		{
			/* Goto corresponding rxstate */
			case RECV_DATA:
				if (C == FRAME_DELIM)
				{
					StopTimer();
					break;
				}
				if (C == 0x7d)
				{
					SMCRxState = RECV_QUOTE;
					goto continue_processing ;
					return;
				}
				/* save the character into a linear buffer */
				if (uim.write_index >= MAX_CONFIG_PKT)
				{
					SMCRxState = RECV_7E;
					/* This pkt didn't go */
					/* This is used for searching in the Circular buffer */
					LastReadIndex = SMCRxreadidx;
				}
				else
				{
					uim.request_buffer[uim.write_index++] = C;
					goto continue_processing ;
				}
				return;

			case RECV_7E:						/* this is the initial state */
/*Deepak 28/12/1996...*/
			case RECV_LOGIN :	   			/* this is the initial state for configuring a router through SMC*/
/*...Deepak 28/12/1996*/
				if (C == FRAME_DELIM)
				{
Gota7e:	 			StartTimer(PACKET_RX_TIME);
						SMCRxState = RECV_DATA;
						uim.write_index = 0;
				}
				else
				{
               /* 17/07/1997 Vidy */
               if ((!SettingUpMux) && (!ChatOnPort))
               {
/*Deepak...*/
					   if (toupper(C) == toupper(LoginStr[0]))
				  	   {						/* echo the typed char on the smc	 */
							/*check for dtty_management_enabled here*/	
                     if (is_dtty_enabled() == FALSE)
                        return;
						   send_packet_on_SMC (&C, (USHORT)sizeof(BYTE));
                     SMCRxState = CONFIGURATION_THROUGH_SMC_IN_PROGRESS;
               	   loginstate = LOGIN_BEING_ACCEPTED;
                     loginstring_buffer[loginstring_buffer_index++] = 'l';
                     return;
   					}
/*...Deepak*/
               }
					/* If the port is still disabled then it is modem connected.
					So wait for 'CONNECT' string. If the port is enabled then
					either modem is online or this is direct connected. So look
					for 'NO CARRIER' string anyway. */
					if (ChatOnPort)
					{
/* Earlier we were handling SMC rx buffer character by character. 
	Normal chat ( manual opertaion) it won't create problems. 
	But in cases were traffic is heavy (Upgrading ISDN firmware using
 	flashpro) it will create problems. So whenever we will get control
	clear SMC rx buffer and send it to respective WAN port. 
	sudhir 19/12/97
*/
	
						uim.send_buffer[uim.send_buffer_index++] = C;
						while (SMCRxreadidx != SMCRxwriteidx)
						{
							uim.send_buffer[uim.send_buffer_index++] = SMCRxBuffer[SMCRxreadidx];
							INC_CIR_INDEX(SMCRxreadidx, RX_BUF_LEN);
						}
						chat_send_wan_packet(&uim.send_buffer[0], uim.send_buffer_index, ((USHORT)(ChatOnPort - 1)));	
						uim.send_buffer_index = 0;				

#if 0
						chat_send_wan_packet(&C, 1, ((USHORT)(ChatOnPort - 1)));	/* need to optimise this */ 
#endif

						return;
					}
					if (uim.enabled == FALSE)
					{
						if( SearchCirBuff("CONNECT"))
							uim.enabled = TRUE;
					} else if(uim.enabled == TRUE)
					{
						if( SearchCirBuff("NO CARRIER"))
							uim.enabled = FALSE;
					}
				}  
				return;


			case RECV_QUOTE:
				if (uim.write_index >= MAX_CONFIG_PKT)
				{
					SMCRxState = RECV_7E;			/* This pkt didn't go */
					/* This is used for searching in the Circular buffer */
					LastReadIndex = SMCRxreadidx;
				}
				else
				{
					uim.request_buffer[uim.write_index++] = (C ^ 0x20);
					SMCRxState = RECV_DATA;
					goto continue_processing ;
				}
				return;


			case RECV_MDM_RESP:
				/* - In case a FRAME_DELIM has come then assume that modem
				is already Online or this is a Direct Connection. 
				   - If some other character has come then put it into
				   RequestBuffer and check for the response string. */
				if(C == FRAME_DELIM) 
				{
					ModemPresentOrNot = 0;
					uim.enabled = TRUE;		/* Vidy added this on 28th Feb 96 */
					goto Gota7e;
				} 
				else 
					uim.request_buffer[uim.write_index++] = C;

				/* If proper response (initstr+OK) is got then send the
				next modem string */
				if(SearchBuffForResp("OK")) 
				{
					ModemPresentOrNot = 0;
					StopTimer();
						/* This is used for searching in the Circular buffer */
						LastReadIndex = SMCRxreadidx;
						SMCRxState = RECV_7E;
				}
				return;

/*Deepak...*/
         case CONFIGURATION_THROUGH_SMC_IN_PROGRESS:
			   switch(loginstate)
            {
               case LOGIN_BEING_ACCEPTED:
                  accept_loginstring (C);
                  return;

               case LOGIN_ACCEPTED :
                  dtty_timer = DTTY_TIMEOUT;
/* sudhir 19/12/97 */
/* Earlier we were handling SMC rx buffer character by character. 
	Normal chat ( manual opertaion) it won't create problems. 
	But in cases were traffic is heavy (Upgrading ISDN firmware using
 	flashpro) it will create problems. So whenever we will get control
	clear SMC rx buffer and send it to respective WAN port. 
*/

						if (ChatOnPort)
						{
							uim.send_buffer[uim.send_buffer_index++] = C;
							check_for_resetstr_and_reset(C);	 /* Jo 18/01/99 */
							while (SMCRxreadidx != SMCRxwriteidx)
							{
								check_for_resetstr_and_reset( SMCRxBuffer[SMCRxreadidx] );  /* Jo 18/01/99 */
								uim.send_buffer[uim.send_buffer_index++] = SMCRxBuffer[SMCRxreadidx];
								INC_CIR_INDEX(SMCRxreadidx, RX_BUF_LEN);
							}
							chat_send_wan_packet(&uim.send_buffer[0], uim.send_buffer_index, ((USHORT)(ChatOnPort - 1)));	
							uim.send_buffer_index = 0;				
							return;
/* sudhir 19/12/97 */
						}
					   call_save_buffer (dumbtty_key,C);
                  return;
            }
/*...Deepak*/
			default:
				return;
		}
		

		if ( uim.write_index >= MIN_PKT_LEN) {
			/* Check for packet integrity */
			ActualDataPtr = uim.request_buffer + SMC_PKT_HEAD_SIZE;
	 		if( CheckCRC(uim.request_buffer, uim.write_index)) {
sendonsmc:	
				PktLength = ProcessPkt( ActualDataPtr);

				/* Disable interrupts */
				save_pl = _GPL();
				_SPL(7);

				/* Quote into 1 of the tx_descriptors at offset of 1 - to add 7E */
				sptr_tx_descriptor = get_entry_from_list((LINK *) &uim.free_tx_list);
				if (sptr_tx_descriptor == NULL)
				{
					/* no use printing a message here cause there are no free descriptors*/
					/* Enable interrupts */
					_SPL(save_pl);
					goto exitgetp;
				}

				sptr_tx_packet = sptr_tx_descriptor->sptr_tx_packet;
				PktLength = Quote(uim.response_buffer, sptr_tx_packet + 1, PktLength);
				PktLength++;
				sptr_tx_packet[0]=sptr_tx_packet[PktLength++] = FRAME_DELIM;
				sptr_tx_descriptor->length = PktLength;

				if (ActualDataPtr[0] == SMC_WAN_CHAT_START)
				{
					/*
					If the request is for wan chat, dont send any
					error code. Send a message so that the terminal
					prints it
					*/
					return_packet = (ResultType *) (&uim.response_buffer[0] + SMC_PKT_HEAD_SIZE) ;
					if (return_packet->ErrCode == ERR_CHAT_PORT_OPEN)
					{
						strcpy (sptr_tx_descriptor->sptr_tx_packet,
								  wan_conf_return_strings[(int)get_wan_port_avail_error_code()]) ;
						sptr_tx_descriptor->length = 
								  strlen(wan_conf_return_strings[(int)get_wan_port_avail_error_code()]);
					}
					else
					{
						strcpy(sptr_tx_descriptor->sptr_tx_packet,
								ChatStartMessage[ActualDataPtr[2]]);
						sptr_tx_descriptor->length = 
								strlen(ChatStartMessage[ActualDataPtr[2]]);
					}
				}
				if (ActualDataPtr[0] == MUX_INITIALIZATION_START)
				{
					if (SettingUpMux)
					{
						strcpy(sptr_tx_descriptor->sptr_tx_packet, MuxInitMessage[0]);
						sptr_tx_descriptor->length = strlen(MuxInitMessage[0]);
					}
					else
					{
						strcpy(sptr_tx_descriptor->sptr_tx_packet, MuxInitMessage[1]);
						sptr_tx_descriptor->length = strlen(MuxInitMessage[1]);
					}
				}
				if (ActualDataPtr[0] == SET_WAN_DTR_SIGNAL_STATE)
				{
					/* we don't want anything to go to terminal */
					sptr_tx_descriptor->length = 0;
				}
				schedule_pkt_on_SMC(sptr_tx_descriptor);

				/* Enable interrupts */
				_SPL(save_pl);

			}
			else
			{
				*ActualDataPtr = DEF_PKT_TYPE;
				GlobalErr = ERR_PKT_TYPE;
				goto sendonsmc;
			}
 				
exitgetp:
			/* wait for a 7E. No chance of back-to-back packets coming.*/
			SMCRxState = RECV_7E;
			uim.write_index = 0;
			LastReadIndex = SMCRxreadidx;
		}
	}
}

/*****************************************************************************
	Routine	: SendModemCommand
*****************************************************************************/
void SendModemCommand(void)
{
	int		save_pl;		/* location to save interupt priority level */
	UIM_TX_DESCRIPTOR	*sptr_tx_descriptor;

	SMCRxState = RECV_MDM_RESP;
	uim.write_index = 0;

	/* Disable interrupts */
	save_pl = _GPL();
	_SPL(7);
	
	if( sptr_tx_descriptor = get_entry_from_list((LINK *) &uim.free_tx_list)) 
	{
		/* copy the modem string into the descriptorbuffer to transmit on SMC */
		strcpy(sptr_tx_descriptor->sptr_tx_packet, ModemCmds[MdmCmdIdx]);
		sptr_tx_descriptor->length = strlen(ModemCmds[MdmCmdIdx]);
		MdmCmdIdx++;

		schedule_pkt_on_SMC(sptr_tx_descriptor);
	}
	/* Enable interrupts */
	_SPL(save_pl);
	StartTimer(MDM_RESP_TIME);
}

/****************************************************************************/
/* This is going to be called from the transmit interrupt service routine */
/****************************************************************************/
void uim_tx_isr_complete(void)
{
	UIM_TX_DESCRIPTOR		*sptr_tx_descriptor;

  	if (uim.sptr_current_tx_descriptor == NULL) 
	{
		/* something went wrong */
		printf ("UIM: Panic, current_tx_descriptor NULL!\r\n");
		return;
	}
	/* add this descriptor to free list */
	add_entry_to_list (&uim.free_tx_list, (LINK *)uim.sptr_current_tx_descriptor);

	/* check on the scheduled_for_tx list for any more packets */
	sptr_tx_descriptor = get_entry_from_list ((LINK *) &uim.scheduled_for_tx);

	/* update the current_tx_descriptor for next interrupt */
	uim.sptr_current_tx_descriptor =sptr_tx_descriptor;
	if (sptr_tx_descriptor != NULL) 
		/* schedule this buffer to go */
		SendPktOnSMC(sptr_tx_descriptor->sptr_tx_packet, sptr_tx_descriptor->length);
}	

/****************************************************************************
	Routine	: Schedules a pkt to go on the SMC if it is free. Otherwise
	it saves the descriptor in the scheduled_for_tx list
****************************************************************************/
void	schedule_pkt_on_SMC(UIM_TX_DESCRIPTOR	*sptr_tx_descriptor)
{
/* Jo 25/03/99 */
	int			save_pl;		/* location to save interupt priority level */

	/* Disable interrupts */
	save_pl = _GPL();
	_SPL(7);
/* Jo 25/03/99 */

	/* first check the length of the packet */
	if(sptr_tx_descriptor->length == 0) 
	{
		/* add this descriptor to free list */
		add_entry_to_list (&uim.free_tx_list, (LINK *)sptr_tx_descriptor);
		_SPL(save_pl);  	/* Jo 25/03/99 */
		return;
	}

	/* if SMC is busy, put the packet into scheduled_for_tx list */
	if(uim.sptr_current_tx_descriptor == NULL) 
	{
		uim.sptr_current_tx_descriptor = sptr_tx_descriptor;
		SendPktOnSMC(sptr_tx_descriptor->sptr_tx_packet, sptr_tx_descriptor->length);
	} 
	else
		add_entry_to_list(&uim.scheduled_for_tx, (LINK *)sptr_tx_descriptor);
	_SPL(save_pl);  /* Jo 25/03/99 */
}

UIM_TX_DESCRIPTOR	*PrintDescriptor = NULL;
/****************************************************************************
	Routine	: Gets a tx_descriptor from the free_tx_list for printing. 
	If succesful, returns TRUE else FALSE.
****************************************************************************/
enum BOOLEAN get_a_print_descriptor(void)
{
	int		save_pl;		/* location to save interupt priority level */
	
	if( uim.enabled == FALSE) 
	{
		PrintDescriptor = NULL;
		return FALSE;
	}

	/* Disable interrupts */
	save_pl = _GPL();
	_SPL(7);
	
	if( (PrintDescriptor = get_entry_from_list(&uim.free_tx_list)) == NULL) 
	{
		/* Enable interrupts */
		_SPL(save_pl);
		return	FALSE;
	}
	PrintDescriptor->length = 0;
	/* Enable interrupts */
	_SPL(save_pl);
	return	TRUE;
}

/****************************************************************************
	Routine	: process_timeout
	Function : Called from Timer interrupt handler. Checks for condition for
	timeout and processes accordingly.
	Interrupts are already diabled
****************************************************************************/
void	process_timeout(void)
{

	StopTimer();
	ModemPresentOrNot = 0;
	if(SMCRxState == RECV_MDM_RESP) 
	{
		/* Timeout has occured with no modem response. So the modem is already 
		online or this is direct connection. So the link is up and can be used 
		for Printing. But for config - only when 7E comes. */

		uim.enabled = TRUE;
		SMCRxState = RECV_7E;
		/* This is used for searching in the Circular buffer */
		LastReadIndex = SMCRxreadidx;
	} 
	else if(SMCRxState == RECV_DATA) 
	{
		/* Packet has not arrived and timeout occured. Search for modem
		string 'NO CARRIER' in the RequestBuffer and then discard the buffer */
		if (SearchBuffForResp("NO CARRIER"))
			uim.enabled = FALSE;
		SMCRxState = RECV_7E;
		/* This is used for searching in the Circular buffer */
		LastReadIndex = SMCRxreadidx;
	}
		
}

/****************************************************************************
	Routine	: SearchBuffForResp
	Function : Looks in the linear buffer - uim.request_buffer, for the 
	specified response.
****************************************************************************/
USHORT	SearchBuffForResp(char *String) 
{
	USHORT	i,j;						
	USHORT		Strnglen;

	if (!uim.write_index)	/* Save some overhead, while waiting for responses */
		return FALSE;
	Strnglen = strlen(String);
	if (uim.write_index < Strnglen)
		return FALSE;

	for(i=0; i<= (uim.write_index - Strnglen); i++) {
		for (j = 0; j < Strnglen; j++) {
			if (uim.request_buffer[i+j] != String[j])
				break;
		}
		if(j == Strnglen)
			return TRUE;
	}
	return FALSE;
}

/****************************************************************************
	Routine	: SearchCirBuff
	Function : Looks in the circular buffer - SMCRxBuffer, for the 
	specified response. It start looking from LastReadIndex uptil the
	SMCRxwriteidx.
****************************************************************************/
USHORT	SearchCirBuff(char *String) 
{
	USHORT	i,j;						
	USHORT	Strnglen;
	USHORT	NumCharsRxed;

	if (SMCRxwriteidx == LastReadIndex)	/* Save some overhead, while waiting for responses */
		return FALSE;
	Strnglen = strlen(String);
	/* Have enough characters come ? */
	NumCharsRxed = (SMCRxwriteidx - LastReadIndex + RX_BUF_LEN) % RX_BUF_LEN;
	if( NumCharsRxed < Strnglen)
		return FALSE;

	for(i=0; i<= (NumCharsRxed - Strnglen); i++) 
	{
		for (j = 0; j < Strnglen; j++) 
		{
			if (SMCRxBuffer[(i+j+LastReadIndex)%RX_BUF_LEN] != String[j])
				break;
		}
		if(j == Strnglen) 
		{
			/* Update this value otherwise next time around, if no packets
			have come in between, we will start checking from the same place 
			and take action because of a previosly got modem response */
			LastReadIndex = (i+j+LastReadIndex) % RX_BUF_LEN;
			return TRUE;
		}
	}

	return FALSE;
}


/*Deepak 29/12/1996...*/
/****************************************************************************
*  Routine 	 :  send_packet_on_SMC 
*	Input     :  The buffer to be sent on SMC and the size of the buffer.	 *
*					 The contents of the buffer sent	to this fn are destroyed
*  Function  :  The Transmit_Descriptor is allocated and the packet is sent *
*					 on the SMC without any Quoting.										 *
****************************************************************************/
void send_packet_on_SMC (BYTE *buffer,USHORT buffer_size)
{
	USHORT		PktLength;
	int			save_pl;		/* location to save interupt priority level */
	BYTE			*sptr_tx_packet;
	UIM_TX_DESCRIPTOR	*sptr_tx_descriptor;

	/* Disable interrupts */
	save_pl = _GPL();
	_SPL(7);

	/* Quote into 1 of the tx_descriptors at offset of 1 - to add 7E */
	sptr_tx_descriptor = get_entry_from_list((LINK *) &uim.free_tx_list);
	if(sptr_tx_descriptor == NULL) 
	{
		/* no use printing a message here cause there are no free descriptors*/
		/* Enable interrupts */
		_SPL(save_pl);
		goto exitgetp;
	}
	PktLength = buffer_size;
	sptr_tx_packet = sptr_tx_descriptor->sptr_tx_packet;

	memcpy(sptr_tx_packet, buffer, PktLength);

	sptr_tx_descriptor->length = PktLength;
	schedule_pkt_on_SMC(sptr_tx_descriptor);
	/* Enable interrupts */
	_SPL(save_pl);
exitgetp:
	uim.write_index = 0;
	LastReadIndex = SMCRxreadidx;
}

/*...Deepak 29/12/1996*/

/* Jo 18/01/99 */
/*  */
/* Author	: Ravi																	*/
/* Function : check_for_resetstr_and_reset									*/
/* Scope	   : Checks for ATRESETAT and warmboots the system				*/
/*																							*/
/*  */
void check_for_resetstr_and_reset (BYTE ResetChar)
{
	if ( toupper(ResetChar) == toupper(ResetStr[ResetStrIndex]) )
		ResetStrIndex++ ;
	else
		ResetStrIndex = 0 ;

	if ( ResetStrIndex >= strlen(ResetStr) )
	{
#if	SMALL_MEM_MAP
			BootBinIOPB.BootMode = WARM_BOOT_MODE;
#else
			*DownloadFlag = WARM_BOOT_MODE ;
#endif
	 	Reset();		
	}
}
/* Jo 18/01/99 */
