/**************************************************************************
	Header file for 68360 porting
**************************************************************************/


/* the baud rates supported by hardware. These are only approximate */
/* Jo 26/04/99 */
const int BaudRateValues[] =
{
	300, 600, 1200, 2400, 4800, 9600, 19200, 38400, 57600, 115200, 230400,
	460800, 921600
};

#define	MAX_BAUD_INDEX (sizeof(BaudRateValues)/sizeof(BaudRateValues[0])-1)
#define	SYNC_MAX_BAUD_INDEX (sizeof(SyncBaudRateValues)/sizeof(SyncBaudRateValues[0])-1)
#define	DEFAULT_BAUD_INDEX 5		/* corresponds to 9600 baud */
#define	SYNC_DEFAULT_BAUD_INDEX 1		/* corresponds to 9600 baud */

/* chetan 30/9/96 */
int AsyncBaudEntries = MAX_BAUD_INDEX ;
/* chetan 30/9/96 */

/* Baud rate divisor array, this is assuming 68360 at 25MHz */
const int BRGConfigValues[] =
	{
#if __SPEED__ == 25
		0x289, 0x1456, 0xA2A, 0x514, 0x288, 0x144, 0xA0, 0x50, 0x34, 0x1A, 0xA, 0x4, 0x0
#elif __SPEED__ == 258048
		0x29F, 0x14FE, 0xA7E, 0x53E, 0x29E, 0x14E, 0xA6, 0x52, 0x36, 0x1A, 0xC, 0x6, 0x2
#else
&&&& - to check for null def
#endif
	};

CommonInitSCC(void);

InitSCC(USHORT port_number);


int GetBaudDivisor(int ActualBaudRate);

typedef struct tagRXBD {
	WORD	RxStat;
	WORD	RxLen;
	DWORD	RxPntr;
}RXBDType;

typedef struct tagTXBD {
	WORD	TxStat;
	WORD	TxLen;
	DWORD	TxPntr;
}TXBDType;

#ifdef DDDDEBUG
#define	ModBaseAdr      $0FFFF0000
#if 0
#define	ETH_NO_RX_BD	$8
#define	ETH_NO_TX_BD	$4

#define	WAN_NO_RX_BD	$2
#define	WAN_NO_TX_BD	$4
#endif

#define	OFFSETETHRXBD	$60
#define	OFFSETETHTXBD	(OFFSETETHRXBD+8*ETH_NO_RX_BD)

#define	OFFSETWAN1RXBD	(OFFSETETHTXBD+8*ETH_NO_TX_BD)
#define	OFFSETWAN1TXBD	(OFFSETWAN1RXBD+8*WAN_NO_RX_BD)

#define	OFFSETWAN2RXBD	(OFFSETWAN1TXBD+8*WAN_NO_TX_BD)
#define	OFFSETWAN2TXBD	(OFFSETWAN2RXBD+8*WAN_NO_RX_BD)

#define	OFFSETWAN3RXBD	(OFFSETWAN2TXBD+8*WAN_NO_TX_BD)
#define	OFFSETWAN3TXBD	(OFFSETWAN3RXBD+8*WAN_NO_RX_BD)


#define	ETHRXBD	(ModBaseAdr+OFFSETETHRXBD)
#define	ETHTXBD	(ModBaseAdr+OFFSETETHTXBD)

#define	WAN1RXBD	(ModBaseAdr+OFFSETWAN1RXBD)
#define	WAN1TXBD	(ModBaseAdr+OFFSETWAN1TXBD)

#define	WAN2RXBD	(ModBaseAdr+OFFSETWAN2RXBD)
#define	WAN2TXBD	(ModBaseAdr+OFFSETWAN2TXBD)


#define	WAN3RXBD	(ModBaseAdr+OFFSETWAN3RXBD)
#define	WAN3TXBD	(ModBaseAdr+OFFSETWAN3TXBD)
#endif

#define  NUMBER_OF_SCC_RX_BDS    2 /* defined in ..\driver.inc asm file */

#define	SAFE_LEVEL	7
