/****************************************************************************
   File        : Shell.c
   Atuhor      : SUDHIR.K
   Date        : 23/6/97 
******************************************************************************/


#include	<defs.h>
#include <string.h>
#include	<stdlib.h>
#include	<stdio.h>
#include	<stdarg.h>
#include <udb.h>
#include "wan.h"

#ifdef _BIG_PROXY_

BYTE SHELL_menu_hdr[] = 
"\n\r\
\n\r\
\t\tShell Menu\n\r\
\t\t-----------\n\n\r";

/* sudhir 30/6/97 */
char logged_off[] = "\n\rYou are logged off\n\r";


char tc_user_name_prompt[] = "\n\n\n\n\rlogin: ";
char tc_password_prompt[] = "\n\r\\n\rEnter password: ";
char tc_invalid_user_name[] = 
"\n\r\n\rInvalid User Name!!!\n\r\
\nlogin: ";

char tc_invalid_user_password[] = 
"\n\r\n\rInvalid Password!!!\n\r\
\nEnter Password: ";

char invalid_response[] =
"\n\n\rInvalid response!!!\n\r\
\nEnter Choice: ";
char no_users_message[] = "\n\rNo inbound users on ths port\n\r" ;
char termser_dis[] = "\n\rTerminal Server Disabled\n\r";



/* sudhir new change */
USHORT menu_status[5];

extern enum BOOLEAN is_ppp_enabled_for_port (port_number);
/* Jo extern enum BOOLEAN is_slip_enabled_for_port (port_number);*/
extern enum BOOLEAN check_if_slip_is_enabled(USHORT port_num) ;
extern int ag_get_number_of_inbound_users (port_number);



USHORT total_number_of_options=0;
USHORT number_of_name_retries[3];
USHORT number_of_password_retries[3];
BYTE  *user_entry ;
#define NUMBER_OF_RETRIES 3

void non_ppp_packet_received_during_packet_analysis (USHORT port_number, BYTE *sptr_packet);




BYTE menu_buffer[NUMBER_OF_SERIAL_PORTS][200];

/* This function will get dynamic shell menu depending on the status of
	PPP, SLIP, Ag and terminal server */

void get_initial_shell_menu (USHORT port_number)
{
   static BYTE PPP_menu[]   = "%d. PPP\n\r";
   static BYTE SLIP_menu[]  = "%d. SLIP\n\r";
   static BYTE AG_menu[]    = "%d. AG Inbound\n\r";
   static BYTE Telnet_menu[]= "%d. Telnet to Host\n\r";
	static BYTE logoff[] = "%d. logoff\n\r";
   static BYTE yourchoice[] = "\n\rEnter Choice: "; 

   BYTE temp_buffer[50];
   USHORT index=1;
	menu_status[0] = 0; menu_status[1] = 0; menu_status[2] = 0;
	menu_status[4] = 0; menu_status[5] = 0;





   
   strcpy (menu_buffer[port_number],SHELL_menu_hdr);

/* write a new function */
   total_number_of_options = 0;
   
   if (is_ppp_enabled_for_port(port_number))
   {
      sprintf (temp_buffer, PPP_menu, index++);
      strcat (menu_buffer[port_number], temp_buffer);
      menu_status[0] = 1;
      total_number_of_options++;
   }   
     
/* use existing function */
   if (check_if_slip_is_enabled (port_number))
   {
      sprintf (temp_buffer, SLIP_menu, index++);         
      strcat (menu_buffer[port_number], temp_buffer);
      menu_status[1] = 1;
      total_number_of_options++;
   }      
      
/* user existing function */
   if (ag_get_number_of_inbound_users (port_number))
   {
      sprintf (temp_buffer, AG_menu, index++);         
      strcat (menu_buffer[port_number], temp_buffer);
      menu_status[2] = 1;
      total_number_of_options++;
   }

/* use existing one */
   if (is_term_server_enabled (port_number))
   {
      sprintf (temp_buffer, Telnet_menu, index++);         
      strcat (menu_buffer[port_number], temp_buffer);
      menu_status[3] = 1;
      total_number_of_options++;
   }

	total_number_of_options += 1;
	sprintf (temp_buffer, logoff, index++);
	strcat (menu_buffer[port_number], temp_buffer);
	menu_status[4] = 1;
	

   strcat (menu_buffer[port_number],yourchoice);
   return;
}




USHORT get_user_response_to_shell_menu (USHORT port_number, BYTE *buffer)
{
   USHORT rcvd_option = 0;   

   if (strlen(buffer) != 1) 
	{
/*		wan.port[port_number].shell_menu_on = SHELL_MENU_OFF ; */
		wan.port[port_number].analysed_once = FALSE ;
		WriteToPort (port_number, invalid_response, strlen (invalid_response)) ;
		return (0) ;
	}

   switch (*buffer)
	{
		case ('1') :
         rcvd_option = 1;
         break;

		case ('2') :
         rcvd_option = 2;
         break;

		case ('3') :
         rcvd_option = 3;
         break;

		case ('4') :
         rcvd_option = 4;
         break;

		case ('5') :
			rcvd_option = 5;
         break;

		default :
			WriteToPort (port_number, invalid_response, strlen (invalid_response)) ;
			wan.port[port_number].analysed_once = FALSE ;
         return 0;
	} 
   if (rcvd_option > total_number_of_options)
   {
      WriteToPort (port_number, invalid_response, strlen (invalid_response)) ;
      return 0;
   }

   return rcvd_option ;
         
}

enum SHELL_MENU_RESPONSE get_actual_choice (USHORT actual_choice)
{
   USHORT mapped_value=0;
   USHORT  index_of_option;


   if (actual_choice > 0)
   {
      for (index_of_option = 0; index_of_option < 5; index_of_option++)
      {
         mapped_value++;

         if (menu_status[index_of_option] == 1)
            actual_choice--;     

         if (!actual_choice)            
            break;               
      }
   }
   else
   {
     mapped_value = INVALID_OPTION;
   }

   return mapped_value;
}

void process_the_shell_menu_response (USHORT port_number, BYTE *buffer)
{
   USHORT rcvd_option =0;

   rcvd_option = get_user_response_to_shell_menu (port_number,buffer);
   
   switch (get_actual_choice (rcvd_option))
   {
      case INVALID_OPTION:
			
         WriteToPort (port_number, invalid_response, strlen (invalid_response)) ;
         break;

      case PPP_SHELL_OPTION:
         wan_printf (WAN_RX_PRINTF, "WAN : Starting PPP on port %04X\n", port_number) ;
			wan.port[port_number].packet_analysis_on = FALSE ;
			change_protocol_to_async_hdlc (port_number) ;
			lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
      			LOWER_DEVICE_DRIVER_UP, port_number) ;
			lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
		   		OPEN_DEVICE_DRIVER_PORT, port_number) ;
#if PROXY_SERVER
         wan.port[port_number].statistics.connection_up_time = 0 ;
         wan.port[port_number].statistics.connection_bytes_transmitted = 0 ;
         wan.port[port_number].statistics.connection_bytes_received = 0 ;
         wan.port[port_number].statistics.connection_packets_transmitted = 0 ;
         wan.port[port_number].statistics.connection_packets_received = 0 ;
         wan.port[port_number].statistics.number_of_calls++ ;
#endif

			wan.port[port_number].shell_menu_on = SHELL_MENU_OFF ;
			wan.port[port_number].analysed_once = FALSE ;
			break ;

      case SLIP_SHELL_OPTION:
         wan_printf (WAN_RX_PRINTF, "WAN : SLIP packet received on port %d\n", port_number) ;
			wan.port[port_number].packet_analysis_on = FALSE ;
			wan.port[port_number].shell_menu_on = SHELL_MENU_OFF ;
			wan.port[port_number].analysed_once = FALSE ;
			change_protocol_to_async(port_number, TRUE, SLIP_MODE);
			lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
      			LOWER_DEVICE_DRIVER_SLIP_UP, port_number);
			lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
					OPEN_DEVICE_DRIVER_PORT, port_number);
#if PROXY_SERVER
         wan.port[port_number].statistics.connection_up_time = 0 ;
         wan.port[port_number].statistics.connection_bytes_transmitted = 0 ;
         wan.port[port_number].statistics.connection_bytes_received = 0 ;
         wan.port[port_number].statistics.connection_packets_transmitted = 0 ;
         wan.port[port_number].statistics.connection_packets_received = 0 ;
         wan.port[port_number].statistics.number_of_calls++ ;
#endif

			break ;

      case AG_SHELL_OPTION:
#if 0
         if (allot_port_to_inbound_if_required (port_number) == FALSE)
			{
   			WriteToPort (port_number, no_users_message, strlen (no_users_message)) ;
            printf ("from AG inbound\n");               
				wan.port[port_number].packet_analysis_on = TRUE ;
				wan.port[port_number].shell_menu_on = SHELL_MENU_OFF ;
				wan.port[port_number].analysed_once = FALSE ;
			}
			else
			{
				wan.port[port_number].packet_analysis_on = FALSE ;
				wan.port[port_number].shell_menu_on = SHELL_MENU_OFF ;
				wan.port[port_number].analysed_once = FALSE ;
				start_analysing_packets_on_port (port_number) ;
			}
#endif
         break;

      case TELNET_OPTION:
         if (!is_term_server_enabled (port_number))
         {
            WriteToPort (port_number, termser_dis, strlen (termser_dis));
            break;
         }
			init_terminal_server ((USHORT) port_number) ;
	   	wan.port[port_number].packet_analysis_on = FALSE ;
			wan.port[port_number].shell_menu_on = SHELL_MENU_OFF ;
      	wan.port[port_number].analysed_once = FALSE ;
         break;

		case SHELL_LOGOFF:
			WriteToPort (port_number, logged_off, strlen (logged_off));
			wan.port[port_number].shell_menu_on = SHELL_MENU_LOGIN_PROMPT_SENT;
			wan.port[port_number].packet_analysis_on = TRUE;
			wan.port[port_number].shell_menu_response_length = 0;
			break;

      default:
         WriteToPort (port_number, invalid_response, strlen (invalid_response)) ;
         break;
   }
   return;
}


void check_for_user_name_and_send_prompt (USHORT port_number)
{

   if (get_ras_number_of_users () == 0)
   {
      /* send the shell menu here */
/*      wan.port[port_number].shell_menu_on = SHELL_MENU_SENT; */
      non_ppp_packet_received_during_packet_analysis (port_number,NULL);
   }
   else
   {
      WriteToPort (port_number, &tc_user_name_prompt[0], strlen (&tc_user_name_prompt[0])) ;
   	wan.port[port_number].shell_menu_on = SHELL_MENU_USER_NAME_RECEIVED;
   }
}

enum BOOLEAN check_if_valid_user_name (BYTE *buffer)
{
	if (strlen (buffer) ==  0)
		return FALSE;

	while (*buffer)
   {
      if (*buffer != ' ' && *buffer != '\t')
         return TRUE;
      buffer++;
   }         
	return FALSE;
}

void validate_username_and_process (USHORT port_number, BYTE *buffer)
{
   BYTE *user_index;
	static char invalid_user_name[] = 
      "\n\r\n\rInvalid User Name!!!\n\r\
   \n\b\b\blogin: ";

	if (!check_if_valid_user_name (buffer))
	{
		WriteToPort (port_number, &tc_user_name_prompt[0], strlen (&tc_user_name_prompt[0])) ;
		return;
	}

		
   if (is_valid_ras_user (buffer) == NULL)
   {
		WriteToPort (port_number, &invalid_user_name[0], strlen (&invalid_user_name[0])) ;

       number_of_name_retries[port_number]++;
/*       if (number_of_name_retries[port_number] >= NUMBER_OF_RETRIES)
       {
           number_of_name_retries[port_number] = 0;
       } */
       printf ("Invalid User\n");
   }
   else
   {
      user_index =(BYTE *)get_ptr_to_udb_record (buffer);
      if (user_index == NULL)
      {
         printf ("Invalid User 1\n");
         return;
      }
      if (has_ras_user_password (user_index))
      {
         user_entry = (BYTE *)get_ptr_to_udb_record (buffer);
         WriteToPort (port_number, &tc_password_prompt[0], strlen (&tc_password_prompt[0])) ;
         wan.port[port_number].shell_menu_on = SHELL_MENU_PASSWORD_PROMPT_SENT;
      }
      else
      {
/*         wan.port[port_number].shell_menu_on = SHELL_MENU_SENT; */
           non_ppp_packet_received_during_packet_analysis (port_number,NULL);
      }
   }
}


void validate_user_password_and_process (USHORT port_number, BYTE *buffer)
{

   if (is_valid_ras_user_password ((BYTE *) user_entry, (char *) buffer))
   {
/*      wan.port[port_number].shell_menu_on = SHELL_MENU_SENT; */
      non_ppp_packet_received_during_packet_analysis (port_number,NULL);
   }
   else
   {
       number_of_password_retries[port_number]++;
       if (number_of_password_retries[port_number] >= NUMBER_OF_RETRIES)
       {
          number_of_password_retries[port_number] = 0;
          WriteToPort (port_number, &tc_user_name_prompt[0], strlen (&tc_user_name_prompt[0])) ;
          wan.port[port_number].shell_menu_on = SHELL_MENU_USER_NAME_RECEIVED;
          return;
          /* do necessary actions */
       }
       WriteToPort (port_number, &tc_invalid_user_password[0], strlen (&tc_invalid_user_password[0])) ;
   }
}

void non_ppp_packet_received_during_packet_analysis (USHORT port_number, BYTE *sptr_packet)
{

	wan.port[port_number].shell_menu_on = SHELL_MENU_ANALYSIS ;
	wan.port[port_number].analysed_once = FALSE ;
	wan.port[port_number].shell_menu_response[0] = 0 ;
	wan.port[port_number].shell_menu_response_length = 0 ;
	wan.port[port_number].shell_menu_idle_timer = SHELL_MENU_MAX_IDLE_TIME ;


/* sudhir planning to change 
   get dynamically constructed menu instead of sending initial_menu
   call get_initial_shell_menu */
   
	/* Send the shell menu now */
   get_initial_shell_menu (port_number);
	WriteToPort (port_number, menu_buffer[port_number], strlen (menu_buffer[port_number])) ;
}

#endif

