#include	"defs.h"
/*	$Modname: asynconf.c$  $version: 1.2$      $date: 12/01/94$   */
/*
* 	$lgb$
1.0 09/22/94 ross initial release.
1.1 09/22/94 ross
1.2 12/01/94 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 Router Engines, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<stddef.h>
#include	<string.h>
#include	<stdio.h>
#include "wan.h"
#include	<cnffile.h>
#include	<vnvrmstr.h>
#include	"vnvwan.h"
#include	<wanmgr.h>

/* Sachin 18/06/1996 */
/* Jo 26/04/99 */
const char *wan_conf_return_strings[] =
{
	"\n\rPort available for configuration\n\r",
	"\n\rPort disabled - not available for configuration.\n\r",
	"\n\rPort in use - not available for configuration.\n\r",
	"\n\rDial on demand ports not available for configuration\n\r",
	NULL
} ;

/* Sachin 18/06/1996 */

/* Jo */
int wan_read_configuration (char *cptr_config) ;
void print_wan_configured_parameters () ;


/****************************************************************************/
static enum WAN_PORT_OWNER wandrv_wan_owner[NUMBER_OF_SERIAL_PORTS];

void init_wan_port_owner_table()
{
	int i;

	for (i = 0; i < NUMBER_OF_SERIAL_PORTS; i++)
		wandrv_wan_owner[i] = OWNED_BY_NONE;
}

/* NOTE: Following call will unconditionally change ownership assuming
** the calling code knows what it is doing.
*/
void set_wan_port_owner(USHORT port_number, enum WAN_PORT_OWNER wan_owner)
{
	wandrv_wan_owner[port_number] = wan_owner;

	if (wan.port[port_number].enabled == FALSE)
		return ;

	switch (wan_owner)
	{
		case OWNED_BY_NONE:
			/* Restart the modem state machine of the regular WAN driver */
			InitSCC(port_number);
/*			if (wan.port[port_number].asyncport == TRUE)
				initialize_connection_on_port(port_number);
			wan_control((enum DEVICE_CONTROL_OPERATION) OPEN_SERIAL_PORT, port_number, 0); 
			SetLineConfigUART(SET_CONF_SET_SIGS, LINE_STAT_DTR, port_number); */
			break;

		/* If new owners are AG or TELNET, we don't need the WANDRV buffers. */

		case OWNED_BY_TELNET:
			Flush_Rx_Tx_Buffers(port_number);
			break ;

		case OWNED_BY_AG:
			Flush_Rx_Tx_Buffers(port_number);
			break;

		case OWNED_BY_PPP:
			/* In case of PPP, the buffers will be released by the call to change
			** protocol to HDLC. This will happen immediately.
			*/
			break;

/* Jo 17/5/99 SLIP not handled in LCPR */
#ifdef _BIG_PROXY_	
		/* Kamalnath SLIP 07\03\1997 */
		case OWNED_BY_SLIP :
			break;
		/* Kamalnath SLIP 07\03\1997 */
#endif
/* Jo 17/5/99 SLIP not handled in LCPR */

	}
}

enum WAN_PORT_OWNER get_wan_port_owner(USHORT port_number)
{
	return wandrv_wan_owner[port_number];
}

/* ----------- Functions retrieving configuration information ---------- */

enum BOOLEAN is_wan_enabled(USHORT port_number)
{
	return wan.port[port_number].enabled;	
}

enum BOOLEAN is_wan_direct_connect(USHORT port_number)
{
	return wan.port[port_number].direct_connect_enabled;
}

enum BOOLEAN is_wan_async(USHORT port_number)
{
	return (wan.port[port_number].asyncport);
}

ULONG get_wan_configured_baud_rate(USHORT port_number)
{
	if (wan.port[port_number].asyncport == TRUE)
		return wan.port[port_number].port_speed;
/*	Jo else
		 return wan.port[port_number].sync_port_speed; */
}

char **get_wan_modem_init_strings(USHORT port_number, char **modem_init_strings)
{
	int i;

	for (i = 0; i < 5; i++)
		*(modem_init_strings + i) = &wan.port[port_number].modem_info.strings.init_string[i][0];
	return modem_init_strings;
}

char *get_wan_modem_hangup_string(USHORT port_number)
{
	return wan.port[port_number].modem_info.strings.modem_hangup_string;
}

char *get_wan_modem_dial_prefix(USHORT port_number)
{
	return wan.port[port_number].modem_info.strings.modem_dial_prefix;
}

char *get_wan_modem_dial_suffix(USHORT port_number)
{
	return wan.port[port_number].modem_info.strings.modem_dial_suffix;
}

enum BOOLEAN is_wan_port_answering (USHORT port_number)
{
	return (wan.port[port_number].modem_info.configured_auto_answer) ;
}

/* Sachin 18/12/1996 */

enum WAN_PORT_AVAILABILITY is_port_available_for_configuration (USHORT port_number)
{
	if (wan.port[port_number].enabled == FALSE)
		return (PORT_DISABLED) ;

	if (is_wan_port_answering (port_number) == TRUE)
	{
		/* Answering port */

		if (get_wan_port_owner (port_number) != OWNED_BY_NONE)
			return (PORT_IN_USE) ;
		else
			return (PORT_AVAILABLE_FOR_CONFIGURATION) ;
	}
	else
	{
		/* Dialing port */
/*		if (is_port_dial_on_demand (port_number) == TRUE)
			return (PORT_DIAL_ON_DEMAND) ;*/

		if (get_wan_port_owner (port_number) == OWNED_BY_NONE)
			return (PORT_AVAILABLE_FOR_CONFIGURATION) ;

		if (is_DCD_present (port_number) == TRUE)
			return (PORT_IN_USE) ;

		return (PORT_AVAILABLE_FOR_CONFIGURATION) ;
	}
}

/* Sachin 18/12/1996 */

/* chetan 5/11/96 */
int EnquirePortOwner (USHORT port_number)
{
	switch (get_wan_port_owner (port_number))
	{
		case OWNED_BY_NONE :
			set_wan_port_owner (port_number, OWNED_BY_PPP) ;
			return 1 ;

		case OWNED_BY_PPP :
			return 1 ;

/* Jo 17/5/99 SLIP not handled in LCPR */
#ifdef _BIG_PROXY_	
		/* Kamalnath SLIP 07\03\1997 */
		case OWNED_BY_SLIP :
			return 0 ;
		/* Kamalnath SLIP 07\03\1997 */
#endif
/* Jo 17/5/99 SLIP not handled in LCPR */
		
		default :
			return 0 ;
	}
}
/* chetan 5/11/96 */


/* sudhir for proxy server */

/* Jo 22/04/99 */
#if 0
USHORT get_wan_port_tx_buffer_size (USHORT port_number)
{

/* this is to be removed */
	return wan.port[port_number].statistics.number_of_bytes_txed;
}

enum BOOLEAN is_enough_buffer_is_free (USHORT port_number)
{
	
  if (wan.port[port_number].statistics.number_of_bytes_to_tx > (((NUMBER_OF_TX_BUFFERS * 1500) * 1) / (128*100)))
		return FALSE;

	return TRUE;			
}
#endif
/* Jo 22/04/99 */

/* Jo 24/07/98 : reads the WAN configuration from flash into WAN_CLASS 
					  starting from the location specified by cptr_config */

int wan_read_configuration (char *cptr_config)
{
	 CNF_WAN *wan_ptr ;
	 USHORT port_index ;

	 wan_ptr = (CNF_WAN *)cptr_config ;
	 if (wan_ptr->wan_header.magic_number != CNF_WAN_MAGIC_NUMBER)
			return (0) ;

	 wan.enabled = wan_ptr->wan_header.enabled ;
	 wan.number_of_ports = wan_ptr->wan_header.number_of_ports ;

	 for (port_index = 0; port_index < wan.number_of_ports; port_index++)
	 {
			wan.port[port_index].enabled = wan_ptr->wan_ports[port_index].enabled ;
			wan.port[port_index].port_speed = wan_ptr->wan_ports[port_index].speed ;
			wan.port[port_index].asyncport = TRUE;
			wan.port[port_index].direct_connect_enabled = wan_ptr->wan_ports[port_index].direct_connect ;
			wan.port[port_index].modem_info.configured_auto_answer = wan_ptr->wan_ports[port_index].auto_answer ; 

		   strcpy (wan.port[port_index].modem_info.strings.modem_type, wan_ptr->wan_ports[port_index].modem_type);
			strcpy (wan.port[port_index].modem_info.strings.init_string[0], wan_ptr->wan_ports[port_index].modem_init_string1) ;
			strcpy (wan.port[port_index].modem_info.strings.init_string[1], wan_ptr->wan_ports[port_index].modem_init_string2) ;
			strcpy (wan.port[port_index].modem_info.strings.init_string[2], wan_ptr->wan_ports[port_index].modem_init_string3) ;
			strcpy (wan.port[port_index].modem_info.strings.init_string[3], wan_ptr->wan_ports[port_index].modem_init_string4) ;
			strcpy (wan.port[port_index].modem_info.strings.init_string[4], wan_ptr->wan_ports[port_index].modem_init_string5) ;
			strcpy (wan.port[port_index].modem_info.strings.modem_dial_prefix, wan_ptr->wan_ports[port_index].dial_prefix) ;
			strcpy (wan.port[port_index].modem_info.strings.modem_dial_suffix, wan_ptr->wan_ports[port_index].dial_suffix) ;
			strcpy (wan.port[port_index].modem_info.strings.modem_dial_number, wan_ptr->wan_ports[port_index].dial_number) ;
			strcpy (wan.port[port_index].modem_info.strings.modem_ring_mesg, wan_ptr->wan_ports[port_index].ring_message) ;
			strcpy (wan.port[port_index].modem_info.strings.modem_hangup_string, wan_ptr->wan_ports[port_index].hangup_string) ;
			strcpy (wan.port[port_index].modem_info.strings.modem_ok_mesg, wan_ptr->wan_ports[port_index].ok_message) ;
			strcpy (wan.port[port_index].modem_info.strings.modem_no_carrier_mesg, wan_ptr->wan_ports[port_index].no_carrier_message) ;
			strcpy (wan.port[port_index].modem_info.strings.modem_error_mesg, wan_ptr->wan_ports[port_index].error_message) ;
			strcpy (wan.port[port_index].modem_info.strings.modem_no_dial_tone_mesg, wan_ptr->wan_ports[port_index].no_dial_tone_message) ;
			strcpy (wan.port[port_index].modem_info.strings.modem_busy_mesg, wan_ptr->wan_ports[port_index].busy_message) ;
			strcpy (wan.port[port_index].modem_info.strings.modem_no_answer_mesg, wan_ptr->wan_ports[port_index].no_answer_message) ;
			strcpy (wan.port[port_index].modem_info.strings.modem_response_string, wan_ptr->wan_ports[port_index].response_string) ;
			wan.port[port_index].connection_started_by_DCD = TRUE ;
			wan.port[port_index].connection_dropped_by_DCD = TRUE ;
			wan.port[port_index].connection_started_by_modem_response = TRUE ;
			wan.port[port_index].sync_xmit_idle_flags = TRUE ;
			wan.port[port_index].script_enabled = wan_ptr->wan_ports[port_index].script_enabled ;
			wan.port[port_index].restart_script_on_comm_failure = wan_ptr->wan_ports[port_index].restart_script_on_comm_failure ;
	 }			

#if PRINT_CONFIG
	print_wan_configured_parameters() ;
#endif
	 return (wan_ptr->wan_header.section_length) ;
}

/* Jo 19/04/99 */
#if PRINT_CONFIG
void print_wan_configured_parameters()
{
	 char buffer1[3000], buffer2[3000], buffer3[3000] ;

	 sprintf (buffer1, "wan_enabled : %d\n"
							 "no_of_ports : %d\n"
							 "PORT 0\n"
							 "enabled  : %d\n"
							 "port speed : %lu\n"
							 "async port : %d\n"
							 "direct_connect_enabled : %d\n"
							 "MODEM INFO \n"
							 "auto_answer : %d\n"
							 "modem type : %s\n"
							 "init 1 : %s\n"
							 "init 2 : %s\n"
							 "init 3 : %s\n"
							 "init 4 : %s\n"
							 "init 5 : %s\n"
							 "dial prefix : %s\n"
							 "dial suffix : %s\n"
							 "dial no : %s\n"
							 "ring msg : %s\n"
							 "hangup str : %s\n"
							 "ok msg : %s\n"
							 "no carrier msg: %s\n"
							 "error msg : %s\n"
							 "no dial tone msg : %s\n"
							 "busy msg : %s\n"
							 "no answer msg : %s\n"
							 "modem response : %s\n"
							 "conn started by DCD : %d\n"
							 "conn dropped by DCD : %d\n"
							 "conn started by modem : %d\n"
							 "sync xmit idle flag : %d\n"
							 "script enabled : %d\n"
							 "restart script : %d\n",
							 wan.enabled,
							 wan.number_of_ports,
							 wan.port[0].enabled,
							 wan.port[0].port_speed,
							 wan.port[0].asyncport,
							 wan.port[0].direct_connect_enabled,
							 wan.port[0].modem_info.configured_auto_answer,
							 wan.port[0].modem_info.strings.modem_type,
							 wan.port[0].modem_info.strings.init_string[0],
							 wan.port[0].modem_info.strings.init_string[1],
							 wan.port[0].modem_info.strings.init_string[2],
							 wan.port[0].modem_info.strings.init_string[3],
							 wan.port[0].modem_info.strings.init_string[4],
							 wan.port[0].modem_info.strings.modem_dial_prefix,
							 wan.port[0].modem_info.strings.modem_dial_suffix,
							 wan.port[0].modem_info.strings.modem_dial_number,
							 wan.port[0].modem_info.strings.modem_ring_mesg, 
							 wan.port[0].modem_info.strings.modem_hangup_string,
							 wan.port[0].modem_info.strings.modem_ok_mesg,
							 wan.port[0].modem_info.strings.modem_no_carrier_mesg,
							 wan.port[0].modem_info.strings.modem_error_mesg,
							 wan.port[0].modem_info.strings.modem_no_dial_tone_mesg,
							 wan.port[0].modem_info.strings.modem_busy_mesg,
							 wan.port[0].modem_info.strings.modem_no_answer_mesg, 
							 wan.port[0].modem_info.strings.modem_response_string,
							 wan.port[0].connection_started_by_DCD,
							 wan.port[0].connection_dropped_by_DCD,
							 wan.port[0].connection_started_by_modem_response,
							 wan.port[0].sync_xmit_idle_flags,
							 wan.port[0].script_enabled,
							 wan.port[0].restart_script_on_comm_failure) ;


	 sprintf (buffer2, "PORT 1\n"
							 "enabled  : %d\n"
							 "port speed : %lu\n"
							 "async port : %d\n"
							 "direct_connect_enabled : %d\n"
							 "MODEM INFO \n"
							 "auto_answer : %d\n"
							 "modem type : %s\n"
							 "init 1 : %s\n"
							 "init 2 : %s\n"
							 "init 3 : %s\n"
							 "init 4 : %s\n"
							 "init 5 : %s\n"
							 "dial prefix : %s\n"
							 "dial suffix : %s\n"
							 "dial no : %s\n"
							 "ring msg : %s\n"
							 "hangup str : %s\n"
							 "ok msg : %s\n"
							 "no carrier msg: %s\n"
							 "error msg : %s\n"
							 "no dial tone msg : %s\n"
							 "busy msg : %s\n"
							 "no answer msg : %s\n"
							 "modem response : %s\n"
							 "conn started by DCD : %d\n"
							 "conn dropped by DCD : %d\n"
							 "conn started by modem : %d\n"
							 "sync xmit idle flag : %d\n"
							 "script enabled : %d\n"
							 "restart script : %d\n",
							 wan.port[1].enabled,
							 wan.port[1].port_speed,
							 wan.port[1].asyncport,
							 wan.port[1].direct_connect_enabled,
							 wan.port[1].modem_info.configured_auto_answer,
							 wan.port[1].modem_info.strings.modem_type,
							 wan.port[1].modem_info.strings.init_string[0],
							 wan.port[1].modem_info.strings.init_string[1],
							 wan.port[1].modem_info.strings.init_string[2],
							 wan.port[1].modem_info.strings.init_string[3],
							 wan.port[1].modem_info.strings.init_string[4],
							 wan.port[1].modem_info.strings.modem_dial_prefix,
							 wan.port[1].modem_info.strings.modem_dial_suffix,
							 wan.port[1].modem_info.strings.modem_dial_number,
							 wan.port[1].modem_info.strings.modem_ring_mesg, 
							 wan.port[1].modem_info.strings.modem_hangup_string,
							 wan.port[1].modem_info.strings.modem_ok_mesg,
							 wan.port[1].modem_info.strings.modem_no_carrier_mesg,
							 wan.port[1].modem_info.strings.modem_error_mesg,
							 wan.port[1].modem_info.strings.modem_no_dial_tone_mesg,
							 wan.port[1].modem_info.strings.modem_busy_mesg,
							 wan.port[1].modem_info.strings.modem_no_answer_mesg, 
							 wan.port[1].modem_info.strings.modem_response_string,
							 wan.port[1].connection_started_by_DCD,
							 wan.port[1].connection_dropped_by_DCD,
							 wan.port[1].connection_started_by_modem_response,
							 wan.port[1].sync_xmit_idle_flags,
							 wan.port[1].script_enabled,
							 wan.port[1].restart_script_on_comm_failure) ;

	 sprintf (buffer3, "PORT 0\n"
							 "enabled  : %d\n"
							 "port speed : %lu\n"
							 "async port : %d\n"
							 "direct_connect_enabled : %d\n"
							 "MODEM INFO \n"
							 "auto_answer : %d\n"
							 "modem type : %s\n"
							 "init 1 : %s\n"
							 "init 2 : %s\n"
							 "init 3 : %s\n"
							 "init 4 : %s\n"
							 "init 5 : %s\n"
							 "dial prefix : %s\n"
							 "dial suffix : %s\n"
							 "dial no : %s\n"
							 "ring msg : %s\n"
							 "hangup str : %s\n"
							 "ok msg : %s\n"
							 "no carrier msg: %s\n"
							 "error msg : %s\n"
							 "no dial tone msg : %s\n"
							 "busy msg : %s\n"
							 "no answer msg : %s\n"
							 "modem response : %s\n"
							 "conn started by DCD : %d\n"
							 "conn dropped by DCD : %d\n"
							 "conn started by modem : %d\n"
							 "sync xmit idle flag : %d\n"
							 "script enabled : %d\n"
							 "restart script : %d\n",
							 wan.port[2].enabled,
							 wan.port[2].port_speed,
							 wan.port[2].asyncport,
							 wan.port[2].direct_connect_enabled,
							 wan.port[2].modem_info.configured_auto_answer,
							 wan.port[2].modem_info.strings.modem_type,
							 wan.port[2].modem_info.strings.init_string[0],
							 wan.port[2].modem_info.strings.init_string[1],
							 wan.port[2].modem_info.strings.init_string[2],
							 wan.port[2].modem_info.strings.init_string[3],
							 wan.port[2].modem_info.strings.init_string[4],
							 wan.port[2].modem_info.strings.modem_dial_prefix,
							 wan.port[2].modem_info.strings.modem_dial_suffix,
							 wan.port[2].modem_info.strings.modem_dial_number,
							 wan.port[2].modem_info.strings.modem_ring_mesg, 
							 wan.port[2].modem_info.strings.modem_hangup_string,
							 wan.port[2].modem_info.strings.modem_ok_mesg,
							 wan.port[2].modem_info.strings.modem_no_carrier_mesg,
							 wan.port[2].modem_info.strings.modem_error_mesg,
							 wan.port[2].modem_info.strings.modem_no_dial_tone_mesg,
							 wan.port[2].modem_info.strings.modem_busy_mesg,
							 wan.port[2].modem_info.strings.modem_no_answer_mesg, 
							 wan.port[2].modem_info.strings.modem_response_string,
							 wan.port[2].connection_started_by_DCD,
							 wan.port[2].connection_dropped_by_DCD,
							 wan.port[2].connection_started_by_modem_response,
							 wan.port[2].sync_xmit_idle_flags,
							 wan.port[2].script_enabled,
							 wan.port[2].restart_script_on_comm_failure) ;

 	 printf ("buffer1 : %s\n", buffer1) ;
 	 printf ("buffer2 : %s\n", buffer2) ;
 	 printf ("buffer3 : %s\n", buffer3) ;
}
#endif
