#include	"defs.h"
/*	                                                          				
* $lgb$
1.0 04/05/94 ross
1.1 04/05/94 ross initial release
1.2 09/22/94 ross
1.3 12/01/94 ross
* $lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1992 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/*	$Modname: wanrx.c$  $version: 1.3$      $date: 12/01/94$   */
/************************************************************************/
#include <string.h>
#include "wan.h"
#include <softquot.h>
#include "modemsup.h"



extern int check_and_verify_async_packet_received(USHORT port_number);

extern ULONG get_pointer_to_first_filled_bd (USHORT) ;
void non_ppp_packet_received_during_packet_analysis (USHORT port_number, BYTE *sptr_packet) ;
#if 0	/* Jo */
int shell_menu_packet_received (USHORT port_number, BYTE *, USHORT) ;
void shell_menu_timer (USHORT port_number) ;
void shell_menu_state_machine (USHORT port_number, BYTE *buffer);
#endif /* Jo */
/* sudhir 25/4/97 */
extern enum BOOLEAN is_term_server_enabled (USHORT port_number);

extern ULONG  timer_ulong;
/* Jo 22/04/99 */
#if 0
ULONG pkt_in_time;
ULONG pkt_out_time;
ULONG RxPktLatency = 0;
extern ULONG router_up_time;
#endif
/* Jo 22/04/99 */
/****************************************************************************/
/* 
	wan_packet_received 
	This is called from lsl to check if there are any packets pending to 
	be processed. vptr_buffer & usptr_number_of_bytes_rxed are initialized
	if there is an packet present.
*/
	
/****************************************************************************/
/* Jo 26/04/99 */
const char ppp_signature[] = "\x7E\xFF\x7D\x23" ;
/* Kamalnath SLIP 04\04\1997 */
/* Jo const char slip_signature[] = "\xC0" ; */
/* Kamalnath SLIP 04\04\1997 */

void wan_debug_function ()
{

}

enum BOOLEAN wan_packet_received (USHORT port_number, void **vptr_buffer,
	USHORT *usptr_number_of_bytes_rxed)
{
	WAN_RX_DESCRIPTOR *sptr_current_rx_descriptor;
	WAN_PORT_CLASS *sptr_wan_port_class;
	int	TmpSr;
	SCC_BUFFER_DESCRIPTOR *sptr_rx_bd ;
	int shell_menu_resp ;

	if (wan.port[port_number].enabled != TRUE)
	{
		return (FALSE);
	}

	sptr_wan_port_class = &wan.port[port_number];

	/* Initially check if we are still in the UART-ASYNC driver. If so, then
	** we are analysing the received packets to check if the packet is PPP or
	** not. If there is no packet, nothing is done. If packet is PPP, a switch
	** is made to ASYNC-HDLC and PPP is informed. Else the AG inbound module 
	** is asked if it wants the port.
	*/
	if (wan.port[port_number].packet_analysis_on == TRUE)
	{
		/*
		This means, the answering wan port is up and we now need to do
		an analysis of the incoming packet to see what is the kind of call.
		If it is a PPP call or an AG inbound call or a call by a terminal
		client to the terminal server
		*/
		sptr_rx_bd = (SCC_BUFFER_DESCRIPTOR *)get_pointer_to_first_filled_bd (port_number) ;
		if (sptr_rx_bd == NULL)
		{
			return FALSE ;
		}

		if  (sptr_rx_bd != NULL)
      {
		   if ((strncmp (sptr_rx_bd->buffer_ptr, &ppp_signature[0], strlen (&ppp_signature[0])) == 0) ||
		      (strncmp (sptr_rx_bd->buffer_ptr, &ppp_signature[1], strlen (&ppp_signature[1])) == 0))
		   {
			/* It is a PPP packet */
/*			   wan_printf (WAN_RX_PRINTF, "WAN : PPP packet received on port %d\n", port_number) ;*/
            wan.port[port_number].packet_analysis_on = FALSE ;
/*	Jo		   wan.port[port_number].shell_menu_on = SHELL_MENU_OFF ; 
			   wan.port[port_number].analysed_once = FALSE ;*/

				change_protocol_to_async_hdlc (port_number) ;

			   lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
				   LOWER_DEVICE_DRIVER_UP, port_number) ;
			   lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
				   OPEN_DEVICE_DRIVER_PORT, port_number) ;
#if PROXY_SERVER
            wan.port[port_number].statistics.connection_up_time = 0 ;
            wan.port[port_number].statistics.connection_bytes_transmitted = 0 ;
            wan.port[port_number].statistics.connection_bytes_received = 0 ;
            wan.port[port_number].statistics.connection_packets_transmitted = 0 ;
            wan.port[port_number].statistics.connection_packets_received = 0 ;
            wan.port[port_number].statistics.number_of_calls++ ;
#endif

			   sptr_rx_bd->bd_status &= (USHORT) 0xFF70 ;
			   sptr_rx_bd->bd_status |= (USHORT) 0x8000 ;
			   sptr_rx_bd->buffer_length &= 0 ;

			   return (FALSE) ;
		   }

/* Jo 17/5/99 SLIP not handled in LCPR */
#ifdef _BIG_PROXY_
		/* Kamalnath SLIP 04\04\1997 */
		   else if (strncmp (sptr_rx_bd->buffer_ptr, &slip_signature[0], strlen (&slip_signature[0])) == 0)
		   {
			/* It is a SLIP packet */
/*			   wan_printf (WAN_RX_PRINTF, "WAN : SLIP packet received on port %d\n", port_number) ;*/
			   wan.port[port_number].packet_analysis_on = FALSE ;
		   	wan.port[port_number].shell_menu_on = SHELL_MENU_OFF ;
			   wan.port[port_number].analysed_once = FALSE ;

			   change_protocol_to_async(port_number, TRUE, SLIP_MODE);
			   lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
					LOWER_DEVICE_DRIVER_SLIP_UP, port_number);
			   lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
					OPEN_DEVICE_DRIVER_PORT, port_number);

#if PROXY_SERVER
            wan.port[port_number].statistics.connection_up_time = 0 ;
            wan.port[port_number].statistics.connection_bytes_transmitted = 0 ;
            wan.port[port_number].statistics.connection_bytes_received = 0 ;
            wan.port[port_number].statistics.connection_packets_transmitted = 0 ;
            wan.port[port_number].statistics.connection_packets_received = 0 ;
            wan.port[port_number].statistics.number_of_calls++ ;
#endif
			   sptr_rx_bd->bd_status &= (USHORT) 0xFF70 ;
			   sptr_rx_bd->bd_status |= (USHORT) 0x8000 ;
			   sptr_rx_bd->buffer_length &= 0 ;

			   return (FALSE) ;
		   }
#endif
/* Jo 17/5/99 SLIP not handled in LCPR */

	   }
	}
/* 
	We are going to modify the current_rx_list linked list. Which is also being
   	modified when a packet received from the network. so disable ints.
*/
		TmpSr = _GPL(); 
		_SPL(7);
	sptr_current_rx_descriptor = (WAN_RX_DESCRIPTOR *) get_entry_from_list (&sptr_wan_port_class->current_rx_list);
		_SPL(TmpSr);

	if (sptr_current_rx_descriptor != NULL)
		{
		if (*((BYTE *)sptr_current_rx_descriptor->sptr_rx_buffer) != 0xff)
			wan_debug_function ();

		*usptr_number_of_bytes_rxed = sptr_current_rx_descriptor->number_of_bytes_rxed;
		*vptr_buffer = sptr_current_rx_descriptor->sptr_rx_buffer;

/* we are giving the buffer to lsl for processing the packet. The Rx descriptor
	is now without a buffer. so try to allocate a new buffer for this */

		get_a_new_wan_buffer(port_number, sptr_current_rx_descriptor); 

		return(TRUE);
		}

	return (FALSE);
}
/******************************************************************************/
/* 
	The Rx descriptor is tried to put in with a new buffer by doing a device_driv-
	er_malloc(). if successfull we put the descpr in free_rx_list or else we
	put it in need_buffer_list.
*/
/******************************************************************************/
enum TEST get_a_new_wan_buffer (USHORT real_port_number, WAN_RX_DESCRIPTOR *sptr_current_rx_descriptor)
{
	int	TmpSr;

	sptr_current_rx_descriptor->sptr_rx_buffer =
		(SERIAL_BUFFER *)device_driver_malloc (real_port_number, wan.port[real_port_number].device_driver_id, (USHORT) NULL);

	if (sptr_current_rx_descriptor->sptr_rx_buffer != NULL)
		{
		sptr_current_rx_descriptor->number_of_bytes_rxed = 0x0000;

		TmpSr = _GPL(); 
		_SPL(7);
		add_entry_to_list ((LINK *) &wan.port[real_port_number].free_rx_list, (LINK *) sptr_current_rx_descriptor);
		_SPL(TmpSr);
		return (PASS);
		}
	else
		{
printf("in need buffer\n") ;
		sptr_current_rx_descriptor->number_of_bytes_rxed = 0x0000;

		add_entry_to_list ((LINK *) &wan.port[real_port_number].rx_descriptor_need_buffer_list,
			(LINK *) sptr_current_rx_descriptor);

		return (FAIL);
		}
}
/****************************************************************************/
/* 
	this is called from lsl after the recvd pkt is processed.
*/
/****************************************************************************/
void wan_return_buffer_to_device_driver (USHORT real_port_number, void *vptr_buffer)
{
	WAN_RX_DESCRIPTOR *sptr_rx_descriptor;

		if (wan.port[real_port_number].enabled != TRUE)
			return ;

	device_driver_free (real_port_number, wan.port[real_port_number].device_driver_id, vptr_buffer);

	sptr_rx_descriptor = (WAN_RX_DESCRIPTOR *)
		get_entry_from_list ((LINK *) &wan.port[real_port_number].rx_descriptor_need_buffer_list);

	if (sptr_rx_descriptor != NULL)
		{
		get_a_new_wan_buffer (real_port_number, sptr_rx_descriptor);
		}
}

/****************************************************************************/
/* this is called whenever a new packet is received from wan port and a new
   buffer is to be allocated for reception. This is also called in the
   beginning when wan port controller is being initialized. After the buffer
   is got from the free_rx_list the descriptor is added to scheduled_for_rx
   queue. This is called with interrupts disabled from wan port interrupt
   service routine.
*/
/****************************************************************************/
void *get_a_free_wan_rx_descriptor (int port_number)
{
	WAN_RX_DESCRIPTOR *sptr_free_rx_descriptor ;
	WAN_PORT_CLASS *sptr_wan_port_class = &wan.port[port_number] ;

	sptr_free_rx_descriptor = (WAN_RX_DESCRIPTOR *) get_entry_from_list (&sptr_wan_port_class->free_rx_list) ;
	if (sptr_free_rx_descriptor != NULL)
	{
		add_entry_to_list (&sptr_wan_port_class->scheduled_for_rx,
													(LINK *) sptr_free_rx_descriptor) ;
		return (sptr_free_rx_descriptor->sptr_rx_buffer) ;
	}

	return NULL ;
}
/****************************************************************************/
/* this is called when ever any wan packet which is in error is
   received. In this case it is necessarry to take out the first packet from
   scheduled_for_rx queue and put it in end. This is done this way as we will
   continue to use the same buffer for subsequent reception. this is also
   called whenever the free_rx_list becomes empty in the wan int servie
   routine and we need to allocate a buffer for the RX BD.
   this is called with ints disabled.
*/
/****************************************************************************/
void wan_rx_error_adjust_scheduled_rx_list (int port_number, int overflow)
{
	LINK *sptr_rx_descriptor ;
	WAN_PORT_CLASS *sptr_wan_port_class ;
	sptr_wan_port_class = &wan.port[port_number] ;

#ifndef SOFTWARE_QUOTING
	/* printf ("In wan_rx_error_adjust_scheduled_rx_list()\n") ; */
#endif

	sptr_rx_descriptor = get_entry_from_list (&sptr_wan_port_class->scheduled_for_rx);
	if (sptr_rx_descriptor == NULL)
	{
		printf("\r\n Rx interrupt for not received packet") ;
		return ;
	}
	add_entry_to_list (&sptr_wan_port_class->scheduled_for_rx,
														(LINK *) sptr_rx_descriptor) ;
/* By Sanjay */
	if (overflow)
	{
		++(((DEVICE_DRIVER_REGISTRATION_ENTRY *)(sptr_wan_port_class->device_driver_id))->rfc1213_ifEntry.ifInDiscards) ;
		sptr_wan_port_class->statistics.number_of_rx_queue_overflows ++ ;
	}
	else
	{
	 	++(((DEVICE_DRIVER_REGISTRATION_ENTRY *)(sptr_wan_port_class->device_driver_id))->rfc1213_ifEntry.ifInErrors) ;
		sptr_wan_port_class->statistics.number_of_rx_errors ++ ;
	}
/* By Sanjay */
}
/****************************************************************************/
/* if a packet is received with no errors and also a free rx_descriptor is
   available this is called. this just picks up the packet from 
   scheduled_for_rx queue and put it on current_rx_list.
   This is called with interrupts disabled.
*/
/****************************************************************************/
void put_wan_pkt_on_recvd_que (int port_number, int len_of_wan_pkt)
{
	WAN_RX_DESCRIPTOR *sptr_rx_descriptor ;
	WAN_PORT_CLASS *sptr_wan_port_class ; 
	sptr_wan_port_class = &wan.port[port_number] ;

	sptr_rx_descriptor = (WAN_RX_DESCRIPTOR *) get_entry_from_list (&sptr_wan_port_class->scheduled_for_rx);
	if (sptr_rx_descriptor == NULL)
	{
		wan_printf (WAN_RX_PRINTF, "\r\n WAN: scheduled_for_rx list empty") ;
		return ;
	}
	sptr_rx_descriptor->number_of_bytes_rxed = len_of_wan_pkt ;
	sptr_wan_port_class->statistics.number_of_packets_rxed ++ ;
	sptr_wan_port_class->statistics.number_of_bytes_rxed += len_of_wan_pkt ;

#if PROXY_SERVER
	sptr_wan_port_class->statistics.connection_bytes_received += len_of_wan_pkt ;
	sptr_wan_port_class->statistics.connection_packets_received ++;
#endif
		

/* By Sanjay */
	add_entry_to_list (&sptr_wan_port_class->current_rx_list,
														(LINK *) sptr_rx_descriptor) ;
}

/* Sachin */
void flush_rx_buffers_sticking_around (USHORT port_number)
{
	void *vptr_rxed_packet ;
	USHORT number_of_bytes ;

	while (wan_packet_received (port_number, &vptr_rxed_packet, &number_of_bytes) == TRUE)
	{
		printf ("WAN : One more Rx buffer sticking on to port %d\n", port_number) ; 
		wan_return_buffer_to_device_driver (port_number, vptr_rxed_packet) ;
	}
}
/* Sachin */


/*
	Returns :
		0 : Analysis not conclusive
		1 : Start PPP
		2 : Start AG Inbound
		3 : Start Terminal Server
*/

extern char invalid_response[];
extern char tc_invalid_user_name[];
extern char tc_invalid_user_password[];


#ifdef _BIG_PROXY_
int shell_menu_packet_received (USHORT port_number, BYTE *sptr_packet, USHORT packet_length)
{
	int i;
	int initial_length = wan.port[port_number].shell_menu_response_length ;
   int send_pkt_len[NUMBER_OF_SERIAL_PORTS];
   BYTE *send_invalid;

	wan.port[port_number].shell_menu_idle_timer = SHELL_MENU_MAX_IDLE_TIME ;

   for (i = 0; i < NUMBER_OF_SERIAL_PORTS; i++)
      send_pkt_len[i] = 0;

	if (wan.port[port_number].shell_menu_response_length >= SHELL_MENU_MAX_RESPONSE_LENGTH)
	{
      WriteToPort (port_number, invalid_response, strlen (invalid_response)) ;
      wan.port[port_number].shell_menu_response_length = 0;
		wan.port[port_number].analysed_once = FALSE ;
		return (0) ;
	}

	for (i = 0 ; i < packet_length ; i++, sptr_packet++)
	{
		if (wan.port[port_number].shell_menu_response_length >= SHELL_MENU_MAX_RESPONSE_LENGTH)
		{
			wan.port[port_number].analysed_once = FALSE ;
			WriteToPort (port_number, &wan.port[port_number].shell_menu_response[initial_length],
							wan.port[port_number].shell_menu_response_length-initial_length) ;
         wan.port[port_number].shell_menu_response_length = 0;
         switch (wan.port[port_number].shell_menu_on)
         {
            case SHELL_MENU_USER_NAME_RECEIVED:
               send_invalid = tc_invalid_user_name;
               break;

            case SHELL_MENU_PASSWORD_RECEIVED:
               send_invalid = tc_invalid_user_password;
               break;
            
            case SHELL_MENU_ANALYSIS:
               send_invalid = invalid_response;
               break;
         }

         WriteToPort (port_number, send_invalid, strlen (send_invalid)) ;
			return (0) ;
		}
		if (*sptr_packet == '\b')
		{
         wan.port[port_number].shell_menu_response[wan.port[port_number].shell_menu_response_length] = *sptr_packet ;
			if (wan.port[port_number].shell_menu_response_length)
				wan.port[port_number].shell_menu_response_length--;
         send_pkt_len[port_number]++;
  		}
		else
		{
		   wan.port[port_number].shell_menu_response[wan.port[port_number].shell_menu_response_length] = *sptr_packet ;
			wan.port[port_number].shell_menu_response_length++ ;
         send_pkt_len[port_number]++;
		}
      if (*sptr_packet == '\r')
		{
     	   break ;
		}
   }

   if (wan.port[port_number].shell_menu_on != SHELL_MENU_PASSWORD_PROMPT_SENT)
   {
      WriteToPort (port_number, &wan.port[port_number].shell_menu_response[initial_length],send_pkt_len[port_number]) ; 
   }
   

	if (wan.port[port_number].shell_menu_response[wan.port[port_number].shell_menu_response_length-1] != '\r')
		return (0) ; 

#if 0
   if (wan.port[port_number].shell_menu_on == SHELL_MENU_ANALYSIS)
      WriteToPort (port_number, newline_buff, strlen (newline_buff)) ;    
#endif
      
   wan.port[port_number].shell_menu_response[wan.port[port_number].shell_menu_response_length-1] = 0;
   shell_menu_state_machine (port_number, wan.port[port_number].shell_menu_response);
}


void shell_menu_state_machine (USHORT port_number, BYTE *buffer)
{
   switch (wan.port[port_number].shell_menu_on)
   {
      case SHELL_MENU_LOGIN_PROMPT_SENT:
         check_for_user_name_and_send_prompt (port_number);
         wan.port[port_number].shell_menu_response_length = 0;
         break;

      case SHELL_MENU_USER_NAME_RECEIVED:
         validate_username_and_process (port_number, buffer);
         wan.port[port_number].shell_menu_response_length = 0;
         break;
            
      case SHELL_MENU_PASSWORD_PROMPT_SENT:
      case SHELL_MENU_PASSWORD_RECEIVED:
/*         if (buffer == NULL)
            break; */
         validate_user_password_and_process (port_number, buffer);
         wan.port[port_number].shell_menu_response_length = 0;
         break;            

      case SHELL_MENU_SENT:
/*         if (buffer == NULL)
            break;  */
         non_ppp_packet_received_during_packet_analysis (port_number,buffer);
         wan.port[port_number].shell_menu_response_length = 0;
         break;
                     
      case SHELL_MENU_ANALYSIS:
/*         if (buffer == NULL)  
            break;  */
         process_the_shell_menu_response (port_number, buffer);
         wan.port[port_number].shell_menu_response_length = 0;
         break;

		case SHELL_MENU_OFF:
			break ;

      default:
         break;
   }
	wan.port[port_number].shell_menu_response[0] = 0 ;

   return;
}
#endif


#if 0
void shell_menu_timer (USHORT port_number)
{
	if (wan.port[port_number].shell_menu_on == TRUE)
	{
		if (wan.port[port_number].shell_menu_idle_timer)
			wan.port[port_number].shell_menu_idle_timer-- ;
		else
		{
			wan.port[port_number].shell_menu_on = FALSE ;
			wan.port[port_number].analysed_once = FALSE ;
		}
	}
}


enum BOOLEAN is_PPP_enabled (USHORT port_number)
{
	return (TRUE) ;
}

enum BOOLEAN is_AG_enabled (USHORT port_number)
{
	return (TRUE) ;
}

enum BOOLEAN is_terminal_server_enabled (USHORT port_number)
{
	return (TRUE) ;
}

#endif


