#include	"defs.h"
#include <string.h>
#include "wan.h"
#include <wanmgr.h>
#include <softquot.h>
extern ULONG  timer_ulong;

/* Jo 22/04/99 */
#if 0
extern ULONG pkt_in_time;
extern ULONG pkt_out_time;
extern ULONG router_up_time;
#endif
/* Jo 22/04/99 */
/* Kamalnath SLIP 07\03\1997 */
/* Jo extern enum BOOLEAN check_if_slip_on_is_set_to_true(USHORT port_num);*/
enum BOOLEAN check_if_slip_is_enabled(USHORT port_number);
/* Kamalnath SLIP 07\03\1997 */

#ifndef FRAME_RELAY
typedef	struct	PPP_HEADER
{
	BYTE										hdlc_address;
	BYTE									  hdlc_control;
	USHORT									protocol_type;
} PPP_HEADER;
#endif

int ScheduleTxPort(int portnum, WAN_TX_DESCRIPTOR *descriptor);
int TxPktOnSCC2(void *,int);
int TxPktOnSCC3(void *,int);
int TxPktOnSCC4(void *,int);
int TxAHDLCPktOnSCC2(void *,int);
int TxAHDLCPktOnSCC3(void *,int);
int TxAHDLCPktOnSCC4(void *,int);
/* int wanpkts_act_txed; */
#ifdef DEBUG
int wanpkts_act_freed; 
#endif /* DEBUG */

int	packets_came_for_xmit;
int	packets_scheded;
int 	packets_queued;
int	xmit_interrupts;

int	LostInterrupts = 0;

/****************************************************************************/
/* This is the actual routine which is going to be called for transmission
	of all packets to be transmitted on the wan ports. here we try to get a free
	wan tx descriptor. if we cannot get the descriptor the packet is dropped. and
	completion routines are called. other wise it is transmitted.
*/
/****************************************************************************/
enum TEST send_wan_packet (USHORT port_number, USHORT virtual_port_number, SERIAL_BUFFER *sptr_tx_buffer,
	USHORT number_of_bytes,	enum BOOLEAN do_not_calculate_new_crc, enum BOOLEAN device_driver_buffer,
	void (*fptr_tx_completion) (USHORT port_number, SERIAL_BUFFER *sptr_wan_buffer),void *vptr_wan_buffer)
{
	enum WAN_PORT_OWNER wan_owner;
	WAN_PORT_CLASS *sptr_wan_port_class;
	WAN_TX_DESCRIPTOR *sptr_current_tx_descriptor;
	int	save_pl;		/* location to save interupt priority level */


	PARAMETER_NOT_USED (do_not_calculate_new_crc);

/* if port is disabled return fail */
		if (wan.port[port_number].enabled != TRUE)
		{
		if (fptr_tx_completion != NULL)
		{
#ifdef FRAME_RELAY
			(*fptr_tx_completion) (virtual_port_number, (SERIAL_BUFFER *)vptr_wan_buffer) ;
#else
#ifndef SOFTWARE_QUOTING
			(*fptr_tx_completion) (virtual_port_number,(char *) sptr_tx_buffer - sizeof (MAC_HEADER) + sizeof (PPP_HEADER));
#else
			(*fptr_tx_completion) (virtual_port_number, (char *) sptr_tx_buffer - sizeof (LINK));
#endif
#endif
		}
		return (FAIL);
	}

	/* If PPP does not own the port, don't use it for sending */
	wan_owner = get_wan_port_owner(port_number);
/* Jo Removed OWNED_BY_SLIP */
	if (!(wan_owner == OWNED_BY_PPP || wan_owner == OWNED_BY_NONE))
	{
		if (device_driver_buffer == TRUE) /* we are calling device_driver_free */
			{
			packet_forward_device_driver_free (port_number, wan.port[port_number].device_driver_id,
				(void *) ((ULONG) sptr_tx_buffer));
			}

		if (fptr_tx_completion != NULL)
			{
#ifdef FRAME_RELAY
			(*fptr_tx_completion) (virtual_port_number, (SERIAL_BUFFER *)vptr_wan_buffer) ;
#else
#ifndef SOFTWARE_QUOTING
      	(*fptr_tx_completion) (virtual_port_number,(char *) sptr_tx_buffer - sizeof (MAC_HEADER) + sizeof (PPP_HEADER));
#else
			(*fptr_tx_completion) (virtual_port_number, (char *) sptr_tx_buffer - sizeof (LINK));
#endif
#endif
		}

		return (FAIL);
	}

	sptr_wan_port_class = &wan.port[port_number];
	sptr_current_tx_descriptor = get_entry_from_list (&sptr_wan_port_class->free_tx_list);

	if (sptr_current_tx_descriptor == NULL)
		{						/* no free descriptor drop the packet */
/* By Sanjay */
		++(((DEVICE_DRIVER_REGISTRATION_ENTRY *)(sptr_wan_port_class->device_driver_id))->rfc1213_ifEntry.ifOutDiscards);
	sptr_wan_port_class->statistics.number_of_rejected_tx_packets++;

/* By Sanjay */

		if (device_driver_buffer == TRUE) /* we are calling device_Driver_free */
		{
			packet_forward_device_driver_free (port_number, wan.port[port_number].device_driver_id,
				(void *) ((ULONG) sptr_tx_buffer));
		}

		if (fptr_tx_completion != NULL)
			{
#ifdef FRAME_RELAY
			(*fptr_tx_completion) (virtual_port_number, (SERIAL_BUFFER *)vptr_wan_buffer) ;
#else
#ifndef SOFTWARE_QUOTING
			(*fptr_tx_completion) (virtual_port_number,(char *) sptr_tx_buffer - sizeof (MAC_HEADER) + sizeof (PPP_HEADER));
#else
			(*fptr_tx_completion) (virtual_port_number, (char *) sptr_tx_buffer - sizeof (LINK));
#endif
#endif
		}

		return (FAIL);
	}
/* By Sanjay */
	++(((DEVICE_DRIVER_REGISTRATION_ENTRY *)(sptr_wan_port_class->device_driver_id))->rfc1213_ifEntry.ifOutQLen);
 	(((DEVICE_DRIVER_REGISTRATION_ENTRY *)(sptr_wan_port_class->device_driver_id))->rfc1213_ifEntry.ifOutOctets) += number_of_bytes;
	sptr_wan_port_class->statistics.number_of_packets_to_tx++;
/* By Sanjay */

	/* sudhir for proxy server*/
	sptr_wan_port_class->statistics.number_of_bytes_to_tx += number_of_bytes;

	sptr_current_tx_descriptor->length = number_of_bytes;
	sptr_current_tx_descriptor->protocol_stack_virtual_port_number = virtual_port_number;
	sptr_current_tx_descriptor->sptr_tx_packet = sptr_tx_buffer;
	sptr_current_tx_descriptor->fptr_tx_complete = fptr_tx_completion;
	sptr_current_tx_descriptor->vptr_wan_buffer = vptr_wan_buffer;
	sptr_current_tx_descriptor->in_use = TRUE;
	sptr_current_tx_descriptor->device_driver_buffer = device_driver_buffer;

packets_came_for_xmit++;

	/* Disable interrupts */
	save_pl = _GPL();
	_SPL(7);
	
	/* each of the ports are programmed so that we can Q up upto SYNC_WAN_NO_TX_BD
	simultaneously for transmission. so we try to find if any of them is free.
	if it is free then we use it and put this descriptor in scheduled_for_tx
	list else put the descriptor in current_tx_list .
	*/

/* Srikar, Mar 24, 1997. Following added to inform LSL of packet transmit submission. */
	lsl_control(LSL_PACKET_TRANSMIT_SUBMITTED_OR_COMPLETED, wan.number_of_lan_ports + port_number, LSL_PACKET_SUBMITTED_FOR_TRANSMIT);

/* Jo 17/5/99 SLIP not handled in LCPR */
#ifdef _BIG_PROXY_
/* Kamalnath 18\03\1997 SLIP */				
	if (check_if_slip_is_enabled(port_number))
	{
		if ( !sptr_wan_port_class->sptr_current_tx_descriptor) 
		{
			ScheduleTxPort(port_number, sptr_current_tx_descriptor);
			sptr_wan_port_class->sptr_current_tx_descriptor = sptr_current_tx_descriptor;
		}	
		else 
		{
			packets_queued++;
			add_entry_to_list (&sptr_wan_port_class->current_tx_list, (LINK *) sptr_current_tx_descriptor);
		}
		/* Enable interrupts */
		_SPL(save_pl);

  		return (PASS);
  	}								
/* Kamalnath 18\03\1997 SLIP */				
#endif
/* Jo 17/5/99 SLIP not handled in LCPR */


#ifndef SOFTWARE_QUOTING
		if(ScheduleTxPort(port_number, sptr_current_tx_descriptor)){
			add_entry_to_list (&sptr_wan_port_class->scheduled_for_tx, (LINK *) sptr_current_tx_descriptor);
	}	else
			add_entry_to_list (&sptr_wan_port_class->current_tx_list, (LINK *) sptr_current_tx_descriptor);
#else
	if ( !sptr_wan_port_class->sptr_current_tx_descriptor) {
		ScheduleTxPort(port_number, sptr_current_tx_descriptor);
		sptr_wan_port_class->sptr_current_tx_descriptor = sptr_current_tx_descriptor;
	}	else {
packets_queued++;
			add_entry_to_list (&sptr_wan_port_class->current_tx_list, (LINK *) sptr_current_tx_descriptor);
	}
#endif

	/* Enable interrupts */
	_SPL(save_pl);

	return (PASS);
}
/****************************************************************************/
/* This is going to be called from the transmit interrupt service routine */
/****************************************************************************/
void wan_tx_isr_complete (int port_number)
{
	WAN_PORT_CLASS *sptr_wan_port_class ;
	WAN_TX_DESCRIPTOR *sptr_current_tx_descriptor ;

	sptr_wan_port_class = &wan.port[port_number] ;
	xmit_interrupts ++ ;

/* 
the first descriptor in scheduled_for_tx is the one which we are expecting
to be completed first.
*/
#ifndef SOFTWARE_QUOTING

/* Jo 17/5/99 SLIP not handled in LCPR */
#ifdef _BIG_PROXY_
		/* Kamalnath 18\03\1997 SLIP */				
		if (check_if_slip_is_enabled(port_number))
		{
			sptr_current_tx_descriptor = sptr_wan_port_class->sptr_current_tx_descriptor ;
		}
		else
/* Kamalnath 18\03\1997 SLIP */				
#endif
/* Jo 17/5/99 SLIP not handled in LCPR */

		sptr_current_tx_descriptor = get_entry_from_list ((LINK *) &wan.port[port_number].scheduled_for_tx) ;
#else
		sptr_current_tx_descriptor = sptr_wan_port_class->sptr_current_tx_descriptor ;
#endif

		if (sptr_current_tx_descriptor == NULL)
		{
			/* something went wrong  as we have got an tx_complete intr. for something
					which we have not sent*/
			wan_printf (WAN_TX_PRINTF, "WAN: Panic, current_tx_descriptor NULL!\r\n");
			return ;
		}
/* By Sanjay */
	--(((DEVICE_DRIVER_REGISTRATION_ENTRY *)(sptr_wan_port_class->device_driver_id))->rfc1213_ifEntry.ifOutQLen);
	sptr_wan_port_class->statistics.number_of_packets_txed++;
	sptr_wan_port_class->statistics.number_of_bytes_txed +=
				sptr_current_tx_descriptor->length;
#if PROXY_SERVER
   sptr_wan_port_class->statistics.connection_bytes_transmitted += sptr_current_tx_descriptor->length ;
   sptr_wan_port_class->statistics.connection_packets_transmitted ++; /* Vidy 31/10/97 */
#endif
	sptr_wan_port_class->statistics.number_of_packets_to_tx--;
/* By Sanjay */

	/* sudhir for proxy server */
	sptr_wan_port_class->statistics.number_of_bytes_to_tx -= 
				sptr_current_tx_descriptor->length;


	/* add this descriptor to the xmited_tx_list */
   add_entry_to_list (&sptr_wan_port_class->xmited_tx_list,(LINK *) sptr_current_tx_descriptor);

	/* check on the current_tx_list for any more packets */
	sptr_current_tx_descriptor = get_entry_from_list ((LINK *) &wan.port[port_number].current_tx_list);

	/* update the current_tx_descriptor in port_class for next interrupt */
	if (sptr_current_tx_descriptor != NULL)
	{
#ifndef SOFTWARE_QUOTING

/* Jo 17/5/99 SLIP not handled in LCPR */
#ifdef _BIG_PROXY_
  		/* Kamalnath 18\03\1997 SLIP */				
		if (check_if_slip_is_enabled(port_number))
		{
			sptr_wan_port_class->sptr_current_tx_descriptor = sptr_current_tx_descriptor;
  		}
		else
/* Kamalnath 18\03\1997 SLIP */				
#endif
/* Jo 17/5/99 SLIP not handled in LCPR */

	  	add_entry_to_list (&sptr_wan_port_class->scheduled_for_tx,(LINK *) sptr_current_tx_descriptor);
#else
		sptr_wan_port_class->sptr_current_tx_descriptor = sptr_current_tx_descriptor;
#endif
		ScheduleTxPort (port_number, sptr_current_tx_descriptor) ;
	}
	else
	{
/* Jo 17/5/99 SLIP not handled in LCPR */
#ifdef _BIG_PROXY_
/* Kamalnath 18\03\1997 SLIP */				
		if (check_if_slip_is_enabled(port_number))
		{
			sptr_wan_port_class->sptr_current_tx_descriptor = NULL;
		}
/* Kamalnath 18\03\1997 SLIP */				
#endif
/* Jo 17/5/99 SLIP not handled in LCPR */

#ifdef SOFTWARE_QUOTING
		sptr_wan_port_class->sptr_current_tx_descriptor = NULL;
#endif
	}
}	
/******************************************************************************/
/* 
this routine is called from lsl foreground. this gives us a chance to call
the completion routines of all the packets which have already been sent. we 
take the descriptors from xmitted list and put them in free list . We also
check need buffer list so that we can do a device_driver_malloc for that.
*/
/******************************************************************************/
void wan_packet_transmitted (USHORT port_number)
{

	WAN_PORT_CLASS *sptr_wan_port_class;
	WAN_TX_DESCRIPTOR *sptr_current_tx_descriptor;
	WAN_RX_DESCRIPTOR *sptr_rx_descriptor_that_needs_a_buffer;
	int	saved_pl;

		if (wan.port[port_number].enabled != TRUE)
						return;

	sptr_wan_port_class = &wan.port[port_number];


	sptr_rx_descriptor_that_needs_a_buffer = (WAN_RX_DESCRIPTOR *)
			get_entry_from_list ((LINK *) &wan.port[port_number].rx_descriptor_need_buffer_list);

	if (sptr_rx_descriptor_that_needs_a_buffer != NULL)
		{
		get_a_new_wan_buffer (port_number, sptr_rx_descriptor_that_needs_a_buffer);
		}

	saved_pl = _GPL();
	_SPL(7);
	sptr_current_tx_descriptor = get_entry_from_list ((LINK *) &wan.port[port_number].xmited_tx_list);
	_SPL(saved_pl);

/* Jo 17/5/99 SLIP not handled in LCPR */
#ifdef _BIG_PROXY_
/* Kamalnath 18\03\1997 SLIP */				
	if (check_if_slip_is_enabled(port_number))
	{
		while (sptr_current_tx_descriptor != NULL)
		{
			sptr_current_tx_descriptor->in_use = FALSE;

			if (sptr_current_tx_descriptor->fptr_tx_complete != NULL)
			{
				(*sptr_current_tx_descriptor->fptr_tx_complete) (
					sptr_current_tx_descriptor->protocol_stack_virtual_port_number,
/*					(char *)sptr_current_tx_descriptor->sptr_tx_packet); */

/* 25/05/97 Changed as per Prasad's fix, Vidy */
					(char *)sptr_current_tx_descriptor->vptr_wan_buffer);
			}
			add_entry_to_list (&sptr_wan_port_class->free_tx_list,(LINK *) &sptr_current_tx_descriptor->links);

			saved_pl = _GPL();
			_SPL(7);
			sptr_current_tx_descriptor = get_entry_from_list ((LINK *) &wan.port[port_number].xmited_tx_list);
			_SPL(saved_pl);

		}
		return;
	}
/* Kamalnath 18\03\1997 SLIP */				
#endif
/* Jo 17/5/99 SLIP not handled in LCPR */

	while (sptr_current_tx_descriptor != NULL)
		{
		sptr_current_tx_descriptor->in_use = FALSE;

		if (sptr_current_tx_descriptor->fptr_tx_complete != NULL)
			{
#ifdef FRAME_RELAY
			(*sptr_current_tx_descriptor->fptr_tx_complete) (
					sptr_current_tx_descriptor->protocol_stack_virtual_port_number,
					(SERIAL_BUFFER *)sptr_current_tx_descriptor->vptr_wan_buffer) ;
#else
#ifndef SOFTWARE_QUOTING
				(*sptr_current_tx_descriptor->fptr_tx_complete) (
					sptr_current_tx_descriptor->protocol_stack_virtual_port_number,
					(char *)sptr_current_tx_descriptor->sptr_tx_packet - sizeof (MAC_HEADER) + sizeof (PPP_HEADER));
#else
				(*sptr_current_tx_descriptor->fptr_tx_complete) (
					sptr_current_tx_descriptor->protocol_stack_virtual_port_number,
					(char *)sptr_current_tx_descriptor->sptr_tx_packet - sizeof (LINK));
#endif
#endif
		}

		/* Srikar, Mar 24, 1997. Following added to inform LSL of packet transmit completion. */

		lsl_control(LSL_PACKET_TRANSMIT_SUBMITTED_OR_COMPLETED, wan.number_of_lan_ports + port_number, LSL_PACKET_TRANSMIT_OVER);

		/*	lsl_control (LSL_TX_LIST_PACKET_SENT, wan.port[port_number].device_driver_id); */

		if (sptr_current_tx_descriptor->device_driver_buffer == TRUE)
			{
			packet_forward_device_driver_free (port_number,wan.port[port_number].device_driver_id,
				sptr_current_tx_descriptor->sptr_tx_packet);
			}

	   add_entry_to_list (&sptr_wan_port_class->free_tx_list,(LINK *) &sptr_current_tx_descriptor->links);

		saved_pl = _GPL();
		_SPL(7);
		sptr_current_tx_descriptor = get_entry_from_list ((LINK *) &wan.port[port_number].xmited_tx_list);
		_SPL(saved_pl);
		}
}

/******************************************************************************/
/*
	this routine just looks at the type of link and calls the suitable routine
	for txing the pkt.
*/
/******************************************************************************/
int ScheduleTxPort(int port_number, WAN_TX_DESCRIPTOR *descriptor)
{
	switch (port_number)
	{
		case 0:
				
#ifdef _BIG_PROXY_ /* Jo 17/5/99 SLIP not handled in LCPR */
				if (check_if_slip_is_enabled(port_number))
				{
					return(TxPktOnSCC2(descriptor->sptr_tx_packet,descriptor->length));
				}
#endif /* Jo 17/5/99 SLIP not handled in LCPR */
				return(TxAHDLCPktOnSCC2(descriptor->sptr_tx_packet,descriptor->length));

		case 1:
#ifdef _BIG_PROXY_ /* Jo 17/5/99 SLIP not handled in LCPR */
				if (check_if_slip_is_enabled(port_number))
				{
					return(TxPktOnSCC3(descriptor->sptr_tx_packet,descriptor->length));
				}
#endif /* Jo 17/5/99 SLIP not handled in LCPR */
				return(TxAHDLCPktOnSCC3(descriptor->sptr_tx_packet,descriptor->length));

		case 2:
#ifdef _BIG_PROXY_ /* Jo 17/5/99 SLIP not handled in LCPR */
				if (check_if_slip_is_enabled(port_number))
				{
					return(TxPktOnSCC4(descriptor->sptr_tx_packet,descriptor->length));
				}
#endif /* Jo 17/5/99 SLIP not handled in LCPR */
				return(TxAHDLCPktOnSCC4(descriptor->sptr_tx_packet,descriptor->length));
		}
	return(PASS);
}

/* By Sanjay */
/* Called whenever a transmission error occurs that results in the 
** discarding of the packet currently being transmitted
*/
void wan_tx_error (USHORT port_number)
{
  ++ (((DEVICE_DRIVER_REGISTRATION_ENTRY *)(wan.port[port_number].device_driver_id))->rfc1213_ifEntry.ifOutErrors) ;
	wan.port[port_number].statistics.number_of_tx_errors ++ ;
}
