/* ------------------------------------------------------------------------
  FILENAME : cfgmgr.h
  Author 	: O.S.Sridhar
  Date		: 28-7-97
  Last Date Modified : 16 Nov 1999	
  Modifications : Imran made changes for small proxy
  Modifications : Jo, 16 Nov 1999 Added new state for DialIn Port Type in enum var WAN_LINK_STATUS
-------------------------------------------------------------------------*/
#include <indexs.h>		// for calling the parameters

#define CM_MAX_NUMBER_OF_SECTIONS 	  	6
#define CM_NO_PORT_PARAMETER_PRESENT	255
#define CM_LIFE_TIME 						180
#define CM_NUMBER_OF_FLASH_PROMS 		2
#define CM_MAX_NUMBER_OF_USERS 			1
#define CM_CLOSE_CONNECTION				1
#define CM_ACCESS_CHANGED					2
#define IP_ADDRES_LENGTH 			      16 
#define METRIC_LENGTH 						4

#define CM_ETHERNET_ADDRESS_LENGTH 12+1

#define PROTOCOL_PORT_LENGTH  4+1

/* Jo 14/07/99 */
#define CM_ALL_PORTS 3

/* Jo 04/10/99 */
#define MAX_TCP_APPLICATIONS     43
#define MAX_UDP_APPLICATIONS     42

#define FTP20						20
#define FTP21						21
#define SSL_FTP989				989
#define SSL_FTP990				990
#define Q931_VOIP_900			900
#define Q931_VOIP_902			902
#define RTP_VOIP_5004			5004
#define RTP_VOIP_5006			5006
#define RTCP_VOIP_5005  		5005
#define RTCP_VOIP_5007  		5007
/* Jo 04/10/99 */

	 /* Imran 3/9/98 */
#define CM_IP_ID					0
#define CM_WAN_ID					1
#define CM_PPP_ID					2
#define CM_PROXY_ID				3
#define CM_DHCP_ID				4
#define CM_STATIC_ROUTES_ID	5
/* Jo 19/08/99 Added new section id for Static routes */

#define PROXY_APPLICATION  		1   
#define PROXY_USER_APPLICATION	2
#define PROXY_FILTER					3	
#define PROXY_LINK  					4
#define PROXY_NAT						5
#define PROXY_DHCP 					6
	/* Imran 3/9/98 */
    								 
#ifndef BOOL
#define BOOL int
#endif

#ifndef ULONG
#define ULONG unsigned long
#endif

#ifndef USHORT
#define USHORT unsigned short
#endif

#ifndef LINK_TYPEDEF_DEFINED

#define LINK_TYPEDEF_DEFINED

typedef	struct	LINK
{
	struct	LINK	*sptr_forward_link;
	struct	LINK	*sptr_backward_link;
} LINK;

#endif

/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */
enum TEST_RESULT {UNIQUE_ENTRY = 0, PROXY_RESERVED_ENTRY, PROXY_ENTRY, PROXY_RANGE_ENTRY};

/* Access permissions that will be returned to user while initialization */
enum ACCESS_PERMISSIONS {	CM_NO_READ_WRITE_ACCESS = 0,
									CM_READ_ONLY,
									CM_READ_AND_WRITE };



/* structure to store the info of a user who gets connected to CFGMGR */
typedef struct USER_LIST
{
	LINK	links;			/* doubly linked list to traverse users */
	ULONG Connection_ID;  	/* unique ID by which the user will be identified */
	int 	Owner_Type;		/* Contains owner type like DTTY, WEB, TELNET */
	int 	Timeout_Count;	/* Stores timeout value of this connection */
	int 	Permissions;		/* Permissions of this connection can be read, write */
	int 	Section_Locked;	/* Currently which section is being modified by this user */
	int 	(*fn_ptr_to_callback) (ULONG connection_id, int value);
} USER_LIST;

/* Imran 14/9/98 */

typedef struct
{
   struct dhcp_tag_definition_struct *sptr_tag_list;  
   ULONG  total_number_of_tags;
} CONFIGURATION_MANAGER_CLASS;
/* Imran 14/9/98 */
			
#ifndef _BOOLEAN
#define _BOOLEAN
enum BOOLEAN {	FALSE = 0, TRUE = 1}; 
#endif	

/* Agent Type to be passed as parameter to initialize */
enum CM_AGENT_TYPE    	{	CM_OWNED_BY_NONE, 
									CM_OWNED_BY_SNMP, 
									CM_OWNED_BY_TELNET, 
									CM_OWNED_BY_HTTP, 
									CM_OWNED_BY_UIM, 
									CM_OWNED_BY_DTTY};

/* Jo 19/08/99 Added new section for Static routes */
/* defines section names */
enum CM_SECTIONS      {	
								CM_IP_SECTION = 0,
								CM_WAN_SECTION = 1,
								CM_PPP_SECTION = 2,
								CM_PROXY_SECTION = 3,
								CM_DHCP_SECTION = 4, 
								CM_STATIC_ROUTES_SECTION = 5, 
								CM_UNKNOWN_SECTION = 6 };

/* Defines Data Format */
enum CM_DATA_FORMAT   { 	CM_UNKNOWN_FORMAT  = 0,
									CM_STRING_FORMAT,
									CM_USHORT_FORMAT,
									CM_ULONG_FORMAT, 
									CM_BYTE_FORMAT,
									CM_STRUCTURE_FORMAT,
									CM_DOT_FORMAT,				// only for other modules to have ip address in dot format
									CM_BIT_FORMAT, 			// only for cfgmgr
									CM_SPECIAL_FORMAT			// only for cfgmgr
									}; // for specifying error conditions

enum CM_GET_RESULTS   	{	CM_GET_FAILED = 0,
									CM_GET_ILLEGAL_USER_ID,
									CM_GET_UNKNOWN_PARAMETER_ID,
									CM_GET_INVALID_DATA_FORMAT,
									CM_GET_INVALID_STRING_LENGTH,
									CM_GET_INSUFFICIENT_BUFFER_SPACE,
									CM_GET_SUCCESSFUL	};

enum CM_SET_RESULTS   	{	CM_SET_FAILED = 0,
									CM_SET_NO_WRITE_PERMISSION,
									CM_SET_UNKNOWN_PARAMETER_ID,
									CM_ERROR_WHILE_VALIDATING, /* Imran */
									CM_SET_INVALID_DATA_FORMAT,
									CM_SET_SUCCESSFUL	};

enum CM_ADD_RESULTS   	{	CM_ADD_FAILED = 0, 
									CM_ADD_NO_WRITE_PERMISSION,
									CM_ADD_INVALID_PARAMETER_ID,
									CM_ADD_SUCCESSFUL };

enum CM_DELETE_RESULTS   {	CM_DELETE_FAILED = 0, 
									CM_DELETE_NO_WRITE_PERMISSION,
									CM_DELETE_INVALID_PARAMETER_ID,
									CM_DELETE_SUCCESSFUL };

enum CM_WRITE_RESULTS   {	CM_WRITE_FAILED = 0,
									CM_WRITE_SUCCESSFUL	};

enum CM_INIT_RESULTS  {CM_INIT_FAILED_NOT_ENOUGH_MEMORY = -1, CM_INIT_SUCCESSFUL = 0, CM_MANAGER_IS_SNMP = 1, CM_MANAGER_IS_TELNET = 2, CM_MANAGER_IS_HTTP = 3, CM_MANAGER_IS_UIM = 4, CM_MANAGER_IS_DTTY = 5};
enum PHYSICAL_PORT {ETHERNET_PORT = 0, WAN_PORT_1, WAN_PORT_2, WAN_PORT_3};

enum FILTER {FILTER_ON_DESTINATION = 0, FILTER_ON_SOURCE , FORWARD_ON_DESTINATION, FORWARD_ON_SOURCE};
enum IP_PORT_FILTER_PROTOCOL {PROTOCOL_TCP, PROTOCOL_UDP};

typedef struct PARAMETER_NODE
{
	struct PARAMETER_NODE* next;
	struct PARAMETER_NODE* previous;
	char parameter[255];
}PARAMETER_NODE;

typedef struct
{
	enum IP_PORT_FILTER_PROTOCOL protocol;
	BYTE protocol_port[PROTOCOL_PORT_LENGTH];
	enum PHYSICAL_PORT physical_port;
	enum FILTER filter_type;
}STRUCT_IP_PORT_FILTER;

typedef struct
{
	BYTE ip_address[IP_ADDRES_LENGTH];
	enum PHYSICAL_PORT physical_port;
	enum FILTER filter_type;
}STRUCT_IP_ADDRESS_FILTER;

typedef struct 
{
	USHORT port;
	USHORT protocol;
}STRUCT_PROXY_ENTRY;

/* Imran,for proxy user defined ports */
typedef struct 
{
   USHORT 	protocol ;
	USHORT 	lower_port_number;
	USHORT 	higher_port_number;
	BYTE 		port_description[16];
}STRUCT_PROXY_USER_ENTRY;
/* Imran,for proxy user defined ports */

typedef struct
{
	BYTE addr[255];
} STRUCT_PROXY_FILTER;

typedef struct
{
	BYTE global_addr[IP_ADDRES_LENGTH];
	BYTE local_addr[IP_ADDRES_LENGTH];
} STRUCT_NAT_STATIC_ENTRY;

typedef struct
{
	BYTE local_addr[IP_ADDRES_LENGTH];
	USHORT protocol;
	USHORT port;
} STRUCT_NAT_DYNAMIC_ENTRY;

/* Jo 19/08/99 changed parameters for Static routes */
typedef struct
{
	ULONG ip_address ;
	ULONG gateway_address ;
	ULONG address_mask ;
	USHORT port_number ;
	BYTE	metric ;
}STRUCT_STATIC_ROUTE;
/* Jo 19/08/99 changed parameters for Static routes */

typedef struct
{
   BYTE ip_addr[IP_ADDRES_LENGTH];
   USHORT  port;
}STRUCT_HOST_ENTRY;

typedef struct
{
	BYTE echo_reply;		
	BYTE destination_unreachable;
	BYTE source_quench;
	BYTE redirect;
	BYTE echo_request;
	BYTE time_exceeded;
	BYTE parameter_problem;
	BYTE time_stamp_request;
	BYTE time_stamp_reply;
	BYTE address_mask_request;
	BYTE address_mask_reply;

	enum PHYSICAL_PORT physical_port;
}STRUCT_IP_ICMP_FILTER;

extern CONFIGURATION_MANAGER_CLASS cfgmgr_class;

/* Define functions of cminit.c */
extern ULONG cm_initialize_configuration_manager (enum CM_AGENT_TYPE agent_type, 
					int *Permissions,
					int (*fn_ptr_to_callback)(ULONG, int ));
extern void cm_deinitialize_configuration_manager (ULONG connection_id);
extern void cm_keep_alive_configuration_manager (ULONG connection_id);
extern enum CM_WRITE_RESULTS cm_write_configuration (ULONG connection_id);

/* Configuration manager support functions added by Imran... */
extern int get_ulong_ip_address(char *dot_decimal_ip_address, ULONG *int_ip_address);
extern int get_dot_decimal_ip_address (ULONG int_ip_address, char *dot_decimal_ip_address);
extern BYTE is_duplicate_application(USHORT protocol, USHORT port, USHORT index);
extern BYTE is_duplicate_user_application(STRUCT_PROXY_USER_ENTRY *ptr_to_proxy_user_entry,int edit_index);
extern BYTE is_duplicate_port_range(USHORT protocol,USHORT Loport,USHORT Hiport,char *port_desc,int edit_index);
extern BYTE is_duplicate_ip_addr_filter(BYTE *ip_addr, USHORT index);
extern BYTE is_duplicate_mac_addr_filter(BYTE *mac_addr);
extern BYTE is_duplicate_domain_name_filter(BYTE *domain_name);
/* ...Configuration manager support functions added by Imran */
/* Jo 14/07/99 */
extern void set_client_only_interdep (USHORT port_no)	;
extern void set_ppp_strings (ULONG parameter_id, USHORT port_number, BYTE valid) ; 
extern enum BOOLEAN set_mlppp_dependencies (enum BOOLEAN flag) ;
/* Jo 14/07/99 */

/* General API Functions */

extern enum CM_GET_RESULTS get_parameter (ULONG connection_identifier,
														enum CM_SECTIONS section_id,
														ULONG parameter_id,
														USHORT port_number,
														enum CM_DATA_FORMAT data_format,
														void *data_ptr,
														int nbytes,
														char *error_string);

extern enum CM_SET_RESULTS set_parameter (ULONG connection_identifier,
														enum CM_SECTIONS section_id,
														ULONG parameter_id,
														USHORT port_number,
														enum CM_DATA_FORMAT data_format,
														void *data_ptr,
														int nbytes,
														char *error_string);

extern enum CM_ADD_RESULTS add_parameters (ULONG connection_identifier,
														enum CM_SECTIONS section_id,
														ULONG parameter_id,
														USHORT port_number,
														void *struct_to_write,
														char *error_string);

extern enum CM_DELETE_RESULTS delete_parameters (ULONG connection_identifier,
														enum CM_SECTIONS section_id,
														ULONG parameter_id,
														USHORT port_number,
														int index_to_delete,
														char *error_string);


/* Imran 4/9/98 */
extern int cm_get_entry(USHORT parameter_id, USHORT  section_id, ULONG *offset,
								USHORT *entry_num,USHORT index);

extern int cm_edit_entry(ULONG connection_id, enum CM_SECTIONS section_id,
								ULONG parameter_id,USHORT index, void *struct_to_write,
								int filter_type_or_port_no);
/* Imran 4/9/98 */

/* Jo 19/08/99 Added for static routes */

extern void get_number_of_static_routes (USHORT *number_of_entries) ;
extern int cm_get_static_entry (enum CM_SECTIONS section_id, STRUCT_STATIC_ROUTE **static_route_entry,	
			USHORT *entry_num) ;
extern void calculate_offset_of_static_route_entry (ULONG *offset) ;
extern int cm_edit_static_route_entry (ULONG connection_id, enum CM_SECTIONS section_id,
							USHORT index, void *struct_to_write, int filter_type_or_port_no) ;
extern int add_static_route_entry (ULONG parameter_id, USHORT port_no, void *struct_to_write) ;
extern int delete_static_route_entry (ULONG parameter_id, USHORT port_no, int index_to_delete) ;

/* Jo 19/08/99 Added for static routes */


#if 0
enum FRAME_TYPE
{
	RAW_8023,
	ETHERNET_TYPE_II,
	LLC,
	SNAP,
	SAME_TYPE_AS_RX_FRAME /* for future use, DO NOT ALLOW AS A CONFIGURATION OPTION */
};
#endif

/* ... Extern Declerations */
/*........................ Cut Here ............................... */

/* DHCP Related */


#define CM_IP_ADDRESS_LENGTH        16
#define CM_MAX_MAC_ADDRESS_LENGTH   21
#define CM_DHCP_OPTION_VALUE_LENGTH 50

typedef struct 
{
   BYTE ip_address_lower[CM_IP_ADDRESS_LENGTH];
   BYTE ip_address_higher[CM_IP_ADDRESS_LENGTH];
   BYTE net_mask[CM_IP_ADDRESS_LENGTH];
   BYTE exclude_ip_address_lower[CM_IP_ADDRESS_LENGTH];
   BYTE exclude_ip_address_higher[CM_IP_ADDRESS_LENGTH];
}CM_STRUCT_DHCP_RANGE;

typedef struct
{
   BYTE ip_address_to_bind[CM_IP_ADDRESS_LENGTH];
   BYTE mac_address_length;
   BYTE mac_address_to_bind[CM_MAX_MAC_ADDRESS_LENGTH];
}CM_STRUCT_DHCP_BIND;

typedef struct
{
   BYTE option;
   BYTE option_value[CM_DHCP_OPTION_VALUE_LENGTH];
   BYTE position;
}CM_STRUCT_DHCP_OPTION;

typedef struct
{
   BYTE string[100];
   void (*setup_function) (char* cptr_start_of_configuration_string, ULONG parameter_1, ULONG ulptr_parameter_2, ULONG parameter_3);
}STRUCT_OF_STRINGS_AND_CORR_FUNCTIONS;

typedef struct
{
   BYTE option;
   BYTE (*validation_function) (BYTE* new_value, BYTE max_digits, ULONG lower_limit, ULONG upper_limit);
   BYTE max_digits;
   ULONG lower_limit;
   ULONG upper_limit;
}CM_OPTION_VALIDATING_TABLE;

typedef struct
{
   USHORT option;
   void (*convert_function) (BYTE* original, BYTE* converted);  
   void (*revert_function)  (struct dhcp_option_entry* sptr_option, BYTE* converted);  /* Imran */
}CM_OPTION_CONVERSION_TABLE;

enum CM_DHCP_RANGE_INSERTION_RETURN_TYPE 
{
   CM_DHCP_INSERTION_SUCCESS = 1,

   /* Validations */
   CM_DHCP_INSERTION_FAILED_INVALID_LOWER_IP_ADDRESS,
   CM_DHCP_INSERTION_FAILED_INVALID_HIGHER_IP_ADDRESS,
   CM_DHCP_INSERTION_FAILED_INVALID_SUBNET_MASK,
   CM_DHCP_INSERTION_FAILED_INVALID_RANGE,
   CM_DHCP_INSERTION_FAILED_INVALID_LOWER_IP_ADDRESS_EXCLUDE, 
            /* this includes whether this address is greater then or equal to lower ip address */
   CM_DHCP_INSERTION_FAILED_INVALID_HIGHER_IP_ADDRESS_EXCLUDE,
            /* this includes whether this address is less then or equal to upper ip address  and this should be greater than above field - lower_ip_address_exclude */
   CM_DHCP_INSERTION_FAILED_INVALID_EXCLUSION,

   /* Overlaps/Duplications */
   CM_DHCP_INSERTION_FAILED_RANGE_DUPLICATION,
   CM_DHCP_INSERTION_FAILED_OVERLAPING_WITH_OTHER_RANGE_EXCLUSION,

   /* Memory */
   CM_DHCP_INSERTION_FAILED_INSUFFICIENT_MEMORY,

   /* Following are for editing the tags ... */
   CM_DHCP_EDITING_FAILED_IP_IS_BOUND_TO_MAC_ADDRESS,
   CM_DHCP_EDITING_FAILED_TO_GET_OLD_RANGE,
   CM_DHCP_EDITING_FAILED_TO_CHANGE_DEFAULT

};

enum CM_DHCP_RANGE_DELETION_RETURN_TYPE
{
   CM_DHCP_DELETION_SUCCESS = 1,
   CM_DHCP_DELETION_RANGE_NOT_FOUND,
   CM_DHCP_DELETION_FAILED_TRYING_TO_DELETE_DEFAULT
};

enum CM_DHCP_BIND_RETURN_TYPE
{
   CM_DHCP_BINDING_SUCCESS = 1,
   CM_DHCP_BINDING_FAILED_DUPLICATED_IP_ADDRESS,
   CM_DHCP_BINDING_FAILED_DUPLICATED_MAC_ADDRESS,

   CM_DHCP_BINDING_FAILED_INVALID_MAC_ADDRESS_LENGTH,
   CM_DHCP_BINDING_FAILED_MAC_ADDRESS_GREATER_THAN_LENGTH,
   CM_DHCP_BINDING_FAILED_INVALID_MAC_ADDRESS,
   CM_DHCP_BINDING_FAILED_INVALID_IP_ADDRESS,
   CM_DHCP_BINDING_FAILED_IP_ADDRESS_OUT_OF_RANGE,
   CM_DHCP_BINDING_FAILED_CAN_NOT_BIND_DEFAULT_RANGE,

   /* Memory */
   CM_DHCP_BINDING_FAILED_INSUFFICIENT_MEMORY
};

enum CM_DHCP_UNBIND_RETURN_TYPE
{
   CM_DHCP_UNBIND_SUCCESS = 1,
   CM_DHCP_UNBIND_FAILED 
};

enum CM_DHCP_INSERT_OPTION_RETURN_TYPE
{
   CM_DHCP_INSERTING_OPTION_SUCCESS = 1,
   CM_DHCP_INSERTING_OPTION_FAILED_INVALID_DATA,
   CM_DHCP_INSERTING_OPTION_FAILED_DUPLICATE_ENTRY,

   /* Memory */
   CM_DHCP_EDITING_OPTION_FAILED_INSUFFICIENT_MEMORY
};

enum CM_DHCP_DELETE_OPTION_RETURN_TYPE
{
   CM_DHCP_DELETING_OPTION_SUCCESS = 1,
   CM_DHCP_DELETING_OPTION_FAILED_OPTION_NOT_FOUND,
   CM_DHCP_DELETING_OPTION_FAILED_CANNOT_DELETE
};

/* API's to be included in \rtrware\include\cfgmgr.h ... */
extern BYTE cm_initialise_dhcp_address_range_list();   /* Imran 14/9/98 */
/* Range */
extern enum CM_DHCP_RANGE_INSERTION_RETURN_TYPE cm_insert_dhcp_address_range(CM_STRUCT_DHCP_RANGE* sptr_range_to_insert);
extern enum CM_DHCP_RANGE_DELETION_RETURN_TYPE  cm_delete_dhcp_address_range(CM_STRUCT_DHCP_RANGE* sptr_range_to_delete);
extern enum CM_DHCP_RANGE_DELETION_RETURN_TYPE  cm_delete_dhcp_address_range_by_tag_number(USHORT tag_number);
extern enum CM_DHCP_RANGE_INSERTION_RETURN_TYPE cm_edit_dhcp_address_range(CM_STRUCT_DHCP_RANGE* sptr_old_range, CM_STRUCT_DHCP_RANGE* sptr_new_range);
extern BYTE                                     cm_get_dhcp_address_range(USHORT tag_number, CM_STRUCT_DHCP_RANGE* sptr_range);
/* Binding */
extern enum CM_DHCP_BIND_RETURN_TYPE            cm_bind_mac_and_ip_address(USHORT tag_number, CM_STRUCT_DHCP_BIND* sptr_bind_info);
extern enum CM_DHCP_UNBIND_RETURN_TYPE          cm_unbind_mac_and_ip_address(USHORT tag_number, CM_STRUCT_DHCP_BIND* sptr_unbind_info, USHORT index); /* Imran added index parameter */
#if 0 /* Jo 30/04/99 */
extern BYTE                                     cm_get_first_dhcp_binding(USHORT tag_number, CM_STRUCT_DHCP_BIND* sptr_bind);
extern BYTE                                     cm_get_next_dhcp_binding(USHORT tag_number, CM_STRUCT_DHCP_BIND* sptr_bind);
extern BYTE                                     cm_get_dhcp_range_option_by_number(USHORT tag_number, BYTE option_number, CM_STRUCT_DHCP_OPTION* sptr_option);
#endif /* Jo 30/04/99 */

extern BYTE                                     cm_get_dhcp_binding(USHORT tag_number, BYTE bind_number, CM_STRUCT_DHCP_BIND* sptr_bind_info);
/* Option */
extern enum CM_DHCP_INSERT_OPTION_RETURN_TYPE   cm_insert_dhcp_range_option(USHORT tag_number, CM_STRUCT_DHCP_OPTION* sptr_dhcp_option_to_insert);
extern enum CM_DHCP_DELETE_OPTION_RETURN_TYPE   cm_delete_dhcp_range_option(USHORT tag_number, CM_STRUCT_DHCP_OPTION* sptr_dhcp_option_to_delete);
extern enum CM_DHCP_INSERT_OPTION_RETURN_TYPE   cm_edit_dhcp_range_option(USHORT tag_number, CM_STRUCT_DHCP_OPTION* sptr_dhcp_old_option, CM_STRUCT_DHCP_OPTION* sptr_dhcp_new_option);
extern BYTE                                     cm_get_dhcp_range_option_by_option(USHORT tag_number, USHORT option, CM_STRUCT_DHCP_OPTION* sptr_option);
/* General */
extern USHORT   cm_get_total_number_of_ranges();
extern USHORT   cm_get_total_number_of_bindings_in_a_range(USHORT tag_number);
extern USHORT   cm_get_number_of_option_values(USHORT option);

#if PROXY_SERVER

typedef enum
{
   IDLE,
   OFFLINE,
   WAN_LINK_UP, /* Physical Link up */
   LCP_UP,
   PPP_CLIENT_UP,
   MLPPP_CLIENT_UP,
   SEND_INIT_COMMAND,
   WAIT_FOR_OK,
   DIAL_NUMBER,
   WAIT_FOR_CONNECT,
/* Sachin 09/11/1997 */
   SLIP_CLIENT_UP,
   DISABLED,
/* Sachin 09/11/1997 */

/* ...Jo 16 Nov 1999. Added these missing states for DialIn Port Type */

	CALL_BACK,
	RAS_CLIENT_CONNECTED,
	IDLE_WAIT_CALL,
	RAS_WAIT_CALL,
	HANGING_UP,

/* ...Jo 16 Nov 1999. Added these missing states for DialIn Port Type */
   WAN_PORT_STATUS_NUMBER_OF_STATES
} WAN_LINK_STATUS ;

extern ULONG proxy_get_local_ip_address (USHORT port_number) ;
extern ULONG proxy_get_remote_ip_address (USHORT port_number) ;
extern ULONG proxy_get_subnet_mask (USHORT port_number) ;
extern BYTE get_port_status (USHORT port_number) ;
extern ULONG get_baud_rate (USHORT port_number) ;
extern char *get_modem_name (USHORT port_number, char *modem_name_string, int modem_name_string_length) ;
extern char *get_modem_connect_message (USHORT port_number, char *connect_message_string, int connect_message_string_length) ;
extern char *get_ppp_user_name (USHORT port_number, char *user_name, int user_name_length) ;

extern ULONG get_connection_up_time (USHORT port_number) ;
extern ULONG get_connection_tx_count (USHORT port_number) ;
extern ULONG get_connection_rx_count (USHORT port_number) ;

extern ULONG get_aggregate_rx_count (USHORT port_number) ;
extern ULONG get_aggregate_tx_count (USHORT port_number) ;
extern ULONG get_number_of_calls (USHORT port_number) ;
extern ULONG get_aggregate_connection_time (USHORT port_number) ;

/* Vidy added the following 4 functions 31/10/97 */
extern ULONG get_connection_tx_packet_count (USHORT port_number) ;
extern ULONG get_connection_rx_packet_count (USHORT port_number) ;

extern ULONG get_aggregate_rx_packet_count (USHORT port_number) ;
extern ULONG get_aggregate_tx_packet_count (USHORT port_number) ;

/* Ramana added the following functions for NAT, Filters and Link Control */
extern void update_count_in_ini (BYTE *lhs_string, BYTE flag,USHORT port_num);

/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */

extern void get_ftp_port_numbers(ULONG connection_id, USHORT *ctrl_port, USHORT *data_port);

/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */

#endif

